/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.annotation.FlaggedApi;
import android.annotation.Nullable;
import android.net.wifi.WifiSsid;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@FlaggedApi(value="com.android.wifi.flags.secure_ranging")
public class PasnConfig
implements Parcelable {
    public static final int AKM_NONE = 0;
    public static final int AKM_PASN = 1;
    public static final int AKM_SAE = 2;
    public static final int AKM_FT_EAP_SHA256 = 4;
    public static final int AKM_FT_PSK_SHA256 = 8;
    public static final int AKM_FT_EAP_SHA384 = 16;
    public static final int AKM_FT_PSK_SHA384 = 32;
    public static final int AKM_FILS_EAP_SHA256 = 64;
    public static final int AKM_FILS_EAP_SHA384 = 128;
    private static final Map<String, Integer> sStringToAkm = new HashMap<String, Integer>();
    public static final int CIPHER_NONE = 0;
    public static final int CIPHER_CCMP_128 = 1;
    public static final int CIPHER_CCMP_256 = 2;
    public static final int CIPHER_GCMP_128 = 4;
    public static final int CIPHER_GCMP_256 = 8;
    private static final Map<String, Integer> sStringToCipher;
    private final int mBaseAkms;
    private final int mCiphers;
    private String mPassword;
    private final WifiSsid mWifiSsid;
    private final byte[] mPasnComebackCookie;
    @android.annotation.NonNull
    public static final Parcelable.Creator<PasnConfig> CREATOR;

    public int getBaseAkms() {
        return this.mBaseAkms;
    }

    public int getCiphers() {
        return this.mCiphers;
    }

    @Nullable
    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    @Nullable
    public WifiSsid getWifiSsid() {
        return this.mWifiSsid;
    }

    @Nullable
    public byte[] getPasnComebackCookie() {
        return this.mPasnComebackCookie;
    }

    private PasnConfig(@android.annotation.NonNull Parcel in) {
        this.mBaseAkms = in.readInt();
        this.mCiphers = in.readInt();
        this.mPassword = in.readString();
        this.mWifiSsid = SdkLevel.isAtLeastT() ? in.readParcelable(WifiSsid.class.getClassLoader(), WifiSsid.class) : (WifiSsid)in.readParcelable(WifiSsid.class.getClassLoader());
        this.mPasnComebackCookie = in.createByteArray();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mBaseAkms);
        dest.writeInt(this.mCiphers);
        dest.writeString(this.mPassword);
        dest.writeParcelable(this.mWifiSsid, flags);
        dest.writeByteArray(this.mPasnComebackCookie);
    }

    public static int getBaseAkmsFromCapabilities(String capabilities) {
        int akms = 0;
        if (capabilities == null) {
            return akms;
        }
        for (String akm : sStringToAkm.keySet()) {
            if (!capabilities.contains(akm)) continue;
            akms |= sStringToAkm.get(akm).intValue();
        }
        return akms;
    }

    public static int getCiphersFromCapabilities(String capabilities) {
        int ciphers = 0;
        if (capabilities == null) {
            return ciphers;
        }
        for (String cipher : sStringToCipher.keySet()) {
            if (!capabilities.contains(cipher)) continue;
            ciphers |= sStringToCipher.get(cipher).intValue();
        }
        return ciphers;
    }

    private PasnConfig(Builder builder) {
        this.mBaseAkms = builder.mBaseAkms;
        this.mCiphers = builder.mCiphers;
        this.mPassword = builder.mPassword;
        this.mWifiSsid = builder.mWifiSsid;
        this.mPasnComebackCookie = builder.mPasnComebackCookie;
    }

    public static boolean isAkmRequiresPassword(int akms) {
        return (akms & 2) != 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PasnConfig)) {
            return false;
        }
        PasnConfig that = (PasnConfig)o;
        return this.mBaseAkms == that.mBaseAkms && this.mCiphers == that.mCiphers && Objects.equals(this.mPassword, that.mPassword) && Objects.equals(this.mWifiSsid, that.mWifiSsid) && Arrays.equals(this.mPasnComebackCookie, that.mPasnComebackCookie);
    }

    public int hashCode() {
        int result = Objects.hash(this.mBaseAkms, this.mCiphers, this.mPassword, this.mWifiSsid);
        result = 31 * result + Arrays.hashCode(this.mPasnComebackCookie);
        return result;
    }

    public String toString() {
        String password = this.mPassword != null ? "*" : "null";
        return "PasnConfig{mBaseAkms=" + this.mBaseAkms + ", mCiphers=" + this.mCiphers + ", mPassword='" + password + '\'' + ", mWifiSsid=" + this.mWifiSsid + ", mPasnComebackCookie=" + Arrays.toString(this.mPasnComebackCookie) + '}';
    }

    static {
        sStringToAkm.put("None", 0);
        sStringToAkm.put("PASN", 1);
        sStringToAkm.put("SAE", 2);
        sStringToAkm.put("EAP-FILS-SHA256", 64);
        sStringToAkm.put("EAP-FILS-SHA384", 128);
        sStringToAkm.put("FT/EAP", 4);
        sStringToAkm.put("FT/PSK", 8);
        sStringToAkm.put("EAP-FT-SHA384", 16);
        sStringToAkm.put("FT/PSK-SHA384", 32);
        sStringToCipher = new HashMap<String, Integer>();
        sStringToCipher.put("None", 0);
        sStringToCipher.put("CCMP-128", 1);
        sStringToCipher.put("CCMP-256", 2);
        sStringToCipher.put("GCMP-128", 4);
        sStringToCipher.put("GCMP-256", 8);
        CREATOR = new Parcelable.Creator<PasnConfig>(){

            @Override
            public PasnConfig createFromParcel(Parcel in) {
                return new PasnConfig(in);
            }

            public PasnConfig[] newArray(int size) {
                return new PasnConfig[size];
            }
        };
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public static class Builder {
        private final int mBaseAkms;
        private final int mCiphers;
        private String mPassword = null;
        private WifiSsid mWifiSsid = null;
        byte[] mPasnComebackCookie = null;

        public Builder(int baseAkms, int ciphers) {
            this.mBaseAkms = baseAkms;
            this.mCiphers = ciphers;
        }

        @android.annotation.NonNull
        public Builder setPassword(@android.annotation.NonNull String password) {
            Objects.requireNonNull(password, "Password must not be null");
            this.mPassword = password;
            return this;
        }

        @android.annotation.NonNull
        public Builder setWifiSsid(@android.annotation.NonNull WifiSsid wifiSsid) {
            Objects.requireNonNull(wifiSsid, "SSID must not be null");
            this.mWifiSsid = wifiSsid;
            return this;
        }

        @android.annotation.NonNull
        public Builder setPasnComebackCookie(@android.annotation.NonNull byte[] pasnComebackCookie) {
            Objects.requireNonNull(pasnComebackCookie, "PASN comeback cookie must not be null");
            if (pasnComebackCookie.length > 255 || pasnComebackCookie.length == 0) {
                throw new IllegalArgumentException("Cookie with invalid length " + pasnComebackCookie.length);
            }
            this.mPasnComebackCookie = pasnComebackCookie;
            return this;
        }

        @android.annotation.NonNull
        public PasnConfig build() {
            return new PasnConfig(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Cipher {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AkmType {
    }
}

