/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.OuiKeyedData;
import android.net.wifi.ParcelUtil;
import android.net.wifi.ScanResult;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.rtt.PasnConfig;
import android.net.wifi.rtt.ResponderConfig;
import android.net.wifi.rtt.SecureRangingConfig;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class RangingRequest
implements Parcelable {
    private static final String TAG = "RangingRequest";
    private static final int MAX_PEERS = 10;
    private static final int DEFAULT_RTT_BURST_SIZE = 8;
    private static final int MIN_RTT_BURST_SIZE = 2;
    private static final int MAX_RTT_BURST_SIZE = 31;
    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public static final int SECURITY_MODE_OPEN = 0;
    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public static final int SECURITY_MODE_OPPORTUNISTIC = 1;
    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public static final int SECURITY_MODE_SECURE_AUTH = 2;
    public final List<ResponderConfig> mRttPeers;
    public final int mRttBurstSize;
    public final int mSecurityMode;
    @NonNull
    private List<OuiKeyedData> mVendorData;
    @NonNull
    public static final Parcelable.Creator<RangingRequest> CREATOR = new Parcelable.Creator<RangingRequest>(){

        public RangingRequest[] newArray(int size) {
            return new RangingRequest[size];
        }

        @Override
        public RangingRequest createFromParcel(Parcel in) {
            return new RangingRequest(in.readArrayList(null), in.readInt(), in.readInt(), ParcelUtil.readOuiKeyedDataList(in));
        }
    };

    public static int getMaxPeers() {
        return 10;
    }

    public static int getDefaultRttBurstSize() {
        return 8;
    }

    public static int getMinRttBurstSize() {
        return 2;
    }

    public static int getMaxRttBurstSize() {
        return 31;
    }

    private RangingRequest(List<ResponderConfig> rttPeers, int rttBurstSize, int securityMode, @NonNull List<OuiKeyedData> vendorData) {
        this.mRttPeers = rttPeers;
        this.mRttBurstSize = rttBurstSize;
        this.mSecurityMode = securityMode;
        this.mVendorData = new ArrayList<OuiKeyedData>(vendorData);
    }

    @SystemApi
    @NonNull
    public List<ResponderConfig> getRttResponders() {
        return this.mRttPeers;
    }

    public int getRttBurstSize() {
        return this.mRttBurstSize;
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public int getSecurityMode() {
        return this.mSecurityMode;
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public List<OuiKeyedData> getVendorData() {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        return this.mVendorData;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.mRttPeers);
        dest.writeInt(this.mRttBurstSize);
        dest.writeInt(this.mSecurityMode);
        dest.writeList(this.mVendorData);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "RangingRequest: mRttPeers=[", "]");
        for (ResponderConfig rc : this.mRttPeers) {
            sj.add(rc.toString());
        }
        sj.add("mRttBurstSize=" + this.mRttBurstSize);
        sj.add("mSecurityMode=" + this.mSecurityMode);
        sj.add("mVendorData=" + this.mVendorData);
        return ((Object)sj).toString();
    }

    public void enforceValidity(boolean awareSupported) {
        if (this.mRttPeers.size() > 10) {
            throw new IllegalArgumentException("Ranging to too many peers requested. Use getMaxPeers() API to get limit.");
        }
        for (ResponderConfig peer : this.mRttPeers) {
            if (peer.isValid(awareSupported)) continue;
            throw new IllegalArgumentException("Invalid Responder specification");
        }
        if (this.mRttBurstSize < RangingRequest.getMinRttBurstSize() || this.mRttBurstSize > RangingRequest.getMaxRttBurstSize()) {
            throw new IllegalArgumentException("RTT burst size is out of range");
        }
        if (this.mVendorData == null) {
            throw new IllegalArgumentException("Vendor data must be non-null");
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangingRequest)) {
            return false;
        }
        RangingRequest lhs = (RangingRequest)o;
        return this.mRttPeers.size() == lhs.mRttPeers.size() && this.mRttPeers.containsAll(lhs.mRttPeers) && this.mRttBurstSize == lhs.mRttBurstSize && this.mSecurityMode == lhs.mSecurityMode && Objects.equals(this.mVendorData, lhs.mVendorData);
    }

    public int hashCode() {
        return Objects.hash(this.mRttPeers, this.mRttBurstSize, this.mSecurityMode, this.mVendorData);
    }

    public static class Builder {
        private List<ResponderConfig> mRttPeers = new ArrayList<ResponderConfig>();
        private int mRttBurstSize = 8;
        @NonNull
        private List<OuiKeyedData> mVendorData = Collections.emptyList();
        private int mSecurityMode = 1;

        @NonNull
        public Builder setRttBurstSize(int rttBurstSize) {
            if (rttBurstSize < 2 || rttBurstSize > 31) {
                throw new IllegalArgumentException("RTT burst size out of range.");
            }
            this.mRttBurstSize = rttBurstSize;
            return this;
        }

        @NonNull
        public Builder addAccessPoint(@NonNull ScanResult apInfo) {
            if (apInfo == null) {
                throw new IllegalArgumentException("Null ScanResult!");
            }
            return this.addResponder(ResponderConfig.fromScanResult(apInfo));
        }

        @NonNull
        public Builder addAccessPoints(@NonNull List<ScanResult> apInfos) {
            if (apInfos == null) {
                throw new IllegalArgumentException("Null list of ScanResults!");
            }
            for (ScanResult scanResult : apInfos) {
                this.addAccessPoint(scanResult);
            }
            return this;
        }

        @NonNull
        public Builder addResponder(@NonNull ResponderConfig responder) {
            if (responder == null) {
                throw new IllegalArgumentException("Null Responder!");
            }
            this.mRttPeers.add(responder);
            return this;
        }

        @NonNull
        public Builder addResponders(@NonNull List<ResponderConfig> responders) {
            if (responders == null) {
                throw new IllegalArgumentException("Null list of Responders");
            }
            for (ResponderConfig responder : responders) {
                this.addResponder(responder);
            }
            return this;
        }

        @NonNull
        public Builder addNon80211mcCapableAccessPoint(@NonNull ScanResult apInfo) {
            if (apInfo == null) {
                throw new IllegalArgumentException("Null ScanResult!");
            }
            if (apInfo.is80211mcResponder() || apInfo.is80211azNtbResponder()) {
                throw new IllegalArgumentException("AP supports the 802.11mc or 8022.11az protocol.");
            }
            return this.addResponder(ResponderConfig.fromScanResult(apInfo));
        }

        @NonNull
        public Builder addNon80211mcCapableAccessPoints(@NonNull List<ScanResult> apInfos) {
            if (apInfos == null) {
                throw new IllegalArgumentException("Null list of ScanResults!");
            }
            for (ScanResult scanResult : apInfos) {
                if (scanResult.is80211mcResponder() || scanResult.is80211azNtbResponder()) {
                    throw new IllegalArgumentException("At least one AP supports the 802.11mc or 802.11az protocol.");
                }
                this.addAccessPoint(scanResult);
            }
            return this;
        }

        public Builder addWifiAwarePeer(@NonNull MacAddress peerMacAddress) {
            if (peerMacAddress == null) {
                throw new IllegalArgumentException("Null peer MAC address");
            }
            return this.addResponder(ResponderConfig.fromWifiAwarePeerMacAddressWithDefaults(peerMacAddress));
        }

        public Builder addWifiAwarePeer(@NonNull PeerHandle peerHandle) {
            if (peerHandle == null) {
                throw new IllegalArgumentException("Null peer handler (identifier)");
            }
            return this.addResponder(ResponderConfig.fromWifiAwarePeerHandleWithDefaults(peerHandle));
        }

        @SystemApi
        @RequiresApi(value=35)
        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setVendorData(@NonNull List<OuiKeyedData> vendorData) {
            if (!SdkLevel.isAtLeastV()) {
                throw new UnsupportedOperationException();
            }
            if (vendorData == null) {
                throw new IllegalArgumentException("setVendorData received a null value");
            }
            this.mVendorData = vendorData;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
        @NonNull
        public Builder setSecurityMode(int securityMode) {
            this.mSecurityMode = securityMode;
            return this;
        }

        @SuppressLint(value={"NewApi"})
        private void filterRttPeersBasedOnSecurityMode() {
            Iterator<ResponderConfig> peers = this.mRttPeers.iterator();
            while (peers.hasNext()) {
                ResponderConfig peer = peers.next();
                SecureRangingConfig config = peer.getSecureRangingConfig();
                if (this.mSecurityMode == 2) {
                    PasnConfig pasn;
                    PasnConfig pasnConfig = pasn = config != null ? config.getPasnConfig() : null;
                    if (pasn != null && pasn.getBaseAkms() != 1) continue;
                    peers.remove();
                    Log.i(RangingRequest.TAG, "SECURITY_MODE_SECURE_AUTH is set, removing non-secure peer: " + peer.getMacAddress());
                    continue;
                }
                if (this.mSecurityMode != 0 || !config.isRangingFrameProtectionEnabled()) continue;
                peers.remove();
                Log.i(RangingRequest.TAG, "SECURITY_MODE_OPEN is set, removing secure peer: " + peer.getMacAddress());
            }
        }

        public RangingRequest build() {
            if (this.mSecurityMode != 1) {
                this.filterRttPeersBasedOnSecurityMode();
            }
            return new RangingRequest(this.mRttPeers, this.mRttBurstSize, this.mSecurityMode, this.mVendorData);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityMode {
    }
}

