/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.OuiKeyedData;
import android.net.wifi.ParcelUtil;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.rtt.ResponderLocation;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RangingResult
implements Parcelable {
    private static final String TAG = "RangingResult";
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAIL = 1;
    public static final int STATUS_RESPONDER_DOES_NOT_SUPPORT_IEEE80211MC = 2;
    public static final int UNSPECIFIED = -1;
    private final int mStatus;
    private final MacAddress mMac;
    private final PeerHandle mPeerHandle;
    private final int mDistanceMm;
    private final int mDistanceStdDevMm;
    private final int mRssi;
    private final int mNumAttemptedMeasurements;
    private final int mNumSuccessfulMeasurements;
    private final byte[] mLci;
    private final byte[] mLcr;
    private final ResponderLocation mResponderLocation;
    private final long mTimestamp;
    private final boolean mIs80211mcMeasurement;
    private final int mFrequencyMHz;
    private final int mPacketBw;
    private final boolean mIs80211azNtbMeasurement;
    private final long mNtbMinMeasurementTime;
    private final long mNtbMaxMeasurementTime;
    private final int mI2rTxLtfRepetitions;
    private final int mR2iTxLtfRepetitions;
    private final int mNumTxSpatialStreams;
    private final int mNumRxSpatialStreams;
    private List<OuiKeyedData> mVendorData;
    private final boolean mIsRangingAuthenticated;
    private final boolean mIsRangingFrameProtected;
    private final boolean mIsSecureHeLtfEnabled;
    private final int mSecureHeLtfProtocolVersion;
    private final byte[] mPasnComebackCookie;
    private final long mPasnComebackAfterMillis;
    @NonNull
    public static final Parcelable.Creator<RangingResult> CREATOR = new Parcelable.Creator<RangingResult>(){

        public RangingResult[] newArray(int size) {
            return new RangingResult[size];
        }

        @Override
        public RangingResult createFromParcel(Parcel in) {
            Builder builder = new Builder().setStatus(in.readInt()).setMacAddress(in.readBoolean() ? MacAddress.CREATOR.createFromParcel(in) : null).setPeerHandle(in.readBoolean() ? new PeerHandle(in.readInt()) : null).setDistanceMm(in.readInt()).setDistanceStdDevMm(in.readInt()).setRssi(in.readInt()).setNumAttemptedMeasurements(in.readInt()).setNumSuccessfulMeasurements(in.readInt()).setLci(in.createByteArray()).setLcr(in.createByteArray()).setUnverifiedResponderLocation((ResponderLocation)in.readParcelable(this.getClass().getClassLoader())).setRangingTimestampMillis(in.readLong()).set80211mcMeasurement(in.readBoolean()).setMeasurementChannelFrequencyMHz(in.readInt()).setMeasurementBandwidth(in.readInt()).set80211azNtbMeasurement(in.readBoolean()).setMinTimeBetweenNtbMeasurementsMicros(in.readLong()).setMaxTimeBetweenNtbMeasurementsMicros(in.readLong()).set80211azInitiatorTxLtfRepetitionsCount(in.readInt()).set80211azResponderTxLtfRepetitionsCount(in.readInt()).set80211azNumberOfTxSpatialStreams(in.readInt()).set80211azNumberOfRxSpatialStreams(in.readInt());
            if (SdkLevel.isAtLeastV()) {
                builder.setVendorData(ParcelUtil.readOuiKeyedDataList(in));
            }
            builder.setRangingAuthenticated(in.readBoolean()).setRangingFrameProtected(in.readBoolean()).setSecureHeLtfEnabled(in.readBoolean()).setPasnComebackAfterMillis(in.readLong()).setPasnComebackCookie(in.createByteArray()).setSecureHeLtfProtocolVersion(in.readInt());
            return builder.build();
        }
    };

    private RangingResult(Builder builder) {
        this.mStatus = builder.mStatus;
        this.mMac = builder.mMac;
        this.mPeerHandle = builder.mPeerHandle;
        this.mDistanceMm = builder.mDistanceMm;
        this.mDistanceStdDevMm = builder.mDistanceStdDevMm;
        this.mRssi = builder.mRssi;
        this.mNumAttemptedMeasurements = builder.mNumAttemptedMeasurements;
        this.mNumSuccessfulMeasurements = builder.mNumSuccessfulMeasurements;
        this.mLci = builder.mLci == null ? EMPTY_BYTE_ARRAY : builder.mLci;
        this.mLcr = builder.mLcr == null ? EMPTY_BYTE_ARRAY : builder.mLcr;
        this.mResponderLocation = builder.mResponderLocation;
        this.mTimestamp = builder.mTimestamp;
        this.mIs80211mcMeasurement = builder.mIs80211mcMeasurement;
        this.mFrequencyMHz = builder.mFrequencyMHz;
        this.mPacketBw = builder.mPacketBw;
        this.mIs80211azNtbMeasurement = builder.mIs80211azNtbMeasurement;
        this.mNtbMinMeasurementTime = builder.mNtbMinMeasurementTime;
        this.mNtbMaxMeasurementTime = builder.mNtbMaxMeasurementTime;
        this.mI2rTxLtfRepetitions = builder.mI2rTxLtfRepetitions;
        this.mR2iTxLtfRepetitions = builder.mR2iTxLtfRepetitions;
        this.mNumRxSpatialStreams = builder.mNumRxSpatialStreams;
        this.mNumTxSpatialStreams = builder.mNumTxSpatialStreams;
        this.mVendorData = builder.mVendorData;
        this.mIsRangingAuthenticated = builder.mIsRangingAuthenticated;
        this.mIsRangingFrameProtected = builder.mIsRangingFrameProtected;
        this.mIsSecureHeLtfEnabled = builder.mIsSecureHeLtfEnabled;
        this.mSecureHeLtfProtocolVersion = builder.mSecureHeLtfProtocolVersion;
        this.mPasnComebackCookie = builder.mPasnComebackCookie;
        this.mPasnComebackAfterMillis = builder.mPasnComebackAfterMillis;
    }

    public int getStatus() {
        return this.mStatus;
    }

    @Nullable
    public MacAddress getMacAddress() {
        return this.mMac;
    }

    @Nullable
    public PeerHandle getPeerHandle() {
        return this.mPeerHandle;
    }

    public int getDistanceMm() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getDistanceMm(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mDistanceMm;
    }

    public int getDistanceStdDevMm() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getDistanceStdDevMm(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mDistanceStdDevMm;
    }

    public int getRssi() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getRssi(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mRssi;
    }

    public int getNumAttemptedMeasurements() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getNumAttemptedMeasurements(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mNumAttemptedMeasurements;
    }

    public int getNumSuccessfulMeasurements() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getNumSuccessfulMeasurements(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mNumSuccessfulMeasurements;
    }

    @Nullable
    public ResponderLocation getUnverifiedResponderLocation() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getUnverifiedResponderLocation(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mResponderLocation;
    }

    @SuppressLint(value={"UnflaggedApi"})
    @NonNull
    public byte[] getLci() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getLci(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mLci;
    }

    @SuppressLint(value={"UnflaggedApi"})
    @NonNull
    public byte[] getLcr() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getReportedLocationCivic(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mLcr;
    }

    public long getRangingTimestampMillis() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getRangingTimestampMillis(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mTimestamp;
    }

    public boolean is80211mcMeasurement() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("is80211mcMeasurementResult(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mIs80211mcMeasurement;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public boolean is80211azNtbMeasurement() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("is80211azNtbMeasurement(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mIs80211azNtbMeasurement;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public long getMinTimeBetweenNtbMeasurementsMicros() {
        return this.mNtbMinMeasurementTime;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public long getMaxTimeBetweenNtbMeasurementsMicros() {
        return this.mNtbMaxMeasurementTime;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int get80211azResponderTxLtfRepetitionsCount() {
        return this.mR2iTxLtfRepetitions;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int get80211azInitiatorTxLtfRepetitionsCount() {
        return this.mI2rTxLtfRepetitions;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int get80211azNumberOfTxSpatialStreams() {
        return this.mNumTxSpatialStreams;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int get80211azNumberOfRxSpatialStreams() {
        return this.mNumRxSpatialStreams;
    }

    public int getMeasurementChannelFrequencyMHz() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getMeasurementChannelFrequencyMHz(): invoked on an invalid result: getStatus()= " + this.mStatus);
        }
        return this.mFrequencyMHz;
    }

    public int getMeasurementBandwidth() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getMeasurementBandwidth(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mPacketBw;
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public List<OuiKeyedData> getVendorData() {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        return this.mVendorData;
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public boolean isRangingAuthenticated() {
        return this.mIsRangingAuthenticated;
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public boolean isRangingFrameProtected() {
        return this.mIsRangingFrameProtected;
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public boolean isSecureHeLtfEnabled() {
        return this.mIsSecureHeLtfEnabled;
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public int getSecureHeLtfProtocolVersion() {
        return this.mSecureHeLtfProtocolVersion;
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    @Nullable
    public byte[] getPasnComebackCookie() {
        return this.mPasnComebackCookie;
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public long getPasnComebackAfterMillis() {
        return this.mPasnComebackAfterMillis;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mStatus);
        if (this.mMac == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            this.mMac.writeToParcel(dest, flags);
        }
        if (this.mPeerHandle == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            dest.writeInt(this.mPeerHandle.peerId);
        }
        dest.writeInt(this.mDistanceMm);
        dest.writeInt(this.mDistanceStdDevMm);
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mNumAttemptedMeasurements);
        dest.writeInt(this.mNumSuccessfulMeasurements);
        dest.writeByteArray(this.mLci);
        dest.writeByteArray(this.mLcr);
        dest.writeParcelable(this.mResponderLocation, flags);
        dest.writeLong(this.mTimestamp);
        dest.writeBoolean(this.mIs80211mcMeasurement);
        dest.writeInt(this.mFrequencyMHz);
        dest.writeInt(this.mPacketBw);
        dest.writeBoolean(this.mIs80211azNtbMeasurement);
        dest.writeLong(this.mNtbMinMeasurementTime);
        dest.writeLong(this.mNtbMaxMeasurementTime);
        dest.writeInt(this.mI2rTxLtfRepetitions);
        dest.writeInt(this.mR2iTxLtfRepetitions);
        dest.writeInt(this.mNumTxSpatialStreams);
        dest.writeInt(this.mNumRxSpatialStreams);
        if (SdkLevel.isAtLeastV()) {
            dest.writeList(this.mVendorData);
        }
        dest.writeBoolean(this.mIsRangingAuthenticated);
        dest.writeBoolean(this.mIsRangingFrameProtected);
        dest.writeBoolean(this.mIsSecureHeLtfEnabled);
        dest.writeLong(this.mPasnComebackAfterMillis);
        dest.writeByteArray(this.mPasnComebackCookie);
        dest.writeInt(this.mSecureHeLtfProtocolVersion);
    }

    public String toString() {
        return "RangingResult: [status=" + this.mStatus + ", mac=" + this.mMac + ", peerHandle=" + (this.mPeerHandle == null ? "<null>" : Integer.valueOf(this.mPeerHandle.peerId)) + ", distanceMm=" + this.mDistanceMm + ", distanceStdDevMm=" + this.mDistanceStdDevMm + ", rssi=" + this.mRssi + ", numAttemptedMeasurements=" + this.mNumAttemptedMeasurements + ", numSuccessfulMeasurements=" + this.mNumSuccessfulMeasurements + ", lci=" + Arrays.toString(this.mLci) + ", lcr=" + Arrays.toString(this.mLcr) + ", responderLocation=" + this.mResponderLocation + ", timestamp=" + this.mTimestamp + ", is80211mcMeasurement=" + this.mIs80211mcMeasurement + ", frequencyMHz=" + this.mFrequencyMHz + ", packetBw=" + this.mPacketBw + ", is80211azNtbMeasurement=" + this.mIs80211azNtbMeasurement + ", ntbMinMeasurementTimeMicros=" + this.mNtbMinMeasurementTime + ", ntbMaxMeasurementTimeMicros=" + this.mNtbMaxMeasurementTime + ", i2rTxLtfRepetitions=" + this.mI2rTxLtfRepetitions + ", r2iTxLtfRepetitions=" + this.mR2iTxLtfRepetitions + ", numTxSpatialStreams=" + this.mNumTxSpatialStreams + ", numRxSpatialStreams=" + this.mNumRxSpatialStreams + ", vendorData=" + this.mVendorData + ", isRangingAuthenticated=" + this.mIsRangingAuthenticated + ", isRangingFrameProtected=" + this.mIsRangingFrameProtected + ", isSecureHeLtfEnabled=" + this.mIsSecureHeLtfEnabled + ", pasnComebackCookie=" + Arrays.toString(this.mPasnComebackCookie) + ", pasnComebackAfterMillis=" + this.mPasnComebackAfterMillis + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangingResult)) {
            return false;
        }
        RangingResult lhs = (RangingResult)o;
        return this.mStatus == lhs.mStatus && Objects.equals(this.mMac, lhs.mMac) && Objects.equals(this.mPeerHandle, lhs.mPeerHandle) && this.mDistanceMm == lhs.mDistanceMm && this.mDistanceStdDevMm == lhs.mDistanceStdDevMm && this.mRssi == lhs.mRssi && this.mNumAttemptedMeasurements == lhs.mNumAttemptedMeasurements && this.mNumSuccessfulMeasurements == lhs.mNumSuccessfulMeasurements && Arrays.equals(this.mLci, lhs.mLci) && Arrays.equals(this.mLcr, lhs.mLcr) && this.mTimestamp == lhs.mTimestamp && this.mIs80211mcMeasurement == lhs.mIs80211mcMeasurement && Objects.equals(this.mResponderLocation, lhs.mResponderLocation) && this.mFrequencyMHz == lhs.mFrequencyMHz && this.mPacketBw == lhs.mPacketBw && this.mIs80211azNtbMeasurement == lhs.mIs80211azNtbMeasurement && this.mNtbMinMeasurementTime == lhs.mNtbMinMeasurementTime && this.mNtbMaxMeasurementTime == lhs.mNtbMaxMeasurementTime && this.mI2rTxLtfRepetitions == lhs.mI2rTxLtfRepetitions && this.mR2iTxLtfRepetitions == lhs.mR2iTxLtfRepetitions && this.mNumTxSpatialStreams == lhs.mNumTxSpatialStreams && this.mNumRxSpatialStreams == lhs.mNumRxSpatialStreams && Objects.equals(this.mVendorData, lhs.mVendorData) && this.mIsRangingAuthenticated == lhs.mIsRangingAuthenticated && this.mIsRangingFrameProtected == lhs.mIsRangingFrameProtected && this.mIsSecureHeLtfEnabled == lhs.isSecureHeLtfEnabled() && this.mPasnComebackAfterMillis == lhs.mPasnComebackAfterMillis && Arrays.equals(this.mPasnComebackCookie, lhs.mPasnComebackCookie);
    }

    public int hashCode() {
        return Objects.hash(this.mStatus, this.mMac, this.mPeerHandle, this.mDistanceMm, this.mDistanceStdDevMm, this.mRssi, this.mNumAttemptedMeasurements, this.mNumSuccessfulMeasurements, Arrays.hashCode(this.mLci), Arrays.hashCode(this.mLcr), this.mResponderLocation, this.mTimestamp, this.mIs80211mcMeasurement, this.mFrequencyMHz, this.mPacketBw, this.mIs80211azNtbMeasurement, this.mNtbMinMeasurementTime, this.mNtbMaxMeasurementTime, this.mI2rTxLtfRepetitions, this.mR2iTxLtfRepetitions, this.mNumTxSpatialStreams, this.mR2iTxLtfRepetitions, this.mVendorData, this.mIsRangingAuthenticated, this.mIsRangingFrameProtected, this.mIsSecureHeLtfEnabled, this.mPasnComebackAfterMillis, Arrays.hashCode(this.mPasnComebackCookie));
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static class Builder {
        private int mStatus = 1;
        private MacAddress mMac = null;
        private PeerHandle mPeerHandle = null;
        private int mDistanceMm = 0;
        private int mDistanceStdDevMm = 0;
        private int mRssi = -127;
        private int mNumAttemptedMeasurements = 0;
        private int mNumSuccessfulMeasurements = 0;
        private byte[] mLci = null;
        private byte[] mLcr = null;
        private ResponderLocation mResponderLocation = null;
        private long mTimestamp = 0L;
        private boolean mIs80211mcMeasurement = false;
        private int mFrequencyMHz = -1;
        private int mPacketBw = -1;
        private boolean mIs80211azNtbMeasurement = false;
        private long mNtbMinMeasurementTime = -1L;
        private long mNtbMaxMeasurementTime = -1L;
        private int mI2rTxLtfRepetitions = -1;
        private int mR2iTxLtfRepetitions = -1;
        private int mNumTxSpatialStreams = -1;
        private int mNumRxSpatialStreams = -1;
        private List<OuiKeyedData> mVendorData = Collections.emptyList();
        private boolean mIsRangingAuthenticated;
        private boolean mIsRangingFrameProtected;
        private boolean mIsSecureHeLtfEnabled;
        private int mSecureHeLtfProtocolVersion;
        private byte[] mPasnComebackCookie = null;
        private long mPasnComebackAfterMillis = -1L;

        public Builder() {
        }

        public Builder(@NonNull RangingResult other) {
            if (other == null) {
                Log.e(RangingResult.TAG, "Cannot provide a null RangingResult");
                return;
            }
            this.mStatus = other.mStatus;
            this.mMac = other.mMac;
            this.mPeerHandle = other.mPeerHandle;
            this.mDistanceMm = other.mDistanceMm;
            this.mDistanceStdDevMm = other.mDistanceStdDevMm;
            this.mRssi = other.mRssi;
            this.mNumAttemptedMeasurements = other.mNumAttemptedMeasurements;
            this.mNumSuccessfulMeasurements = other.mNumSuccessfulMeasurements;
            if (other.mLci != null) {
                this.mLci = (byte[])other.mLci.clone();
            }
            if (other.mLcr != null) {
                this.mLcr = (byte[])other.mLcr.clone();
            }
            this.mResponderLocation = new ResponderLocation(this.mLci, this.mLcr);
            this.mTimestamp = other.mTimestamp;
            this.mIs80211mcMeasurement = other.mIs80211mcMeasurement;
            this.mFrequencyMHz = other.mFrequencyMHz;
            this.mPacketBw = other.mPacketBw;
            this.mIs80211azNtbMeasurement = other.mIs80211azNtbMeasurement;
            this.mNtbMinMeasurementTime = other.mNtbMinMeasurementTime;
            this.mNtbMaxMeasurementTime = other.mNtbMaxMeasurementTime;
            this.mI2rTxLtfRepetitions = other.mI2rTxLtfRepetitions;
            this.mR2iTxLtfRepetitions = other.mR2iTxLtfRepetitions;
            this.mNumTxSpatialStreams = other.mNumTxSpatialStreams;
            this.mNumRxSpatialStreams = other.mNumRxSpatialStreams;
            this.mIsRangingAuthenticated = other.mIsRangingAuthenticated;
            this.mIsRangingFrameProtected = other.mIsRangingFrameProtected;
            this.mIsSecureHeLtfEnabled = other.mIsSecureHeLtfEnabled;
            this.mSecureHeLtfProtocolVersion = other.mSecureHeLtfProtocolVersion;
            if (other.mPasnComebackCookie != null) {
                this.mPasnComebackCookie = (byte[])other.mPasnComebackCookie.clone();
                this.mPasnComebackAfterMillis = other.mPasnComebackAfterMillis;
            }
            this.mVendorData = new ArrayList<OuiKeyedData>(other.mVendorData);
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setStatus(int status) {
            this.mStatus = status;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setMacAddress(@Nullable MacAddress macAddress) {
            this.mMac = macAddress;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setPeerHandle(@Nullable PeerHandle peerHandle) {
            this.mPeerHandle = peerHandle;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setDistanceMm(int distanceMm) {
            this.mDistanceMm = distanceMm;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setDistanceStdDevMm(int distanceStdDevMm) {
            this.mDistanceStdDevMm = distanceStdDevMm;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setRssi(int rssi) {
            this.mRssi = rssi;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setNumAttemptedMeasurements(int numAttemptedMeasurements) {
            this.mNumAttemptedMeasurements = numAttemptedMeasurements;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setNumSuccessfulMeasurements(int numSuccessfulMeasurements) {
            this.mNumSuccessfulMeasurements = numSuccessfulMeasurements;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setLci(@Nullable byte[] lci) {
            this.mLci = lci;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setLcr(@Nullable byte[] lcr) {
            this.mLcr = lcr;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setUnverifiedResponderLocation(@Nullable ResponderLocation responderLocation) {
            this.mResponderLocation = responderLocation;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setRangingTimestampMillis(long timestamp) {
            this.mTimestamp = timestamp;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder set80211mcMeasurement(boolean is80211mcMeasurement) {
            this.mIs80211mcMeasurement = is80211mcMeasurement;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setMeasurementChannelFrequencyMHz(int frequencyMHz) {
            this.mFrequencyMHz = frequencyMHz;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setMeasurementBandwidth(int measurementBandwidth) {
            this.mPacketBw = measurementBandwidth;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder set80211azNtbMeasurement(boolean is80211azNtbMeasurement) {
            this.mIs80211azNtbMeasurement = is80211azNtbMeasurement;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setMinTimeBetweenNtbMeasurementsMicros(long ntbMinMeasurementTime) {
            this.mNtbMinMeasurementTime = ntbMinMeasurementTime;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setMaxTimeBetweenNtbMeasurementsMicros(long ntbMaxMeasurementTime) {
            this.mNtbMaxMeasurementTime = ntbMaxMeasurementTime;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder set80211azInitiatorTxLtfRepetitionsCount(int i2rTxLtfRepetitions) {
            this.mI2rTxLtfRepetitions = i2rTxLtfRepetitions;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder set80211azResponderTxLtfRepetitionsCount(int r2iTxLtfRepetitions) {
            this.mR2iTxLtfRepetitions = r2iTxLtfRepetitions;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder set80211azNumberOfTxSpatialStreams(int numTxSpatialStreams) {
            this.mNumTxSpatialStreams = numTxSpatialStreams;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder set80211azNumberOfRxSpatialStreams(int numRxSpatialStreams) {
            this.mNumRxSpatialStreams = numRxSpatialStreams;
            return this;
        }

        @SystemApi
        @RequiresApi(value=35)
        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setVendorData(@NonNull List<OuiKeyedData> vendorData) {
            if (!SdkLevel.isAtLeastV()) {
                throw new UnsupportedOperationException();
            }
            if (vendorData == null) {
                throw new IllegalArgumentException("setVendorData received a null value");
            }
            this.mVendorData = vendorData;
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
        public Builder setRangingAuthenticated(boolean isRangingAuthenticated) {
            this.mIsRangingAuthenticated = isRangingAuthenticated;
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
        public Builder setRangingFrameProtected(boolean isRangingFrameProtected) {
            this.mIsRangingFrameProtected = isRangingFrameProtected;
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
        public Builder setSecureHeLtfEnabled(boolean isSecureHeLtfEnabled) {
            this.mIsSecureHeLtfEnabled = isSecureHeLtfEnabled;
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
        public Builder setSecureHeLtfProtocolVersion(int secureHeLtfProtocolVersion) {
            this.mSecureHeLtfProtocolVersion = secureHeLtfProtocolVersion;
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
        public Builder setPasnComebackCookie(@NonNull byte[] pasnComebackCookie) {
            this.mPasnComebackCookie = pasnComebackCookie;
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
        public Builder setPasnComebackAfterMillis(long comebackAfterMillis) {
            this.mPasnComebackAfterMillis = comebackAfterMillis;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public RangingResult build() {
            if (this.mMac == null && this.mPeerHandle == null) {
                throw new IllegalArgumentException("Either MAC address or Peer handle is needed");
            }
            if (this.mIs80211azNtbMeasurement && this.mIs80211mcMeasurement) {
                throw new IllegalArgumentException("A ranging result cannot use both IEEE 802.11mc and IEEE 802.11az measurements simultaneously");
            }
            return new RangingResult(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RangeResultStatus {
    }
}

