/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.annotation.FlaggedApi;
import android.net.wifi.rtt.PasnConfig;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.util.Objects;

@FlaggedApi(value="com.android.wifi.flags.secure_ranging")
public class SecureRangingConfig
implements Parcelable {
    private final boolean mEnableSecureHeLtf;
    private final boolean mEnableRangingFrameProtection;
    private final PasnConfig mPasnConfig;
    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    @android.annotation.NonNull
    public static final Parcelable.Creator<SecureRangingConfig> CREATOR = new Parcelable.Creator<SecureRangingConfig>(){

        @Override
        public SecureRangingConfig createFromParcel(Parcel in) {
            return new SecureRangingConfig(in);
        }

        public SecureRangingConfig[] newArray(int size) {
            return new SecureRangingConfig[size];
        }
    };

    private SecureRangingConfig(boolean enableSecureHeLtf, boolean enableRangingFrameProtection, @android.annotation.NonNull PasnConfig pasnConfig) {
        Objects.requireNonNull(pasnConfig, "pasnConfig cannot be null");
        this.mEnableSecureHeLtf = enableSecureHeLtf;
        this.mEnableRangingFrameProtection = enableRangingFrameProtection;
        this.mPasnConfig = pasnConfig;
    }

    private SecureRangingConfig(@android.annotation.NonNull Parcel in) {
        this.mEnableSecureHeLtf = in.readByte() != 0;
        this.mEnableRangingFrameProtection = in.readByte() != 0;
        this.mPasnConfig = SdkLevel.isAtLeastT() ? in.readParcelable(PasnConfig.class.getClassLoader(), PasnConfig.class) : (PasnConfig)in.readParcelable(PasnConfig.class.getClassLoader());
    }

    private SecureRangingConfig(Builder builder) {
        this.mEnableSecureHeLtf = builder.mEnableSecureHeLtf;
        this.mEnableRangingFrameProtection = builder.mEnableRangingFrameProtection;
        this.mPasnConfig = builder.mPasnConfig;
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public boolean isSecureHeLtfEnabled() {
        return this.mEnableSecureHeLtf;
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public boolean isRangingFrameProtectionEnabled() {
        return this.mEnableRangingFrameProtection;
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    @android.annotation.NonNull
    public PasnConfig getPasnConfig() {
        return this.mPasnConfig;
    }

    @Override
    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public int describeContents() {
        return 0;
    }

    @Override
    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeByte((byte)(this.mEnableSecureHeLtf ? 1 : 0));
        dest.writeByte((byte)(this.mEnableRangingFrameProtection ? 1 : 0));
        dest.writeParcelable(this.mPasnConfig, flags);
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public String toString() {
        return "SecureRangingConfig{mEnableSecureHeLtf=" + this.mEnableSecureHeLtf + ", mEnableRangingProtection=" + this.mEnableRangingFrameProtection + ", mPasnConfig=" + this.mPasnConfig + '}';
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecureRangingConfig)) {
            return false;
        }
        SecureRangingConfig that = (SecureRangingConfig)o;
        return this.mEnableSecureHeLtf == that.mEnableSecureHeLtf && this.mEnableRangingFrameProtection == that.mEnableRangingFrameProtection && Objects.equals(this.mPasnConfig, that.mPasnConfig);
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public int hashCode() {
        return Objects.hash(this.mEnableSecureHeLtf, this.mEnableRangingFrameProtection, this.mPasnConfig);
    }

    @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
    public static class Builder {
        private boolean mEnableSecureHeLtf = true;
        private boolean mEnableRangingFrameProtection = true;
        private final PasnConfig mPasnConfig;

        @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
        public Builder(@android.annotation.NonNull PasnConfig pasnConfig) {
            Objects.requireNonNull(pasnConfig, "pasnConfig must not be null");
            this.mPasnConfig = pasnConfig;
        }

        @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
        @android.annotation.NonNull
        public Builder setSecureHeLtfEnabled(boolean enableSecureHeLtf) {
            this.mEnableSecureHeLtf = enableSecureHeLtf;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
        @android.annotation.NonNull
        public Builder setRangingFrameProtectionEnabled(boolean enableRangingFrameProtection) {
            this.mEnableRangingFrameProtection = enableRangingFrameProtection;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.secure_ranging")
        @android.annotation.NonNull
        public SecureRangingConfig build() {
            return new SecureRangingConfig(this);
        }
    }
}

