/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.usd;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.wifi.aware.TlvBufferUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.net.wifi.flags.usd")
public abstract class Config {
    public static final int MAX_NUM_OF_OPERATING_FREQUENCIES = 32;
    public static final int TRANSMISSION_TYPE_UNICAST = 0;
    public static final int TRANSMISSION_TYPE_MULTICAST = 1;
    public static final int SUBSCRIBE_TYPE_PASSIVE = 0;
    public static final int SUBSCRIBE_TYPE_ACTIVE = 1;
    public static final int SERVICE_PROTO_TYPE_GENERIC = 0;
    public static final int SERVICE_PROTO_TYPE_CSA_MATTER = 1;
    private final byte[] mServiceName;
    private final int mTtlSeconds;
    private final int mServiceProtoType;
    private final byte[] mTxMatchFilterTlv;
    private final byte[] mRxMatchFilterTlv;
    private final byte[] mServiceSpecificInfo;
    private final int[] mOperatingFrequencies;

    public Config(@NonNull byte[] serviceName, int ttlSeconds, int serviceProtoType, @Nullable byte[] txMatchFilterTlv, @Nullable byte[] rxMatchFilterTlv, @Nullable byte[] serviceSpecificInfo, @Nullable int[] operatingFrequencies) {
        this.mServiceName = serviceName;
        this.mTtlSeconds = ttlSeconds;
        this.mServiceProtoType = serviceProtoType;
        this.mTxMatchFilterTlv = txMatchFilterTlv;
        this.mRxMatchFilterTlv = rxMatchFilterTlv;
        this.mServiceSpecificInfo = serviceSpecificInfo;
        this.mOperatingFrequencies = operatingFrequencies;
    }

    @NonNull
    public byte[] getServiceName() {
        return this.mServiceName;
    }

    public int getTtlSeconds() {
        return this.mTtlSeconds;
    }

    public int getServiceProtoType() {
        return this.mServiceProtoType;
    }

    @NonNull
    public List<byte[]> getTxMatchFilter() {
        return new TlvBufferUtils.TlvIterable(0, 1, this.mTxMatchFilterTlv).toList();
    }

    @Nullable
    public byte[] getTxMatchFilterTlv() {
        return this.mTxMatchFilterTlv;
    }

    @NonNull
    public List<byte[]> getRxMatchFilter() {
        return new TlvBufferUtils.TlvIterable(0, 1, this.mRxMatchFilterTlv).toList();
    }

    @Nullable
    public byte[] getRxMatchFilterTlv() {
        return this.mRxMatchFilterTlv;
    }

    @Nullable
    public byte[] getServiceSpecificInfo() {
        return this.mServiceSpecificInfo;
    }

    @Nullable
    public int[] getOperatingFrequenciesMhz() {
        return this.mOperatingFrequencies;
    }

    public String toString() {
        return "Config{mServiceName=" + Arrays.toString(this.mServiceName) + ", mTtlSeconds=" + this.mTtlSeconds + ", mServiceProtoType=" + this.mServiceProtoType + ", mTxMatchFilterTlv=" + Arrays.toString(this.mTxMatchFilterTlv) + ", mRxMatchFilterTlv=" + Arrays.toString(this.mRxMatchFilterTlv) + ", mServiceSpecificInfo=" + Arrays.toString(this.mServiceSpecificInfo) + ", mOperatingFrequencies=" + Arrays.toString(this.mOperatingFrequencies) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config config = (Config)o;
        return this.mTtlSeconds == config.mTtlSeconds && this.mServiceProtoType == config.mServiceProtoType && Arrays.equals(this.mServiceName, config.mServiceName) && Arrays.equals(this.mTxMatchFilterTlv, config.mTxMatchFilterTlv) && Arrays.equals(this.mRxMatchFilterTlv, config.mRxMatchFilterTlv) && Arrays.equals(this.mServiceSpecificInfo, config.mServiceSpecificInfo) && Arrays.equals(this.mOperatingFrequencies, config.mOperatingFrequencies);
    }

    public int hashCode() {
        int result = Objects.hash(this.mTtlSeconds, this.mServiceProtoType);
        result = 31 * result + Arrays.hashCode(this.mServiceName);
        result = 31 * result + Arrays.hashCode(this.mTxMatchFilterTlv);
        result = 31 * result + Arrays.hashCode(this.mRxMatchFilterTlv);
        result = 31 * result + Arrays.hashCode(this.mServiceSpecificInfo);
        result = 31 * result + Arrays.hashCode(this.mOperatingFrequencies);
        return result;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ServiceProtoType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SubscribeType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TransmissionType {
    }
}

