/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.MacAddress;
import android.net.wifi.ScanResult;
import android.net.wifi.SecurityParams;
import android.net.wifi.WifiConfiguration;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.layoutlib.androidx.annotation.Keep;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class ScanResultUtil {
    private static final String TAG = "ScanResultUtil";

    private ScanResultUtil() {
    }

    public static boolean isScanResultForPskNetwork(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("PSK");
    }

    public static boolean isScanResultForWapiPskNetwork(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("WAPI-PSK");
    }

    public static boolean isScanResultForWapiCertNetwork(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("WAPI-CERT");
    }

    private static boolean isScanResultForPmfMandatoryNetwork(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("[MFPR]");
    }

    private static boolean isScanResultForPmfCapableNetwork(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("[MFPC]");
    }

    public static boolean isEapScanResultForPasspointR1R2Network(@NonNull ScanResult scanResult) {
        return scanResult.isPasspointNetwork();
    }

    public static boolean isEapScanResultForPasspointR3Network(@NonNull ScanResult scanResult) {
        if (!ScanResultUtil.isScanResultForPmfMandatoryNetwork(scanResult)) {
            return false;
        }
        return scanResult.isPasspointNetwork();
    }

    public static boolean isScanResultForWpa3EnterpriseTransitionNetwork(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("EAP/SHA1") && scanResult.capabilities.contains("EAP/SHA256") && scanResult.capabilities.contains("RSN") && !scanResult.capabilities.contains("WEP") && !scanResult.capabilities.contains("TKIP") && !ScanResultUtil.isScanResultForPmfMandatoryNetwork(scanResult) && ScanResultUtil.isScanResultForPmfCapableNetwork(scanResult);
    }

    public static boolean isScanResultForWpa3EnterpriseOnlyNetwork(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("EAP/SHA256") && !scanResult.capabilities.contains("EAP/SHA1") && scanResult.capabilities.contains("RSN") && !scanResult.capabilities.contains("WEP") && !scanResult.capabilities.contains("TKIP") && ScanResultUtil.isScanResultForPmfMandatoryNetwork(scanResult) && ScanResultUtil.isScanResultForPmfCapableNetwork(scanResult);
    }

    public static boolean isScanResultForEapSuiteBNetwork(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("SUITE_B_192") && scanResult.capabilities.contains("RSN") && !scanResult.capabilities.contains("WEP") && !scanResult.capabilities.contains("TKIP") && ScanResultUtil.isScanResultForPmfMandatoryNetwork(scanResult);
    }

    public static boolean isScanResultForWepNetwork(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("WEP");
    }

    public static boolean isScanResultForOweNetwork(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("OWE");
    }

    public static boolean isScanResultForOweTransitionNetwork(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("OWE_TRANSITION");
    }

    public static boolean isScanResultForSaeNetwork(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("SAE");
    }

    public static boolean isScanResultForPskSaeTransitionNetwork(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("PSK") && scanResult.capabilities.contains("SAE");
    }

    public static boolean isScanResultForFilsSha256Network(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("FILS-SHA256");
    }

    public static boolean isScanResultForFilsSha384Network(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("FILS-SHA384");
    }

    public static boolean isScanResultForDppNetwork(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("DPP");
    }

    public static boolean isScanResultForWpaPersonalOnlyNetwork(@NonNull ScanResult scanResult) {
        return ScanResultUtil.isScanResultForPskNetwork(scanResult) && !scanResult.capabilities.contains("RSN");
    }

    public static boolean isScanResultForUnknownAkmNetwork(@NonNull ScanResult scanResult) {
        return scanResult.capabilities.contains("?");
    }

    public static boolean isScanResultForPskOnlyNetwork(@NonNull ScanResult r) {
        return ScanResultUtil.isScanResultForPskNetwork(r) && !ScanResultUtil.isScanResultForSaeNetwork(r);
    }

    public static boolean isScanResultForSaeOnlyNetwork(@NonNull ScanResult r) {
        return !ScanResultUtil.isScanResultForPskNetwork(r) && ScanResultUtil.isScanResultForSaeNetwork(r);
    }

    public static boolean isScanResultForOpenOnlyNetwork(@NonNull ScanResult r) {
        return ScanResultUtil.isScanResultForOpenNetwork(r) && !ScanResultUtil.isScanResultForOweNetwork(r);
    }

    public static boolean isScanResultForOweOnlyNetwork(@NonNull ScanResult r) {
        return !ScanResultUtil.isScanResultForOweTransitionNetwork(r) && ScanResultUtil.isScanResultForOweNetwork(r);
    }

    public static boolean isScanResultForWpa2EnterpriseOnlyNetwork(@NonNull ScanResult scanResult) {
        return (scanResult.capabilities.contains("EAP/SHA1") || scanResult.capabilities.contains("EAP/SHA256") || scanResult.capabilities.contains("FT/EAP") || scanResult.capabilities.contains("EAP-FILS")) && !ScanResultUtil.isScanResultForWpa3EnterpriseOnlyNetwork(scanResult) && !ScanResultUtil.isScanResultForWpa3EnterpriseTransitionNetwork(scanResult);
    }

    public static boolean isScanResultForOpenNetwork(@NonNull ScanResult scanResult) {
        return !ScanResultUtil.isScanResultForWepNetwork(scanResult) && !ScanResultUtil.isScanResultForPskNetwork(scanResult) && !ScanResultUtil.isScanResultForWpa2EnterpriseOnlyNetwork(scanResult) && !ScanResultUtil.isScanResultForSaeNetwork(scanResult) && !ScanResultUtil.isScanResultForWpa3EnterpriseTransitionNetwork(scanResult) && !ScanResultUtil.isScanResultForWpa3EnterpriseOnlyNetwork(scanResult) && !ScanResultUtil.isScanResultForWapiPskNetwork(scanResult) && !ScanResultUtil.isScanResultForWapiCertNetwork(scanResult) && !ScanResultUtil.isScanResultForEapSuiteBNetwork(scanResult) && !ScanResultUtil.isScanResultForDppNetwork(scanResult) && !ScanResultUtil.isScanResultForUnknownAkmNetwork(scanResult);
    }

    @VisibleForTesting
    @NonNull
    public static String createQuotedSsid(@Nullable String ssid) {
        return "\"" + ssid + "\"";
    }

    @Keep
    @Nullable
    public static WifiConfiguration createNetworkFromScanResult(@NonNull ScanResult scanResult) {
        WifiConfiguration config = new WifiConfiguration();
        config.SSID = ScanResultUtil.createQuotedSsid(scanResult.SSID);
        List<SecurityParams> list = ScanResultUtil.generateSecurityParamsListFromScanResult(scanResult);
        if (list.isEmpty()) {
            return null;
        }
        config.setSecurityParams(list);
        return config;
    }

    @NonNull
    public static List<SecurityParams> generateSecurityParamsListFromScanResult(@NonNull ScanResult scanResult) {
        ArrayList<SecurityParams> list = new ArrayList<SecurityParams>();
        if (ScanResultUtil.isScanResultForOweTransitionNetwork(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(0));
            list.add(SecurityParams.createSecurityParamsBySecurityType(6));
            return list;
        }
        if (ScanResultUtil.isScanResultForOweNetwork(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(6));
            return list;
        }
        if (ScanResultUtil.isScanResultForOpenNetwork(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(0));
            return list;
        }
        if (ScanResultUtil.isScanResultForWepNetwork(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(1));
            return list;
        }
        if (ScanResultUtil.isScanResultForWapiPskNetwork(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(7));
            return list;
        }
        if (ScanResultUtil.isScanResultForWapiCertNetwork(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(8));
            return list;
        }
        if (ScanResultUtil.isScanResultForPskNetwork(scanResult) && ScanResultUtil.isScanResultForSaeNetwork(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(2));
            list.add(SecurityParams.createSecurityParamsBySecurityType(4));
            return list;
        }
        if (ScanResultUtil.isScanResultForPskNetwork(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(2));
            return list;
        }
        if (ScanResultUtil.isScanResultForSaeNetwork(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(4));
            return list;
        }
        if (ScanResultUtil.isScanResultForDppNetwork(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(13));
            return list;
        }
        boolean isEapNetworkAndNotSuiteB = false;
        if (ScanResultUtil.isScanResultForEapSuiteBNetwork(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(5));
        } else if (ScanResultUtil.isScanResultForWpa3EnterpriseTransitionNetwork(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(3));
            list.add(SecurityParams.createSecurityParamsBySecurityType(9));
            isEapNetworkAndNotSuiteB = true;
        } else if (ScanResultUtil.isScanResultForWpa3EnterpriseOnlyNetwork(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(9));
            isEapNetworkAndNotSuiteB = true;
        } else if (ScanResultUtil.isScanResultForWpa2EnterpriseOnlyNetwork(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(3));
            isEapNetworkAndNotSuiteB = true;
        }
        if (!isEapNetworkAndNotSuiteB) {
            return list;
        }
        if (ScanResultUtil.isEapScanResultForPasspointR1R2Network(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(11));
        }
        if (ScanResultUtil.isEapScanResultForPasspointR3Network(scanResult)) {
            list.add(SecurityParams.createSecurityParamsBySecurityType(12));
        }
        return list;
    }

    public static void dumpScanResults(@NonNull PrintWriter pw, @Nullable List<ScanResult> scanResults, long nowMs) {
        if (scanResults != null && scanResults.size() != 0) {
            pw.println("    BSSID              Frequency      RSSI           Age(sec)     SSID                                 Flags");
            for (ScanResult r : scanResults) {
                int numRadioChainInfos;
                long timeStampMs = r.timestamp / 1000L;
                String age = timeStampMs <= 0L ? "___?___" : (nowMs < timeStampMs ? "  0.000" : (timeStampMs < nowMs - 1000000L ? ">1000.0" : String.format("%3.3f", (double)(nowMs - timeStampMs) / 1000.0)));
                String ssid = r.SSID == null ? "" : r.SSID;
                String rssiInfo = "";
                int n = numRadioChainInfos = r.radioChainInfos == null ? 0 : r.radioChainInfos.length;
                rssiInfo = numRadioChainInfos == 1 ? String.format("%5d(%1d:%3d)       ", r.level, r.radioChainInfos[0].id, r.radioChainInfos[0].level) : (numRadioChainInfos == 2 ? String.format("%5d(%1d:%3d/%1d:%3d)", r.level, r.radioChainInfos[0].id, r.radioChainInfos[0].level, r.radioChainInfos[1].id, r.radioChainInfos[1].level) : String.format("%9d         ", r.level));
                String capabilities = r.capabilities;
                if ((r.flags & 1L) == 1L) {
                    capabilities = capabilities + "[PASSPOINT]";
                }
                pw.printf("  %17s  %9d  %18s   %7s    %-32s  %s\n", r.BSSID, r.frequency, rssiInfo, age, String.format("%1.32s", ssid), capabilities);
            }
        }
    }

    public static boolean validateScanResultList(@Nullable List<ScanResult> scanResults) {
        if (scanResults == null || scanResults.isEmpty()) {
            Log.w(TAG, "Empty or null ScanResult list");
            return false;
        }
        for (ScanResult scanResult : scanResults) {
            if (ScanResultUtil.validate(scanResult)) continue;
            Log.w(TAG, "Invalid ScanResult: " + scanResult);
            return false;
        }
        return true;
    }

    private static boolean validate(@Nullable ScanResult scanResult) {
        return scanResult != null && scanResult.SSID != null && scanResult.capabilities != null && scanResult.BSSID != null;
    }

    public static String redactBssid(MacAddress bssid, int numRedactedOctets) {
        if (bssid == null) {
            return "";
        }
        StringBuilder redactedBssid = new StringBuilder();
        byte[] bssidBytes = bssid.toByteArray();
        if (numRedactedOctets < 0 || numRedactedOctets > 6) {
            numRedactedOctets = 4;
        }
        for (int i = 0; i < 6; ++i) {
            if (i < numRedactedOctets) {
                redactedBssid.append("xx");
            } else {
                redactedBssid.append(String.format("%02X", bssidBytes[i]));
            }
            if (i == 5) continue;
            redactedBssid.append(":");
        }
        return redactedBssid.toString();
    }
}

