/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.app.Activity;
import android.compat.annotation.UnsupportedAppUsage;
import android.nfc.NfcActivityManager;
import android.nfc.NfcAdapter;
import android.os.Binder;
import android.os.Bundle;

public class NfcActivityState {
    @UnsupportedAppUsage
    boolean resumed = false;
    @UnsupportedAppUsage
    Activity activity;
    @UnsupportedAppUsage
    NfcAdapter.ReaderCallback readerCallback = null;
    @UnsupportedAppUsage
    int readerModeFlags = 0;
    @UnsupportedAppUsage
    Bundle readerModeExtras = null;
    @UnsupportedAppUsage
    Binder token;
    @UnsupportedAppUsage
    int mPollTech = 255;
    @UnsupportedAppUsage
    int mListenTech = 255;
    @UnsupportedAppUsage
    private final NfcActivityManager mNfcActivityManager;

    public NfcActivityState(Activity activity, NfcActivityManager activityManager) {
        this.mNfcActivityManager = activityManager;
        if (activity.isDestroyed()) {
            throw new IllegalStateException("activity is already destroyed");
        }
        this.resumed = activity.isResumed();
        this.activity = activity;
        this.token = new Binder();
        this.mNfcActivityManager.registerApplication(activity.getApplication());
    }

    public void destroy() {
        this.mNfcActivityManager.unregisterApplication(this.activity.getApplication());
        this.resumed = false;
        this.activity = null;
        this.readerCallback = null;
        this.readerModeFlags = 0;
        this.readerModeExtras = null;
        this.token = null;
        this.mPollTech = 255;
        this.mListenTech = 255;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("[");
        s.append(this.readerCallback);
        s.append("]");
        return s.toString();
    }
}

