/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.NonNull;
import android.nfc.INfcControllerAlwaysOnListener;
import android.nfc.NfcAdapter;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class NfcControllerAlwaysOnListener
extends INfcControllerAlwaysOnListener.Stub {
    private static final String TAG = NfcControllerAlwaysOnListener.class.getSimpleName();
    private final Map<NfcAdapter.ControllerAlwaysOnListener, Executor> mListenerMap = new HashMap<NfcAdapter.ControllerAlwaysOnListener, Executor>();
    private IBinder.DeathRecipient mDeathRecipient;
    private boolean mCurrentState = false;
    private boolean mIsRegistered = false;

    private void linkToNfcDeath() {
        try {
            this.mDeathRecipient = new IBinder.DeathRecipient(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void binderDied() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        NfcControllerAlwaysOnListener.this.mDeathRecipient = null;
                    }
                    final Handler handler = new Handler(Looper.getMainLooper());
                    handler.postDelayed(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                1 var1_1 = this;
                                synchronized (var1_1) {
                                    if (!NfcControllerAlwaysOnListener.this.mListenerMap.isEmpty()) {
                                        NfcAdapter.callService(() -> NfcAdapter.getService().registerControllerAlwaysOnListener(NfcControllerAlwaysOnListener.this));
                                    }
                                }
                            }
                            catch (Throwable t) {
                                handler.postDelayed(this, 50L);
                            }
                        }
                    }, 50L);
                }
            };
            NfcAdapter.getService().asBinder().linkToDeath(this.mDeathRecipient, 0);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't link to death");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NonNull Executor executor, @NonNull NfcAdapter.ControllerAlwaysOnListener listener) {
        if (!NfcAdapter.callServiceReturn(() -> NfcAdapter.getService().isControllerAlwaysOnSupported(), false).booleanValue()) {
            return;
        }
        NfcControllerAlwaysOnListener nfcControllerAlwaysOnListener = this;
        synchronized (nfcControllerAlwaysOnListener) {
            if (this.mListenerMap.containsKey(listener)) {
                return;
            }
            this.mListenerMap.put(listener, executor);
            if (!this.mIsRegistered) {
                NfcControllerAlwaysOnListener listenerAidl = this;
                NfcAdapter.callService(() -> {
                    NfcAdapter.getService().registerControllerAlwaysOnListener(listenerAidl);
                    this.linkToNfcDeath();
                    this.mIsRegistered = true;
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(@NonNull NfcAdapter.ControllerAlwaysOnListener listener) {
        if (!NfcAdapter.callServiceReturn(() -> NfcAdapter.getService().isControllerAlwaysOnSupported(), false).booleanValue()) {
            return;
        }
        NfcControllerAlwaysOnListener nfcControllerAlwaysOnListener = this;
        synchronized (nfcControllerAlwaysOnListener) {
            if (!this.mListenerMap.containsKey(listener)) {
                return;
            }
            this.mListenerMap.remove(listener);
            if (this.mListenerMap.isEmpty() && this.mIsRegistered) {
                NfcControllerAlwaysOnListener listenerAidl = this;
                NfcAdapter.callService(() -> {
                    NfcAdapter.getService().unregisterControllerAlwaysOnListener(listenerAidl);
                    if (this.mDeathRecipient != null) {
                        NfcAdapter.getService().asBinder().unlinkToDeath(this.mDeathRecipient, 0);
                        this.mDeathRecipient = null;
                    }
                    this.mIsRegistered = false;
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCurrentState(@NonNull NfcAdapter.ControllerAlwaysOnListener listener) {
        NfcControllerAlwaysOnListener nfcControllerAlwaysOnListener = this;
        synchronized (nfcControllerAlwaysOnListener) {
            Executor executor = this.mListenerMap.get(listener);
            long identity = Binder.clearCallingIdentity();
            try {
                executor.execute(() -> listener.onControllerAlwaysOnChanged(this.mCurrentState));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onControllerAlwaysOnChanged(boolean isEnabled) {
        NfcControllerAlwaysOnListener nfcControllerAlwaysOnListener = this;
        synchronized (nfcControllerAlwaysOnListener) {
            this.mCurrentState = isEnabled;
            for (NfcAdapter.ControllerAlwaysOnListener cb : this.mListenerMap.keySet()) {
                this.sendCurrentState(cb);
            }
        }
    }
}

