/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.NonNull;
import android.nfc.INfcAdapter;
import android.nfc.INfcWlcStateListener;
import android.nfc.NfcAdapter;
import android.nfc.WlcListenerDeviceInfo;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import com.android.nfc.x.android.nfc.Flags;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class NfcWlcStateListener
extends INfcWlcStateListener.Stub {
    private static final String TAG = NfcWlcStateListener.class.getSimpleName();
    private final INfcAdapter mAdapter;
    private final Map<NfcAdapter.WlcStateListener, Executor> mListenerMap = new HashMap<NfcAdapter.WlcStateListener, Executor>();
    private WlcListenerDeviceInfo mCurrentState = null;
    private boolean mIsRegistered = false;

    public NfcWlcStateListener(@NonNull INfcAdapter adapter) {
        this.mAdapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NonNull Executor executor, @NonNull NfcAdapter.WlcStateListener listener) {
        NfcWlcStateListener nfcWlcStateListener = this;
        synchronized (nfcWlcStateListener) {
            if (this.mListenerMap.containsKey(listener)) {
                return;
            }
            this.mListenerMap.put(listener, executor);
            if (!this.mIsRegistered) {
                try {
                    this.mAdapter.registerWlcStateListener(this);
                    this.mIsRegistered = true;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to register");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(@NonNull NfcAdapter.WlcStateListener listener) {
        NfcWlcStateListener nfcWlcStateListener = this;
        synchronized (nfcWlcStateListener) {
            if (!this.mListenerMap.containsKey(listener)) {
                return;
            }
            this.mListenerMap.remove(listener);
            if (this.mListenerMap.isEmpty() && this.mIsRegistered) {
                try {
                    this.mAdapter.unregisterWlcStateListener(this);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to unregister");
                }
                this.mIsRegistered = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCurrentState(@NonNull NfcAdapter.WlcStateListener listener) {
        NfcWlcStateListener nfcWlcStateListener = this;
        synchronized (nfcWlcStateListener) {
            Executor executor = this.mListenerMap.get(listener);
            long identity = Binder.clearCallingIdentity();
            try {
                if (Flags.enableNfcCharging()) {
                    executor.execute(() -> listener.onWlcStateChanged(this.mCurrentState));
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWlcStateChanged(@NonNull WlcListenerDeviceInfo wlcListenerDeviceInfo) {
        NfcWlcStateListener nfcWlcStateListener = this;
        synchronized (nfcWlcStateListener) {
            this.mCurrentState = wlcListenerDeviceInfo;
            for (NfcAdapter.WlcStateListener cb : this.mListenerMap.keySet()) {
                this.sendCurrentState(cb);
            }
        }
    }
}

