/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.NonNull;
import android.nfc.TagLostException;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;

public class TransceiveResult
implements Parcelable {
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_FAILURE = 1;
    public static final int RESULT_TAGLOST = 2;
    public static final int RESULT_EXCEEDED_LENGTH = 3;
    final int mResult;
    final byte[] mResponseData;
    @NonNull
    public static final Parcelable.Creator<TransceiveResult> CREATOR = new Parcelable.Creator<TransceiveResult>(){

        @Override
        public TransceiveResult createFromParcel(Parcel in) {
            byte[] responseData;
            int result = in.readInt();
            if (result == 0) {
                int responseLength = in.readInt();
                responseData = new byte[responseLength];
                in.readByteArray(responseData);
            } else {
                responseData = null;
            }
            return new TransceiveResult(result, responseData);
        }

        public TransceiveResult[] newArray(int size) {
            return new TransceiveResult[size];
        }
    };

    public TransceiveResult(int result, byte[] data) {
        this.mResult = result;
        this.mResponseData = data;
    }

    public byte[] getResponseOrThrow() throws IOException {
        switch (this.mResult) {
            case 0: {
                return this.mResponseData;
            }
            case 2: {
                throw new TagLostException("Tag was lost.");
            }
            case 3: {
                throw new IOException("Transceive length exceeds supported maximum");
            }
        }
        throw new IOException("Transceive failed");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mResult);
        if (this.mResult == 0) {
            dest.writeInt(this.mResponseData.length);
            dest.writeByteArray(this.mResponseData);
        }
    }
}

