/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.database.CursorWindow;
import android.os.PowerComponents;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.IntArray;
import android.util.Slog;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RavenwoodKeepWholeClass
public abstract class BatteryConsumer {
    private static final String TAG = "BatteryConsumer";
    public static final int POWER_COMPONENT_ANY = -1;
    public static final int POWER_COMPONENT_SCREEN = 0;
    public static final int POWER_COMPONENT_CPU = 1;
    public static final int POWER_COMPONENT_BLUETOOTH = 2;
    public static final int POWER_COMPONENT_CAMERA = 3;
    public static final int POWER_COMPONENT_AUDIO = 4;
    public static final int POWER_COMPONENT_VIDEO = 5;
    public static final int POWER_COMPONENT_FLASHLIGHT = 6;
    public static final int POWER_COMPONENT_SYSTEM_SERVICES = 7;
    public static final int POWER_COMPONENT_MOBILE_RADIO = 8;
    public static final int POWER_COMPONENT_SENSORS = 9;
    public static final int POWER_COMPONENT_GNSS = 10;
    public static final int POWER_COMPONENT_WIFI = 11;
    public static final int POWER_COMPONENT_WAKELOCK = 12;
    public static final int POWER_COMPONENT_MEMORY = 13;
    public static final int POWER_COMPONENT_PHONE = 14;
    public static final int POWER_COMPONENT_AMBIENT_DISPLAY = 15;
    public static final int POWER_COMPONENT_IDLE = 16;
    public static final int POWER_COMPONENT_REATTRIBUTED_TO_OTHER_CONSUMERS = 17;
    public static final int POWER_COMPONENT_BASE = 18;
    public static final int POWER_COMPONENT_COUNT = 19;
    public static final int FIRST_CUSTOM_POWER_COMPONENT_ID = 1000;
    public static final int LAST_CUSTOM_POWER_COMPONENT_ID = 9999;
    private static final String[] sPowerComponentNames = new String[19];
    @Deprecated
    public static final int POWER_MODEL_UNDEFINED = 0;
    @Deprecated
    public static final int POWER_MODEL_POWER_PROFILE = 1;
    @Deprecated
    public static final int POWER_MODEL_ENERGY_CONSUMPTION = 2;
    public static final int PROCESS_STATE_ANY = -1;
    public static final int PROCESS_STATE_UNSPECIFIED = 0;
    public static final int PROCESS_STATE_FOREGROUND = 1;
    public static final int PROCESS_STATE_BACKGROUND = 2;
    public static final int PROCESS_STATE_FOREGROUND_SERVICE = 3;
    public static final int PROCESS_STATE_CACHED = 4;
    public static final int PROCESS_STATE_COUNT = 5;
    private static final String[] sProcessStateNames;
    private static final IntArray SUPPORTED_POWER_COMPONENTS_PER_PROCESS_STATE;
    static final int COLUMN_INDEX_BATTERY_CONSUMER_TYPE = 0;
    static final int COLUMN_COUNT = 1;
    public static final int SCREEN_STATE_ANY = 0;
    public static final int SCREEN_STATE_UNSPECIFIED = 0;
    public static final int SCREEN_STATE_ON = 1;
    public static final int SCREEN_STATE_OTHER = 2;
    public static final int SCREEN_STATE_COUNT = 3;
    private static final String[] sScreenStateNames;
    public static final int POWER_STATE_ANY = 0;
    public static final int POWER_STATE_UNSPECIFIED = 0;
    public static final int POWER_STATE_BATTERY = 1;
    public static final int POWER_STATE_OTHER = 2;
    public static final int POWER_STATE_COUNT = 3;
    private static final String[] sPowerStateNames;
    public static final Dimensions UNSPECIFIED_DIMENSIONS;
    protected final BatteryConsumerData mData;
    protected final PowerComponents mPowerComponents;

    protected BatteryConsumer(BatteryConsumerData data, @NonNull PowerComponents powerComponents) {
        this.mData = data;
        this.mPowerComponents = powerComponents;
    }

    public BatteryConsumer(BatteryConsumerData data) {
        this.mData = data;
        this.mPowerComponents = new PowerComponents(data);
    }

    public String getPowerComponentName(int powerComponent) {
        return this.mData.layout.getPowerComponentName(powerComponent);
    }

    public double getConsumedPower() {
        return this.mPowerComponents.getConsumedPower(UNSPECIFIED_DIMENSIONS);
    }

    public double getConsumedPower(Dimensions dimensions) {
        return this.mPowerComponents.getConsumedPower(dimensions);
    }

    public long getUsageDurationMillis(@NonNull Dimensions dimensions) {
        return this.mPowerComponents.getUsageDurationMillis(dimensions);
    }

    public int[] getPowerComponentIds() {
        return this.mData.layout.powerComponentIds;
    }

    public Key[] getKeys(int componentId) {
        return this.mData.layout.getKeys(componentId);
    }

    public Key getKey(int componentId) {
        return this.mData.layout.getKey(componentId, 0, 0, 0);
    }

    public Key getKey(int componentId, int processState) {
        return this.mData.layout.getKey(componentId, processState, 0, 0);
    }

    public double getConsumedPower(int componentId) {
        return this.mPowerComponents.getConsumedPower(componentId, -1, 0, 0);
    }

    public double getConsumedPower(@NonNull Key key) {
        return this.mPowerComponents.getConsumedPower(key);
    }

    @Deprecated
    public int getPowerModel(int componentId) {
        return 0;
    }

    @Deprecated
    public int getPowerModel(@NonNull Key key) {
        return 0;
    }

    @Deprecated
    public double getConsumedPowerForCustomComponent(int componentId) {
        return this.getConsumedPower(componentId);
    }

    public int getCustomPowerComponentCount() {
        return this.mData.layout.customPowerComponentCount;
    }

    public String getCustomPowerComponentName(int componentId) {
        return this.mPowerComponents.getCustomPowerComponentName(componentId);
    }

    public long getUsageDurationMillis(int componentId) {
        return this.mPowerComponents.getUsageDurationMillis(componentId, -1, 0, 0);
    }

    public long getUsageDurationMillis(@NonNull Key key) {
        return this.mPowerComponents.getUsageDurationMillis(key);
    }

    public static String powerComponentIdToString(int componentId) {
        if (componentId == -1) {
            return "all";
        }
        return sPowerComponentNames[componentId];
    }

    public static int powerModelToProtoEnum(int powerModel) {
        switch (powerModel) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public static String processStateToString(int processState) {
        return sProcessStateNames[processState];
    }

    public static String powerStateToString(int powerState) {
        return sPowerStateNames[powerState];
    }

    public static String screenStateToString(int screenState) {
        return sScreenStateNames[screenState];
    }

    public void dump(PrintWriter pw) {
        this.dump(pw, true);
    }

    public abstract void dump(PrintWriter var1, boolean var2);

    boolean hasStatsProtoData() {
        return this.writeStatsProtoImpl(null, 0L);
    }

    void writeStatsProto(@NonNull ProtoOutputStream proto, long fieldId) {
        this.writeStatsProtoImpl(proto, fieldId);
    }

    private boolean writeStatsProtoImpl(@Nullable ProtoOutputStream proto, long fieldId) {
        long totalConsumedPowerDeciCoulombs = BatteryConsumer.convertMahToDeciCoulombs(this.getConsumedPower());
        if (totalConsumedPowerDeciCoulombs == 0L) {
            return false;
        }
        if (proto == null) {
            return true;
        }
        long token = proto.start(fieldId);
        proto.write(0x10300000001L, totalConsumedPowerDeciCoulombs);
        this.mPowerComponents.writeStatsProto(proto);
        proto.end(token);
        return true;
    }

    static long convertMahToDeciCoulombs(double powerMah) {
        return (long)(powerMah * 36.0 + 0.5);
    }

    static BatteryConsumerDataLayout createBatteryConsumerDataLayout(String[] customPowerComponentNames, boolean includeProcessStateData, boolean includeScreenStateData, boolean includePowerStateData) {
        int columnCount = 1;
        columnCount = Math.max(columnCount, 3);
        columnCount = Math.max(columnCount, 3);
        columnCount = Math.max(columnCount, 2);
        return new BatteryConsumerDataLayout(columnCount, customPowerComponentNames, includeProcessStateData, includeScreenStateData, includePowerStateData);
    }

    static {
        BatteryConsumer.sPowerComponentNames[0] = "screen";
        BatteryConsumer.sPowerComponentNames[1] = "cpu";
        BatteryConsumer.sPowerComponentNames[2] = "bluetooth";
        BatteryConsumer.sPowerComponentNames[3] = "camera";
        BatteryConsumer.sPowerComponentNames[4] = "audio";
        BatteryConsumer.sPowerComponentNames[5] = "video";
        BatteryConsumer.sPowerComponentNames[6] = "flashlight";
        BatteryConsumer.sPowerComponentNames[7] = "system_services";
        BatteryConsumer.sPowerComponentNames[8] = "mobile_radio";
        BatteryConsumer.sPowerComponentNames[9] = "sensors";
        BatteryConsumer.sPowerComponentNames[10] = "gnss";
        BatteryConsumer.sPowerComponentNames[11] = "wifi";
        BatteryConsumer.sPowerComponentNames[12] = "wakelock";
        BatteryConsumer.sPowerComponentNames[13] = "memory";
        BatteryConsumer.sPowerComponentNames[14] = "phone";
        BatteryConsumer.sPowerComponentNames[15] = "ambient_display";
        BatteryConsumer.sPowerComponentNames[16] = "idle";
        BatteryConsumer.sPowerComponentNames[17] = "reattributed";
        BatteryConsumer.sPowerComponentNames[18] = "";
        sProcessStateNames = new String[5];
        BatteryConsumer.sProcessStateNames[0] = "unspecified";
        BatteryConsumer.sProcessStateNames[1] = "fg";
        BatteryConsumer.sProcessStateNames[2] = "bg";
        BatteryConsumer.sProcessStateNames[3] = "fgs";
        BatteryConsumer.sProcessStateNames[4] = "cached";
        int[] supportedPowerComponents = new int[]{18, 1, 8, 11, 2, 4, 5, 6, 3, 10, 9, 12};
        Arrays.sort(supportedPowerComponents);
        SUPPORTED_POWER_COMPONENTS_PER_PROCESS_STATE = IntArray.wrap(supportedPowerComponents);
        sScreenStateNames = new String[3];
        BatteryConsumer.sScreenStateNames[0] = "unspecified";
        BatteryConsumer.sScreenStateNames[1] = "on";
        BatteryConsumer.sScreenStateNames[2] = "off/doze";
        sPowerStateNames = new String[3];
        BatteryConsumer.sPowerStateNames[0] = "unspecified";
        BatteryConsumer.sPowerStateNames[1] = "on battery";
        BatteryConsumer.sPowerStateNames[2] = "not on battery";
        UNSPECIFIED_DIMENSIONS = new Dimensions(-1, -1, 0, 0);
    }

    static class BatteryConsumerData {
        private final CursorWindow mCursorWindow;
        private final int mCursorRow;
        public final BatteryConsumerDataLayout layout;

        BatteryConsumerData(CursorWindow cursorWindow, int cursorRow, BatteryConsumerDataLayout layout2) {
            this.mCursorWindow = cursorWindow;
            this.mCursorRow = cursorRow;
            this.layout = layout2;
        }

        @Nullable
        static BatteryConsumerData create(CursorWindow cursorWindow, BatteryConsumerDataLayout layout2) {
            int cursorRow = cursorWindow.getNumRows();
            if (!cursorWindow.allocRow()) {
                Slog.e(BatteryConsumer.TAG, "Cannot allocate BatteryConsumerData: too many UIDs: " + cursorRow);
                cursorRow = -1;
            }
            return new BatteryConsumerData(cursorWindow, cursorRow, layout2);
        }

        boolean hasValue(int columnIndex) {
            if (this.mCursorRow == -1) {
                return false;
            }
            return this.mCursorWindow.getType(this.mCursorRow, columnIndex) != 0;
        }

        void putInt(int columnIndex, int value) {
            if (this.mCursorRow == -1) {
                return;
            }
            this.mCursorWindow.putLong(value, this.mCursorRow, columnIndex);
        }

        int getInt(int columnIndex) {
            if (this.mCursorRow == -1) {
                return 0;
            }
            return this.mCursorWindow.getInt(this.mCursorRow, columnIndex);
        }

        void putDouble(int columnIndex, double value) {
            if (this.mCursorRow == -1) {
                return;
            }
            this.mCursorWindow.putDouble(value, this.mCursorRow, columnIndex);
        }

        double getDouble(int columnIndex) {
            if (this.mCursorRow == -1) {
                return 0.0;
            }
            return this.mCursorWindow.getDouble(this.mCursorRow, columnIndex);
        }

        void putLong(int columnIndex, long value) {
            if (this.mCursorRow == -1) {
                return;
            }
            this.mCursorWindow.putLong(value, this.mCursorRow, columnIndex);
        }

        long getLong(int columnIndex) {
            if (this.mCursorRow == -1) {
                return 0L;
            }
            return this.mCursorWindow.getLong(this.mCursorRow, columnIndex);
        }

        void putString(int columnIndex, String value) {
            if (this.mCursorRow == -1) {
                return;
            }
            this.mCursorWindow.putString(value, this.mCursorRow, columnIndex);
        }

        String getString(int columnIndex) {
            if (this.mCursorRow == -1) {
                return null;
            }
            return this.mCursorWindow.getString(this.mCursorRow, columnIndex);
        }
    }

    static class BatteryConsumerDataLayout {
        private static final Key[] KEY_ARRAY = new Key[0];
        public final String[] customPowerComponentNames;
        public final int customPowerComponentCount;
        public final boolean processStateDataIncluded;
        public final boolean screenStateDataIncluded;
        public final boolean powerStateDataIncluded;
        public final int[] powerComponentIds;
        public final Key[] keys;
        public final SparseArray<Key> indexedKeys;
        public final int totalConsumedPowerColumnIndex;
        public final int columnCount;
        private SparseArray<Key[]> mPerComponentKeys;

        private BatteryConsumerDataLayout(int firstColumn, String[] customPowerComponentNames, boolean includeProcessStateData, boolean includeScreenState, boolean includePowerState) {
            this.customPowerComponentNames = customPowerComponentNames;
            this.customPowerComponentCount = customPowerComponentNames.length;
            this.processStateDataIncluded = includeProcessStateData;
            this.screenStateDataIncluded = includeScreenState;
            this.powerStateDataIncluded = includePowerState;
            this.powerComponentIds = new int[19 + this.customPowerComponentCount];
            int id2 = 0;
            int componentId = 0;
            while (componentId < 19) {
                this.powerComponentIds[id2++] = componentId++;
            }
            for (int i = 0; i < this.customPowerComponentCount; ++i) {
                this.powerComponentIds[id2++] = 1000 + i;
            }
            int columnIndex = firstColumn;
            this.totalConsumedPowerColumnIndex = columnIndex++;
            ArrayList<Key> keyList = new ArrayList<Key>();
            for (int screenState = 0; screenState < 3; ++screenState) {
                if (!includeScreenState && screenState != 0) continue;
                for (int powerState = 0; powerState < 3; ++powerState) {
                    if (!includePowerState && powerState != 0) continue;
                    for (int i = 0; i < this.powerComponentIds.length; ++i) {
                        columnIndex = this.addKeys(keyList, includeProcessStateData, this.powerComponentIds[i], screenState, powerState, columnIndex);
                    }
                }
            }
            this.columnCount = columnIndex;
            this.keys = keyList.toArray(KEY_ARRAY);
            this.indexedKeys = new SparseArray(this.keys.length);
            for (int i = 0; i < this.keys.length; ++i) {
                Key key = this.keys[i];
                this.indexedKeys.put(this.keyIndex(key.powerComponentId, key.processState, key.screenState, key.powerState), key);
            }
        }

        public String getPowerComponentName(int powerComponentId) {
            if (powerComponentId < 19) {
                return BatteryConsumer.powerComponentIdToString(powerComponentId);
            }
            if (powerComponentId >= 1000 && powerComponentId < 1000 + this.customPowerComponentCount) {
                return this.customPowerComponentNames[powerComponentId - 1000];
            }
            throw new IllegalArgumentException("Unsupported power component " + powerComponentId);
        }

        private int addKeys(List<Key> keys, boolean includeProcessStateData, int componentId, int screenState, int powerState, int columnIndex) {
            keys.add(new Key(componentId, 0, screenState, powerState, columnIndex++, columnIndex++));
            if (includeProcessStateData || componentId == 18) {
                boolean isSupported;
                boolean bl = isSupported = SUPPORTED_POWER_COMPONENTS_PER_PROCESS_STATE.binarySearch(componentId) >= 0 || componentId >= 1000;
                if (isSupported) {
                    for (int processState = 0; processState < 5; ++processState) {
                        if (processState == 0) continue;
                        keys.add(new Key(componentId, processState, screenState, powerState, columnIndex++, columnIndex++));
                    }
                }
            }
            return columnIndex;
        }

        Key getKey(int componentId, int processState, int screenState, int powerState) {
            return this.indexedKeys.get(this.keyIndex(componentId, processState, screenState, powerState));
        }

        Key getKeyOrThrow(int componentId, int processState, int screenState, int powerState) {
            Key key = this.getKey(componentId, processState, screenState, powerState);
            if (key == null) {
                throw new IllegalArgumentException("Unsupported power component ID: " + Key.toString(componentId, processState, screenState, powerState));
            }
            return key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Key[] getKeys(int componentId) {
            BatteryConsumerDataLayout batteryConsumerDataLayout = this;
            synchronized (batteryConsumerDataLayout) {
                Key[] componentKeys;
                if (this.mPerComponentKeys == null) {
                    this.mPerComponentKeys = new SparseArray(this.powerComponentIds.length);
                }
                if ((componentKeys = this.mPerComponentKeys.get(componentId)) == null) {
                    ArrayList<Key> out = new ArrayList<Key>();
                    for (Key key : this.keys) {
                        if (key.powerComponentId != componentId) continue;
                        out.add(key);
                    }
                    componentKeys = out.toArray(new Key[out.size()]);
                    this.mPerComponentKeys.put(componentId, componentKeys);
                }
                return componentKeys;
            }
        }

        private int keyIndex(int componentId, int processState, int screenState, int powerState) {
            return componentId << 7 | processState << 4 | screenState << 2 | powerState;
        }
    }

    public static class Dimensions {
        public final int powerComponentId;
        public final int processState;
        public final int screenState;
        public final int powerState;

        public Dimensions(int powerComponentId, int processState) {
            this(powerComponentId, processState, 0, 0);
        }

        public Dimensions(int powerComponentId, int processState, int screenState, int powerState) {
            this.powerComponentId = powerComponentId;
            this.processState = processState;
            this.screenState = screenState;
            this.powerState = powerState;
        }

        public String toString() {
            boolean dimensionSpecified = false;
            StringBuilder sb = new StringBuilder();
            if (this.powerComponentId != -1) {
                sb.append("powerComponent=");
                if (this.powerComponentId < 19) {
                    sb.append(sPowerComponentNames[this.powerComponentId]);
                } else {
                    sb.append("CUSTOM/").append(this.powerComponentId);
                }
                dimensionSpecified = true;
            }
            if (this.processState != -1) {
                if (dimensionSpecified) {
                    sb.append(", ");
                }
                sb.append("processState=").append(sProcessStateNames[this.processState]);
                dimensionSpecified = true;
            }
            if (this.screenState != 0) {
                if (dimensionSpecified) {
                    sb.append(", ");
                }
                sb.append("screenState=").append(BatteryConsumer.screenStateToString(this.screenState));
                dimensionSpecified = true;
            }
            if (this.powerState != 0) {
                if (dimensionSpecified) {
                    sb.append(", ");
                }
                sb.append("powerState=").append(BatteryConsumer.powerStateToString(this.powerState));
                dimensionSpecified = true;
            }
            if (!dimensionSpecified) {
                sb.append("any components and process states");
            }
            return sb.toString();
        }
    }

    public static class Key {
        public final int powerComponentId;
        public final int processState;
        public final int screenState;
        public final int powerState;
        final int mPowerColumnIndex;
        final int mDurationColumnIndex;

        private Key(int powerComponentId, int processState, int screenState, int powerState, int powerColumnIndex, int durationColumnIndex) {
            this.powerComponentId = powerComponentId;
            this.processState = processState;
            this.screenState = screenState;
            this.powerState = powerState;
            this.mPowerColumnIndex = powerColumnIndex;
            this.mDurationColumnIndex = durationColumnIndex;
        }

        boolean matches(int powerComponent, int processState, int screenState, int powerState) {
            if (powerComponent != -1 && this.powerComponentId != powerComponent) {
                return false;
            }
            if (this.processState == 0) {
                return false;
            }
            if (processState != -1 && this.processState != processState) {
                return false;
            }
            if (screenState != 0 && this.screenState != screenState) {
                return false;
            }
            return powerState == 0 || this.powerState == powerState;
        }

        public boolean equals(Object o) {
            Key key = (Key)o;
            return this.powerComponentId == key.powerComponentId && this.processState == key.processState && this.screenState == key.screenState && this.powerState == key.powerState;
        }

        public int hashCode() {
            int result = this.powerComponentId;
            result = 31 * result + this.processState;
            result = 31 * result + this.screenState;
            result = 31 * result + this.powerState;
            return result;
        }

        public static String toString(int powerComponent, int processState, int screenState, int powerState) {
            StringBuilder sb = new StringBuilder();
            if (powerComponent < 19) {
                sb.append(BatteryConsumer.powerComponentIdToString(powerComponent));
            } else {
                sb.append("CUSTOM/").append(powerComponent);
            }
            if (processState != 0) {
                sb.append(':');
                sb.append(BatteryConsumer.processStateToString(processState));
            }
            if (screenState != 0) {
                sb.append(":scr-");
                sb.append(sScreenStateNames[screenState]);
            }
            if (powerState != 0) {
                sb.append(":pwr-");
                sb.append(sPowerStateNames[powerState]);
            }
            return sb.toString();
        }

        public String toString() {
            return Key.toString(this.powerComponentId, this.processState, this.screenState, this.powerState);
        }
    }

    protected static abstract class BaseBuilder<T extends BaseBuilder<?>> {
        protected final BatteryConsumerData mData;
        protected final PowerComponents.Builder mPowerComponentsBuilder;

        public BaseBuilder(BatteryConsumerData data, int consumerType, double minConsumedPowerThreshold) {
            this.mData = data;
            data.putLong(0, consumerType);
            this.mPowerComponentsBuilder = new PowerComponents.Builder(data, minConsumedPowerThreshold);
        }

        @Nullable
        public Key[] getKeys(int componentId) {
            return this.mData.layout.getKeys(componentId);
        }

        @Nullable
        public Key getKey(int componentId, int processState) {
            return this.mData.layout.getKey(componentId, processState, 0, 0);
        }

        @Nullable
        public Key getKey(int componentId, int processState, int screenState, int powerState) {
            return this.mData.layout.getKey(componentId, processState, screenState, powerState);
        }

        @Deprecated
        @NonNull
        public T setConsumedPower(int componentId, double componentPower) {
            return this.setConsumedPower(componentId, componentPower, 1);
        }

        @Deprecated
        @NonNull
        public T setConsumedPower(int componentId, double componentPower, int powerModel) {
            this.mPowerComponentsBuilder.setConsumedPower(this.getKey(componentId, 0), componentPower);
            return (T)this;
        }

        @NonNull
        public T addConsumedPower(int componentId, double componentPower, int powerModel) {
            this.mPowerComponentsBuilder.addConsumedPower(this.getKey(componentId, 0), componentPower);
            return (T)this;
        }

        @NonNull
        public T setConsumedPower(Key key, double componentPower, int powerModel) {
            this.mPowerComponentsBuilder.setConsumedPower(key, componentPower);
            return (T)this;
        }

        @NonNull
        public T addConsumedPower(int componentId, double componentPower) {
            this.mPowerComponentsBuilder.addConsumedPower(this.getKey(componentId, 0), componentPower);
            return (T)this;
        }

        @NonNull
        public T addConsumedPower(Key key, double componentPower) {
            this.mPowerComponentsBuilder.addConsumedPower(key, componentPower);
            return (T)this;
        }

        @Deprecated
        @NonNull
        public T setUsageDurationMillis(int componentId, long componentUsageTimeMillis) {
            this.mPowerComponentsBuilder.setUsageDurationMillis(this.getKey(componentId, 0), componentUsageTimeMillis);
            return (T)this;
        }

        @Deprecated
        @NonNull
        public T setUsageDurationMillis(Key key, long componentUsageTimeMillis) {
            this.mPowerComponentsBuilder.setUsageDurationMillis(key, componentUsageTimeMillis);
            return (T)this;
        }

        @NonNull
        public T addUsageDurationMillis(int componentId, long componentUsageTimeMillis) {
            this.mPowerComponentsBuilder.addUsageDurationMillis(this.getKey(componentId, 0), componentUsageTimeMillis);
            return (T)this;
        }

        @NonNull
        public T addUsageDurationMillis(Key key, long componentUsageTimeMillis) {
            this.mPowerComponentsBuilder.addUsageDurationMillis(key, componentUsageTimeMillis);
            return (T)this;
        }

        public double getTotalPower() {
            return this.mPowerComponentsBuilder.getTotalPower();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PowerState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScreenState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProcessState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PowerModel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PowerComponentId {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PowerComponent {
    }
}

