/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.GpuHeadroomParamsInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@FlaggedApi(value="android.os.cpu_gpu_headrooms")
public class GpuHeadroomParams {
    public static final int GPU_HEADROOM_CALCULATION_TYPE_MIN = 0;
    public static final int GPU_HEADROOM_CALCULATION_TYPE_AVERAGE = 1;
    public static final int GPU_HEADROOM_CALCULATION_WINDOW_MILLIS_MIN = 50;
    public static final int GPU_HEADROOM_CALCULATION_WINDOW_MILLIS_MAX = 10000;
    public final GpuHeadroomParamsInternal mInternal = new GpuHeadroomParamsInternal();

    private GpuHeadroomParams() {
    }

    public int getCalculationType() {
        byte by;
        switch (this.mInternal.calculationType) {
            case 0: 
            case 1: {
                by = this.mInternal.calculationType;
                break;
            }
            default: {
                by = 0;
            }
        }
        byte validatedType = by;
        return validatedType;
    }

    public int getCalculationWindowMillis() {
        return this.mInternal.calculationWindowMillis;
    }

    public String toString() {
        return "GpuHeadroomParams{calculationType=" + this.mInternal.calculationType + ", calculationWindowMillis=" + this.mInternal.calculationWindowMillis + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GpuHeadroomParams that = (GpuHeadroomParams)o;
        return this.mInternal.equals(that.mInternal);
    }

    public int hashCode() {
        return this.mInternal.hashCode();
    }

    public static class Builder {
        private int mCalculationType = -1;
        private int mCalculationWindowMillis = -1;

        public Builder() {
        }

        public Builder(@NonNull GpuHeadroomParams params) {
            if (params.mInternal.calculationType >= 0) {
                this.mCalculationType = params.mInternal.calculationType;
            }
            if (params.mInternal.calculationWindowMillis >= 0) {
                this.mCalculationWindowMillis = params.mInternal.calculationWindowMillis;
            }
        }

        @NonNull
        public Builder setCalculationType(int calculationType) {
            switch (calculationType) {
                case 0: 
                case 1: {
                    this.mCalculationType = calculationType;
                    return this;
                }
            }
            throw new IllegalArgumentException("Invalid calculation type: " + calculationType);
        }

        @NonNull
        public Builder setCalculationWindowMillis(int windowMillis) {
            if (windowMillis <= 0) {
                throw new IllegalArgumentException("Invalid calculation window: " + windowMillis);
            }
            this.mCalculationWindowMillis = windowMillis;
            return this;
        }

        @NonNull
        public GpuHeadroomParams build() {
            GpuHeadroomParams params = new GpuHeadroomParams();
            if (this.mCalculationType >= 0) {
                params.mInternal.calculationType = (byte)this.mCalculationType;
            }
            if (this.mCalculationWindowMillis >= 0) {
                params.mInternal.calculationWindowMillis = this.mCalculationWindowMillis;
            }
            return params;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GpuHeadroomCalculationType {
    }
}

