/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.Handler_Delegate;
import android.os.IMessenger;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.os.ThreadLocalWorkSource;
import android.os.TraceNameSupplier;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.Log;
import android.util.Printer;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

@RavenwoodKeepWholeClass
public class Handler {
    private static final boolean FIND_POTENTIAL_LEAKS = false;
    private static final String TAG = "Handler";
    private static Handler MAIN_THREAD_HANDLER = null;
    @UnsupportedAppUsage
    final Looper mLooper;
    final MessageQueue mQueue;
    @UnsupportedAppUsage
    final Callback mCallback;
    final boolean mAsynchronous;
    @UnsupportedAppUsage
    IMessenger mMessenger;
    private final boolean mIsShared;

    public void handleMessage(@NonNull Message msg) {
    }

    public void dispatchMessage(@NonNull Message msg) {
        if (msg.callback != null) {
            Handler.handleCallback(msg);
        } else {
            if (this.mCallback != null && this.mCallback.handleMessage(msg)) {
                return;
            }
            this.handleMessage(msg);
        }
    }

    @Deprecated
    public Handler() {
        this(null, false);
    }

    @Deprecated
    public Handler(@Nullable Callback callback) {
        this(callback, false);
    }

    public Handler(@NonNull Looper looper) {
        this(looper, null, false);
    }

    public Handler(@NonNull Looper looper, @Nullable Callback callback) {
        this(looper, callback, false);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public Handler(boolean async) {
        this(null, async);
    }

    public Handler(@Nullable Callback callback, boolean async) {
        this.mLooper = Looper.myLooper();
        if (this.mLooper == null) {
            throw new RuntimeException("Can't create handler inside thread " + Thread.currentThread() + " that has not called Looper.prepare()");
        }
        this.mQueue = this.mLooper.mQueue;
        this.mCallback = callback;
        this.mAsynchronous = async;
        this.mIsShared = false;
    }

    @UnsupportedAppUsage
    public Handler(@NonNull Looper looper, @Nullable Callback callback, boolean async) {
        this(looper, callback, async, false);
    }

    public Handler(@NonNull Looper looper, @Nullable Callback callback, boolean async, boolean shared) {
        this.mLooper = looper;
        this.mQueue = looper.mQueue;
        this.mCallback = callback;
        this.mAsynchronous = async;
        this.mIsShared = shared;
    }

    @NonNull
    public static Handler createAsync(@NonNull Looper looper) {
        if (looper == null) {
            throw new NullPointerException("looper must not be null");
        }
        return new Handler(looper, null, true);
    }

    @NonNull
    public static Handler createAsync(@NonNull Looper looper, @NonNull Callback callback) {
        if (looper == null) {
            throw new NullPointerException("looper must not be null");
        }
        if (callback == null) {
            throw new NullPointerException("callback must not be null");
        }
        return new Handler(looper, callback, true);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @NonNull
    public static Handler getMain() {
        if (MAIN_THREAD_HANDLER == null) {
            MAIN_THREAD_HANDLER = new Handler(Looper.getMainLooper());
        }
        return MAIN_THREAD_HANDLER;
    }

    @NonNull
    public static Handler mainIfNull(@Nullable Handler handler) {
        return handler == null ? Handler.getMain() : handler;
    }

    @NonNull
    public String getTraceName(@NonNull Message message) {
        if (message.callback instanceof TraceNameSupplier) {
            return ((TraceNameSupplier)((Object)message.callback)).getTraceName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append(": ");
        if (message.callback != null) {
            sb.append(message.callback.getClass().getName());
        } else {
            sb.append("#").append(message.what);
        }
        return sb.toString();
    }

    @NonNull
    public String getMessageName(@NonNull Message message) {
        if (message.callback != null) {
            return message.callback.getClass().getName();
        }
        return "0x" + Integer.toHexString(message.what);
    }

    @NonNull
    public Message obtainMessage() {
        return Message.obtain(this);
    }

    @NonNull
    public Message obtainMessage(int what) {
        return Message.obtain(this, what);
    }

    @NonNull
    public Message obtainMessage(int what, @Nullable Object obj) {
        return Message.obtain(this, what, obj);
    }

    @NonNull
    public Message obtainMessage(int what, int arg1, int arg2) {
        return Message.obtain(this, what, arg1, arg2);
    }

    @NonNull
    public Message obtainMessage(int what, int arg1, int arg2, @Nullable Object obj) {
        return Message.obtain(this, what, arg1, arg2, obj);
    }

    public boolean post(@NonNull Runnable r) {
        return this.sendMessageDelayed(Handler.getPostMessage(r), 0L);
    }

    public boolean postAtTime(@NonNull Runnable r, long uptimeMillis) {
        return this.sendMessageAtTime(Handler.getPostMessage(r), uptimeMillis);
    }

    public boolean postAtTime(@NonNull Runnable r, @Nullable Object token, long uptimeMillis) {
        return this.sendMessageAtTime(Handler.getPostMessage(r, token), uptimeMillis);
    }

    public boolean postDelayed(@NonNull Runnable r, long delayMillis) {
        return this.sendMessageDelayed(Handler.getPostMessage(r), delayMillis);
    }

    public boolean postDelayed(Runnable r, int what, long delayMillis) {
        return this.sendMessageDelayed(Handler.getPostMessage(r).setWhat(what), delayMillis);
    }

    public boolean postDelayed(@NonNull Runnable r, @Nullable Object token, long delayMillis) {
        return this.sendMessageDelayed(Handler.getPostMessage(r, token), delayMillis);
    }

    public boolean postAtFrontOfQueue(@NonNull Runnable r) {
        return this.sendMessageAtFrontOfQueue(Handler.getPostMessage(r));
    }

    public boolean runWithScissors(@NonNull Runnable r, long timeout) {
        if (r == null) {
            throw new IllegalArgumentException("runnable must not be null");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be non-negative");
        }
        if (Looper.myLooper() == this.mLooper) {
            r.run();
            return true;
        }
        BlockingRunnable br = new BlockingRunnable(r);
        return br.postAndWait(this, timeout);
    }

    public void removeCallbacks(@NonNull Runnable r) {
        this.mQueue.removeMessages(this, r, null);
    }

    public void removeCallbacks(@NonNull Runnable r, @Nullable Object token) {
        this.mQueue.removeMessages(this, r, token);
    }

    public boolean sendMessage(@NonNull Message msg) {
        return this.sendMessageDelayed(msg, 0L);
    }

    public boolean sendEmptyMessage(int what) {
        return this.sendEmptyMessageDelayed(what, 0L);
    }

    public boolean sendEmptyMessageDelayed(int what, long delayMillis) {
        Message msg = Message.obtain();
        msg.what = what;
        return this.sendMessageDelayed(msg, delayMillis);
    }

    public boolean sendEmptyMessageAtTime(int what, long uptimeMillis) {
        Message msg = Message.obtain();
        msg.what = what;
        return this.sendMessageAtTime(msg, uptimeMillis);
    }

    public boolean sendMessageDelayed(@NonNull Message msg, long delayMillis) {
        if (delayMillis < 0L) {
            delayMillis = 0L;
        }
        return this.sendMessageAtTime(msg, SystemClock.uptimeMillis() + delayMillis);
    }

    public boolean sendMessageAtTime_Original(@NonNull Message msg, long uptimeMillis) {
        MessageQueue queue = this.mQueue;
        if (queue == null) {
            RuntimeException e = new RuntimeException(this + " sendMessageAtTime() called with no mQueue");
            Log.w("Looper", e.getMessage(), e);
            return false;
        }
        return this.enqueueMessage(queue, msg, uptimeMillis);
    }

    @LayoutlibDelegate
    public boolean sendMessageAtTime(Message message, long l) {
        return Handler_Delegate.sendMessageAtTime(this, message, l);
    }

    public boolean sendMessageAtFrontOfQueue_Original(@NonNull Message msg) {
        MessageQueue queue = this.mQueue;
        if (queue == null) {
            RuntimeException e = new RuntimeException(this + " sendMessageAtFrontOfQueue() called with no mQueue");
            Log.w("Looper", e.getMessage(), e);
            return false;
        }
        return this.enqueueMessage(queue, msg, 0L);
    }

    @LayoutlibDelegate
    public boolean sendMessageAtFrontOfQueue(Message message) {
        return Handler_Delegate.sendMessageAtFrontOfQueue(this, message);
    }

    public boolean executeOrSendMessage(@NonNull Message msg) {
        if (this.mLooper == Looper.myLooper()) {
            this.dispatchMessage(msg);
            return true;
        }
        return this.sendMessage(msg);
    }

    private boolean enqueueMessage(@NonNull MessageQueue queue, @NonNull Message msg, long uptimeMillis) {
        msg.target = this;
        msg.workSourceUid = ThreadLocalWorkSource.getUid();
        if (this.mAsynchronous) {
            msg.setAsynchronous(true);
        }
        return queue.enqueueMessage(msg, uptimeMillis);
    }

    private Object disallowNullArgumentIfShared(@Nullable Object arg) {
        if (this.mIsShared && arg == null) {
            throw new IllegalArgumentException("Null argument disallowed for shared handler. Consider creating your own Handler instance.");
        }
        return arg;
    }

    public void removeMessages(int what) {
        this.mQueue.removeMessages(this, what, null);
    }

    public void removeMessages(int what, @Nullable Object object) {
        this.mQueue.removeMessages(this, what, this.disallowNullArgumentIfShared(object));
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.os.mainline_vcn_platform_api")
    public void removeEqualMessages(int what, @Nullable Object object) {
        this.mQueue.removeEqualMessages(this, what, this.disallowNullArgumentIfShared(object));
    }

    public void removeCallbacksAndMessages(@Nullable Object token) {
        this.mQueue.removeCallbacksAndMessages(this, this.disallowNullArgumentIfShared(token));
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.os.mainline_vcn_platform_api")
    public void removeCallbacksAndEqualMessages(@Nullable Object token) {
        this.mQueue.removeCallbacksAndEqualMessages(this, this.disallowNullArgumentIfShared(token));
    }

    public boolean hasMessages(int what) {
        return this.mQueue.hasMessages(this, what, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.os.mainline_vcn_platform_api")
    public boolean hasMessagesOrCallbacks() {
        return this.mQueue.hasMessages(this);
    }

    public boolean hasMessages(int what, @Nullable Object object) {
        return this.mQueue.hasMessages(this, what, object);
    }

    public boolean hasEqualMessages(int what, @Nullable Object object) {
        return this.mQueue.hasEqualMessages(this, what, object);
    }

    public boolean hasCallbacks(@NonNull Runnable r) {
        return this.mQueue.hasMessages(this, r, null);
    }

    @NonNull
    public Looper getLooper() {
        return this.mLooper;
    }

    public void dump(@NonNull Printer pw, @NonNull String prefix) {
        pw.println(prefix + this + " @ " + SystemClock.uptimeMillis());
        if (this.mLooper == null) {
            pw.println(prefix + "looper uninitialized");
        } else {
            this.mLooper.dump(pw, prefix + "  ");
        }
    }

    public void dumpMine(@NonNull Printer pw, @NonNull String prefix) {
        pw.println(prefix + this + " @ " + SystemClock.uptimeMillis());
        if (this.mLooper == null) {
            pw.println(prefix + "looper uninitialized");
        } else {
            this.mLooper.dump(pw, prefix + "  ", this);
        }
    }

    public String toString() {
        return "Handler (" + this.getClass().getName() + ") {" + Integer.toHexString(System.identityHashCode(this)) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    IMessenger getIMessenger() {
        MessageQueue messageQueue = this.mQueue;
        synchronized (messageQueue) {
            if (this.mMessenger != null) {
                return this.mMessenger;
            }
            this.mMessenger = new MessengerImpl();
            return this.mMessenger;
        }
    }

    private static Message getPostMessage(Runnable r) {
        Message m = Message.obtain();
        m.callback = r;
        return m;
    }

    @UnsupportedAppUsage
    private static Message getPostMessage(Runnable r, Object token) {
        Message m = Message.obtain();
        m.obj = token;
        m.callback = r;
        return m;
    }

    private static void handleCallback(Message message) {
        message.callback.run();
    }

    public static interface Callback {
        public boolean handleMessage(@NonNull Message var1);
    }

    private static class BlockingRunnable
    implements Runnable {
        private final Runnable mTask;
        private boolean mDone;

        public BlockingRunnable(Runnable task) {
            this.mTask = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.mTask.run();
            }
            finally {
                BlockingRunnable blockingRunnable = this;
                synchronized (blockingRunnable) {
                    this.mDone = true;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean postAndWait(Handler handler, long timeout) {
            if (!handler.post(this)) {
                return false;
            }
            BlockingRunnable blockingRunnable = this;
            synchronized (blockingRunnable) {
                if (timeout > 0L) {
                    long expirationTime = SystemClock.uptimeMillis() + timeout;
                    while (!this.mDone) {
                        long delay = expirationTime - SystemClock.uptimeMillis();
                        if (delay <= 0L) {
                            return false;
                        }
                        try {
                            this.wait(delay);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    while (!this.mDone) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            return true;
        }
    }

    private class MessengerImpl
    extends IMessenger.Stub {
        private MessengerImpl() {
        }

        @Override
        public void send(Message msg) {
            msg.sendingUid = Binder.getCallingUid();
            Handler.this.sendMessage(msg);
        }
    }
}

