/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.NativeHandle;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.Closeable;
import java.io.IOException;

@SystemApi
public class HidlMemory
implements Closeable {
    @NonNull
    private final String mName;
    private final long mSize;
    @Nullable
    private NativeHandle mHandle;
    private long mNativeContext;

    public HidlMemory(@NonNull String name, long size, @Nullable NativeHandle handle) {
        this.mName = name;
        this.mSize = size;
        this.mHandle = handle;
    }

    @NonNull
    public HidlMemory dup() throws IOException {
        return new HidlMemory(this.mName, this.mSize, this.mHandle != null ? this.mHandle.dup() : null);
    }

    @Override
    public void close() throws IOException {
        if (this.mHandle != null) {
            this.mHandle.close();
            this.mHandle = null;
        }
    }

    @Nullable
    public NativeHandle releaseHandle() {
        NativeHandle handle = this.mHandle;
        this.mHandle = null;
        return handle;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    public long getSize() {
        return this.mSize;
    }

    @Nullable
    public NativeHandle getHandle() {
        return this.mHandle;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.nativeFinalize();
        }
    }

    private void nativeFinalize() {
        OverrideMethod.invokeV("android.os.HidlMemory#nativeFinalize()V", true, this);
    }
}

