/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IStatsQueryCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.os.IStatsQueryCallback";

    public void sendResults(String[] var1, String[] var2, int[] var3, int var4) throws RemoteException;

    public void sendFailure(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStatsQueryCallback {
        static final int TRANSACTION_sendResults = 1;
        static final int TRANSACTION_sendFailure = 2;

        public Stub() {
            this.attachInterface(this, IStatsQueryCallback.DESCRIPTOR);
        }

        public static IStatsQueryCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IStatsQueryCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IStatsQueryCallback) {
                return (IStatsQueryCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "sendResults";
                }
                case 2: {
                    return "sendFailure";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IStatsQueryCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String[] _arg0 = data.createStringArray();
                    String[] _arg1 = data.createStringArray();
                    int[] _arg2 = data.createIntArray();
                    int _arg3 = data.readInt();
                    this.sendResults(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    this.sendFailure(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IStatsQueryCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IStatsQueryCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendResults(String[] queryData, String[] columnNames, int[] columnTypes, int rowCount) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsQueryCallback.DESCRIPTOR);
                    _data.writeStringArray(queryData);
                    _data.writeStringArray(columnNames);
                    _data.writeIntArray(columnTypes);
                    _data.writeInt(rowCount);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendFailure(String error) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsQueryCallback.DESCRIPTOR);
                    _data.writeString(error);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IStatsQueryCallback {
        @Override
        public void sendResults(String[] queryData, String[] columnNames, int[] columnTypes, int rowCount) throws RemoteException {
        }

        @Override
        public void sendFailure(String error) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

