/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.app.ActivityThread;
import android.app.Instrumentation;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PerfettoTrace;
import android.os.Process;
import android.os.SystemClock;
import android.os.UserHandle;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodRedirect;
import android.ravenwood.annotation.RavenwoodRedirectionClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.ravenwood.annotation.RavenwoodThrow;
import android.util.Log;
import android.util.Printer;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.hidden_from_bootclasspath.android.os.Flags;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.NeverCompile;
import java.io.FileDescriptor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;

@RavenwoodKeepWholeClass
@RavenwoodRedirectionClass(value="MessageQueue_ravenwood")
public class MessageQueue {
    private static final String TAG = "MessageQueue";
    private static final String TAG_L = "LegacyMessageQueue";
    private static final String TAG_C = "ConcurrentMessageQueue";
    private static final boolean DEBUG = false;
    @UnsupportedAppUsage
    private final boolean mQuitAllowed;
    @UnsupportedAppUsage
    private long mPtr;
    @UnsupportedAppUsage(maxTargetSdk=36, publicAlternatives="To manipulate the queue in Instrumentation tests, use {@link android.os.TestLooperManager}")
    Message mMessages;
    private Message mLast;
    @UnsupportedAppUsage
    private final ArrayList<IdleHandler> mIdleHandlers = new ArrayList();
    private SparseArray<FileDescriptorRecord> mFileDescriptorRecords;
    private IdleHandler[] mPendingIdleHandlers;
    private boolean mQuitting;
    private boolean mBlocked;
    private int mAsyncMessageCount;
    private final AtomicLong mMessageCount = new AtomicLong();
    private final Thread mLooperThread;
    private final String mThreadName;
    private final long mTid;
    private static boolean sUseConcurrentInitialized = false;
    private static boolean sUseConcurrent;
    private static Boolean sIsProcessAllowedToUseConcurrent;
    private static final EnqueueOrder sEnqueueOrder;
    private static final MatchDeliverableMessages sMatchDeliverableMessages;
    private static final AtomicLong mMessagesDelivered;
    private int mNextPollTimeoutMillis;
    private boolean mMessageDirectlyQueued;
    private boolean mWorkerShouldQuit;
    private static final MatchHandlerWhatAndObject sMatchHandlerWhatAndObject;
    private static final MatchHandlerWhatAndObjectEquals sMatchHandlerWhatAndObjectEquals;
    private static final MatchHandlerRunnableAndObject sMatchHandlerRunnableAndObject;
    private static final MatchHandler sMatchHandler;
    private static final MatchHandlerRunnableAndObjectEquals sMatchHandlerRunnableAndObjectEquals;
    private static final MatchHandlerAndObject sMatchHandlerAndObject;
    private static final MatchHandlerAndObjectEquals sMatchHandlerAndObjectEquals;
    private static final MatchAllMessages sMatchAllMessages;
    private static final MatchAllFutureMessages sMatchAllFutureMessages;
    private static final int STACK_NODE_MESSAGE = 0;
    private static final int STACK_NODE_ACTIVE = 1;
    private static final int STACK_NODE_PARKED = 2;
    private static final int STACK_NODE_TIMEDPARK = 3;
    private static final int STACK_NODE_QUITTING = 4;
    private static final StateNode sStackStateActive;
    private static final StateNode sStackStateParked;
    private final TimedParkStateNode mStackStateTimedPark = new TimedParkStateNode();
    private static final VarHandle sState;
    private volatile StackNode mStateValue = sStackStateParked;
    private final ConcurrentSkipListSet<Message> mPriorityQueue = new ConcurrentSkipListSet<Message>(sEnqueueOrder);
    private final ConcurrentSkipListSet<Message> mAsyncPriorityQueue = new ConcurrentSkipListSet<Message>(sEnqueueOrder);
    private static final VarHandle sNextInsertSeq;
    private volatile long mNextInsertSeqValue = 0L;
    private static final VarHandle sNextFrontInsertSeq;
    private volatile long mNextFrontInsertSeqValue = -1L;
    private static VarHandle sMptrRefCount;
    private volatile long mMptrRefCountValue = 0L;
    private static final long MPTR_TEARDOWN_MASK = Long.MIN_VALUE;
    private final MessageCounts mMessageCounts = new MessageCounts();
    private final Object mIdleHandlersLock = new Object();
    private final Object mFileDescriptorRecordsLock = new Object();
    private final AtomicInteger mNextBarrierTokenAtomic = new AtomicInteger(1);
    @UnsupportedAppUsage
    private int mNextBarrierToken;
    private final ReentrantLock mDrainingLock = new ReentrantLock();
    private boolean mNextIsDrainingStack = false;
    private final Condition mDrainCompleted = this.mDrainingLock.newCondition();

    @RavenwoodRedirect
    private static long nativeInit() {
        return OverrideMethod.invokeL("android.os.MessageQueue#nativeInit()J", true, null);
    }

    @RavenwoodRedirect
    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.os.MessageQueue#nativeDestroy(J)V", true, null);
    }

    @UnsupportedAppUsage
    @RavenwoodRedirect
    private void nativePollOnce(long l, int n) {
        OverrideMethod.invokeV("android.os.MessageQueue#nativePollOnce(JI)V", true, this);
    }

    @RavenwoodRedirect
    private static void nativeWake(long l) {
        OverrideMethod.invokeV("android.os.MessageQueue#nativeWake(J)V", true, null);
    }

    @RavenwoodRedirect
    private static boolean nativeIsPolling(long l) {
        return OverrideMethod.invokeI("android.os.MessageQueue#nativeIsPolling(J)Z", true, null) != 0;
    }

    @RavenwoodRedirect
    private static void nativeSetFileDescriptorEvents(long l, int n, int n2) {
        OverrideMethod.invokeV("android.os.MessageQueue#nativeSetFileDescriptorEvents(JII)V", true, null);
    }

    MessageQueue(boolean quitAllowed) {
        MessageQueue.getUseConcurrent();
        this.mQuitAllowed = quitAllowed;
        this.mPtr = MessageQueue.nativeInit();
        this.mLooperThread = Thread.currentThread();
        this.mThreadName = this.mLooperThread.getName();
        this.mTid = Process.myTid();
    }

    static boolean getUseConcurrent() {
        if (!sUseConcurrentInitialized) {
            boolean useConcurrent;
            sUseConcurrent = useConcurrent = MessageQueue.computeUseConcurrent();
            sUseConcurrentInitialized = true;
            return useConcurrent;
        }
        return sUseConcurrent;
    }

    private static boolean computeUseConcurrent() {
        if (Flags.useConcurrentMessageQueueInApps()) {
            try {
                Class.forName("org.robolectric.Robolectric");
                return false;
            }
            catch (ClassNotFoundException e) {
                return true;
            }
        }
        String processName = Process.myProcessName();
        if (processName == null) {
            return false;
        }
        if (UserHandle.isCore(Process.myUid())) {
            return !processName.contains("test") && !processName.contains("Test");
        }
        return processName.equals("com.android.systemui") || processName.startsWith("com.android.systemui:");
    }

    @RavenwoodReplace
    private static void throwIfNotTest() {
        ActivityThread activityThread = ActivityThread.currentActivityThread();
        if (activityThread == null) {
            return;
        }
        Instrumentation instrumentation = activityThread.getInstrumentation();
        if (instrumentation == null) {
            return;
        }
        if (instrumentation.isInstrumenting()) {
            return;
        }
        throw new IllegalStateException("Test-only API called not from a test!");
    }

    private static void throwIfNotTest$ravenwood() {
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private void decAndTraceMessageCount() {
        this.mMessageCount.decrementAndGet();
        if (PerfettoTrace.MQ_CATEGORY.isEnabled()) {
            this.traceMessageCount();
        }
    }

    private void incAndTraceMessageCount(Message msg, long when) {
        this.mMessageCount.incrementAndGet();
        if (PerfettoTrace.MQ_CATEGORY.isEnabled()) {
            msg.sendingThreadName = Thread.currentThread().getName();
            msg.mEventId.set(PerfettoTrace.getFlowId());
            this.traceMessageCount();
            long messageDelayMs = Math.max(0L, when - SystemClock.uptimeMillis());
            PerfettoTrace.instant(PerfettoTrace.MQ_CATEGORY, "message_queue_send").setFlow(msg.mEventId.get()).beginProto().beginNested(2004L).addField(2L, this.mThreadName).addField(3L, msg.what).addField(4L, messageDelayMs).endNested().endProto().emit();
        }
    }

    private void traceMessageCount() {
        PerfettoTrace.counter(PerfettoTrace.MQ_CATEGORY, this.mMessageCount.get()).usingThreadCounterTrack(this.mTid, this.mThreadName).emit();
    }

    private void dispose() {
        if (this.mPtr != 0L) {
            MessageQueue.nativeDestroy(this.mPtr);
            this.mPtr = 0L;
        }
    }

    static int compareMessages(@NonNull Message m1, @NonNull Message m2) {
        long whenDiff = m1.when - m2.when;
        if (whenDiff > 0L) {
            return 1;
        }
        if (whenDiff < 0L) {
            return -1;
        }
        long insertSeqDiff = m1.insertSeq - m2.insertSeq;
        if (insertSeqDiff > 0L) {
            return 1;
        }
        if (insertSeqDiff < 0L) {
            return -1;
        }
        return 0;
    }

    private static boolean isBarrier(Message msg) {
        return msg != null && msg.target == null;
    }

    private boolean isIdleConcurrent() {
        long now = SystemClock.uptimeMillis();
        if (this.stackHasMessages(null, 0, null, null, now, sMatchDeliverableMessages, false)) {
            return false;
        }
        Message msg = MessageQueue.first(this.mPriorityQueue);
        if (msg != null && msg.when <= now) {
            return false;
        }
        Message asyncMsg = MessageQueue.first(this.mAsyncPriorityQueue);
        return asyncMsg == null || asyncMsg.when > now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isIdleLegacy() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            long now = SystemClock.uptimeMillis();
            return this.mMessages == null || now < this.mMessages.when;
        }
    }

    public boolean isIdle() {
        if (sUseConcurrent) {
            return this.isIdleConcurrent();
        }
        return this.isIdleLegacy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIdleHandlerConcurrent(@NonNull IdleHandler handler) {
        Object object = this.mIdleHandlersLock;
        synchronized (object) {
            this.mIdleHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIdleHandlerLegacy(@NonNull IdleHandler handler) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.add(handler);
        }
    }

    public void addIdleHandler(@NonNull IdleHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Can't add a null IdleHandler");
        }
        if (sUseConcurrent) {
            this.addIdleHandlerConcurrent(handler);
        } else {
            this.addIdleHandlerLegacy(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIdleHandlerConcurrent(@NonNull IdleHandler handler) {
        Object object = this.mIdleHandlersLock;
        synchronized (object) {
            this.mIdleHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIdleHandlerLegacy(@NonNull IdleHandler handler) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.remove(handler);
        }
    }

    public void removeIdleHandler(@NonNull IdleHandler handler) {
        if (sUseConcurrent) {
            this.removeIdleHandlerConcurrent(handler);
        } else {
            this.removeIdleHandlerLegacy(handler);
        }
    }

    private boolean isPollingConcurrent() {
        if (!this.getQuitting() && this.incrementMptrRefs()) {
            try {
                boolean bl = MessageQueue.nativeIsPolling(this.mPtr);
                return bl;
            }
            finally {
                this.decrementMptrRefs();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPollingLegacy() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            return this.isPollingLocked();
        }
    }

    public boolean isPolling() {
        if (sUseConcurrent) {
            return this.isPollingConcurrent();
        }
        return this.isPollingLegacy();
    }

    private boolean isPollingLocked() {
        return !this.mQuitting && MessageQueue.nativeIsPolling(this.mPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOnFileDescriptorEventListenerConcurrent(@NonNull FileDescriptor fd, int events, @NonNull OnFileDescriptorEventListener listener) {
        Object object = this.mFileDescriptorRecordsLock;
        synchronized (object) {
            this.updateOnFileDescriptorEventListenerLocked(fd, events, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOnFileDescriptorEventListenerLegacy(@NonNull FileDescriptor fd, int events, @NonNull OnFileDescriptorEventListener listener) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.updateOnFileDescriptorEventListenerLocked(fd, events, listener);
        }
    }

    @RavenwoodThrow(blockedBy={ParcelFileDescriptor.class})
    public void addOnFileDescriptorEventListener(@NonNull FileDescriptor fd, int events, @NonNull OnFileDescriptorEventListener listener) {
        if (fd == null) {
            throw new IllegalArgumentException("fd must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (sUseConcurrent) {
            this.addOnFileDescriptorEventListenerConcurrent(fd, events, listener);
        } else {
            this.addOnFileDescriptorEventListenerLegacy(fd, events, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOnFileDescriptorEventListenerConcurrent(@NonNull FileDescriptor fd) {
        Object object = this.mFileDescriptorRecordsLock;
        synchronized (object) {
            this.updateOnFileDescriptorEventListenerLocked(fd, 0, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOnFileDescriptorEventListenerLegacy(@NonNull FileDescriptor fd) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.updateOnFileDescriptorEventListenerLocked(fd, 0, null);
        }
    }

    @RavenwoodThrow(blockedBy={ParcelFileDescriptor.class})
    public void removeOnFileDescriptorEventListener(@NonNull FileDescriptor fd) {
        if (fd == null) {
            throw new IllegalArgumentException("fd must not be null");
        }
        if (sUseConcurrent) {
            this.removeOnFileDescriptorEventListenerConcurrent(fd);
        } else {
            this.removeOnFileDescriptorEventListenerLegacy(fd);
        }
    }

    @RavenwoodThrow(blockedBy={ParcelFileDescriptor.class})
    private void updateOnFileDescriptorEventListenerLocked(FileDescriptor fd, int events, OnFileDescriptorEventListener listener) {
        int fdNum = fd.getInt$();
        int index = -1;
        FileDescriptorRecord record = null;
        if (this.mFileDescriptorRecords != null && (index = this.mFileDescriptorRecords.indexOfKey(fdNum)) >= 0 && (record = this.mFileDescriptorRecords.valueAt(index)) != null && record.mEvents == events) {
            return;
        }
        if (events != 0) {
            events |= 4;
            if (record == null) {
                if (this.mFileDescriptorRecords == null) {
                    this.mFileDescriptorRecords = new SparseArray();
                }
                record = new FileDescriptorRecord(fd, events, listener);
                this.mFileDescriptorRecords.put(fdNum, record);
            } else {
                record.mListener = listener;
                record.mEvents = events;
                ++record.mSeq;
            }
            this.setFileDescriptorEvents(fdNum, events);
        } else if (record != null) {
            record.mEvents = 0;
            this.mFileDescriptorRecords.removeAt(index);
            this.setFileDescriptorEvents(fdNum, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int dispatchEvents(int fd, int events) {
        int seq;
        OnFileDescriptorEventListener listener;
        int oldWatchedEvents;
        FileDescriptorRecord record;
        Object object;
        if (sUseConcurrent) {
            object = this.mFileDescriptorRecordsLock;
            synchronized (object) {
                record = this.mFileDescriptorRecords.get(fd);
                if (record == null) {
                    return 0;
                }
                oldWatchedEvents = record.mEvents;
                if ((events &= oldWatchedEvents) == 0) {
                    return oldWatchedEvents;
                }
                listener = record.mListener;
                seq = record.mSeq;
            }
        }
        object = this;
        synchronized (object) {
            record = this.mFileDescriptorRecords.get(fd);
            if (record == null) {
                return 0;
            }
            oldWatchedEvents = record.mEvents;
            if ((events &= oldWatchedEvents) == 0) {
                return oldWatchedEvents;
            }
            listener = record.mListener;
            seq = record.mSeq;
        }
        int newWatchedEvents = listener.onFileDescriptorEvents(record.mDescriptor, events);
        if (newWatchedEvents != 0) {
            newWatchedEvents |= 4;
        }
        if (newWatchedEvents != oldWatchedEvents) {
            if (sUseConcurrent) {
                Object object2 = this.mFileDescriptorRecordsLock;
                synchronized (object2) {
                    int index = this.mFileDescriptorRecords.indexOfKey(fd);
                    if (index >= 0 && this.mFileDescriptorRecords.valueAt(index) == record && record.mSeq == seq) {
                        record.mEvents = newWatchedEvents;
                        if (newWatchedEvents == 0) {
                            this.mFileDescriptorRecords.removeAt(index);
                        }
                    }
                }
            }
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                int index = this.mFileDescriptorRecords.indexOfKey(fd);
                if (index >= 0 && this.mFileDescriptorRecords.valueAt(index) == record && record.mSeq == seq) {
                    record.mEvents = newWatchedEvents;
                    if (newWatchedEvents == 0) {
                        this.mFileDescriptorRecords.removeAt(index);
                    }
                }
            }
        }
        return newWatchedEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message nextMessage(boolean peek, boolean returnEarliest) {
        block29: {
            Message found;
            boolean i = false;
            while (true) {
                this.mDrainingLock.lock();
                try {
                    this.mNextIsDrainingStack = true;
                }
                finally {
                    this.mDrainingLock.unlock();
                }
                QuittingNode quittingNode = null;
                StackNode oldTop = this.swapAndSetStackStateActive();
                boolean shouldRemoveMessages = false;
                if (oldTop.isQuittingNode()) {
                    quittingNode = (QuittingNode)oldTop;
                    if (!this.mWorkerShouldQuit) {
                        this.mWorkerShouldQuit = true;
                        shouldRemoveMessages = true;
                    }
                }
                this.drainStack(oldTop);
                this.mDrainingLock.lock();
                try {
                    this.mNextIsDrainingStack = false;
                    this.mDrainCompleted.signalAll();
                }
                finally {
                    this.mDrainingLock.unlock();
                }
                if (shouldRemoveMessages) {
                    if (quittingNode.mRemoveAll) {
                        this.removeAllMessages();
                    } else {
                        this.removeAllFutureMessages(quittingNode.mTS);
                    }
                }
                Message msg = MessageQueue.first(this.mPriorityQueue);
                Message asyncMsg = MessageQueue.first(this.mAsyncPriorityQueue);
                long now = SystemClock.uptimeMillis();
                found = null;
                Message next = null;
                if (MessageQueue.isBarrier(msg)) {
                    if (asyncMsg != null && (returnEarliest || now >= asyncMsg.when)) {
                        found = asyncMsg;
                    } else {
                        next = asyncMsg;
                    }
                } else {
                    Message earliest = msg;
                    if (msg == null) {
                        earliest = asyncMsg;
                    } else if (asyncMsg != null && MessageQueue.compareMessages(msg, asyncMsg) > 0) {
                        earliest = asyncMsg;
                    }
                    if (earliest != null) {
                        if (returnEarliest || now >= earliest.when) {
                            found = earliest;
                        } else {
                            next = earliest;
                        }
                    }
                }
                StateNode nextOp = sStackStateActive;
                if (found == null) {
                    if (this.mWorkerShouldQuit) {
                        this.mNextPollTimeoutMillis = 0;
                    } else if (next == null) {
                        this.mNextPollTimeoutMillis = -1;
                        nextOp = sStackStateParked;
                    } else {
                        long nextMessageWhen = next.when;
                        this.mNextPollTimeoutMillis = nextMessageWhen > now ? (int)Math.min(nextMessageWhen - now, Integer.MAX_VALUE) : 0;
                        this.mStackStateTimedPark.mWhenToWake = now + (long)this.mNextPollTimeoutMillis;
                        nextOp = this.mStackStateTimedPark;
                    }
                }
                if (!this.mWorkerShouldQuit && !sState.compareAndSet(this, sStackStateActive, nextOp)) continue;
                this.mMessageCounts.clearCounts();
                if (found == null) break block29;
                if (peek || this.removeFromPriorityQueue(found)) break;
            }
            return found;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message nextConcurrent() {
        long ptr = this.mPtr;
        if (ptr == 0L) {
            return null;
        }
        this.mNextPollTimeoutMillis = 0;
        int pendingIdleHandlerCount = -1;
        while (true) {
            if (this.mNextPollTimeoutMillis != 0) {
                Binder.flushPendingCommands();
            }
            this.mMessageDirectlyQueued = false;
            this.nativePollOnce(ptr, this.mNextPollTimeoutMillis);
            Message msg = this.nextMessage(false, false);
            if (msg != null) {
                msg.markInUse();
                this.decAndTraceMessageCount();
                return msg;
            }
            if (this.mWorkerShouldQuit) {
                this.setMptrTeardownAndWaitForRefsToDrop();
                this.dispose();
                return null;
            }
            Object object = this.mIdleHandlersLock;
            synchronized (object) {
                if (pendingIdleHandlerCount < 0 && this.isIdle()) {
                    pendingIdleHandlerCount = this.mIdleHandlers.size();
                }
                if (pendingIdleHandlerCount <= 0) {
                    continue;
                }
                if (this.mPendingIdleHandlers == null) {
                    this.mPendingIdleHandlers = new IdleHandler[Math.max(pendingIdleHandlerCount, 4)];
                }
                this.mPendingIdleHandlers = this.mIdleHandlers.toArray(this.mPendingIdleHandlers);
            }
            for (int i = 0; i < pendingIdleHandlerCount; ++i) {
                IdleHandler idler = this.mPendingIdleHandlers[i];
                this.mPendingIdleHandlers[i] = null;
                boolean keep = false;
                try {
                    keep = idler.queueIdle();
                }
                catch (Throwable t) {
                    Log.wtf(TAG_C, "IdleHandler threw exception", t);
                }
                if (keep) continue;
                Object object2 = this.mIdleHandlersLock;
                synchronized (object2) {
                    this.mIdleHandlers.remove(idler);
                    continue;
                }
            }
            pendingIdleHandlerCount = 0;
            this.mNextPollTimeoutMillis = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message nextLegacy() {
        long ptr = this.mPtr;
        if (ptr == 0L) {
            return null;
        }
        int pendingIdleHandlerCount = -1;
        int nextPollTimeoutMillis = 0;
        while (true) {
            if (nextPollTimeoutMillis != 0) {
                Binder.flushPendingCommands();
            }
            this.nativePollOnce(ptr, nextPollTimeoutMillis);
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                long now;
                block24: {
                    block23: {
                        now = SystemClock.uptimeMillis();
                        Message prevMsg = null;
                        Message msg = this.mMessages;
                        if (msg != null && msg.target == null) {
                            do {
                                prevMsg = msg;
                            } while ((msg = msg.next) != null && !msg.isAsynchronous());
                        }
                        if (msg == null) break block23;
                        if (now < msg.when) {
                            nextPollTimeoutMillis = (int)Math.min(msg.when - now, Integer.MAX_VALUE);
                            break block24;
                        } else {
                            this.mBlocked = false;
                            if (prevMsg != null) {
                                prevMsg.next = msg.next;
                                if (prevMsg.next == null) {
                                    this.mLast = prevMsg;
                                }
                            } else {
                                this.mMessages = msg.next;
                                if (msg.next == null) {
                                    this.mLast = null;
                                }
                            }
                            msg.next = null;
                            msg.markInUse();
                            if (msg.isAsynchronous()) {
                                --this.mAsyncMessageCount;
                            }
                            this.decAndTraceMessageCount();
                            return msg;
                        }
                    }
                    nextPollTimeoutMillis = -1;
                }
                if (this.mQuitting) {
                    this.dispose();
                    return null;
                }
                if (pendingIdleHandlerCount < 0 && (this.mMessages == null || now < this.mMessages.when)) {
                    pendingIdleHandlerCount = this.mIdleHandlers.size();
                }
                if (pendingIdleHandlerCount <= 0) {
                    this.mBlocked = true;
                    continue;
                }
                if (this.mPendingIdleHandlers == null) {
                    this.mPendingIdleHandlers = new IdleHandler[Math.max(pendingIdleHandlerCount, 4)];
                }
                this.mPendingIdleHandlers = this.mIdleHandlers.toArray(this.mPendingIdleHandlers);
            }
            for (int i = 0; i < pendingIdleHandlerCount; ++i) {
                IdleHandler idler = this.mPendingIdleHandlers[i];
                this.mPendingIdleHandlers[i] = null;
                boolean keep = false;
                try {
                    keep = idler.queueIdle();
                }
                catch (Throwable t) {
                    Log.wtf(TAG_L, "IdleHandler threw exception", t);
                }
                if (keep) continue;
                MessageQueue messageQueue2 = this;
                synchronized (messageQueue2) {
                    this.mIdleHandlers.remove(idler);
                    continue;
                }
            }
            pendingIdleHandlerCount = 0;
            nextPollTimeoutMillis = 0;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=36, publicAlternatives="To manipulate the queue in Instrumentation tests, use {@link android.os.TestLooperManager}")
    Message next() {
        if (sUseConcurrent) {
            return this.nextConcurrent();
        }
        return this.nextLegacy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void quit(boolean safe) {
        if (!this.mQuitAllowed) {
            throw new IllegalStateException("Main thread not allowed to quit.");
        }
        if (sUseConcurrent) {
            StackNode old;
            QuittingNode quittingNode = new QuittingNode(safe);
            do {
                if ((old = sState.getVolatile(this)).isQuittingNode()) {
                    return;
                }
                quittingNode.mNext = old;
                quittingNode.mBottomOfStack = old.isMessageNode() ? ((MessageNode)old).mBottomOfStack : (StateNode)old;
            } while (!sState.compareAndSet(this, old, quittingNode));
            if (this.incrementMptrRefs()) {
                try {
                    MessageQueue.nativeWake(this.mPtr);
                }
                finally {
                    this.decrementMptrRefs();
                }
            }
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.mQuitting) {
                return;
            }
            this.mQuitting = true;
            if (safe) {
                this.removeAllFutureMessagesLocked();
            } else {
                this.removeAllMessagesLocked();
            }
            MessageQueue.nativeWake(this.mPtr);
        }
    }

    private int postSyncBarrierConcurrent() {
        return this.postSyncBarrier(SystemClock.uptimeMillis());
    }

    private int postSyncBarrierLegacy() {
        return this.postSyncBarrier(SystemClock.uptimeMillis());
    }

    @UnsupportedAppUsage
    public int postSyncBarrier() {
        if (sUseConcurrent) {
            return this.postSyncBarrierConcurrent();
        }
        return this.postSyncBarrierLegacy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int postSyncBarrier(long when) {
        if (sUseConcurrent) {
            int token = this.mNextBarrierTokenAtomic.getAndIncrement();
            this.mNextBarrierToken = token + 1;
            Message msg = Message.obtain();
            msg.markInUse();
            msg.arg1 = token;
            if (!this.enqueueMessageUnchecked(msg, when)) {
                Log.wtf(TAG_C, "Unexpected error while adding sync barrier!");
                return -1;
            }
            return token;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            int token = this.mNextBarrierToken++;
            Message msg = Message.obtain();
            msg.markInUse();
            msg.when = when;
            msg.arg1 = token;
            this.incAndTraceMessageCount(msg, when);
            if (this.mLast != null && this.mLast.when <= when) {
                this.mLast.next = msg;
                this.mLast = msg;
                msg.next = null;
                return token;
            }
            Message prev = null;
            Message p = this.mMessages;
            if (when != 0L) {
                while (p != null && p.when <= when) {
                    prev = p;
                    p = p.next;
                }
            }
            if (p == null) {
                this.mLast = msg;
            }
            if (prev != null) {
                msg.next = p;
                prev.next = msg;
            } else {
                msg.next = p;
                this.mMessages = msg;
            }
            return token;
        }
    }

    private void removeSyncBarrierConcurrent(int token) {
        MatchBarrierToken matchBarrierToken = new MatchBarrierToken(token);
        Message m = MessageQueue.first(this.mPriorityQueue);
        boolean removed = this.findOrRemoveMessages(null, 0, null, null, 0L, matchBarrierToken, true);
        if (removed && m != null) {
            if (m.target == null && m.arg1 == token) {
                this.concurrentWake();
            }
        } else if (!removed) {
            throw new IllegalStateException("The specified message queue synchronization  barrier token has not been posted or has already been removed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSyncBarrierLegacy(int token) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            Message prev = null;
            Message p = this.mMessages;
            while (p != null && (p.target != null || p.arg1 != token)) {
                prev = p;
                p = p.next;
            }
            if (p == null) {
                throw new IllegalStateException("The specified message queue synchronization  barrier token has not been posted or has already been removed.");
            }
            if (prev != null) {
                prev.next = p.next;
                if (prev.next == null) {
                    this.mLast = prev;
                }
                needWake = false;
            } else {
                this.mMessages = p.next;
                if (this.mMessages == null) {
                    this.mLast = null;
                }
                needWake = this.mMessages == null || this.mMessages.target != null;
            }
            p.recycleUnchecked();
            this.decAndTraceMessageCount();
            if (needWake && !this.mQuitting) {
                MessageQueue.nativeWake(this.mPtr);
            }
        }
    }

    @UnsupportedAppUsage
    public void removeSyncBarrier(int token) {
        if (sUseConcurrent) {
            this.removeSyncBarrierConcurrent(token);
        } else {
            this.removeSyncBarrierLegacy(token);
        }
    }

    private boolean enqueueMessageConcurrent(Message msg, long when) {
        if (msg.isInUse()) {
            throw new IllegalStateException(msg + " This message is already in use.");
        }
        return this.enqueueMessageUnchecked(msg, when);
    }

    @NeverCompile
    private static void logDeadThread(Message msg) {
        IllegalStateException e = new IllegalStateException(msg.target + " sending message to a Handler on a dead thread");
        Log.w(TAG, e.getMessage(), e);
        msg.recycleUnchecked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enqueueMessageLegacy(Message msg, long when) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            if (msg.isInUse()) {
                throw new IllegalStateException(msg + " This message is already in use.");
            }
            if (this.mQuitting) {
                MessageQueue.logDeadThread(msg);
                return false;
            }
            msg.markInUse();
            msg.when = when;
            this.incAndTraceMessageCount(msg, when);
            Message p = this.mMessages;
            if (p == null || when == 0L || when < p.when) {
                msg.next = p;
                this.mMessages = msg;
                needWake = this.mBlocked;
                if (p == null) {
                    this.mLast = this.mMessages;
                }
            } else {
                boolean bl = needWake = this.mBlocked && p.target == null && msg.isAsynchronous();
                if (when >= this.mLast.when) {
                    needWake = needWake && this.mAsyncMessageCount == 0;
                    msg.next = null;
                    this.mLast.next = msg;
                    this.mLast = msg;
                } else {
                    while (true) {
                        Message prev = p;
                        p = p.next;
                        if (p == null || when < p.when) break;
                        if (!needWake || !p.isAsynchronous()) continue;
                        needWake = false;
                    }
                    if (p == null) {
                        this.mLast = msg;
                    }
                    msg.next = p;
                    prev.next = msg;
                }
            }
            if (msg.isAsynchronous()) {
                ++this.mAsyncMessageCount;
            }
            if (needWake) {
                MessageQueue.nativeWake(this.mPtr);
            }
        }
        return true;
    }

    boolean enqueueMessage(Message msg, long when) {
        if (msg.target == null) {
            throw new IllegalArgumentException("Message must have a target.");
        }
        if (sUseConcurrent) {
            return this.enqueueMessageConcurrent(msg, when);
        }
        return this.enqueueMessageLegacy(msg, when);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message legacyPeekOrPoll(boolean peek) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            long now = SystemClock.uptimeMillis();
            Message prevMsg = null;
            Message msg = this.mMessages;
            if (msg != null && msg.target == null) {
                do {
                    prevMsg = msg;
                } while ((msg = msg.next) != null && !msg.isAsynchronous());
            }
            if (msg != null) {
                if (peek) {
                    return msg;
                }
                if (now >= msg.when) {
                    this.mBlocked = false;
                }
                if (prevMsg != null) {
                    prevMsg.next = msg.next;
                    if (prevMsg.next == null) {
                        this.mLast = prevMsg;
                    }
                } else {
                    this.mMessages = msg.next;
                    if (msg.next == null) {
                        this.mLast = null;
                    }
                }
                msg.next = null;
                msg.markInUse();
                if (msg.isAsynchronous()) {
                    --this.mAsyncMessageCount;
                }
                this.decAndTraceMessageCount();
                return msg;
            }
        }
        return null;
    }

    @SuppressLint(value={"VisiblySynchronized"})
    Long peekWhenForTest() {
        MessageQueue.throwIfNotTest();
        Message ret = sUseConcurrent ? this.nextMessage(true, true) : this.legacyPeekOrPoll(true);
        return ret != null ? Long.valueOf(ret.when) : null;
    }

    @SuppressLint(value={"VisiblySynchronized"})
    @Nullable
    Message pollForTest() {
        MessageQueue.throwIfNotTest();
        if (sUseConcurrent) {
            return this.nextMessage(false, true);
        }
        return this.legacyPeekOrPoll(false);
    }

    boolean isBlockedOnSyncBarrier() {
        MessageQueue.throwIfNotTest();
        if (sUseConcurrent) {
            this.nextMessage(true, false);
            return MessageQueue.isBarrier(MessageQueue.first(this.mPriorityQueue));
        }
        Message msg = this.mMessages;
        return msg != null && msg.target == null;
    }

    private boolean hasMessagesConcurrent(Handler h, int what, Object object) {
        return this.findOrRemoveMessages(h, what, object, null, 0L, sMatchHandlerWhatAndObject, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMessagesLegacy(Handler h, int what, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.what == what && (object == null || p.obj == object)) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    boolean hasMessages(Handler h, int what, Object object) {
        if (h == null) {
            return false;
        }
        if (sUseConcurrent) {
            return this.hasMessagesConcurrent(h, what, object);
        }
        return this.hasMessagesLegacy(h, what, object);
    }

    private boolean hasEqualMessagesConcurrent(Handler h, int what, Object object) {
        return this.findOrRemoveMessages(h, what, object, null, 0L, sMatchHandlerWhatAndObjectEquals, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasEqualMessagesLegacy(Handler h, int what, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.what == what && (object == null || object.equals(p.obj))) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    boolean hasEqualMessages(Handler h, int what, Object object) {
        if (h == null) {
            return false;
        }
        if (sUseConcurrent) {
            return this.hasEqualMessagesConcurrent(h, what, object);
        }
        return this.hasEqualMessagesLegacy(h, what, object);
    }

    private boolean hasMessagesConcurrent(Handler h, Runnable r, Object object) {
        return this.findOrRemoveMessages(h, -1, object, r, 0L, sMatchHandlerRunnableAndObject, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMessagesLegacy(Handler h, Runnable r, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.callback == r && (object == null || p.obj == object)) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    boolean hasMessages(Handler h, Runnable r, Object object) {
        if (h == null) {
            return false;
        }
        if (sUseConcurrent) {
            return this.hasMessagesConcurrent(h, r, object);
        }
        return this.hasMessagesLegacy(h, r, object);
    }

    private boolean hasMessagesConcurrent(Handler h) {
        return this.findOrRemoveMessages(h, -1, null, null, 0L, sMatchHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMessagesLegacy(Handler h) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    boolean hasMessages(Handler h) {
        if (h == null) {
            return false;
        }
        if (sUseConcurrent) {
            return this.hasMessagesConcurrent(h);
        }
        return this.hasMessagesLegacy(h);
    }

    private void removeMessagesConcurrent(Handler h, int what, Object object) {
        this.findOrRemoveMessages(h, what, object, null, 0L, sMatchHandlerWhatAndObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMessagesLegacy(Handler h, int what, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.what == what && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                if (p.isAsynchronous()) {
                    --this.mAsyncMessageCount;
                }
                p.recycleUnchecked();
                this.decAndTraceMessageCount();
                p = n;
            }
            if (p == null) {
                this.mLast = this.mMessages;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.what == what && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    if (n.isAsynchronous()) {
                        --this.mAsyncMessageCount;
                    }
                    n.recycleUnchecked();
                    this.decAndTraceMessageCount();
                    p.next = nn;
                    if (p.next != null) continue;
                    this.mLast = p;
                    continue;
                }
                p = n;
            }
        }
    }

    void removeMessages(Handler h, int what, Object object) {
        if (h == null) {
            return;
        }
        if (sUseConcurrent) {
            this.removeMessagesConcurrent(h, what, object);
        } else {
            this.removeMessagesLegacy(h, what, object);
        }
    }

    private void removeEqualMessagesConcurrent(Handler h, int what, Object object) {
        this.findOrRemoveMessages(h, what, object, null, 0L, sMatchHandlerWhatAndObjectEquals, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEqualMessagesLegacy(Handler h, int what, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.what == what && (object == null || object.equals(p.obj))) {
                this.mMessages = n = p.next;
                if (p.isAsynchronous()) {
                    --this.mAsyncMessageCount;
                }
                p.recycleUnchecked();
                this.decAndTraceMessageCount();
                p = n;
            }
            if (p == null) {
                this.mLast = this.mMessages;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.what == what && (object == null || object.equals(n.obj))) {
                    Message nn = n.next;
                    if (n.isAsynchronous()) {
                        --this.mAsyncMessageCount;
                    }
                    n.recycleUnchecked();
                    this.decAndTraceMessageCount();
                    p.next = nn;
                    if (p.next != null) continue;
                    this.mLast = p;
                    continue;
                }
                p = n;
            }
        }
    }

    void removeEqualMessages(Handler h, int what, Object object) {
        if (h == null) {
            return;
        }
        if (sUseConcurrent) {
            this.removeEqualMessagesConcurrent(h, what, object);
        } else {
            this.removeEqualMessagesLegacy(h, what, object);
        }
    }

    private void removeMessagesConcurrent(Handler h, Runnable r, Object object) {
        this.findOrRemoveMessages(h, -1, object, r, 0L, sMatchHandlerRunnableAndObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMessagesLegacy(Handler h, Runnable r, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.callback == r && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                if (p.isAsynchronous()) {
                    --this.mAsyncMessageCount;
                }
                p.recycleUnchecked();
                this.decAndTraceMessageCount();
                p = n;
            }
            if (p == null) {
                this.mLast = this.mMessages;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.callback == r && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    if (n.isAsynchronous()) {
                        --this.mAsyncMessageCount;
                    }
                    n.recycleUnchecked();
                    this.decAndTraceMessageCount();
                    p.next = nn;
                    if (p.next != null) continue;
                    this.mLast = p;
                    continue;
                }
                p = n;
            }
        }
    }

    void removeMessages(Handler h, Runnable r, Object object) {
        if (h == null || r == null) {
            return;
        }
        if (sUseConcurrent) {
            this.removeMessagesConcurrent(h, r, object);
        } else {
            this.removeMessagesLegacy(h, r, object);
        }
    }

    private void removeEqualMessagesConcurrent(Handler h, Runnable r, Object object) {
        this.findOrRemoveMessages(h, -1, object, r, 0L, sMatchHandlerRunnableAndObjectEquals, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEqualMessagesLegacy(Handler h, Runnable r, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.callback == r && (object == null || object.equals(p.obj))) {
                this.mMessages = n = p.next;
                if (p.isAsynchronous()) {
                    --this.mAsyncMessageCount;
                }
                p.recycleUnchecked();
                this.decAndTraceMessageCount();
                p = n;
            }
            if (p == null) {
                this.mLast = this.mMessages;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.callback == r && (object == null || object.equals(n.obj))) {
                    Message nn = n.next;
                    if (n.isAsynchronous()) {
                        --this.mAsyncMessageCount;
                    }
                    n.recycleUnchecked();
                    this.decAndTraceMessageCount();
                    p.next = nn;
                    if (p.next != null) continue;
                    this.mLast = p;
                    continue;
                }
                p = n;
            }
        }
    }

    void removeEqualMessages(Handler h, Runnable r, Object object) {
        if (h == null || r == null) {
            return;
        }
        if (sUseConcurrent) {
            this.removeEqualMessagesConcurrent(h, r, object);
        } else {
            this.removeEqualMessagesLegacy(h, r, object);
        }
    }

    private void removeCallbacksAndMessagesConcurrent(Handler h, Object object) {
        this.findOrRemoveMessages(h, -1, object, null, 0L, sMatchHandlerAndObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCallbacksAndMessagesLegacy(Handler h, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                if (p.isAsynchronous()) {
                    --this.mAsyncMessageCount;
                }
                p.recycleUnchecked();
                this.decAndTraceMessageCount();
                p = n;
            }
            if (p == null) {
                this.mLast = this.mMessages;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    if (n.isAsynchronous()) {
                        --this.mAsyncMessageCount;
                    }
                    n.recycleUnchecked();
                    this.decAndTraceMessageCount();
                    p.next = nn;
                    if (p.next != null) continue;
                    this.mLast = p;
                    continue;
                }
                p = n;
            }
        }
    }

    void removeCallbacksAndMessages(Handler h, Object object) {
        if (h == null) {
            return;
        }
        if (sUseConcurrent) {
            this.removeCallbacksAndMessagesConcurrent(h, object);
        } else {
            this.removeCallbacksAndMessagesLegacy(h, object);
        }
    }

    void removeCallbacksAndEqualMessagesConcurrent(Handler h, Object object) {
        this.findOrRemoveMessages(h, -1, object, null, 0L, sMatchHandlerAndObjectEquals, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCallbacksAndEqualMessagesLegacy(Handler h, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && (object == null || object.equals(p.obj))) {
                this.mMessages = n = p.next;
                if (p.isAsynchronous()) {
                    --this.mAsyncMessageCount;
                }
                p.recycleUnchecked();
                this.decAndTraceMessageCount();
                p = n;
            }
            if (p == null) {
                this.mLast = this.mMessages;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && (object == null || object.equals(n.obj))) {
                    Message nn = n.next;
                    if (n.isAsynchronous()) {
                        --this.mAsyncMessageCount;
                    }
                    n.recycleUnchecked();
                    this.decAndTraceMessageCount();
                    p.next = nn;
                    if (p.next != null) continue;
                    this.mLast = p;
                    continue;
                }
                p = n;
            }
        }
    }

    void removeCallbacksAndEqualMessages(Handler h, Object object) {
        if (h == null) {
            return;
        }
        if (sUseConcurrent) {
            this.removeCallbacksAndEqualMessagesConcurrent(h, object);
        } else {
            this.removeCallbacksAndEqualMessagesLegacy(h, object);
        }
    }

    private void removeAllMessagesLocked() {
        Message p = this.mMessages;
        while (p != null) {
            Message n = p.next;
            p.recycleUnchecked();
            p = n;
        }
        this.mMessages = null;
        this.mLast = null;
        this.mAsyncMessageCount = 0;
        this.mMessageCount.set(0L);
        this.traceMessageCount();
    }

    private void removeAllFutureMessagesLocked() {
        long now = SystemClock.uptimeMillis();
        Message p = this.mMessages;
        if (p != null) {
            if (p.when > now) {
                this.removeAllMessagesLocked();
            } else {
                Message n;
                while (true) {
                    if ((n = p.next) == null) {
                        return;
                    }
                    if (n.when > now) break;
                    p = n;
                }
                p.next = null;
                this.mLast = p;
                do {
                    p = n;
                    n = p.next;
                    if (p.isAsynchronous()) {
                        --this.mAsyncMessageCount;
                    }
                    p.recycleUnchecked();
                    this.decAndTraceMessageCount();
                } while (n != null);
            }
        }
    }

    private void removeAllMessages() {
        this.findOrRemoveMessages(null, -1, null, null, 0L, sMatchAllMessages, true);
    }

    private void removeAllFutureMessages(long now) {
        this.findOrRemoveMessages(null, -1, null, null, now, sMatchAllFutureMessages, true);
    }

    @NeverCompile
    private void printPriorityQueueNodes() {
        Log.d(TAG_C, "* Dump priority queue");
        for (Message msg : this.mPriorityQueue) {
            Log.d(TAG_C, "** Message what: " + msg.what + " when " + msg.when + " seq: " + msg.insertSeq);
        }
    }

    @NeverCompile
    private int dumpPriorityQueue(ConcurrentSkipListSet<Message> queue, Printer pw, String prefix, Handler h, int n) {
        int count = 0;
        long now = SystemClock.uptimeMillis();
        for (Message msg : queue) {
            if (h == null || h == msg.target) {
                pw.println(prefix + "Message " + (n + count) + ": " + msg.toString(now));
            }
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NeverCompile
    void dump(Printer pw, String prefix, Handler h) {
        if (sUseConcurrent) {
            long now = SystemClock.uptimeMillis();
            int n = 0;
            pw.println(prefix + "(MessageQueue is using Concurrent implementation)");
            StackNode node = sState.getVolatile(this);
            while (node != null) {
                if (node.isMessageNode()) {
                    Message msg = ((MessageNode)node).mMessage;
                    if (h == null || h == msg.target) {
                        pw.println(prefix + "Message " + n + ": " + msg.toString(now));
                    }
                    node = ((MessageNode)node).mNext;
                } else {
                    pw.println(prefix + "State: " + node);
                    node = null;
                }
                ++n;
            }
            pw.println(prefix + "PriorityQueue Messages: ");
            n += this.dumpPriorityQueue(this.mPriorityQueue, pw, prefix, h, n);
            pw.println(prefix + "AsyncPriorityQueue Messages: ");
            n += this.dumpPriorityQueue(this.mAsyncPriorityQueue, pw, prefix, h, n);
            pw.println(prefix + "(Total messages: " + n + ", polling=" + this.isPolling() + ", quitting=" + this.getQuitting() + ")");
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            pw.println(prefix + "(MessageQueue is using Legacy implementation)");
            long now = SystemClock.uptimeMillis();
            int n = 0;
            Message msg = this.mMessages;
            while (msg != null) {
                if (h == null || h == msg.target) {
                    pw.println(prefix + "Message " + n + ": " + msg.toString(now));
                }
                ++n;
                msg = msg.next;
            }
            pw.println(prefix + "(Total messages: " + n + ", polling=" + this.isPollingLocked() + ", quitting=" + this.mQuitting + ")");
        }
    }

    @NeverCompile
    private int dumpPriorityQueue(ConcurrentSkipListSet<Message> queue, ProtoOutputStream proto) {
        int count = 0;
        for (Message msg : queue) {
            msg.dumpDebug(proto, 2246267895809L);
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NeverCompile
    void dumpDebug(ProtoOutputStream proto, long fieldId) {
        if (sUseConcurrent) {
            long messageQueueToken = proto.start(fieldId);
            StackNode node = sState.getVolatile(this);
            while (node.isMessageNode()) {
                Message msg = ((MessageNode)node).mMessage;
                msg.dumpDebug(proto, 2246267895809L);
                node = ((MessageNode)node).mNext;
            }
            this.dumpPriorityQueue(this.mPriorityQueue, proto);
            this.dumpPriorityQueue(this.mAsyncPriorityQueue, proto);
            proto.write(1133871366146L, this.isPolling());
            proto.write(1133871366147L, this.getQuitting());
            proto.end(messageQueueToken);
            return;
        }
        long messageQueueToken = proto.start(fieldId);
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message msg = this.mMessages;
            while (msg != null) {
                msg.dumpDebug(proto, 2246267895809L);
                msg = msg.next;
            }
            proto.write(1133871366146L, this.isPollingLocked());
            proto.write(1133871366147L, this.mQuitting);
        }
        proto.end(messageQueueToken);
    }

    private void insertIntoPriorityQueue(Message msg) {
        if (msg.isAsynchronous()) {
            this.mAsyncPriorityQueue.add(msg);
        } else {
            this.mPriorityQueue.add(msg);
        }
    }

    private boolean removeFromPriorityQueue(Message msg) {
        if (msg.isAsynchronous()) {
            return this.mAsyncPriorityQueue.remove(msg);
        }
        return this.mPriorityQueue.remove(msg);
    }

    private static Message first(ConcurrentSkipListSet<Message> queue) {
        if (queue.isEmpty()) {
            return null;
        }
        try {
            return queue.first();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private void drainStack(StackNode oldTop) {
        QuittingNode quittingNode;
        QuittingNode quittingNode2 = quittingNode = oldTop.isQuittingNode() ? (QuittingNode)oldTop : null;
        if (quittingNode != null) {
            oldTop = quittingNode.mNext;
            quittingNode.mNext = quittingNode.mBottomOfStack;
        }
        while (oldTop.isMessageNode()) {
            MessageNode oldTopMessageNode = (MessageNode)oldTop;
            if (oldTopMessageNode.removeFromStack()) {
                this.insertIntoPriorityQueue(oldTopMessageNode.mMessage);
            }
            MessageNode inserted = oldTopMessageNode;
            oldTop = oldTopMessageNode.mNext;
            inserted.mNext = null;
        }
    }

    private StackNode swapAndSetStackStateActive() {
        StackNode current;
        while ((current = sState.getVolatile(this)) != sStackStateActive && !current.isQuittingNode() && !sState.compareAndSet(this, current, sStackStateActive)) {
        }
        return current;
    }

    private StateNode getStateNode(StackNode node) {
        if (node.isMessageNode()) {
            return ((MessageNode)node).mBottomOfStack;
        }
        if (node.isQuittingNode()) {
            return ((QuittingNode)node).mBottomOfStack;
        }
        return (StateNode)node;
    }

    private void waitForDrainCompleted() {
        this.mDrainingLock.lock();
        while (this.mNextIsDrainingStack) {
            this.mDrainCompleted.awaitUninterruptibly();
        }
        this.mDrainingLock.unlock();
    }

    private boolean incrementMptrRefs() {
        long oldVal;
        do {
            if (((oldVal = this.mMptrRefCountValue) & Long.MIN_VALUE) == 0L) continue;
            return false;
        } while (!sMptrRefCount.compareAndSet(this, oldVal, oldVal + 1L));
        return true;
    }

    private void decrementMptrRefs() {
        long oldVal = sMptrRefCount.getAndAdd(this, -1);
        if (oldVal - 1L == Long.MIN_VALUE) {
            LockSupport.unpark(this.mLooperThread);
        }
    }

    private void concurrentWake() {
        if (this.incrementMptrRefs()) {
            try {
                MessageQueue.nativeWake(this.mPtr);
            }
            finally {
                this.decrementMptrRefs();
            }
        }
    }

    private void setFileDescriptorEvents(int fdNum, int events) {
        if (sUseConcurrent) {
            if (this.incrementMptrRefs()) {
                try {
                    MessageQueue.nativeSetFileDescriptorEvents(this.mPtr, fdNum, events);
                }
                finally {
                    this.decrementMptrRefs();
                }
            }
        } else {
            MessageQueue.nativeSetFileDescriptorEvents(this.mPtr, fdNum, events);
        }
    }

    private boolean getQuitting() {
        return sState.getVolatile(this).isQuittingNode();
    }

    private void setMptrTeardownAndWaitForRefsToDrop() {
        long oldVal;
        while (!sMptrRefCount.compareAndSet(this, oldVal = this.mMptrRefCountValue, oldVal | Long.MIN_VALUE)) {
        }
        boolean wasInterrupted = false;
        try {
            while ((this.mMptrRefCountValue & Long.MAX_VALUE) != 0L) {
                LockSupport.park();
                wasInterrupted |= Thread.interrupted();
            }
        }
        finally {
            if (wasInterrupted) {
                this.mLooperThread.interrupt();
            }
        }
    }

    private boolean enqueueMessageUnchecked(@NonNull Message msg, long when) {
        boolean wakeNeeded;
        boolean inactive;
        StackNode old;
        long seq = when != 0L ? sNextInsertSeq.getAndAdd(this, 1L) + 1L : sNextFrontInsertSeq.getAndAdd(this, -1L) - 1L;
        msg.when = when;
        msg.insertSeq = seq;
        msg.markInUse();
        Looper myLooper = Looper.myLooper();
        if (myLooper != null && myLooper.getQueue() == this) {
            if (this.getQuitting()) {
                MessageQueue.logDeadThread(msg);
                return false;
            }
            this.insertIntoPriorityQueue(msg);
            this.incAndTraceMessageCount(msg, when);
            if (!this.mMessageDirectlyQueued) {
                this.mMessageDirectlyQueued = true;
                MessageQueue.nativeWake(this.mPtr);
            }
            return true;
        }
        MessageNode node = new MessageNode(msg);
        do {
            node.mNext = old = sState.getVolatile(this);
            switch (old.getNodeType()) {
                case 1: {
                    node.mBottomOfStack = (StateNode)old;
                    inactive = false;
                    node.mWokeUp = true;
                    wakeNeeded = false;
                    break;
                }
                case 2: {
                    node.mBottomOfStack = (StateNode)old;
                    inactive = true;
                    node.mWokeUp = true;
                    wakeNeeded = true;
                    break;
                }
                case 3: {
                    node.mBottomOfStack = (StateNode)old;
                    inactive = true;
                    node.mWokeUp = wakeNeeded = this.mStackStateTimedPark.mWhenToWake >= msg.when;
                    break;
                }
                case 4: {
                    MessageQueue.logDeadThread(msg);
                    return false;
                }
                default: {
                    MessageNode oldMessage = (MessageNode)old;
                    node.mBottomOfStack = oldMessage.mBottomOfStack;
                    int bottomType = node.mBottomOfStack.getNodeType();
                    inactive = bottomType >= 2;
                    wakeNeeded = bottomType == 3 && this.mStackStateTimedPark.mWhenToWake >= node.mMessage.when && !oldMessage.mWokeUp;
                    boolean bl = node.mWokeUp = oldMessage.mWokeUp || wakeNeeded;
                }
            }
        } while (!sState.compareAndSet(this, old, node));
        if (inactive) {
            if (wakeNeeded) {
                this.concurrentWake();
            } else {
                this.mMessageCounts.incrementQueued();
            }
        }
        this.incAndTraceMessageCount(msg, when);
        return true;
    }

    private boolean stackHasMessages(Handler h, int what, Object object, Runnable r, long when, MessageCompare compare, boolean removeMatches) {
        StateNode bottom;
        boolean found = false;
        StackNode top = sState.getVolatile(this);
        if (top == (bottom = this.getStateNode(top))) {
            this.waitForDrainCompleted();
            return false;
        }
        if (top.isQuittingNode()) {
            QuittingNode quittingNode = (QuittingNode)top;
            StackNode next = quittingNode.mNext;
            if (next.isMessageNode()) {
                top = next;
            } else {
                this.waitForDrainCompleted();
                return false;
            }
        }
        MessageNode p = (MessageNode)top;
        while (true) {
            StackNode n;
            Message msg;
            if (compare.compareMessage(msg = p.mMessage, h, what, object, r, when)) {
                found = true;
                if (!removeMatches) break;
                if (p.removeFromStack()) {
                    msg.clear();
                    this.decAndTraceMessageCount();
                    if (this.mMessageCounts.incrementCancelled()) {
                        this.concurrentWake();
                    }
                }
            }
            if ((n = p.mNext) == null || !n.isMessageNode()) break;
            p = (MessageNode)n;
        }
        this.waitForDrainCompleted();
        return found;
    }

    private boolean priorityQueueHasMessage(ConcurrentSkipListSet<Message> queue, Handler h, int what, Object object, Runnable r, long when, MessageCompare compare, boolean removeMatches) {
        boolean found = false;
        for (Message msg : queue) {
            if (!compare.compareMessage(msg, h, what, object, r, when)) continue;
            if (removeMatches) {
                if (!queue.remove(msg)) continue;
                msg.clear();
                this.decAndTraceMessageCount();
                found = true;
                continue;
            }
            return true;
        }
        return found;
    }

    private boolean findOrRemoveMessages(Handler h, int what, Object object, Runnable r, long when, MessageCompare compare, boolean removeMatches) {
        boolean foundInStack = this.stackHasMessages(h, what, object, r, when, compare, removeMatches);
        boolean foundInQueue = this.priorityQueueHasMessage(this.mPriorityQueue, h, what, object, r, when, compare, removeMatches);
        return foundInStack || (foundInQueue |= this.priorityQueueHasMessage(this.mAsyncPriorityQueue, h, what, object, r, when, compare, removeMatches));
    }

    static {
        sIsProcessAllowedToUseConcurrent = null;
        sEnqueueOrder = new EnqueueOrder();
        sMatchDeliverableMessages = new MatchDeliverableMessages();
        mMessagesDelivered = new AtomicLong();
        sMatchHandlerWhatAndObject = new MatchHandlerWhatAndObject();
        sMatchHandlerWhatAndObjectEquals = new MatchHandlerWhatAndObjectEquals();
        sMatchHandlerRunnableAndObject = new MatchHandlerRunnableAndObject();
        sMatchHandler = new MatchHandler();
        sMatchHandlerRunnableAndObjectEquals = new MatchHandlerRunnableAndObjectEquals();
        sMatchHandlerAndObject = new MatchHandlerAndObject();
        sMatchHandlerAndObjectEquals = new MatchHandlerAndObjectEquals();
        sMatchAllMessages = new MatchAllMessages();
        sMatchAllFutureMessages = new MatchAllFutureMessages();
        sStackStateActive = new StateNode(1);
        sStackStateParked = new StateNode(2);
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            sState = l.findVarHandle(MessageQueue.class, "mStateValue", StackNode.class);
            sNextInsertSeq = l.findVarHandle(MessageQueue.class, "mNextInsertSeqValue", Long.TYPE);
            sNextFrontInsertSeq = l.findVarHandle(MessageQueue.class, "mNextFrontInsertSeqValue", Long.TYPE);
            sMptrRefCount = l.findVarHandle(MessageQueue.class, "mMptrRefCountValue", Long.TYPE);
        }
        catch (Exception e) {
            Log.wtf(TAG_C, "VarHandle lookup failed", e);
            throw new ExceptionInInitializerError(e);
        }
    }

    static class TimedParkStateNode
    extends StateNode {
        long mWhenToWake;

        TimedParkStateNode() {
            super(3);
        }
    }

    static class StateNode
    extends StackNode {
        StateNode(int type) {
            super(type);
        }
    }

    static class StackNode {
        private final int mType;

        StackNode(int type) {
            this.mType = type;
        }

        int getNodeType() {
            return this.mType;
        }

        boolean isMessageNode() {
            return this.mType == 0;
        }

        boolean isQuittingNode() {
            return this.mType == 4;
        }
    }

    static class EnqueueOrder
    implements Comparator<Message> {
        EnqueueOrder() {
        }

        @Override
        public int compare(Message m1, Message m2) {
            return MessageQueue.compareMessages(m1, m2);
        }
    }

    static class MessageCounts {
        private static VarHandle sCounts;
        private volatile long mCountsValue = 0L;
        private static final long AWAKE = Long.MAX_VALUE;
        private static final int MESSAGE_FLUSH_THRESHOLD = 10;

        MessageCounts() {
        }

        private static int numQueued(long val) {
            return (int)(val >>> 32);
        }

        private static int numCancelled(long val) {
            return (int)val;
        }

        private static long combineCounts(int queued, int cancelled) {
            return (long)queued << 32 | (long)cancelled;
        }

        public void incrementQueued() {
            long newVal;
            long oldVal;
            do {
                oldVal = this.mCountsValue;
                int queued = MessageCounts.numQueued(oldVal);
                int cancelled = MessageCounts.numCancelled(oldVal);
                newVal = MessageCounts.combineCounts(Math.max(queued + 1, queued), cancelled);
            } while (oldVal != Long.MAX_VALUE && !sCounts.compareAndSet(this, oldVal, newVal));
        }

        public boolean incrementCancelled() {
            int cancelled;
            int queued;
            boolean needsPurge;
            long newVal;
            long oldVal;
            do {
                if ((oldVal = this.mCountsValue) == Long.MAX_VALUE) {
                    return false;
                }
                queued = MessageCounts.numQueued(oldVal);
                cancelled = MessageCounts.numCancelled(oldVal);
            } while (!sCounts.compareAndSet(this, oldVal, newVal = (needsPurge = queued > 10 && queued >> 1 < cancelled) ? Long.MAX_VALUE : MessageCounts.combineCounts(queued, Math.max(cancelled + 1, cancelled))));
            return needsPurge;
        }

        public void clearCounts() {
            this.mCountsValue = 0L;
        }

        static {
            try {
                MethodHandles.Lookup l = MethodHandles.lookup();
                sCounts = l.findVarHandle(MessageCounts.class, "mCountsValue", Long.TYPE);
            }
            catch (Exception e) {
                Log.wtf(MessageQueue.TAG_C, "VarHandle lookup failed", e);
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    static class MatchDeliverableMessages
    extends MessageCompare {
        MatchDeliverableMessages() {
        }

        @Override
        public boolean compareMessage(Message m, Handler h, int what, Object object, Runnable r, long when) {
            return m.when <= when;
        }
    }

    static abstract class MessageCompare {
        MessageCompare() {
        }

        public abstract boolean compareMessage(Message var1, Handler var2, int var3, Object var4, Runnable var5, long var6);
    }

    public static interface IdleHandler {
        public boolean queueIdle();
    }

    public static interface OnFileDescriptorEventListener {
        public static final int EVENT_INPUT = 1;
        public static final int EVENT_OUTPUT = 2;
        public static final int EVENT_ERROR = 4;

        public int onFileDescriptorEvents(@NonNull FileDescriptor var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Events {
        }
    }

    static class FileDescriptorRecord {
        public final FileDescriptor mDescriptor;
        public int mEvents;
        public OnFileDescriptorEventListener mListener;
        public int mSeq;

        public FileDescriptorRecord(FileDescriptor descriptor, int events, OnFileDescriptorEventListener listener) {
            this.mDescriptor = descriptor;
            this.mEvents = events;
            this.mListener = listener;
        }
    }

    static class QuittingNode
    extends StackNode {
        volatile StackNode mNext;
        StateNode mBottomOfStack;
        final boolean mRemoveAll;
        final long mTS;

        QuittingNode(boolean safe) {
            super(4);
            if (safe) {
                this.mTS = SystemClock.uptimeMillis();
                this.mRemoveAll = false;
            } else {
                this.mTS = 0L;
                this.mRemoveAll = true;
            }
        }
    }

    static class MessageNode
    extends StackNode {
        final Message mMessage;
        volatile StackNode mNext;
        StateNode mBottomOfStack;
        boolean mWokeUp;
        private static final VarHandle sRemovedFromStack;
        private volatile boolean mRemovedFromStackValue;

        MessageNode(@NonNull Message message) {
            super(0);
            this.mMessage = message;
        }

        boolean removeFromStack() {
            return sRemovedFromStack.compareAndSet(this, false, true);
        }

        static {
            try {
                MethodHandles.Lookup l = MethodHandles.lookup();
                sRemovedFromStack = l.findVarHandle(MessageNode.class, "mRemovedFromStackValue", Boolean.TYPE);
            }
            catch (Exception e) {
                Log.wtf(MessageQueue.TAG_C, "VarHandle lookup failed", e);
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    static class MatchBarrierToken
    extends MessageCompare {
        int mBarrierToken;

        MatchBarrierToken(int token) {
            this.mBarrierToken = token;
        }

        @Override
        public boolean compareMessage(Message m, Handler h, int what, Object object, Runnable r, long when) {
            return m.target == null && m.arg1 == this.mBarrierToken;
        }
    }

    static class MatchHandlerWhatAndObject
    extends MessageCompare {
        MatchHandlerWhatAndObject() {
        }

        @Override
        public boolean compareMessage(Message m, Handler h, int what, Object object, Runnable r, long when) {
            return m.target == h && m.what == what && (object == null || m.obj == object);
        }
    }

    static class MatchHandlerWhatAndObjectEquals
    extends MessageCompare {
        MatchHandlerWhatAndObjectEquals() {
        }

        @Override
        public boolean compareMessage(Message m, Handler h, int what, Object object, Runnable r, long when) {
            return m.target == h && m.what == what && (object == null || object.equals(m.obj));
        }
    }

    static class MatchHandlerRunnableAndObject
    extends MessageCompare {
        MatchHandlerRunnableAndObject() {
        }

        @Override
        public boolean compareMessage(Message m, Handler h, int what, Object object, Runnable r, long when) {
            return m.target == h && m.callback == r && (object == null || m.obj == object);
        }
    }

    static class MatchHandler
    extends MessageCompare {
        MatchHandler() {
        }

        @Override
        public boolean compareMessage(Message m, Handler h, int what, Object object, Runnable r, long when) {
            return m.target == h;
        }
    }

    static class MatchHandlerRunnableAndObjectEquals
    extends MessageCompare {
        MatchHandlerRunnableAndObjectEquals() {
        }

        @Override
        public boolean compareMessage(Message m, Handler h, int what, Object object, Runnable r, long when) {
            return m.target == h && m.callback == r && (object == null || object.equals(m.obj));
        }
    }

    static class MatchHandlerAndObject
    extends MessageCompare {
        MatchHandlerAndObject() {
        }

        @Override
        public boolean compareMessage(Message m, Handler h, int what, Object object, Runnable r, long when) {
            return m.target == h && (object == null || m.obj == object);
        }
    }

    static class MatchHandlerAndObjectEquals
    extends MessageCompare {
        MatchHandlerAndObjectEquals() {
        }

        @Override
        public boolean compareMessage(Message m, Handler h, int what, Object object, Runnable r, long when) {
            return m.target == h && (object == null || object.equals(m.obj));
        }
    }

    static class MatchAllMessages
    extends MessageCompare {
        MatchAllMessages() {
        }

        @Override
        public boolean compareMessage(Message m, Handler h, int what, Object object, Runnable r, long when) {
            return true;
        }
    }

    static class MatchAllFutureMessages
    extends MessageCompare {
        MatchAllFutureMessages() {
        }

        @Override
        public boolean compareMessage(Message m, Handler h, int what, Object object, Runnable r, long when) {
            return m.when > when;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface StackNodeType {
    }
}

