/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PropertyInvalidatedCache;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.BatterySaverPolicyConfig;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.IScreenTimeoutPolicyListener;
import android.os.IThermalHeadroomListener;
import android.os.IThermalService;
import android.os.IThermalStatusListener;
import android.os.IWakeLockCallback;
import android.os.ParcelDuration;
import android.os.PowerExemptionManager;
import android.os.PowerSaveState;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.WorkSource;
import android.service.dreams.Sandman;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.hidden_from_bootclasspath.android.companion.virtualdevice.flags.Flags;
import com.android.internal.util.Preconditions;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public class PowerManager {
    private static final String TAG = "PowerManager";
    public static final int PARTIAL_WAKE_LOCK = 1;
    @Deprecated
    public static final int SCREEN_DIM_WAKE_LOCK = 6;
    @Deprecated
    public static final int SCREEN_BRIGHT_WAKE_LOCK = 10;
    @Deprecated
    public static final int FULL_WAKE_LOCK = 26;
    public static final int PROXIMITY_SCREEN_OFF_WAKE_LOCK = 32;
    public static final int DOZE_WAKE_LOCK = 64;
    public static final int DRAW_WAKE_LOCK = 128;
    public static final int SCREEN_TIMEOUT_OVERRIDE_WAKE_LOCK = 256;
    public static final int WAKE_LOCK_LEVEL_MASK = 65535;
    @Deprecated
    @RequiresPermission(value="android.permission.TURN_SCREEN_ON", conditional=true)
    public static final int ACQUIRE_CAUSES_WAKEUP = 0x10000000;
    public static final int ON_AFTER_RELEASE = 0x20000000;
    public static final int UNIMPORTANT_FOR_LOGGING = 0x40000000;
    @RequiresPermission(value="android.permission.DEVICE_POWER")
    public static final int SYSTEM_WAKELOCK = Integer.MIN_VALUE;
    public static final int RELEASE_FLAG_WAIT_FOR_NO_PROXIMITY = 1;
    public static final int RELEASE_FLAG_TIMEOUT = 65536;
    @UnsupportedAppUsage
    public static final int BRIGHTNESS_ON = 255;
    public static final int BRIGHTNESS_OFF = 0;
    public static final int BRIGHTNESS_DEFAULT = -1;
    public static final int BRIGHTNESS_INVALID = -1;
    public static final float BRIGHTNESS_MAX = 1.0f;
    public static final float BRIGHTNESS_MIN = 0.0f;
    public static final float BRIGHTNESS_OFF_FLOAT = -1.0f;
    public static final float BRIGHTNESS_INVALID_FLOAT = Float.NaN;
    @SystemApi
    public static final int USER_ACTIVITY_EVENT_OTHER = 0;
    @SystemApi
    public static final int USER_ACTIVITY_EVENT_BUTTON = 1;
    @SystemApi
    public static final int USER_ACTIVITY_EVENT_TOUCH = 2;
    @SystemApi
    public static final int USER_ACTIVITY_EVENT_ACCESSIBILITY = 3;
    public static final int USER_ACTIVITY_EVENT_ATTENTION = 4;
    public static final int USER_ACTIVITY_EVENT_FACE_DOWN = 5;
    public static final int USER_ACTIVITY_EVENT_DEVICE_STATE = 6;
    @FlaggedApi(value="android.os.low_light_dream_behavior")
    public static final int FLAG_AMBIENT_SUPPRESSION_NONE = 0;
    @FlaggedApi(value="android.os.low_light_dream_behavior")
    public static final int FLAG_AMBIENT_SUPPRESSION_DREAM = 1;
    @FlaggedApi(value="android.os.low_light_dream_behavior")
    public static final int FLAG_AMBIENT_SUPPRESSION_AOD = 2;
    @FlaggedApi(value="android.os.low_light_dream_behavior")
    public static final int FLAG_AMBIENT_SUPPRESSION_ALL = 3;
    @SystemApi
    public static final int USER_ACTIVITY_FLAG_NO_CHANGE_LIGHTS = 1;
    @SystemApi
    public static final int USER_ACTIVITY_FLAG_INDIRECT = 2;
    public static final int GO_TO_SLEEP_REASON_MIN = 0;
    public static final int GO_TO_SLEEP_REASON_APPLICATION = 0;
    public static final int GO_TO_SLEEP_REASON_DEVICE_ADMIN = 1;
    @UnsupportedAppUsage
    public static final int GO_TO_SLEEP_REASON_TIMEOUT = 2;
    public static final int GO_TO_SLEEP_REASON_LID_SWITCH = 3;
    public static final int GO_TO_SLEEP_REASON_POWER_BUTTON = 4;
    public static final int GO_TO_SLEEP_REASON_HDMI = 5;
    public static final int GO_TO_SLEEP_REASON_SLEEP_BUTTON = 6;
    public static final int GO_TO_SLEEP_REASON_ACCESSIBILITY = 7;
    public static final int GO_TO_SLEEP_REASON_FORCE_SUSPEND = 8;
    public static final int GO_TO_SLEEP_REASON_INATTENTIVE = 9;
    public static final int GO_TO_SLEEP_REASON_QUIESCENT = 10;
    public static final int GO_TO_SLEEP_REASON_DISPLAY_GROUP_REMOVED = 11;
    public static final int GO_TO_SLEEP_REASON_DISPLAY_GROUPS_TURNED_OFF = 12;
    public static final int GO_TO_SLEEP_REASON_DEVICE_FOLD = 13;
    public static final int GO_TO_SLEEP_REASON_UNKNOWN = 14;
    public static final int GO_TO_SLEEP_REASON_MAX = 14;
    public static final int GO_TO_SLEEP_FLAG_NO_DOZE = 1;
    public static final int GO_TO_SLEEP_FLAG_SOFT_SLEEP = 2;
    public static final int BRIGHTNESS_CONSTRAINT_TYPE_MINIMUM = 0;
    public static final int BRIGHTNESS_CONSTRAINT_TYPE_MAXIMUM = 1;
    public static final int BRIGHTNESS_CONSTRAINT_TYPE_DEFAULT = 2;
    public static final int BRIGHTNESS_CONSTRAINT_TYPE_DIM = 3;
    public static final int WAKE_REASON_UNKNOWN = 0;
    public static final int WAKE_REASON_POWER_BUTTON = 1;
    public static final int WAKE_REASON_APPLICATION = 2;
    public static final int WAKE_REASON_PLUGGED_IN = 3;
    public static final int WAKE_REASON_GESTURE = 4;
    public static final int WAKE_REASON_CAMERA_LAUNCH = 5;
    public static final int WAKE_REASON_WAKE_KEY = 6;
    public static final int WAKE_REASON_WAKE_MOTION = 7;
    public static final int WAKE_REASON_HDMI = 8;
    public static final int WAKE_REASON_LID = 9;
    public static final int WAKE_REASON_DISPLAY_GROUP_ADDED = 10;
    public static final int WAKE_REASON_DISPLAY_GROUP_TURNED_ON = 11;
    public static final int WAKE_REASON_UNFOLD_DEVICE = 12;
    public static final int WAKE_REASON_DREAM_FINISHED = 13;
    public static final int WAKE_REASON_TILT = 14;
    public static final int WAKE_REASON_TAP = 15;
    public static final int WAKE_REASON_LIFT = 16;
    public static final int WAKE_REASON_BIOMETRIC = 17;
    public static final int WAKE_REASON_DOCK = 18;
    public static final String REBOOT_RECOVERY = "recovery";
    public static final String REBOOT_RECOVERY_UPDATE = "recovery-update";
    public static final String REBOOT_REQUESTED_BY_DEVICE_OWNER = "deviceowner";
    public static final String REBOOT_SAFE_MODE = "safemode";
    @SystemApi
    public static final String REBOOT_USERSPACE = "userspace";
    public static final String REBOOT_QUIESCENT = "quiescent";
    public static final String SHUTDOWN_USER_REQUESTED = "userrequested";
    public static final String SHUTDOWN_BATTERY_THERMAL_STATE = "thermal,battery";
    public static final String SHUTDOWN_THERMAL_STATE = "thermal";
    public static final String SHUTDOWN_LOW_BATTERY = "battery";
    public static final int SHUTDOWN_REASON_UNKNOWN = 0;
    public static final int SHUTDOWN_REASON_SHUTDOWN = 1;
    public static final int SHUTDOWN_REASON_REBOOT = 2;
    public static final int SHUTDOWN_REASON_USER_REQUESTED = 3;
    public static final int SHUTDOWN_REASON_THERMAL_SHUTDOWN = 4;
    public static final int SHUTDOWN_REASON_LOW_BATTERY = 5;
    public static final int SHUTDOWN_REASON_BATTERY_THERMAL = 6;
    public static final int SCREEN_TIMEOUT_ACTIVE = 0;
    public static final int SCREEN_TIMEOUT_KEEP_DISPLAY_ON = 1;
    public static final int LOCATION_MODE_NO_CHANGE = 0;
    public static final int LOCATION_MODE_GPS_DISABLED_WHEN_SCREEN_OFF = 1;
    public static final int LOCATION_MODE_ALL_DISABLED_WHEN_SCREEN_OFF = 2;
    public static final int LOCATION_MODE_FOREGROUND_ONLY = 3;
    public static final int LOCATION_MODE_THROTTLE_REQUESTS_WHEN_SCREEN_OFF = 4;
    public static final int MIN_LOCATION_MODE = 0;
    public static final int MAX_LOCATION_MODE = 4;
    @SystemApi
    public static final int SOUND_TRIGGER_MODE_ALL_ENABLED = 0;
    @SystemApi
    public static final int SOUND_TRIGGER_MODE_CRITICAL_ONLY = 1;
    @SystemApi
    public static final int SOUND_TRIGGER_MODE_ALL_DISABLED = 2;
    public static final int MIN_SOUND_TRIGGER_MODE = 0;
    public static final int MAX_SOUND_TRIGGER_MODE = 2;
    private static final String CACHE_KEY_IS_POWER_SAVE_MODE_API = "is_power_save_mode";
    private static final String CACHE_KEY_IS_INTERACTIVE_API = "is_interactive";
    private static final int MAX_CACHE_ENTRIES = 1;
    private final PropertyInvalidatedCache<Void, Boolean> mPowerSaveModeCache = new PropertyInvalidatedCache<Void, Boolean>(PowerManager.getCacheArgs("is_power_save_mode"), "is_power_save_mode", null){

        @Override
        public Boolean recompute(Void query) {
            try {
                return PowerManager.this.mService.isPowerSaveMode();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    };
    private final PropertyInvalidatedCache<Integer, Boolean> mInteractiveCache = new PropertyInvalidatedCache<Integer, Boolean>(PowerManager.getCacheArgs("is_interactive"), "is_interactive", null){

        @Override
        public Boolean recompute(Integer displayId) {
            try {
                if (displayId == null) {
                    return PowerManager.this.mService.isInteractive();
                }
                return PowerManager.this.mService.isDisplayInteractive(displayId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    };
    final Context mContext;
    @UnsupportedAppUsage
    final IPowerManager mService;
    @UnsupportedAppUsage(maxTargetSdk=28)
    final Handler mHandler;
    final IThermalService mThermalService;
    private PowerExemptionManager mPowerExemptionManager;
    @GuardedBy(value={"mThermalStatusListenerMap"})
    private final ArrayMap<OnThermalStatusChangedListener, IThermalStatusListener> mThermalStatusListenerMap = new ArrayMap();
    @GuardedBy(value={"mThermalHeadroomListenerMap"})
    private final ArrayMap<OnThermalHeadroomChangedListener, IThermalHeadroomListener> mThermalHeadroomListenerMap = new ArrayMap();
    private final ArrayMap<ScreenTimeoutPolicyListener, IScreenTimeoutPolicyListener> mScreenTimeoutPolicyListeners = new ArrayMap();
    @SystemApi
    public static final int POWER_SAVE_MODE_TRIGGER_PERCENTAGE = 0;
    @SystemApi
    public static final int POWER_SAVE_MODE_TRIGGER_DYNAMIC = 1;
    public static final int THERMAL_STATUS_NONE = 0;
    public static final int THERMAL_STATUS_LIGHT = 1;
    public static final int THERMAL_STATUS_MODERATE = 2;
    public static final int THERMAL_STATUS_SEVERE = 3;
    public static final int THERMAL_STATUS_CRITICAL = 4;
    public static final int THERMAL_STATUS_EMERGENCY = 5;
    public static final int THERMAL_STATUS_SHUTDOWN = 6;
    private final AtomicLong mLastHeadroomUpdate = new AtomicLong(0L);
    private static final int MINIMUM_HEADROOM_TIME_MILLIS = 500;
    public static final String ACTION_ENHANCED_DISCHARGE_PREDICTION_CHANGED = "android.os.action.ENHANCED_DISCHARGE_PREDICTION_CHANGED";
    public static final String ACTION_POWER_SAVE_MODE_CHANGED = "android.os.action.POWER_SAVE_MODE_CHANGED";
    public static final String ACTION_POWER_SAVE_MODE_CHANGED_INTERNAL = "android.os.action.POWER_SAVE_MODE_CHANGED_INTERNAL";
    public static final String ACTION_DEVICE_IDLE_MODE_CHANGED = "android.os.action.DEVICE_IDLE_MODE_CHANGED";
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_DEVICE_LIGHT_IDLE_MODE_CHANGED = "android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED";
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, publicAlternatives="Use {@link #ACTION_DEVICE_LIGHT_IDLE_MODE_CHANGED} instead")
    public static final String ACTION_LIGHT_DEVICE_IDLE_MODE_CHANGED = "android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED";
    public static final String ACTION_POWER_SAVE_WHITELIST_CHANGED = "android.os.action.POWER_SAVE_WHITELIST_CHANGED";
    public static final String ACTION_POWER_SAVE_TEMP_WHITELIST_CHANGED = "android.os.action.POWER_SAVE_TEMP_WHITELIST_CHANGED";
    public static final String ACTION_LOW_POWER_STANDBY_ENABLED_CHANGED = "android.os.action.LOW_POWER_STANDBY_ENABLED_CHANGED";
    public static final String ACTION_LOW_POWER_STANDBY_POLICY_CHANGED = "android.os.action.LOW_POWER_STANDBY_POLICY_CHANGED";
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_LOW_POWER_STANDBY")
    public static final String ACTION_LOW_POWER_STANDBY_PORTS_CHANGED = "android.os.action.LOW_POWER_STANDBY_PORTS_CHANGED";
    public static final String FEATURE_WAKE_ON_LAN_IN_LOW_POWER_STANDBY = "com.android.lowpowerstandby.WAKE_ON_LAN";
    public static final int LOW_POWER_STANDBY_ALLOWED_REASON_VOICE_INTERACTION = 1;
    public static final int LOW_POWER_STANDBY_ALLOWED_REASON_TEMP_POWER_SAVE_ALLOWLIST = 2;
    public static final int LOW_POWER_STANDBY_ALLOWED_REASON_ONGOING_CALL = 4;

    public static String userActivityEventToString(int userActivityEvent) {
        switch (userActivityEvent) {
            case 0: {
                return "other";
            }
            case 1: {
                return "button";
            }
            case 2: {
                return "touch";
            }
            case 3: {
                return "accessibility";
            }
            case 4: {
                return "attention";
            }
            case 5: {
                return "faceDown";
            }
            case 6: {
                return "deviceState";
            }
        }
        return Integer.toString(userActivityEvent);
    }

    public static String sleepReasonToString(int sleepReason) {
        switch (sleepReason) {
            case 7: {
                return "accessibility";
            }
            case 0: {
                return "application";
            }
            case 1: {
                return "device_admin";
            }
            case 13: {
                return "device_folded";
            }
            case 11: {
                return "display_group_removed";
            }
            case 12: {
                return "display_groups_turned_off";
            }
            case 8: {
                return "force_suspend";
            }
            case 5: {
                return "hdmi";
            }
            case 9: {
                return "inattentive";
            }
            case 3: {
                return "lid_switch";
            }
            case 4: {
                return "power_button";
            }
            case 10: {
                return REBOOT_QUIESCENT;
            }
            case 6: {
                return "sleep_button";
            }
            case 2: {
                return "timeout";
            }
            case 14: {
                return "unknown";
            }
        }
        return Integer.toString(sleepReason);
    }

    public static String wakeReasonToString(int wakeReason) {
        switch (wakeReason) {
            case 0: {
                return "WAKE_REASON_UNKNOWN";
            }
            case 1: {
                return "WAKE_REASON_POWER_BUTTON";
            }
            case 2: {
                return "WAKE_REASON_APPLICATION";
            }
            case 3: {
                return "WAKE_REASON_PLUGGED_IN";
            }
            case 4: {
                return "WAKE_REASON_GESTURE";
            }
            case 5: {
                return "WAKE_REASON_CAMERA_LAUNCH";
            }
            case 6: {
                return "WAKE_REASON_WAKE_KEY";
            }
            case 7: {
                return "WAKE_REASON_WAKE_MOTION";
            }
            case 8: {
                return "WAKE_REASON_HDMI";
            }
            case 9: {
                return "WAKE_REASON_LID";
            }
            case 10: {
                return "WAKE_REASON_DISPLAY_GROUP_ADDED";
            }
            case 11: {
                return "WAKE_REASON_DISPLAY_GROUP_TURNED_ON";
            }
            case 12: {
                return "WAKE_REASON_UNFOLD_DEVICE";
            }
            case 13: {
                return "WAKE_REASON_DREAM_FINISHED";
            }
            case 14: {
                return "WAKE_REASON_TILT";
            }
            case 15: {
                return "WAKE_REASON_TAP";
            }
            case 16: {
                return "WAKE_REASON_LIFT";
            }
            case 17: {
                return "WAKE_REASON_BIOMETRIC";
            }
            case 18: {
                return "WAKE_REASON_DOCK";
            }
        }
        return Integer.toString(wakeReason);
    }

    public static String locationPowerSaveModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "NO_CHANGE";
            }
            case 1: {
                return "GPS_DISABLED_WHEN_SCREEN_OFF";
            }
            case 2: {
                return "ALL_DISABLED_WHEN_SCREEN_OFF";
            }
            case 3: {
                return "FOREGROUND_ONLY";
            }
            case 4: {
                return "THROTTLE_REQUESTS_WHEN_SCREEN_OFF";
            }
        }
        return Integer.toString(mode);
    }

    private static PropertyInvalidatedCache.Args getCacheArgs(String api) {
        return new PropertyInvalidatedCache.Args("system_server").maxEntries(1).isolateUids(false).cacheNulls(false).api(api);
    }

    public PowerManager(Context context, IPowerManager service, IThermalService thermalService, Handler handler) {
        this.mContext = context;
        this.mService = service;
        this.mThermalService = thermalService;
        this.mHandler = handler;
    }

    private PowerExemptionManager getPowerExemptionManager() {
        if (this.mPowerExemptionManager == null) {
            this.mPowerExemptionManager = this.mContext.getSystemService(PowerExemptionManager.class);
        }
        return this.mPowerExemptionManager;
    }

    @UnsupportedAppUsage
    public int getMinimumScreenBrightnessSetting() {
        return this.mContext.getResources().getInteger(17695023);
    }

    @UnsupportedAppUsage
    public int getMaximumScreenBrightnessSetting() {
        return this.mContext.getResources().getInteger(17695022);
    }

    @UnsupportedAppUsage
    public int getDefaultScreenBrightnessSetting() {
        return this.mContext.getResources().getInteger(17695021);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public float getBrightnessConstraint(int constraint) {
        return this.getBrightnessConstraint(0, constraint);
    }

    public float getBrightnessConstraint(int displayId, int constraint) {
        try {
            return this.mService.getBrightnessConstraint(displayId, constraint);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public WakeLock newWakeLock(int levelAndFlags, String tag) {
        if (Flags.displayPowerManagerApis()) {
            return this.newWakeLock(levelAndFlags, tag, this.mContext.getDisplayId());
        }
        PowerManager.validateWakeLockParameters(levelAndFlags, tag);
        return new WakeLock(levelAndFlags, tag, this.mContext.getOpPackageName(), -1);
    }

    public WakeLock newWakeLock(int levelAndFlags, String tag, int displayId) {
        PowerManager.validateWakeLockParameters(levelAndFlags, tag);
        return new WakeLock(levelAndFlags, tag, this.mContext.getOpPackageName(), displayId);
    }

    @UnsupportedAppUsage
    public static void validateWakeLockParameters(int levelAndFlags, String tag) {
        switch (levelAndFlags & 0xFFFF) {
            case 1: 
            case 6: 
            case 10: 
            case 26: 
            case 32: 
            case 64: 
            case 128: 
            case 256: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Must specify a valid wake lock level.");
            }
        }
        if (tag == null) {
            throw new IllegalArgumentException("The tag must not be null.");
        }
    }

    @Deprecated
    public void userActivity(long when, boolean noChangeLights) {
        this.userActivity(when, 0, noChangeLights ? 1 : 0);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.DEVICE_POWER", "android.permission.USER_ACTIVITY"})
    public void userActivity(long when, int event, int flags) {
        try {
            this.mService.userActivity(this.mContext.getDisplayId(), when, event, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void goToSleep(long time) {
        this.goToSleep(time, 0, 0);
    }

    @UnsupportedAppUsage
    public void goToSleep(long time, int reason, int flags) {
        try {
            this.mService.goToSleep(time, reason, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.DEVICE_POWER")
    public void goToSleep(int displayId, long time, int reason, int flags) {
        try {
            this.mService.goToSleepWithDisplayId(displayId, time, reason, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void wakeUp(long time) {
        this.wakeUp(time, 0, "wakeUp");
    }

    @Deprecated
    @UnsupportedAppUsage
    public void wakeUp(long time, String details) {
        this.wakeUp(time, 0, details);
    }

    public void wakeUp(long time, int reason, String details) {
        try {
            this.mService.wakeUp(time, reason, details, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void wakeUp(long time, int reason, String details, int displayId) {
        try {
            this.mService.wakeUpWithDisplayId(time, reason, details, this.mContext.getOpPackageName(), displayId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void nap(long time) {
        try {
            this.mService.nap(time);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.READ_DREAM_STATE", "android.permission.WRITE_DREAM_STATE"})
    public void dream(long time) {
        Sandman.startDreamByUserRequest(this.mContext);
    }

    public void boostScreenBrightness(long time) {
        try {
            this.mService.boostScreenBrightness(time);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.DEVICE_POWER")
    public void addScreenTimeoutPolicyListener(int displayId, final @NonNull Executor executor, final @NonNull ScreenTimeoutPolicyListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Preconditions.checkArgument(!this.mScreenTimeoutPolicyListeners.containsKey(listener), "Listener already registered: %s", listener);
        IScreenTimeoutPolicyListener.Stub stub = new IScreenTimeoutPolicyListener.Stub(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onScreenTimeoutPolicyChanged(int screenTimeoutPolicy) {
                long token = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener.onScreenTimeoutPolicyChanged(screenTimeoutPolicy));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        };
        try {
            this.mService.addScreenTimeoutPolicyListener(displayId, stub);
            this.mScreenTimeoutPolicyListeners.put(listener, stub);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.DEVICE_POWER")
    public void removeScreenTimeoutPolicyListener(int displayId, @NonNull ScreenTimeoutPolicyListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        IScreenTimeoutPolicyListener internalListener = this.mScreenTimeoutPolicyListeners.get(listener);
        Preconditions.checkArgument(internalListener != null, "Listener was not added");
        try {
            this.mService.removeScreenTimeoutPolicyListener(displayId, internalListener);
            this.mScreenTimeoutPolicyListeners.remove(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isWakeLockLevelSupported(int level) {
        try {
            if (Flags.displayPowerManagerApis()) {
                return this.mService.isWakeLockLevelSupportedWithDisplayId(level, this.mContext.getDisplayId());
            }
            return this.mService.isWakeLockLevelSupported(level);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean isScreenOn() {
        return this.isInteractive();
    }

    public boolean isInteractive() {
        if (Flags.displayPowerManagerApis()) {
            return this.isInteractive(this.mContext.getDisplayId());
        }
        return this.mInteractiveCache.query(null);
    }

    public boolean isInteractive(int displayId) {
        return this.mInteractiveCache.query(displayId);
    }

    public static boolean isRebootingUserspaceSupportedImpl() {
        return false;
    }

    public boolean isRebootingUserspaceSupported() {
        return PowerManager.isRebootingUserspaceSupportedImpl();
    }

    @RequiresPermission(value="android.permission.REBOOT")
    public void reboot(@Nullable String reason) {
        if (REBOOT_USERSPACE.equals(reason) && !this.isRebootingUserspaceSupported()) {
            throw new UnsupportedOperationException("Attempted userspace reboot on a device that doesn't support it");
        }
        try {
            this.mService.reboot(false, reason, true);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REBOOT")
    public void rebootSafeMode() {
        try {
            this.mService.rebootSafeMode(false, true);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean areAutoPowerSaveModesEnabled() {
        try {
            return this.mService.areAutoPowerSaveModesEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isPowerSaveMode() {
        return this.mPowerSaveModeCache.query(null);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.DEVICE_POWER", "android.permission.POWER_SAVER"})
    public boolean setPowerSaveModeEnabled(boolean mode) {
        try {
            return this.mService.setPowerSaveModeEnabled(mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.os.battery_saver_supported_check_api")
    public boolean isBatterySaverSupported() {
        try {
            return this.mService.isBatterySaverSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    public BatterySaverPolicyConfig getFullPowerSavePolicy() {
        try {
            return this.mService.getFullPowerSavePolicy();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.DEVICE_POWER", "android.permission.POWER_SAVER"})
    public boolean setFullPowerSavePolicy(@NonNull BatterySaverPolicyConfig config) {
        try {
            return this.mService.setFullPowerSavePolicy(config);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.POWER_SAVER")
    public boolean setDynamicPowerSaveHint(boolean powerSaveHint, int disableThreshold) {
        try {
            return this.mService.setDynamicPowerSaveHint(powerSaveHint, disableThreshold);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.DEVICE_POWER", "android.permission.POWER_SAVER"})
    public boolean setAdaptivePowerSavePolicy(@NonNull BatterySaverPolicyConfig config) {
        try {
            return this.mService.setAdaptivePowerSavePolicy(config);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.DEVICE_POWER", "android.permission.POWER_SAVER"})
    public boolean setAdaptivePowerSaveEnabled(boolean enabled) {
        try {
            return this.mService.setAdaptivePowerSaveEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public int getPowerSaveModeTrigger() {
        try {
            return this.mService.getPowerSaveModeTrigger();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.BATTERY_PREDICTION", "android.permission.DEVICE_POWER"})
    public void setBatteryDischargePrediction(@NonNull Duration timeRemaining, boolean isPersonalized) {
        if (timeRemaining == null) {
            throw new IllegalArgumentException("time remaining must not be null");
        }
        try {
            this.mService.setBatteryDischargePrediction(new ParcelDuration(timeRemaining), isPersonalized);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public Duration getBatteryDischargePrediction() {
        try {
            ParcelDuration parcelDuration = this.mService.getBatteryDischargePrediction();
            if (parcelDuration == null) {
                return null;
            }
            return parcelDuration.getDuration();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isBatteryDischargePredictionPersonalized() {
        try {
            return this.mService.isBatteryDischargePredictionPersonalized();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public PowerSaveState getPowerSaveState(int serviceType) {
        try {
            return this.mService.getPowerSaveState(serviceType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getLocationPowerSaveMode() {
        PowerSaveState powerSaveState = this.getPowerSaveState(1);
        if (!powerSaveState.batterySaverEnabled) {
            return 0;
        }
        return powerSaveState.locationMode;
    }

    public int getSoundTriggerPowerSaveMode() {
        PowerSaveState powerSaveState = this.getPowerSaveState(8);
        if (!powerSaveState.batterySaverEnabled) {
            return 0;
        }
        return powerSaveState.soundTriggerMode;
    }

    public boolean isDeviceIdleMode() {
        try {
            return this.mService.isDeviceIdleMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isDeviceLightIdleMode() {
        try {
            return this.mService.isLightDeviceIdleMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=31, publicAlternatives="Use {@link #isDeviceLightIdleMode()} instead.")
    public boolean isLightDeviceIdleMode() {
        return this.isDeviceLightIdleMode();
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public boolean isLowPowerStandbySupported() {
        try {
            return this.mService.isLowPowerStandbySupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isLowPowerStandbyEnabled() {
        try {
            return this.mService.isLowPowerStandbyEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public void setLowPowerStandbyEnabled(boolean enabled) {
        try {
            this.mService.setLowPowerStandbyEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public void setLowPowerStandbyActiveDuringMaintenance(boolean activeDuringMaintenance) {
        try {
            this.mService.setLowPowerStandbyActiveDuringMaintenance(activeDuringMaintenance);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public void forceLowPowerStandbyActive(boolean active) {
        try {
            this.mService.forceLowPowerStandbyActive(active);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public void setLowPowerStandbyPolicy(@Nullable LowPowerStandbyPolicy policy) {
        try {
            this.mService.setLowPowerStandbyPolicy(LowPowerStandbyPolicy.toParcelable(policy));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Nullable
    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public LowPowerStandbyPolicy getLowPowerStandbyPolicy() {
        try {
            return LowPowerStandbyPolicy.fromParcelable(this.mService.getLowPowerStandbyPolicy());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isExemptFromLowPowerStandby() {
        try {
            return this.mService.isExemptFromLowPowerStandby();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isAllowedInLowPowerStandby(int reason) {
        try {
            return this.mService.isReasonAllowedInLowPowerStandby(reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isAllowedInLowPowerStandby(@NonNull String feature) {
        try {
            return this.mService.isFeatureAllowedInLowPowerStandby(feature);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SET_LOW_POWER_STANDBY_PORTS")
    @NonNull
    public LowPowerStandbyPortsLock newLowPowerStandbyPortsLock(@NonNull List<LowPowerStandbyPortDescription> ports) {
        LowPowerStandbyPortsLock standbyPorts = new LowPowerStandbyPortsLock(ports);
        return standbyPorts;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    @NonNull
    public List<LowPowerStandbyPortDescription> getActiveLowPowerStandbyPorts() {
        try {
            return LowPowerStandbyPortDescription.fromParcelable(this.mService.getActiveLowPowerStandbyPorts());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isIgnoringBatteryOptimizations(String packageName) {
        return this.getPowerExemptionManager().isAllowListed(packageName, true);
    }

    public void shutdown(boolean confirm, String reason, boolean wait) {
        try {
            this.mService.shutdown(confirm, reason, wait);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isSustainedPerformanceModeSupported() {
        return this.mContext.getResources().getBoolean(17891970);
    }

    public int getCurrentThermalStatus() {
        try {
            return this.mThermalService.getCurrentThermalStatus();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void addThermalStatusListener(@NonNull OnThermalStatusChangedListener listener) {
        Objects.requireNonNull(listener, "Thermal status listener cannot be null");
        this.addThermalStatusListener(this.mContext.getMainExecutor(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThermalStatusListener(final @NonNull Executor executor, final @NonNull OnThermalStatusChangedListener listener) {
        Objects.requireNonNull(listener, "Thermal status listener cannot be null");
        Objects.requireNonNull(executor, "Executor cannot be null");
        ArrayMap<OnThermalStatusChangedListener, IThermalStatusListener> arrayMap = this.mThermalStatusListenerMap;
        synchronized (arrayMap) {
            Preconditions.checkArgument(!this.mThermalStatusListenerMap.containsKey(listener), "Thermal status listener already registered: %s", listener);
            IThermalStatusListener.Stub internalListener = new IThermalStatusListener.Stub(this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onStatusChange(int status) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> listener.onThermalStatusChanged(status));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            };
            try {
                if (!this.mThermalService.registerThermalStatusListener(internalListener)) {
                    throw new RuntimeException("Thermal status listener failed to set");
                }
                this.mThermalStatusListenerMap.put(listener, internalListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThermalStatusListener(@NonNull OnThermalStatusChangedListener listener) {
        Objects.requireNonNull(listener, "Thermal status listener cannot be null");
        ArrayMap<OnThermalStatusChangedListener, IThermalStatusListener> arrayMap = this.mThermalStatusListenerMap;
        synchronized (arrayMap) {
            IThermalStatusListener internalListener = this.mThermalStatusListenerMap.get(listener);
            Preconditions.checkArgument(internalListener != null, "Thermal status listener was not added");
            try {
                if (!this.mThermalService.unregisterThermalStatusListener(internalListener)) {
                    throw new RuntimeException("Failed to unregister thermal status listener");
                }
                this.mThermalStatusListenerMap.remove(listener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @FlaggedApi(value="android.os.allow_thermal_thresholds_callback")
    public void addThermalHeadroomListener(@NonNull OnThermalHeadroomChangedListener listener) {
        Objects.requireNonNull(listener, "Thermal headroom listener cannot be null");
        this.addThermalHeadroomListener(this.mContext.getMainExecutor(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.os.allow_thermal_thresholds_callback")
    public void addThermalHeadroomListener(final @NonNull Executor executor, final @NonNull OnThermalHeadroomChangedListener listener) {
        Objects.requireNonNull(listener, "Thermal headroom listener cannot be null");
        Objects.requireNonNull(executor, "Executor cannot be null");
        ArrayMap<OnThermalHeadroomChangedListener, IThermalHeadroomListener> arrayMap = this.mThermalHeadroomListenerMap;
        synchronized (arrayMap) {
            Preconditions.checkArgument(!this.mThermalHeadroomListenerMap.containsKey(listener), "Thermal headroom listener already registered: %s", listener);
            IThermalHeadroomListener.Stub internalListener = new IThermalHeadroomListener.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onHeadroomChange(float headroom, float forecastHeadroom, int forecastSeconds, float[] thresholds) throws RemoteException {
                    Map<Integer, Float> map = PowerManager.this.convertThresholdsToMap(thresholds);
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> listener.onThermalHeadroomChanged(headroom, forecastHeadroom, forecastSeconds, map));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            };
            try {
                if (!this.mThermalService.registerThermalHeadroomListener(internalListener)) {
                    throw new RuntimeException("Thermal headroom listener failed to set");
                }
                this.mThermalHeadroomListenerMap.put(listener, internalListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.os.allow_thermal_thresholds_callback")
    public void removeThermalHeadroomListener(@NonNull OnThermalHeadroomChangedListener listener) {
        Objects.requireNonNull(listener, "Thermal headroom listener cannot be null");
        ArrayMap<OnThermalHeadroomChangedListener, IThermalHeadroomListener> arrayMap = this.mThermalHeadroomListenerMap;
        synchronized (arrayMap) {
            IThermalHeadroomListener internalListener = this.mThermalHeadroomListenerMap.get(listener);
            Preconditions.checkArgument(internalListener != null, "Thermal headroom listener was not added");
            try {
                if (!this.mThermalService.unregisterThermalHeadroomListener(internalListener)) {
                    throw new RuntimeException("Failed to unregister thermal status listener");
                }
                this.mThermalHeadroomListenerMap.remove(listener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public float getThermalHeadroom(int forecastSeconds) {
        long now = SystemClock.elapsedRealtime();
        long timeSinceLastUpdate = now - this.mLastHeadroomUpdate.get();
        if (timeSinceLastUpdate < 500L) {
            return Float.NaN;
        }
        try {
            float forecast = this.mThermalService.getThermalHeadroom(forecastSeconds);
            this.mLastHeadroomUpdate.set(SystemClock.elapsedRealtime());
            return forecast;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.os.allow_thermal_headroom_thresholds")
    @NonNull
    public Map<Integer, Float> getThermalHeadroomThresholds() {
        try {
            return this.convertThresholdsToMap(this.mThermalService.getThermalHeadroomThresholds());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private Map<Integer, Float> convertThresholdsToMap(float[] thresholds) {
        ArrayMap<Integer, Float> ret = new ArrayMap<Integer, Float>(6);
        for (int status = 1; status <= 6; ++status) {
            if (Float.isNaN(thresholds[status])) continue;
            ret.put(status, Float.valueOf(thresholds[status]));
        }
        return ret;
    }

    public void setDozeAfterScreenOff(boolean dozeAfterScreenOf) {
        try {
            this.mService.setDozeAfterScreenOff(dozeAfterScreenOf);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DREAM_STATE")
    public boolean isAmbientDisplayAvailable() {
        try {
            return this.mService.isAmbientDisplayAvailable();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void suppressAmbientDisplay(@NonNull String token, boolean suppress) {
        try {
            this.mService.suppressAmbientDisplay(token, suppress);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.os.low_light_dream_behavior")
    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void suppressAmbientDisplay(@NonNull String token, int suppressionFlags) {
        try {
            this.mService.suppressAmbientDisplayBehavior(token, suppressionFlags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DREAM_STATE")
    public boolean isAmbientDisplaySuppressedForToken(@NonNull String token) {
        try {
            return this.mService.isAmbientDisplaySuppressedForToken(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DREAM_STATE")
    public boolean isAmbientDisplaySuppressed() {
        try {
            return this.mService.isAmbientDisplaySuppressed();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.READ_DREAM_STATE", "android.permission.READ_DREAM_SUPPRESSION"})
    public boolean isAmbientDisplaySuppressedForTokenByApp(@NonNull String token, int appUid) {
        try {
            return this.mService.isAmbientDisplaySuppressedForTokenByApp(token, appUid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getLastShutdownReason() {
        try {
            return this.mService.getLastShutdownReason();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getLastSleepReason() {
        try {
            return this.mService.getLastSleepReason();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.DEVICE_POWER")
    public boolean forceSuspend() {
        try {
            return this.mService.forceSuspend();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static String lowPowerStandbyAllowedReasonsToString(int allowedReasons) {
        ArrayList<String> allowedStrings = new ArrayList<String>();
        if ((allowedReasons & 1) != 0) {
            allowedStrings.add("ALLOWED_REASON_VOICE_INTERACTION");
            allowedReasons &= 0xFFFFFFFE;
        }
        if ((allowedReasons & 2) != 0) {
            allowedStrings.add("ALLOWED_REASON_TEMP_POWER_SAVE_ALLOWLIST");
            allowedReasons &= 0xFFFFFFFD;
        }
        if ((allowedReasons & 4) != 0) {
            allowedStrings.add("ALLOWED_REASON_ONGOING_CALL");
            allowedReasons &= 0xFFFFFFFB;
        }
        if (allowedReasons != 0) {
            allowedStrings.add(String.valueOf(allowedReasons));
        }
        return String.join((CharSequence)",", allowedStrings);
    }

    public static void invalidatePowerSaveModeCaches() {
        PropertyInvalidatedCache.invalidateCache("system_server", CACHE_KEY_IS_POWER_SAVE_MODE_API);
    }

    public static void invalidateIsInteractiveCaches() {
        PropertyInvalidatedCache.invalidateCache("system_server", CACHE_KEY_IS_INTERACTIVE_API);
    }

    public class WakeLock {
        @UnsupportedAppUsage
        private int mFlags;
        @UnsupportedAppUsage
        private String mTag;
        private int mTagHash;
        private final String mPackageName;
        private final IBinder mToken;
        private int mInternalCount;
        private int mExternalCount;
        private boolean mRefCounted = true;
        private boolean mHeld;
        private WorkSource mWorkSource;
        private String mHistoryTag;
        private final int mDisplayId;
        private WakeLockStateListener mListener;
        private IWakeLockCallback mCallback;
        private final Runnable mReleaser = () -> this.release(65536);

        WakeLock(int flags, String tag, String packageName, int displayId) {
            this.mFlags = flags;
            this.mTag = tag;
            this.mTagHash = this.mTag.hashCode();
            this.mPackageName = packageName;
            this.mToken = new Binder();
            this.mDisplayId = displayId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (this.mHeld) {
                    Log.wtf(PowerManager.TAG, "WakeLock finalized while still held: " + this.mTag);
                    Trace.asyncTraceForTrackEnd(131072L, "WakeLocks", this.mTagHash);
                    try {
                        PowerManager.this.mService.releaseWakeLock(this.mToken, 0);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setReferenceCounted(boolean value) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                this.mRefCounted = value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                this.acquireLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire(long timeout) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                this.acquireLocked();
                PowerManager.this.mHandler.postDelayed(this.mReleaser, timeout);
            }
        }

        private void acquireLocked() {
            ++this.mInternalCount;
            ++this.mExternalCount;
            if (!this.mRefCounted || this.mInternalCount == 1) {
                PowerManager.this.mHandler.removeCallbacks(this.mReleaser);
                Trace.asyncTraceForTrackBegin(131072L, "WakeLocks", this.mTag, this.mTagHash);
                try {
                    PowerManager.this.mService.acquireWakeLock(this.mToken, this.mFlags, this.mTag, this.mPackageName, this.mWorkSource, this.mHistoryTag, this.mDisplayId, this.mCallback);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                this.mHeld = true;
            }
        }

        public void release() {
            this.release(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(int flags) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (this.mInternalCount > 0) {
                    --this.mInternalCount;
                }
                if ((flags & 0x10000) == 0) {
                    --this.mExternalCount;
                }
                if (!this.mRefCounted || this.mInternalCount == 0) {
                    PowerManager.this.mHandler.removeCallbacks(this.mReleaser);
                    if (this.mHeld) {
                        Trace.asyncTraceForTrackEnd(131072L, "WakeLocks", this.mTagHash);
                        try {
                            PowerManager.this.mService.releaseWakeLock(this.mToken, flags);
                        }
                        catch (RemoteException e) {
                            throw e.rethrowFromSystemServer();
                        }
                        this.mHeld = false;
                    }
                }
                if (this.mRefCounted && this.mExternalCount < 0) {
                    throw new RuntimeException("WakeLock under-locked " + this.mTag);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isHeld() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setWorkSource(WorkSource ws) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                boolean changed;
                if (ws != null && ws.isEmpty()) {
                    ws = null;
                }
                if (ws == null) {
                    changed = this.mWorkSource != null;
                    this.mWorkSource = null;
                } else if (this.mWorkSource == null) {
                    changed = true;
                    this.mWorkSource = new WorkSource(ws);
                } else {
                    boolean bl = changed = !this.mWorkSource.equals(ws);
                    if (changed) {
                        this.mWorkSource.set(ws);
                    }
                }
                if (changed && this.mHeld) {
                    try {
                        PowerManager.this.mService.updateWakeLockWorkSource(this.mToken, this.mWorkSource, this.mHistoryTag);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
        }

        public void setTag(String tag) {
            this.mTag = tag;
            this.mTagHash = this.mTag.hashCode();
        }

        public String getTag() {
            return this.mTag;
        }

        public void setHistoryTag(String tag) {
            this.mHistoryTag = tag;
        }

        public void setUnimportantForLogging(boolean state) {
            this.mFlags = state ? (this.mFlags |= 0x40000000) : (this.mFlags &= 0xBFFFFFFF);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateUids(int[] uids) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                try {
                    PowerManager.this.mService.updateWakeLockUids(this.mToken, uids);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                return "WakeLock{" + Integer.toHexString(System.identityHashCode(this)) + " held=" + this.mHeld + ", refCount=" + this.mInternalCount + "}";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dumpDebug(ProtoOutputStream proto, long fieldId) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                long token = proto.start(fieldId);
                proto.write(0x10900000001L, this.mTag);
                proto.write(1138166333442L, this.mPackageName);
                proto.write(1133871366147L, this.mHeld);
                proto.write(1120986464260L, this.mInternalCount);
                if (this.mWorkSource != null) {
                    this.mWorkSource.dumpDebug(proto, 1146756268037L);
                }
                proto.end(token);
            }
        }

        @SuppressLint(value={"WakelockTimeout"})
        public Runnable wrap(Runnable r) {
            this.acquire();
            return () -> {
                try {
                    r.run();
                }
                finally {
                    this.release();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStateListener(final @NonNull Executor executor, final @Nullable WakeLockStateListener listener) {
            Preconditions.checkNotNull(executor, "executor cannot be null");
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (listener != this.mListener) {
                    this.mListener = listener;
                    this.mCallback = listener != null ? new IWakeLockCallback.Stub(this){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onStateChanged(boolean enabled) {
                            long token = Binder.clearCallingIdentity();
                            try {
                                executor.execute(() -> listener.onStateChanged(enabled));
                            }
                            finally {
                                Binder.restoreCallingIdentity(token);
                            }
                        }
                    } : null;
                    if (this.mHeld) {
                        try {
                            PowerManager.this.mService.updateWakeLockCallback(this.mToken, this.mCallback);
                        }
                        catch (RemoteException e) {
                            throw e.rethrowFromSystemServer();
                        }
                    }
                }
            }
        }
    }

    public static interface ScreenTimeoutPolicyListener {
        public void onScreenTimeoutPolicyChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ServiceType {
        public static final int NULL = 0;
        public static final int LOCATION = 1;
        public static final int VIBRATION = 2;
        public static final int ANIMATION = 3;
        public static final int FULL_BACKUP = 4;
        public static final int KEYVALUE_BACKUP = 5;
        public static final int NETWORK_FIREWALL = 6;
        public static final int SCREEN_BRIGHTNESS = 7;
        public static final int SOUND = 8;
        public static final int BATTERY_STATS = 9;
        public static final int DATA_SAVER = 10;
        public static final int AOD = 14;
        public static final int FORCE_ALL_APPS_STANDBY = 11;
        public static final int FORCE_BACKGROUND_CHECK = 12;
        public static final int OPTIONAL_SENSORS = 13;
        public static final int QUICK_DOZE = 15;
        public static final int NIGHT_MODE = 16;
    }

    @SystemApi
    public static class LowPowerStandbyPolicy {
        @NonNull
        private final String mIdentifier;
        @NonNull
        private final Set<String> mExemptPackages;
        private final int mAllowedReasons;
        @NonNull
        private final Set<String> mAllowedFeatures;

        public LowPowerStandbyPolicy(@NonNull String identifier, @NonNull Set<String> exemptPackages, int allowedReasons, @NonNull Set<String> allowedFeatures) {
            Objects.requireNonNull(identifier);
            Objects.requireNonNull(exemptPackages);
            Objects.requireNonNull(allowedFeatures);
            this.mIdentifier = identifier;
            this.mExemptPackages = Collections.unmodifiableSet(exemptPackages);
            this.mAllowedReasons = allowedReasons;
            this.mAllowedFeatures = Collections.unmodifiableSet(allowedFeatures);
        }

        @NonNull
        public String getIdentifier() {
            return this.mIdentifier;
        }

        @NonNull
        public Set<String> getExemptPackages() {
            return this.mExemptPackages;
        }

        public int getAllowedReasons() {
            return this.mAllowedReasons;
        }

        @NonNull
        public Set<String> getAllowedFeatures() {
            return this.mAllowedFeatures;
        }

        public String toString() {
            return "Policy{mIdentifier='" + this.mIdentifier + '\'' + ", mExemptPackages=" + String.join((CharSequence)",", this.mExemptPackages) + ", mAllowedReasons=" + PowerManager.lowPowerStandbyAllowedReasonsToString(this.mAllowedReasons) + ", mAllowedFeatures=" + String.join((CharSequence)",", this.mAllowedFeatures) + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LowPowerStandbyPolicy)) {
                return false;
            }
            LowPowerStandbyPolicy that = (LowPowerStandbyPolicy)o;
            return this.mAllowedReasons == that.mAllowedReasons && Objects.equals(this.mIdentifier, that.mIdentifier) && Objects.equals(this.mExemptPackages, that.mExemptPackages) && Objects.equals(this.mAllowedFeatures, that.mAllowedFeatures);
        }

        public int hashCode() {
            return Objects.hash(this.mIdentifier, this.mExemptPackages, this.mAllowedReasons, this.mAllowedFeatures);
        }

        public static IPowerManager.LowPowerStandbyPolicy toParcelable(LowPowerStandbyPolicy policy) {
            if (policy == null) {
                return null;
            }
            IPowerManager.LowPowerStandbyPolicy parcelablePolicy = new IPowerManager.LowPowerStandbyPolicy();
            parcelablePolicy.identifier = policy.mIdentifier;
            parcelablePolicy.exemptPackages = new ArrayList<String>(policy.mExemptPackages);
            parcelablePolicy.allowedReasons = policy.mAllowedReasons;
            parcelablePolicy.allowedFeatures = new ArrayList<String>(policy.mAllowedFeatures);
            return parcelablePolicy;
        }

        public static LowPowerStandbyPolicy fromParcelable(IPowerManager.LowPowerStandbyPolicy parcelablePolicy) {
            if (parcelablePolicy == null) {
                return null;
            }
            return new LowPowerStandbyPolicy(parcelablePolicy.identifier, new ArraySet<String>(parcelablePolicy.exemptPackages), parcelablePolicy.allowedReasons, new ArraySet<String>(parcelablePolicy.allowedFeatures));
        }
    }

    @SystemApi
    @SuppressLint(value={"NotCloseable"})
    public class LowPowerStandbyPortsLock {
        private final IBinder mToken;
        private final List<LowPowerStandbyPortDescription> mPorts;
        private boolean mHeld;

        LowPowerStandbyPortsLock(List<LowPowerStandbyPortDescription> ports) {
            this.mPorts = ports;
            this.mToken = new Binder();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresPermission(value="android.permission.SET_LOW_POWER_STANDBY_PORTS")
        public void acquire() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                try {
                    PowerManager.this.mService.acquireLowPowerStandbyPorts(this.mToken, LowPowerStandbyPortDescription.toParcelable(this.mPorts));
                    this.mHeld = true;
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresPermission(value="android.permission.SET_LOW_POWER_STANDBY_PORTS")
        public void release() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                try {
                    PowerManager.this.mService.releaseLowPowerStandbyPorts(this.mToken);
                    this.mHeld = false;
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (this.mHeld) {
                    Log.wtf(PowerManager.TAG, "LowPowerStandbyPorts finalized while still held");
                    this.release();
                }
            }
        }
    }

    @SystemApi
    public static class LowPowerStandbyPortDescription {
        public static final int PROTOCOL_TCP = 6;
        public static final int PROTOCOL_UDP = 17;
        public static final int MATCH_PORT_LOCAL = 1;
        public static final int MATCH_PORT_REMOTE = 2;
        private final int mProtocol;
        private final int mPortMatcher;
        private final int mPortNumber;
        @Nullable
        private final InetAddress mLocalAddress;

        public LowPowerStandbyPortDescription(int protocol, int portMatcher, int portNumber) {
            this.mProtocol = protocol;
            this.mPortMatcher = portMatcher;
            this.mPortNumber = portNumber;
            this.mLocalAddress = null;
        }

        public LowPowerStandbyPortDescription(int protocol, int portMatcher, int portNumber, @Nullable InetAddress localAddress) {
            this.mProtocol = protocol;
            this.mPortMatcher = portMatcher;
            this.mPortNumber = portNumber;
            this.mLocalAddress = localAddress;
        }

        private String protocolToString(int protocol) {
            switch (protocol) {
                case 6: {
                    return "TCP";
                }
                case 17: {
                    return "UDP";
                }
            }
            return String.valueOf(protocol);
        }

        private String portMatcherToString(int portMatcher) {
            switch (portMatcher) {
                case 1: {
                    return "MATCH_PORT_LOCAL";
                }
                case 2: {
                    return "MATCH_PORT_REMOTE";
                }
            }
            return String.valueOf(portMatcher);
        }

        public int getProtocol() {
            return this.mProtocol;
        }

        public int getPortMatcher() {
            return this.mPortMatcher;
        }

        public int getPortNumber() {
            return this.mPortNumber;
        }

        @Nullable
        public InetAddress getLocalAddress() {
            return this.mLocalAddress;
        }

        public String toString() {
            return "PortDescription{mProtocol=" + this.protocolToString(this.mProtocol) + ", mPortMatcher=" + this.portMatcherToString(this.mPortMatcher) + ", mPortNumber=" + this.mPortNumber + ", mLocalAddress=" + this.mLocalAddress + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LowPowerStandbyPortDescription)) {
                return false;
            }
            LowPowerStandbyPortDescription that = (LowPowerStandbyPortDescription)o;
            return this.mProtocol == that.mProtocol && this.mPortMatcher == that.mPortMatcher && this.mPortNumber == that.mPortNumber && Objects.equals(this.mLocalAddress, that.mLocalAddress);
        }

        public int hashCode() {
            return Objects.hash(this.mProtocol, this.mPortMatcher, this.mPortNumber, this.mLocalAddress);
        }

        public static IPowerManager.LowPowerStandbyPortDescription toParcelable(LowPowerStandbyPortDescription portDescription) {
            if (portDescription == null) {
                return null;
            }
            IPowerManager.LowPowerStandbyPortDescription parcelablePortDescription = new IPowerManager.LowPowerStandbyPortDescription();
            parcelablePortDescription.protocol = portDescription.mProtocol;
            parcelablePortDescription.portMatcher = portDescription.mPortMatcher;
            parcelablePortDescription.portNumber = portDescription.mPortNumber;
            if (portDescription.mLocalAddress != null) {
                parcelablePortDescription.localAddress = portDescription.mLocalAddress.getAddress();
            }
            return parcelablePortDescription;
        }

        public static List<IPowerManager.LowPowerStandbyPortDescription> toParcelable(List<LowPowerStandbyPortDescription> portDescriptions) {
            if (portDescriptions == null) {
                return null;
            }
            ArrayList<IPowerManager.LowPowerStandbyPortDescription> result = new ArrayList<IPowerManager.LowPowerStandbyPortDescription>();
            for (LowPowerStandbyPortDescription port : portDescriptions) {
                result.add(LowPowerStandbyPortDescription.toParcelable(port));
            }
            return result;
        }

        public static LowPowerStandbyPortDescription fromParcelable(IPowerManager.LowPowerStandbyPortDescription parcelablePortDescription) {
            if (parcelablePortDescription == null) {
                return null;
            }
            InetAddress localAddress = null;
            if (parcelablePortDescription.localAddress != null) {
                try {
                    localAddress = InetAddress.getByAddress(parcelablePortDescription.localAddress);
                }
                catch (UnknownHostException e) {
                    Log.w(PowerManager.TAG, "Address has invalid length", e);
                }
            }
            return new LowPowerStandbyPortDescription(parcelablePortDescription.protocol, parcelablePortDescription.portMatcher, parcelablePortDescription.portNumber, localAddress);
        }

        public static List<LowPowerStandbyPortDescription> fromParcelable(List<IPowerManager.LowPowerStandbyPortDescription> portDescriptions) {
            if (portDescriptions == null) {
                return null;
            }
            ArrayList<LowPowerStandbyPortDescription> result = new ArrayList<LowPowerStandbyPortDescription>();
            for (IPowerManager.LowPowerStandbyPortDescription port : portDescriptions) {
                result.add(LowPowerStandbyPortDescription.fromParcelable(port));
            }
            return result;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface PortMatcher {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Protocol {
        }
    }

    public static interface OnThermalStatusChangedListener {
        public void onThermalStatusChanged(int var1);
    }

    @FlaggedApi(value="android.os.allow_thermal_thresholds_callback")
    public static interface OnThermalHeadroomChangedListener {
        public void onThermalHeadroomChanged(float var1, float var2, int var3, @NonNull Map<Integer, Float> var4);
    }

    public static interface WakeLockStateListener {
        public void onStateChanged(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LowPowerStandbyAllowedReason {
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ThermalStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AutoPowerSaveModeTriggers {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SoundTriggerPowerSaveMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LocationPowerSaveMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScreenTimeoutPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShutdownReason {
    }

    public static class SleepData {
        public final long goToSleepUptimeMillis;
        public final int goToSleepReason;

        public SleepData(long goToSleepUptimeMillis, int goToSleepReason) {
            this.goToSleepUptimeMillis = goToSleepUptimeMillis;
            this.goToSleepReason = goToSleepReason;
        }

        public boolean equals(@Nullable Object o) {
            if (o instanceof SleepData) {
                SleepData other = (SleepData)o;
                return this.goToSleepUptimeMillis == other.goToSleepUptimeMillis && this.goToSleepReason == other.goToSleepReason;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.goToSleepUptimeMillis, this.goToSleepReason);
        }
    }

    public static class WakeData {
        public final long wakeTime;
        public final int wakeReason;
        public final long sleepDurationRealtime;

        public WakeData(long wakeTime, int wakeReason, long sleepDurationRealtime) {
            this.wakeTime = wakeTime;
            this.wakeReason = wakeReason;
            this.sleepDurationRealtime = sleepDurationRealtime;
        }

        public boolean equals(@Nullable Object o) {
            if (o instanceof WakeData) {
                WakeData other = (WakeData)o;
                return this.wakeTime == other.wakeTime && this.wakeReason == other.wakeReason && this.sleepDurationRealtime == other.sleepDurationRealtime;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.wakeTime, this.wakeReason, this.sleepDurationRealtime);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GoToSleepReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WakeReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BrightnessConstraint {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @FlaggedApi(value="android.os.low_light_dream_behavior")
    public static @interface FlagAmbientSuppression {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserActivityEvent {
    }
}

