/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.PowerManager;
import android.os.PowerSaveState;
import android.view.KeyEvent;
import java.util.function.Consumer;

public abstract class PowerManagerInternal {
    public static final int WAKEFULNESS_ASLEEP = 0;
    public static final int WAKEFULNESS_AWAKE = 1;
    public static final int WAKEFULNESS_DREAMING = 2;
    public static final int WAKEFULNESS_DOZING = 3;
    public static final int BOOST_INTERACTION = 0;
    public static final int BOOST_DISPLAY_UPDATE_IMMINENT = 1;
    public static final int MODE_DOUBLE_TAP_TO_WAKE = 0;
    public static final int MODE_LOW_POWER = 1;
    public static final int MODE_SUSTAINED_PERFORMANCE = 2;
    public static final int MODE_FIXED_PERFORMANCE = 3;
    public static final int MODE_VR = 4;
    public static final int MODE_LAUNCH = 5;
    public static final int MODE_EXPENSIVE_RENDERING = 6;
    public static final int MODE_INTERACTIVE = 7;
    public static final int MODE_DEVICE_IDLE = 8;
    public static final int MODE_DISPLAY_INACTIVE = 9;
    public static final int MODE_DISPLAY_CHANGE = 17;

    public static String wakefulnessToString(int wakefulness) {
        switch (wakefulness) {
            case 0: {
                return "Asleep";
            }
            case 1: {
                return "Awake";
            }
            case 2: {
                return "Dreaming";
            }
            case 3: {
                return "Dozing";
            }
        }
        return Integer.toString(wakefulness);
    }

    public static int wakefulnessToProtoEnum(int wakefulness) {
        switch (wakefulness) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return wakefulness;
    }

    public static boolean isInteractive(int wakefulness) {
        return wakefulness == 1 || wakefulness == 2;
    }

    public abstract void setUserActivityTimeoutOverrideFromWindowManager(long var1);

    public abstract void setUserInactiveOverrideFromWindowManager();

    public abstract void setMaximumScreenOffTimeoutFromDeviceAdmin(int var1, long var2);

    public abstract void setDozeOverrideFromDreamManager(int var1, int var2, float var3, int var4, boolean var5);

    public abstract void setDrawWakeLockOverrideFromSidekick(boolean var1);

    public abstract PowerSaveState getLowPowerState(int var1);

    public abstract void registerLowPowerModeObserver(LowPowerModeListener var1);

    public void registerLowPowerModeObserver(final int serviceType, final Consumer<PowerSaveState> listener) {
        this.registerLowPowerModeObserver(new LowPowerModeListener(){

            @Override
            public int getServiceType() {
                return serviceType;
            }

            @Override
            public void onLowPowerModeChanged(PowerSaveState state) {
                listener.accept(state);
            }
        });
    }

    public abstract boolean setDeviceIdleMode(boolean var1);

    public abstract boolean setLightDeviceIdleMode(boolean var1);

    public abstract void setDeviceIdleWhitelist(int[] var1);

    public abstract void setDeviceIdleTempWhitelist(int[] var1);

    public abstract void setLowPowerStandbyAllowlist(int[] var1);

    public abstract void setLowPowerStandbyActive(boolean var1);

    public abstract void startUidChanges();

    public abstract void finishUidChanges();

    public abstract void updateUidProcState(int var1, int var2);

    public abstract void uidGone(int var1);

    public abstract void uidActive(int var1);

    public abstract void uidIdle(int var1);

    public abstract void setForceDisableWakelocks(boolean var1);

    public abstract void setPowerBoost(int var1, int var2);

    public abstract void setPowerMode(int var1, boolean var2);

    public abstract boolean wasDeviceIdleFor(long var1);

    public abstract PowerManager.WakeData getLastWakeup();

    public abstract PowerManager.SleepData getLastGoToSleep();

    public abstract boolean interceptPowerKeyDown(KeyEvent var1);

    public abstract void nap(long var1, boolean var3);

    public abstract boolean isAmbientDisplaySuppressed();

    public abstract void setDevicePostured(boolean var1);

    public abstract void updateSettings();

    public static interface LowPowerModeListener {
        public int getServiceType();

        public void onLowPowerModeChanged(PowerSaveState var1);
    }
}

