/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.os.ProxyFileDescriptorCallback;
import android.os.storage.StorageManager;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Slog;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InterruptedIOException;
import libcore.io.IoUtils;

public class RevocableFileDescriptor {
    private static final String TAG = "RevocableFileDescriptor";
    private static final boolean DEBUG = true;
    private FileDescriptor mInner;
    private ParcelFileDescriptor mOuter;
    private volatile boolean mRevoked;
    private ParcelFileDescriptor.OnCloseListener mOnCloseListener;
    private final ProxyFileDescriptorCallback mCallback = new ProxyFileDescriptorCallback(){

        private void checkRevoked() throws ErrnoException {
            if (RevocableFileDescriptor.this.mRevoked) {
                throw new ErrnoException(RevocableFileDescriptor.TAG, OsConstants.EPERM);
            }
        }

        @Override
        public long onGetSize() throws ErrnoException {
            this.checkRevoked();
            return Os.fstat((FileDescriptor)RevocableFileDescriptor.this.mInner).st_size;
        }

        @Override
        public int onRead(long offset, int size, byte[] data) throws ErrnoException {
            int n;
            InterruptedIOException e2;
            this.checkRevoked();
            for (n = 0; n < size; n += e2.bytesTransferred) {
                try {
                    n += Os.pread(RevocableFileDescriptor.this.mInner, data, n, size - n, offset + (long)n);
                    break;
                }
                catch (InterruptedIOException e2) {
                    continue;
                }
            }
            return n;
        }

        @Override
        public int onWrite(long offset, int size, byte[] data) throws ErrnoException {
            int n;
            InterruptedIOException e2;
            this.checkRevoked();
            for (n = 0; n < size; n += e2.bytesTransferred) {
                try {
                    n += Os.pwrite(RevocableFileDescriptor.this.mInner, data, n, size - n, offset + (long)n);
                    break;
                }
                catch (InterruptedIOException e2) {
                    continue;
                }
            }
            return n;
        }

        @Override
        public void onFsync() throws ErrnoException {
            Slog.v(RevocableFileDescriptor.TAG, "onFsync()");
            this.checkRevoked();
            Os.fsync(RevocableFileDescriptor.this.mInner);
        }

        @Override
        public void onRelease() {
            Slog.v(RevocableFileDescriptor.TAG, "onRelease()");
            RevocableFileDescriptor.this.mRevoked = true;
            IoUtils.closeQuietly(RevocableFileDescriptor.this.mInner);
            if (RevocableFileDescriptor.this.mOnCloseListener != null) {
                RevocableFileDescriptor.this.mOnCloseListener.onClose(null);
            }
        }
    };

    public RevocableFileDescriptor() {
    }

    public RevocableFileDescriptor(Context context, File file) throws IOException {
        try {
            this.init(context, Os.open(file.getAbsolutePath(), OsConstants.O_CREAT | OsConstants.O_RDWR, 448));
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    public RevocableFileDescriptor(Context context, FileDescriptor fd) throws IOException {
        this.init(context, fd);
    }

    public RevocableFileDescriptor(Context context, FileDescriptor fd, Handler handler) throws IOException {
        this.init(context, fd, handler);
    }

    public void init(Context context, FileDescriptor fd) throws IOException {
        this.init(context, fd, null);
    }

    public void init(Context context, FileDescriptor fd, Handler handler) throws IOException {
        this.mInner = fd;
        StorageManager sm = context.getSystemService(StorageManager.class);
        this.mOuter = handler != null ? sm.openProxyFileDescriptor(0x30000000, this.mCallback, handler) : sm.openProxyFileDescriptor(0x30000000, this.mCallback);
    }

    public ParcelFileDescriptor getRevocableFileDescriptor() {
        return this.mOuter;
    }

    public void revoke() {
        this.mRevoked = true;
        IoUtils.closeQuietly(this.mInner);
    }

    public void addOnCloseListener(ParcelFileDescriptor.OnCloseListener onCloseListener) {
        this.mOnCloseListener = onCloseListener;
    }

    public boolean isRevoked() {
        return this.mRevoked;
    }
}

