/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.ConnectionInfo;
import android.os.IBinder;
import android.os.IClientCallback;
import android.os.IServiceCallback;
import android.os.IServiceManager;
import android.os.RemoteException;
import android.os.Service;
import android.os.ServiceDebugInfo;
import com.android.tools.layoutlib.create.OverrideMethod;

class ServiceManagerProxy
implements IServiceManager {
    @UnsupportedAppUsage
    private IBinder mRemote;
    private IServiceManager mServiceManager;

    public ServiceManagerProxy(IBinder remote) {
        this.mRemote = remote;
        this.mServiceManager = IServiceManager.Stub.asInterface(Binder.allowBlocking(this.getNativeServiceManager()));
    }

    @Override
    public IBinder asBinder() {
        return this.mRemote;
    }

    @Override
    @UnsupportedAppUsage
    public IBinder getService(String name) throws RemoteException {
        return this.checkService2((String)name).getServiceWithMetadata().service;
    }

    @Override
    public Service getService2(String name) throws RemoteException {
        return this.checkService2(name);
    }

    @Override
    @UnsupportedAppUsage
    public IBinder checkService(String name) throws RemoteException {
        return this.checkService2((String)name).getServiceWithMetadata().service;
    }

    @Override
    public Service checkService2(String name) throws RemoteException {
        return this.mServiceManager.checkService2(name);
    }

    @Override
    public void addService(String name, IBinder service, boolean allowIsolated, int dumpPriority) throws RemoteException {
        this.mServiceManager.addService(name, service, allowIsolated, dumpPriority);
    }

    @Override
    public String[] listServices(int dumpPriority) throws RemoteException {
        return this.mServiceManager.listServices(dumpPriority);
    }

    @Override
    public void registerForNotifications(String name, IServiceCallback cb) throws RemoteException {
        this.mServiceManager.registerForNotifications(name, cb);
    }

    @Override
    public void unregisterForNotifications(String name, IServiceCallback cb) throws RemoteException {
        throw new RemoteException();
    }

    @Override
    public boolean isDeclared(String name) throws RemoteException {
        return this.mServiceManager.isDeclared(name);
    }

    @Override
    public String[] getDeclaredInstances(String iface) throws RemoteException {
        return this.mServiceManager.getDeclaredInstances(iface);
    }

    @Override
    public String updatableViaApex(String name) throws RemoteException {
        return this.mServiceManager.updatableViaApex(name);
    }

    @Override
    public String[] getUpdatableNames(String apexName) throws RemoteException {
        return this.mServiceManager.getUpdatableNames(apexName);
    }

    @Override
    public ConnectionInfo getConnectionInfo(String name) throws RemoteException {
        return this.mServiceManager.getConnectionInfo(name);
    }

    @Override
    public void registerClientCallback(String name, IBinder service, IClientCallback cb) throws RemoteException {
        throw new RemoteException();
    }

    @Override
    public void tryUnregisterService(String name, IBinder service) throws RemoteException {
        throw new RemoteException();
    }

    @Override
    public ServiceDebugInfo[] getServiceDebugInfo() throws RemoteException {
        return this.mServiceManager.getServiceDebugInfo();
    }

    @Override
    public boolean checkServiceAccess(IServiceManager.CallerContext callerCtx, String service, String access) throws RemoteException {
        return this.mServiceManager.checkServiceAccess(callerCtx, service, access);
    }

    private IBinder getNativeServiceManager() {
        return (IBinder)OverrideMethod.invokeA("android.os.ServiceManagerProxy#getNativeServiceManager()Landroid/os/IBinder;", true, this);
    }
}

