/*
 * Decompiled with CFR 0.152.
 */
package android.os.flagging;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.flagging.AconfigStorageWriteException;
import android.os.flagging.AconfigdProtoStreamer;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

@SystemApi
@FlaggedApi(value="android.provider.flags.new_storage_public_api")
public class FlagManager {
    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public static final String FLAG_SERVICE_NAME = "flag";

    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public FlagManager(@NonNull Context unusedContext) {
    }

    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public void setBooleanOverridesOnSystemBuildFingerprint(@NonNull String buildFingerprint, @NonNull Map<String, Boolean> flags) {
        try {
            new AconfigdProtoStreamer().sendOtaFlagOverrideRequests(flags, buildFingerprint);
        }
        catch (IOException e) {
            throw new AconfigStorageWriteException("failed to set boolean overrides on system build fingerprint", e);
        }
    }

    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public void setBooleanOverridesOnReboot(@NonNull Map<String, Boolean> flags) {
        try {
            new AconfigdProtoStreamer().sendFlagOverrideRequests(flags, 3L);
        }
        catch (IOException e) {
            throw new AconfigStorageWriteException("failed to set boolean overrides on reboot", e);
        }
    }

    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public void setBooleanLocalOverridesOnReboot(@NonNull Map<String, Boolean> flags) {
        try {
            new AconfigdProtoStreamer().sendFlagOverrideRequests(flags, 2L);
        }
        catch (IOException e) {
            throw new AconfigStorageWriteException("failed to set boolean overrides on reboot", e);
        }
    }

    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public void setBooleanLocalOverridesImmediately(@NonNull Map<String, Boolean> flags) {
        try {
            new AconfigdProtoStreamer().sendFlagOverrideRequests(flags, 1L);
        }
        catch (IOException e) {
            throw new AconfigStorageWriteException("failed to set boolean overrides on reboot", e);
        }
    }

    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public void clearBooleanLocalOverridesOnReboot(@Nullable Set<String> flags) {
        try {
            new AconfigdProtoStreamer().sendClearFlagOverrideRequests(flags, 2L);
        }
        catch (IOException e) {
            throw new AconfigStorageWriteException("failed to set boolean overrides on reboot", e);
        }
    }

    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public void clearBooleanLocalOverridesImmediately(@Nullable Set<String> flags) {
        try {
            new AconfigdProtoStreamer().sendClearFlagOverrideRequests(flags, 1L);
        }
        catch (IOException e) {
            throw new AconfigStorageWriteException("failed to set boolean overrides on reboot", e);
        }
    }
}

