/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibrationEffect;
import android.os.VibratorInfo;
import android.os.vibrator.VibrationEffectSegment;
import java.util.Objects;

public class PrebakedSegment
extends VibrationEffectSegment {
    public static final int DEFAULT_STRENGTH = 1;
    public static final boolean DEFAULT_SHOULD_FALLBACK = true;
    private final int mEffectId;
    private final boolean mFallback;
    private final int mEffectStrength;
    @NonNull
    public static final Parcelable.Creator<PrebakedSegment> CREATOR = new Parcelable.Creator<PrebakedSegment>(){

        @Override
        public PrebakedSegment createFromParcel(Parcel in) {
            in.readInt();
            return new PrebakedSegment(in);
        }

        public PrebakedSegment[] newArray(int size) {
            return new PrebakedSegment[size];
        }
    };

    PrebakedSegment(@NonNull Parcel in) {
        this.mEffectId = in.readInt();
        this.mFallback = in.readByte() != 0;
        this.mEffectStrength = in.readInt();
    }

    public PrebakedSegment(int effectId, boolean shouldFallback, int effectStrength) {
        this.mEffectId = effectId;
        this.mFallback = shouldFallback;
        this.mEffectStrength = effectStrength;
    }

    public int getEffectId() {
        return this.mEffectId;
    }

    public int getEffectStrength() {
        return this.mEffectStrength;
    }

    public boolean shouldFallback() {
        return this.mFallback;
    }

    @Override
    public long getDuration() {
        return -1L;
    }

    @Override
    public long getDuration(@Nullable VibratorInfo vibratorInfo) {
        long l;
        if (vibratorInfo == null) {
            return this.getDuration();
        }
        switch (this.mEffectId) {
            case 0: 
            case 2: 
            case 5: {
                l = this.estimateFromPrimitiveDuration(vibratorInfo, 1);
                break;
            }
            case 21: {
                l = this.estimateFromPrimitiveDuration(vibratorInfo, 7);
                break;
            }
            case 3: {
                l = this.estimateFromPrimitiveDuration(vibratorInfo, 2);
                break;
            }
            case 1: {
                long clickDuration = vibratorInfo.getPrimitiveDuration(1);
                if (clickDuration > 0L) {
                    l = 2L * clickDuration;
                    break;
                }
                l = this.getDuration();
                break;
            }
            default: {
                l = this.getDuration();
            }
        }
        return l;
    }

    private long estimateFromPrimitiveDuration(VibratorInfo vibratorInfo, int primitiveId) {
        int duration = vibratorInfo.getPrimitiveDuration(primitiveId);
        return duration > 0 ? (long)duration : this.getDuration();
    }

    @Override
    public boolean areVibrationFeaturesSupported(@NonNull VibratorInfo vibratorInfo) {
        boolean bl;
        if (vibratorInfo.isEffectSupported(this.mEffectId) == 1) {
            return true;
        }
        if (!this.mFallback) {
            return false;
        }
        switch (this.mEffectId) {
            case 0: 
            case 1: 
            case 2: 
            case 5: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean isHapticFeedbackCandidate() {
        boolean bl;
        switch (this.mEffectId) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 21: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @NonNull
    public PrebakedSegment resolve(int defaultAmplitude) {
        return this;
    }

    @NonNull
    public PrebakedSegment scale(float scaleFactor) {
        return this;
    }

    @NonNull
    public PrebakedSegment scaleLinearly(float scaleFactor) {
        return this;
    }

    @NonNull
    public PrebakedSegment applyEffectStrength(int effectStrength) {
        if (effectStrength != this.mEffectStrength && PrebakedSegment.isValidEffectStrength(effectStrength)) {
            return new PrebakedSegment(this.mEffectId, this.mFallback, effectStrength);
        }
        return this;
    }

    private static boolean isValidEffectStrength(int strength) {
        boolean bl;
        switch (strength) {
            case 0: 
            case 1: 
            case 2: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void validate() {
        switch (this.mEffectId) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 21: {
                break;
            }
            default: {
                int[] ringtones = VibrationEffect.RINGTONES;
                if (this.mEffectId >= ringtones[0] && this.mEffectId <= ringtones[ringtones.length - 1]) break;
                throw new IllegalArgumentException("Unknown prebaked effect type (value=" + this.mEffectId + ")");
            }
        }
        if (!PrebakedSegment.isValidEffectStrength(this.mEffectStrength)) {
            throw new IllegalArgumentException("Unknown prebaked effect strength (value=" + this.mEffectStrength + ")");
        }
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof PrebakedSegment)) {
            return false;
        }
        PrebakedSegment other = (PrebakedSegment)o;
        return this.mEffectId == other.mEffectId && this.mFallback == other.mFallback && this.mEffectStrength == other.mEffectStrength;
    }

    public int hashCode() {
        return Objects.hash(this.mEffectId, this.mFallback, this.mEffectStrength);
    }

    public String toString() {
        return "Prebaked{effect=" + VibrationEffect.effectIdToString(this.mEffectId) + ", strength=" + VibrationEffect.effectStrengthToString(this.mEffectStrength) + ", fallback=" + this.mFallback + "}";
    }

    @Override
    public String toDebugString() {
        return String.format("Prebaked=%s(%s, %s fallback)", VibrationEffect.effectIdToString(this.mEffectId), VibrationEffect.effectStrengthToString(this.mEffectStrength), this.mFallback ? "with" : "no");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(1);
        out.writeInt(this.mEffectId);
        out.writeByte((byte)(this.mFallback ? 1 : 0));
        out.writeInt(this.mEffectStrength);
    }
}

