/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.os.CombinedVibration;
import android.os.RemoteException;
import android.os.VibrationEffect;
import android.os.vibrator.IVibrationSession;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.os.vibrator.vendor_vibration_effects")
public class VendorVibrationSession
implements AutoCloseable {
    private static final String TAG = "VendorVibrationSession";
    public static final int STATUS_SUCCESS = 1;
    public static final int STATUS_IGNORED = 2;
    public static final int STATUS_UNSUPPORTED = 3;
    public static final int STATUS_CANCELED = 4;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_UNKNOWN_ERROR = 5;
    private final IVibrationSession mSession;

    public VendorVibrationSession(@NonNull IVibrationSession session) {
        Objects.requireNonNull(session);
        this.mSession = session;
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(@NonNull VibrationEffect effect, @Nullable String reason) {
        try {
            this.mSession.vibrate(CombinedVibration.createParallel(effect), reason);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to vibrate in a vendor vibration session.", e);
            e.rethrowFromSystemServer();
        }
    }

    public void cancel() {
        try {
            this.mSession.cancelSession();
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to cancel vendor vibration session.", e);
            e.rethrowFromSystemServer();
        }
    }

    @Override
    public void close() {
        try {
            this.mSession.finishSession();
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to finish vendor vibration session.", e);
            e.rethrowFromSystemServer();
        }
    }

    public static interface Callback {
        public void onStarted(@NonNull VendorVibrationSession var1);

        public void onFinishing();

        public void onFinished(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }
}

