/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.annotation.Nullable;
import android.content.res.Resources;
import android.os.VibrationAttributes;
import android.util.IndentingPrintWriter;
import java.util.Arrays;

public class VibrationConfig {
    private static final float DEFAULT_SCALE_LEVEL_GAIN = 1.4f;
    private static final int DEFAULT_AMPLITUDE = 255;
    private final float mHapticChannelMaxVibrationAmplitude;
    private final int mDefaultVibrationAmplitude;
    private final int mRampStepDurationMs;
    private final int mRampDownDurationMs;
    private final int mRequestVibrationParamsTimeoutMs;
    private final int[] mRequestVibrationParamsForUsages;
    private final boolean mIgnoreVibrationsOnWirelessCharger;
    private final int mDefaultAlarmVibrationIntensity;
    private final int mDefaultHapticFeedbackIntensity;
    private final int mDefaultMediaVibrationIntensity;
    private final int mDefaultNotificationVibrationIntensity;
    private final int mDefaultRingVibrationIntensity;
    private final int mDefaultKeyboardVibrationIntensity;
    private final boolean mKeyboardVibrationSettingsSupported;
    private final int mVibrationPipelineMaxDurationMs;

    public VibrationConfig(@Nullable Resources resources) {
        this.mDefaultVibrationAmplitude = resources.getInteger(17694834);
        this.mHapticChannelMaxVibrationAmplitude = VibrationConfig.loadFloat(resources, 17105130);
        this.mRampDownDurationMs = VibrationConfig.loadInteger(resources, 17695068, 0);
        this.mRampStepDurationMs = VibrationConfig.loadInteger(resources, 17695069, 0);
        this.mRequestVibrationParamsTimeoutMs = VibrationConfig.loadInteger(resources, 17695002, 0);
        this.mRequestVibrationParamsForUsages = VibrationConfig.loadIntArray(resources, 17236150);
        this.mIgnoreVibrationsOnWirelessCharger = VibrationConfig.loadBoolean(resources, 17891787);
        this.mKeyboardVibrationSettingsSupported = VibrationConfig.loadBoolean(resources, 17891803);
        this.mVibrationPipelineMaxDurationMs = VibrationConfig.loadInteger(resources, 17695067, 0);
        this.mDefaultAlarmVibrationIntensity = VibrationConfig.loadDefaultIntensity(resources, 17694807);
        this.mDefaultHapticFeedbackIntensity = VibrationConfig.loadDefaultIntensity(resources, 17694812);
        this.mDefaultMediaVibrationIntensity = VibrationConfig.loadDefaultIntensity(resources, 17694815);
        this.mDefaultNotificationVibrationIntensity = VibrationConfig.loadDefaultIntensity(resources, 17694823);
        this.mDefaultRingVibrationIntensity = VibrationConfig.loadDefaultIntensity(resources, 17694831);
        this.mDefaultKeyboardVibrationIntensity = VibrationConfig.loadDefaultIntensity(resources, 17694813);
    }

    private static int loadDefaultIntensity(@Nullable Resources res, int resId) {
        int defaultIntensity = 2;
        int value = VibrationConfig.loadInteger(res, resId, defaultIntensity);
        if (value < 0 || value > 3) {
            return defaultIntensity;
        }
        return value;
    }

    private static float loadFloat(@Nullable Resources res, int resId) {
        return res != null ? res.getFloat(resId) : 0.0f;
    }

    private static int loadInteger(@Nullable Resources res, int resId, int defaultValue) {
        return res != null ? res.getInteger(resId) : defaultValue;
    }

    private static boolean loadBoolean(@Nullable Resources res, int resId) {
        return res != null && res.getBoolean(resId);
    }

    private static int[] loadIntArray(@Nullable Resources res, int resId) {
        return res != null ? res.getIntArray(resId) : new int[]{};
    }

    public float getHapticChannelMaximumAmplitude() {
        if (this.mHapticChannelMaxVibrationAmplitude <= 0.0f) {
            return Float.NaN;
        }
        return this.mHapticChannelMaxVibrationAmplitude;
    }

    public int getDefaultVibrationAmplitude() {
        if (this.mDefaultVibrationAmplitude < 1 || this.mDefaultVibrationAmplitude > 255) {
            return 255;
        }
        return this.mDefaultVibrationAmplitude;
    }

    public float getDefaultVibrationScaleLevelGain() {
        return 1.4f;
    }

    public int getRampDownDurationMs() {
        if (this.mRampDownDurationMs < 0) {
            return 0;
        }
        return this.mRampDownDurationMs;
    }

    public int getRequestVibrationParamsTimeoutMs() {
        return Math.max(this.mRequestVibrationParamsTimeoutMs, 0);
    }

    public int[] getRequestVibrationParamsForUsages() {
        return this.mRequestVibrationParamsForUsages;
    }

    public int getRampStepDurationMs() {
        if (this.mRampStepDurationMs < 0) {
            return 0;
        }
        return this.mRampStepDurationMs;
    }

    public int getVibrationPipelineMaxDurationMs() {
        if (this.mVibrationPipelineMaxDurationMs < 0) {
            return 0;
        }
        return this.mVibrationPipelineMaxDurationMs;
    }

    public boolean ignoreVibrationsOnWirelessCharger() {
        return this.mIgnoreVibrationsOnWirelessCharger;
    }

    public boolean isKeyboardVibrationSettingsSupported() {
        return this.mKeyboardVibrationSettingsSupported;
    }

    public int getDefaultVibrationIntensity(int usage) {
        switch (usage) {
            case 17: {
                return this.mDefaultAlarmVibrationIntensity;
            }
            case 49: 
            case 65: {
                return this.mDefaultNotificationVibrationIntensity;
            }
            case 33: {
                return this.mDefaultRingVibrationIntensity;
            }
            case 18: 
            case 34: 
            case 50: 
            case 66: 
            case 98: {
                return this.mDefaultHapticFeedbackIntensity;
            }
            case 82: {
                return this.isKeyboardVibrationSettingsSupported() ? this.mDefaultKeyboardVibrationIntensity : this.mDefaultHapticFeedbackIntensity;
            }
        }
        return this.mDefaultMediaVibrationIntensity;
    }

    public String toString() {
        return "VibrationConfig{mIgnoreVibrationsOnWirelessCharger=" + this.mIgnoreVibrationsOnWirelessCharger + ", mDefaultVibrationAmplitude=" + this.mDefaultVibrationAmplitude + ", mHapticChannelMaxVibrationAmplitude=" + this.mHapticChannelMaxVibrationAmplitude + ", mRampStepDurationMs=" + this.mRampStepDurationMs + ", mRampDownDurationMs=" + this.mRampDownDurationMs + ", mRequestVibrationParamsForUsages=" + Arrays.toString(this.getRequestVibrationParamsForUsagesNames()) + ", mRequestVibrationParamsTimeoutMs=" + this.mRequestVibrationParamsTimeoutMs + ", mDefaultAlarmIntensity=" + this.mDefaultAlarmVibrationIntensity + ", mDefaultHapticFeedbackIntensity=" + this.mDefaultHapticFeedbackIntensity + ", mDefaultMediaIntensity=" + this.mDefaultMediaVibrationIntensity + ", mDefaultNotificationIntensity=" + this.mDefaultNotificationVibrationIntensity + ", mDefaultRingIntensity=" + this.mDefaultRingVibrationIntensity + ", mDefaultKeyboardIntensity=" + this.mDefaultKeyboardVibrationIntensity + ", mKeyboardVibrationSettingsSupported=" + this.mKeyboardVibrationSettingsSupported + "}";
    }

    public void dumpWithoutDefaultSettings(IndentingPrintWriter pw) {
        pw.println("VibrationConfig:");
        pw.increaseIndent();
        pw.println("ignoreVibrationsOnWirelessCharger = " + this.mIgnoreVibrationsOnWirelessCharger);
        pw.println("defaultVibrationAmplitude = " + this.mDefaultVibrationAmplitude);
        pw.println("hapticChannelMaxAmplitude = " + this.mHapticChannelMaxVibrationAmplitude);
        pw.println("rampStepDurationMs = " + this.mRampStepDurationMs);
        pw.println("rampDownDurationMs = " + this.mRampDownDurationMs);
        pw.println("requestVibrationParamsForUsages = " + Arrays.toString(this.getRequestVibrationParamsForUsagesNames()));
        pw.println("requestVibrationParamsTimeoutMs = " + this.mRequestVibrationParamsTimeoutMs);
        pw.decreaseIndent();
    }

    private String[] getRequestVibrationParamsForUsagesNames() {
        int usagesCount = this.mRequestVibrationParamsForUsages.length;
        String[] names = new String[usagesCount];
        for (int i = 0; i < usagesCount; ++i) {
            names[i] = VibrationAttributes.usageToString(this.mRequestVibrationParamsForUsages[i]);
        }
        return names;
    }
}

