/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.os.UserHandle;
import android.os._Original_Build;
import android.permission.AdminPermissionControlParams;
import android.permission.IPermissionController;
import android.permission.RuntimePermissionPresentationInfo;
import android.permission.RuntimePermissionUsageInfo;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.infra.AndroidFuture;
import com.android.internal.infra.RemoteStream;
import com.android.internal.infra.ServiceConnector;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.FunctionalUtils;
import com.android.internal.util.Preconditions;
import java.io.FileDescriptor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import libcore.util.EmptyArray;

@SystemApi
public class PermissionControllerManager {
    private static final String TAG = PermissionControllerManager.class.getSimpleName();
    private static final long REQUEST_TIMEOUT_MILLIS = 60000L * (long)_Original_Build.HW_TIMEOUT_MULTIPLIER;
    private static final long UNBIND_TIMEOUT_MILLIS = 10000L * (long)_Original_Build.HW_TIMEOUT_MULTIPLIER;
    private static final int CHUNK_SIZE = 4096;
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static ArrayMap<Pair<Integer, Thread>, ServiceConnector<IPermissionController>> sRemoteServices = new ArrayMap(1);
    public static final int REASON_MALWARE = 1;
    public static final int REASON_INSTALLER_POLICY_VIOLATION = 2;
    public static final int COUNT_ONLY_WHEN_GRANTED = 1;
    public static final int COUNT_WHEN_SYSTEM = 2;
    @SystemApi
    public static final int HIBERNATION_ELIGIBILITY_UNKNOWN = -1;
    @SystemApi
    public static final int HIBERNATION_ELIGIBILITY_ELIGIBLE = 0;
    @SystemApi
    public static final int HIBERNATION_ELIGIBILITY_EXEMPT_BY_SYSTEM = 1;
    @SystemApi
    public static final int HIBERNATION_ELIGIBILITY_EXEMPT_BY_USER = 2;
    @NonNull
    private final Context mContext;
    @NonNull
    private final ServiceConnector<IPermissionController> mRemoteService;
    @NonNull
    private final Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionControllerManager(@NonNull Context context, final @NonNull Handler handler) {
        Object object = sLock;
        synchronized (object) {
            Pair<Integer, Thread> key = new Pair<Integer, Thread>(context.getUserId(), handler.getLooper().getThread());
            ServiceConnector.Impl<IPermissionController> remoteService = sRemoteServices.get(key);
            if (remoteService == null) {
                Intent intent = new Intent("android.permission.PermissionControllerService");
                String pkgName = context.getPackageManager().getPermissionControllerPackageName();
                intent.setPackage(pkgName);
                ResolveInfo serviceInfo = context.getPackageManager().resolveService(intent, 0);
                if (serviceInfo == null) {
                    String errorMsg = "No PermissionController package (" + pkgName + ") for user " + context.getUserId();
                    Log.wtf(TAG, errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                remoteService = new ServiceConnector.Impl<IPermissionController>((Context)ActivityThread.currentApplication(), new Intent("android.permission.PermissionControllerService").setComponent(serviceInfo.getComponentInfo().getComponentName()), 0, context.getUserId(), IPermissionController.Stub::asInterface){

                    @Override
                    protected Handler getJobHandler() {
                        return handler;
                    }

                    @Override
                    protected long getRequestTimeoutMs() {
                        return REQUEST_TIMEOUT_MILLIS;
                    }

                    @Override
                    protected long getAutoDisconnectTimeoutMs() {
                        return UNBIND_TIMEOUT_MILLIS;
                    }
                };
                sRemoteServices.put(key, (ServiceConnector<IPermissionController>)remoteService);
            }
            this.mRemoteService = remoteService;
        }
        this.mContext = context;
        this.mHandler = handler;
    }

    private void enforceSomePermissionsGrantedToSelf(String ... requiredPermissions) {
        for (String requiredPermission : requiredPermissions) {
            if (this.mContext.checkSelfPermission(requiredPermission) != 0) continue;
            return;
        }
        throw new SecurityException("At lest one of the following permissions is required: " + Arrays.toString(requiredPermissions));
    }

    @RequiresPermission(value="android.permission.REVOKE_RUNTIME_PERMISSIONS")
    public void revokeRuntimePermissions(@NonNull Map<String, List<String>> request, boolean doDryRun, int reason, @NonNull Executor executor, @NonNull OnRevokeRuntimePermissionsCallback callback) {
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull(request);
        for (Map.Entry<String, List<String>> appRequest : request.entrySet()) {
            Preconditions.checkNotNull(appRequest.getKey());
            Preconditions.checkCollectionElementsNotNull(appRequest.getValue(), "permissions");
        }
        this.enforceSomePermissionsGrantedToSelf("android.permission.REVOKE_RUNTIME_PERMISSIONS");
        this.mRemoteService.postAsync(service -> {
            Bundle bundledizedRequest = new Bundle();
            for (Map.Entry appRequest : request.entrySet()) {
                bundledizedRequest.putStringArrayList((String)appRequest.getKey(), new ArrayList<String>((Collection)appRequest.getValue()));
            }
            AndroidFuture revokeRuntimePermissionsResult = new AndroidFuture();
            service.revokeRuntimePermissions(bundledizedRequest, doDryRun, reason, this.mContext.getPackageName(), revokeRuntimePermissionsResult);
            return revokeRuntimePermissionsResult;
        }).whenCompleteAsync((revoked, err) -> {
            long token = Binder.clearCallingIdentity();
            try {
                if (err != null) {
                    Log.e(TAG, "Failure when revoking runtime permissions " + revoked, err);
                    callback.onRevokeRuntimePermissions(Collections.emptyMap());
                } else {
                    callback.onRevokeRuntimePermissions((Map<String, List<String>>)revoked);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }, executor);
    }

    @RequiresPermission(allOf={"android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.REVOKE_RUNTIME_PERMISSIONS", "android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY"}, conditional=true)
    public void setRuntimePermissionGrantStateByDeviceAdmin(@NonNull String callerPackageName, @NonNull AdminPermissionControlParams params, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        Preconditions.checkStringNotEmpty(callerPackageName);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Objects.requireNonNull(params, "Admin control params must not be null.");
        this.mRemoteService.postAsync(service -> {
            AndroidFuture setRuntimePermissionGrantStateResult = new AndroidFuture();
            service.setRuntimePermissionGrantStateByDeviceAdminFromParams(callerPackageName, params, setRuntimePermissionGrantStateResult);
            return setRuntimePermissionGrantStateResult;
        }).whenCompleteAsync((setRuntimePermissionGrantStateResult, err) -> {
            long token = Binder.clearCallingIdentity();
            try {
                if (err != null) {
                    Log.e(TAG, "Error setting permissions state for device admin " + callerPackageName, err);
                    callback.accept(false);
                } else {
                    callback.accept(((Object)Boolean.TRUE).equals(setRuntimePermissionGrantStateResult));
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }, executor);
    }

    @RequiresPermission(value="android.permission.GET_RUNTIME_PERMISSIONS")
    public void getRuntimePermissionBackup(@NonNull UserHandle user, @NonNull Executor executor, @NonNull Consumer<byte[]> callback) {
        Preconditions.checkNotNull(user);
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(callback);
        this.enforceSomePermissionsGrantedToSelf("android.permission.GET_RUNTIME_PERMISSIONS");
        this.mRemoteService.postAsync(service -> RemoteStream.receiveBytes(remotePipe -> service.getRuntimePermissionBackup(user, (ParcelFileDescriptor)remotePipe))).whenCompleteAsync((bytes, err) -> {
            if (err != null) {
                Log.e(TAG, "Error getting permission backup", err);
                callback.accept(EmptyArray.BYTE);
            } else {
                callback.accept((byte[])bytes);
            }
        }, executor);
    }

    @RequiresPermission(anyOf={"android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.RESTORE_RUNTIME_PERMISSIONS"})
    public void stageAndApplyRuntimePermissionsBackup(@NonNull byte[] backup, @NonNull UserHandle user) {
        Preconditions.checkNotNull(backup);
        Preconditions.checkNotNull(user);
        this.enforceSomePermissionsGrantedToSelf("android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.RESTORE_RUNTIME_PERMISSIONS");
        this.mRemoteService.postAsync(service -> RemoteStream.sendBytes(remotePipe -> service.stageAndApplyRuntimePermissionsBackup(user, (ParcelFileDescriptor)remotePipe), backup)).whenComplete((nullResult, err) -> {
            if (err != null) {
                Log.e(TAG, "Error sending permission backup", err);
            }
        });
    }

    @RequiresPermission(anyOf={"android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.RESTORE_RUNTIME_PERMISSIONS"})
    public void applyStagedRuntimePermissionBackup(@NonNull String packageName, @NonNull UserHandle user, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        Preconditions.checkNotNull(packageName);
        Preconditions.checkNotNull(user);
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(callback);
        this.enforceSomePermissionsGrantedToSelf("android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.RESTORE_RUNTIME_PERMISSIONS");
        this.mRemoteService.postAsync(service -> {
            AndroidFuture applyStagedRuntimePermissionBackupResult = new AndroidFuture();
            service.applyStagedRuntimePermissionBackup(packageName, user, applyStagedRuntimePermissionBackupResult);
            return applyStagedRuntimePermissionBackupResult;
        }).whenCompleteAsync((applyStagedRuntimePermissionBackupResult, err) -> {
            long token = Binder.clearCallingIdentity();
            try {
                if (err != null) {
                    Log.e(TAG, "Error restoring delayed permissions for " + packageName, err);
                    callback.accept(true);
                } else {
                    callback.accept(((Object)Boolean.TRUE).equals(applyStagedRuntimePermissionBackupResult));
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }, executor);
    }

    public void dump(@NonNull FileDescriptor fd, @Nullable String[] args) {
        try {
            this.mRemoteService.postAsync(service -> AndroidFuture.runAsync(FunctionalUtils.uncheckExceptions(() -> service.asBinder().dump(fd, args)), BackgroundThread.getExecutor())).get(REQUEST_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Log.e(TAG, "Could not get dump", e);
        }
    }

    @RequiresPermission(value="android.permission.GET_RUNTIME_PERMISSIONS")
    public void getAppPermissions(@NonNull String packageName, @NonNull OnGetAppPermissionResultCallback callback, @Nullable Handler handler) {
        Preconditions.checkNotNull(packageName);
        Preconditions.checkNotNull(callback);
        Handler finalHandler = handler != null ? handler : this.mHandler;
        this.mRemoteService.postAsync(service -> {
            AndroidFuture getAppPermissionsResult = new AndroidFuture();
            service.getAppPermissions(packageName, getAppPermissionsResult);
            return getAppPermissionsResult;
        }).whenComplete((getAppPermissionsResult, err) -> finalHandler.post(() -> {
            if (err != null) {
                Log.e(TAG, "Error getting app permission", err);
                callback.onGetAppPermissions(Collections.emptyList());
            } else {
                callback.onGetAppPermissions(CollectionUtils.emptyIfNull(getAppPermissionsResult));
            }
        }));
    }

    @RequiresPermission(value="android.permission.REVOKE_RUNTIME_PERMISSIONS")
    public void revokeRuntimePermission(@NonNull String packageName, @NonNull String permissionName) {
        Preconditions.checkNotNull(packageName);
        Preconditions.checkNotNull(permissionName);
        this.mRemoteService.run(service -> service.revokeRuntimePermission(packageName, permissionName));
    }

    @RequiresPermission(value="android.permission.GET_RUNTIME_PERMISSIONS")
    public void countPermissionApps(@NonNull List<String> permissionNames, int flags, @NonNull OnCountPermissionAppsResultCallback callback, @Nullable Handler handler) {
        Preconditions.checkCollectionElementsNotNull(permissionNames, "permissionNames");
        Preconditions.checkFlagsArgument(flags, 3);
        Preconditions.checkNotNull(callback);
        Handler finalHandler = handler != null ? handler : this.mHandler;
        this.mRemoteService.postAsync(service -> {
            AndroidFuture countPermissionAppsResult = new AndroidFuture();
            service.countPermissionApps(permissionNames, flags, countPermissionAppsResult);
            return countPermissionAppsResult;
        }).whenComplete((countPermissionAppsResult, err) -> finalHandler.post(() -> {
            if (err != null) {
                Log.e(TAG, "Error counting permission apps", err);
                callback.onCountPermissionApps(0);
            } else {
                callback.onCountPermissionApps((int)countPermissionAppsResult);
            }
        }));
    }

    @RequiresPermission(value="android.permission.GET_RUNTIME_PERMISSIONS")
    public void getPermissionUsages(boolean countSystem, long numMillis, @NonNull Executor executor, @NonNull OnPermissionUsageResultCallback callback) {
        Preconditions.checkArgumentNonnegative(numMillis);
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(callback);
        this.mRemoteService.postAsync(service -> {
            AndroidFuture getPermissionUsagesResult = new AndroidFuture();
            service.getPermissionUsages(countSystem, numMillis, getPermissionUsagesResult);
            return getPermissionUsagesResult;
        }).whenCompleteAsync((getPermissionUsagesResult, err) -> {
            if (err != null) {
                Log.e(TAG, "Error getting permission usages", err);
                callback.onPermissionUsageResult(Collections.emptyList());
            } else {
                long token = Binder.clearCallingIdentity();
                try {
                    callback.onPermissionUsageResult(CollectionUtils.emptyIfNull(getPermissionUsagesResult));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }, executor);
    }

    @RequiresPermission(value="android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY")
    public void grantOrUpgradeDefaultRuntimePermissions(@NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        this.mRemoteService.postAsync(service -> {
            AndroidFuture grantOrUpgradeDefaultRuntimePermissionsResult = new AndroidFuture();
            service.grantOrUpgradeDefaultRuntimePermissions(grantOrUpgradeDefaultRuntimePermissionsResult);
            return grantOrUpgradeDefaultRuntimePermissionsResult;
        }).whenCompleteAsync((grantOrUpgradeDefaultRuntimePermissionsResult, err) -> {
            if (err != null) {
                Log.e(TAG, "Error granting or upgrading runtime permissions", err);
                callback.accept(false);
            } else {
                callback.accept(((Object)Boolean.TRUE).equals(grantOrUpgradeDefaultRuntimePermissionsResult));
            }
        }, executor);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public void getPrivilegesDescriptionStringForProfile(@NonNull String profileName, @NonNull Executor executor, @NonNull Consumer<CharSequence> callback) {
        this.mRemoteService.postAsync(service -> {
            AndroidFuture<String> future = new AndroidFuture<String>();
            service.getPrivilegesDescriptionStringForProfile(profileName, future);
            return future;
        }).whenCompleteAsync((description, err) -> {
            if (err != null) {
                Log.e(TAG, "Error from getPrivilegesDescriptionStringForProfile", err);
                callback.accept(null);
            } else {
                callback.accept((CharSequence)description);
            }
        }, executor);
    }

    public void updateUserSensitive() {
        this.updateUserSensitiveForApp(-1);
    }

    public void updateUserSensitiveForApp(int uid) {
        this.mRemoteService.postAsync(service -> {
            AndroidFuture future = new AndroidFuture();
            service.updateUserSensitiveForApp(uid, future);
            return future;
        }).whenComplete((res, err) -> {
            if (err != null) {
                Log.e(TAG, "Error updating user_sensitive flags for uid " + uid, err);
            }
        });
    }

    @RequiresPermission(value="android.permission.REVOKE_RUNTIME_PERMISSIONS")
    public void notifyOneTimePermissionSessionTimeout(@NonNull String packageName, int deviceId) {
        this.mRemoteService.run(service -> service.notifyOneTimePermissionSessionTimeout(packageName, deviceId));
    }

    public void getPlatformPermissionsForGroup(@NonNull String permissionGroupName, @NonNull Executor executor, @NonNull Consumer<List<String>> callback) {
        this.mRemoteService.postAsync(service -> {
            AndroidFuture<List<String>> future = new AndroidFuture<List<String>>();
            service.getPlatformPermissionsForGroup(permissionGroupName, future);
            return future;
        }).whenCompleteAsync((result, err) -> {
            long token = Binder.clearCallingIdentity();
            try {
                if (err != null) {
                    Log.e(TAG, "Failed to get permissions of " + permissionGroupName, err);
                    callback.accept(new ArrayList());
                } else {
                    callback.accept((List<String>)result);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }, executor);
    }

    public void getGroupOfPlatformPermission(@NonNull String permissionName, @NonNull Executor executor, @NonNull Consumer<String> callback) {
        this.mRemoteService.postAsync(service -> {
            AndroidFuture<String> future = new AndroidFuture<String>();
            service.getGroupOfPlatformPermission(permissionName, future);
            return future;
        }).whenCompleteAsync((result, err) -> {
            long token = Binder.clearCallingIdentity();
            try {
                if (err != null) {
                    Log.e(TAG, "Failed to get group of " + permissionName, err);
                    callback.accept(null);
                } else {
                    callback.accept((String)result);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }, executor);
    }

    public void getUnusedAppCount(@NonNull Executor executor, @NonNull IntConsumer callback) {
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(callback);
        this.mRemoteService.postAsync(service -> {
            AndroidFuture unusedAppCountResult = new AndroidFuture();
            service.getUnusedAppCount(unusedAppCountResult);
            return unusedAppCountResult;
        }).whenCompleteAsync((count, err) -> {
            if (err != null) {
                Log.e(TAG, "Error getting unused app count", err);
                callback.accept(0);
            } else {
                long token = Binder.clearCallingIdentity();
                try {
                    callback.accept((int)count);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }, executor);
    }

    @RequiresPermission(value="android.permission.MANAGE_APP_HIBERNATION")
    public void getHibernationEligibility(@NonNull String packageName, @NonNull Executor executor, @NonNull IntConsumer callback) {
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(callback);
        this.mRemoteService.postAsync(service -> {
            AndroidFuture eligibilityResult = new AndroidFuture();
            service.getHibernationEligibility(packageName, eligibilityResult);
            return eligibilityResult;
        }).whenCompleteAsync((eligibility, err) -> {
            if (err != null) {
                Log.e(TAG, "Error getting hibernation eligibility", err);
                callback.accept(-1);
            } else {
                long token = Binder.clearCallingIdentity();
                try {
                    callback.accept((int)eligibility);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }, executor);
    }

    public void revokeSelfPermissionsOnKill(@NonNull String packageName, @NonNull List<String> permissions) {
        this.mRemoteService.postAsync(service -> {
            AndroidFuture callback = new AndroidFuture();
            service.revokeSelfPermissionsOnKill(packageName, permissions, this.mContext.getDeviceId(), callback);
            return callback;
        }).whenComplete((result, err) -> {
            if (err != null) {
                Log.e(TAG, "Failed to self revoke " + String.join((CharSequence)",", permissions) + " for package " + packageName + ", and device " + this.mContext.getDeviceId(), err);
            }
        });
    }

    public static abstract class OnRevokeRuntimePermissionsCallback {
        public abstract void onRevokeRuntimePermissions(@NonNull Map<String, List<String>> var1);
    }

    public static interface OnGetAppPermissionResultCallback {
        public void onGetAppPermissions(@NonNull List<RuntimePermissionPresentationInfo> var1);
    }

    public static interface OnCountPermissionAppsResultCallback {
        public void onCountPermissionApps(int var1);
    }

    public static interface OnPermissionUsageResultCallback {
        public void onPermissionUsageResult(@NonNull List<RuntimePermissionUsageInfo> var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HibernationEligibilityFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CountPermissionAppsFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Reason {
    }
}

