/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.provider.ParcelableException;

public interface IOpenFileCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.provider.IOpenFileCallback";

    public void onSuccess(ParcelFileDescriptor var1) throws RemoteException;

    public void onFailure(ParcelableException var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOpenFileCallback {
        static final int TRANSACTION_onSuccess = 1;
        static final int TRANSACTION_onFailure = 2;

        public Stub() {
            this.attachInterface(this, IOpenFileCallback.DESCRIPTOR);
        }

        public static IOpenFileCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IOpenFileCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IOpenFileCallback) {
                return (IOpenFileCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSuccess";
                }
                case 2: {
                    return "onFailure";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IOpenFileCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    this.onSuccess(_arg0);
                    break;
                }
                case 2: {
                    ParcelableException _arg0 = data.readTypedObject(ParcelableException.CREATOR);
                    this.onFailure(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IOpenFileCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IOpenFileCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(ParcelFileDescriptor pfd) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOpenFileCallback.DESCRIPTOR);
                    _data.writeTypedObject(pfd, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(ParcelableException exception) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOpenFileCallback.DESCRIPTOR);
                    _data.writeTypedObject(exception, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IOpenFileCallback {
        @Override
        public void onSuccess(ParcelFileDescriptor pfd) throws RemoteException {
        }

        @Override
        public void onFailure(ParcelableException exception) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

