/*
 * Decompiled with CFR 0.152.
 */
package android.provider.internal.aconfig.storage;

import android.provider.internal.aconfig.storage.AconfigStorageException;
import android.provider.internal.aconfig.storage.ByteBufferReader;
import android.provider.internal.aconfig.storage.FileType;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.nio.ByteBuffer;

@RavenwoodKeepWholeClass
public class FlagValueList {
    private Header mHeader;
    private ByteBufferReader mReader;

    public static FlagValueList fromBytes(ByteBuffer bytes) {
        FlagValueList flagValueList = new FlagValueList();
        flagValueList.mReader = new ByteBufferReader(bytes);
        flagValueList.mHeader = Header.fromBytes(flagValueList.mReader);
        return flagValueList;
    }

    public boolean getBoolean(int index) {
        return this.mReader.readByte(this.mHeader.mBooleanValueOffset + index) == 1;
    }

    public Header getHeader() {
        return this.mHeader;
    }

    public int size() {
        return this.mHeader.mNumFlags;
    }

    public static class Header {
        private int mVersion;
        private String mContainer;
        private FileType mFileType;
        private int mFileSize;
        private int mNumFlags;
        private int mBooleanValueOffset;

        public static Header fromBytes(ByteBufferReader reader) {
            Header header = new Header();
            header.mVersion = reader.readInt();
            header.mContainer = reader.readString();
            header.mFileType = FileType.fromInt(reader.readByte());
            header.mFileSize = reader.readInt();
            header.mNumFlags = reader.readInt();
            header.mBooleanValueOffset = reader.readInt();
            if (header.mFileType != FileType.FLAG_VAL) {
                throw new AconfigStorageException("binary file is not a flag value file");
            }
            return header;
        }

        public int getVersion() {
            return this.mVersion;
        }

        public String getContainer() {
            return this.mContainer;
        }

        public FileType getFileType() {
            return this.mFileType;
        }

        public int getFileSize() {
            return this.mFileSize;
        }

        public int getNumFlags() {
            return this.mNumFlags;
        }

        public int getBooleanValueOffset() {
            return this.mBooleanValueOffset;
        }
    }
}

