/*
 * Decompiled with CFR 0.152.
 */
package android.ranging;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class DataNotificationConfig
implements Parcelable {
    private final int mNotificationConfigType;
    private final int mProximityNearCm;
    private final int mProximityFarCm;
    @NonNull
    public static final Parcelable.Creator<DataNotificationConfig> CREATOR = new Parcelable.Creator<DataNotificationConfig>(){

        @Override
        public DataNotificationConfig createFromParcel(Parcel in) {
            return new DataNotificationConfig(in);
        }

        public DataNotificationConfig[] newArray(int size) {
            return new DataNotificationConfig[size];
        }
    };
    public static final int NOTIFICATION_CONFIG_DISABLE = 0;
    public static final int NOTIFICATION_CONFIG_ENABLE = 1;
    public static final int NOTIFICATION_CONFIG_PROXIMITY_LEVEL = 2;
    public static final int NOTIFICATION_CONFIG_PROXIMITY_EDGE = 3;

    private DataNotificationConfig(Parcel in) {
        this.mNotificationConfigType = in.readInt();
        this.mProximityNearCm = in.readInt();
        this.mProximityFarCm = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mNotificationConfigType);
        dest.writeInt(this.mProximityNearCm);
        dest.writeInt(this.mProximityFarCm);
    }

    private DataNotificationConfig(Builder builder) {
        if (builder.mProximityNearCm > builder.mProximityFarCm) {
            throw new IllegalArgumentException("Ntf proximity near cannot be greater than Ntf proximity far");
        }
        this.mNotificationConfigType = builder.mNotificationConfigType;
        this.mProximityNearCm = builder.mProximityNearCm;
        this.mProximityFarCm = builder.mProximityFarCm;
    }

    public int getNotificationConfigType() {
        return this.mNotificationConfigType;
    }

    public int getProximityNearCm() {
        return this.mProximityNearCm;
    }

    public int getProximityFarCm() {
        return this.mProximityFarCm;
    }

    public String toString() {
        return "DataNotificationConfig{ mNotificationConfigType=" + this.mNotificationConfigType + ", mProximityNearCm=" + this.mProximityNearCm + ", mProximityFarCm=" + this.mProximityFarCm + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataNotificationConfig)) {
            return false;
        }
        DataNotificationConfig that = (DataNotificationConfig)o;
        return this.mNotificationConfigType == that.mNotificationConfigType && this.mProximityNearCm == that.mProximityNearCm && this.mProximityFarCm == that.mProximityFarCm;
    }

    public int hashCode() {
        return Objects.hash(this.mNotificationConfigType, this.mProximityNearCm, this.mProximityFarCm);
    }

    public static class Builder {
        private int mNotificationConfigType = 1;
        private int mProximityNearCm = 0;
        private int mProximityFarCm = 20000;

        @NonNull
        public Builder setNotificationConfigType(int config) {
            this.mNotificationConfigType = config;
            return this;
        }

        @NonNull
        public Builder setProximityNearCm(int proximityCm) {
            this.mProximityNearCm = proximityCm;
            return this;
        }

        @NonNull
        public Builder setProximityFarCm(int proximityCm) {
            this.mProximityFarCm = proximityCm;
            return this;
        }

        @NonNull
        public DataNotificationConfig build() {
            return new DataNotificationConfig(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NotificationConfigType {
    }
}

