/*
 * Decompiled with CFR 0.152.
 */
package android.ranging;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.ranging.RangingData;
import android.ranging.RangingDevice;
import android.ranging.SessionHandle;

public interface IRangingCallbacks
extends IInterface {
    public static final String DESCRIPTOR = "android.ranging.IRangingCallbacks";

    public void onOpened(SessionHandle var1) throws RemoteException;

    public void onOpenFailed(SessionHandle var1, int var2) throws RemoteException;

    public void onStarted(SessionHandle var1, RangingDevice var2, int var3) throws RemoteException;

    public void onResults(SessionHandle var1, RangingDevice var2, RangingData var3) throws RemoteException;

    public void onStopped(SessionHandle var1, RangingDevice var2, int var3) throws RemoteException;

    public void onClosed(SessionHandle var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRangingCallbacks {
        static final int TRANSACTION_onOpened = 1;
        static final int TRANSACTION_onOpenFailed = 2;
        static final int TRANSACTION_onStarted = 3;
        static final int TRANSACTION_onResults = 4;
        static final int TRANSACTION_onStopped = 5;
        static final int TRANSACTION_onClosed = 6;

        public Stub() {
            this.attachInterface(this, IRangingCallbacks.DESCRIPTOR);
        }

        public static IRangingCallbacks asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRangingCallbacks.DESCRIPTOR);
            if (iin != null && iin instanceof IRangingCallbacks) {
                return (IRangingCallbacks)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onOpened";
                }
                case 2: {
                    return "onOpenFailed";
                }
                case 3: {
                    return "onStarted";
                }
                case 4: {
                    return "onResults";
                }
                case 5: {
                    return "onStopped";
                }
                case 6: {
                    return "onClosed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRangingCallbacks.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onOpened(_arg0);
                    break;
                }
                case 2: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onOpenFailed(_arg0, _arg1);
                    break;
                }
                case 3: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    RangingDevice _arg1 = data.readTypedObject(RangingDevice.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onStarted(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    RangingDevice _arg1 = data.readTypedObject(RangingDevice.CREATOR);
                    RangingData _arg2 = data.readTypedObject(RangingData.CREATOR);
                    data.enforceNoDataAvail();
                    this.onResults(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    RangingDevice _arg1 = data.readTypedObject(RangingDevice.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onStopped(_arg0, _arg1, _arg2);
                    break;
                }
                case 6: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onClosed(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements IRangingCallbacks {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRangingCallbacks.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOpened(SessionHandle session) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(session, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOpenFailed(SessionHandle session, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(session, 0);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStarted(SessionHandle session, RangingDevice peer, int technology) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(session, 0);
                    _data.writeTypedObject(peer, 0);
                    _data.writeInt(technology);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResults(SessionHandle session, RangingDevice peer, RangingData data) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(session, 0);
                    _data.writeTypedObject(peer, 0);
                    _data.writeTypedObject(data, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStopped(SessionHandle session, RangingDevice peer, int technology) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(session, 0);
                    _data.writeTypedObject(peer, 0);
                    _data.writeInt(technology);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onClosed(SessionHandle session, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(session, 0);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRangingCallbacks {
        @Override
        public void onOpened(SessionHandle session) throws RemoteException {
        }

        @Override
        public void onOpenFailed(SessionHandle session, int reason) throws RemoteException {
        }

        @Override
        public void onStarted(SessionHandle session, RangingDevice peer, int technology) throws RemoteException {
        }

        @Override
        public void onResults(SessionHandle session, RangingDevice peer, RangingData data) throws RemoteException {
        }

        @Override
        public void onStopped(SessionHandle session, RangingDevice peer, int technology) throws RemoteException {
        }

        @Override
        public void onClosed(SessionHandle session, int reason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

