/*
 * Decompiled with CFR 0.152.
 */
package android.ranging;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class RangingMeasurement
implements Parcelable {
    public static final int CONFIDENCE_LOW = 0;
    public static final int CONFIDENCE_MEDIUM = 1;
    public static final int CONFIDENCE_HIGH = 2;
    private final double mMeasurement;
    private final int mConfidence;
    private final double mRawConfidence;
    private final double mError;
    @NonNull
    public static final Parcelable.Creator<RangingMeasurement> CREATOR = new Parcelable.Creator<RangingMeasurement>(){

        @Override
        public RangingMeasurement createFromParcel(Parcel in) {
            return new RangingMeasurement(in);
        }

        public RangingMeasurement[] newArray(int size) {
            return new RangingMeasurement[size];
        }
    };

    private RangingMeasurement(Builder builder) {
        if (Double.isNaN(builder.mMeasurement)) {
            throw new IllegalArgumentException("Missing required parameter: measurement");
        }
        this.mMeasurement = builder.mMeasurement;
        this.mConfidence = builder.mConfidence;
        this.mRawConfidence = builder.mRawConfidence;
        this.mError = builder.mError;
    }

    private RangingMeasurement(@NonNull Parcel in) {
        this.mMeasurement = in.readDouble();
        this.mConfidence = in.readInt();
        this.mRawConfidence = in.readDouble();
        this.mError = in.readDouble();
    }

    public double getMeasurement() {
        return this.mMeasurement;
    }

    public int getConfidence() {
        return this.mConfidence;
    }

    public boolean hasRawConfidence() {
        return !Double.isNaN(this.mRawConfidence);
    }

    public double getRawConfidence() {
        return this.mRawConfidence;
    }

    public boolean hasError() {
        return !Double.isNaN(this.mError);
    }

    public double getError() {
        return this.mError;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeDouble(this.mMeasurement);
        dest.writeInt(this.mConfidence);
        dest.writeDouble(this.mRawConfidence);
        dest.writeDouble(this.mError);
    }

    public String toString() {
        return "RangingMeasurement{mMeasurement=" + this.mMeasurement + ", mConfidence=" + this.mConfidence + ", mRawConfidence=" + this.mRawConfidence + ", mError=" + this.mError + '}';
    }

    public static class Builder {
        private double mMeasurement = Double.NaN;
        private int mConfidence = 1;
        private double mRawConfidence = Double.NaN;
        private double mError = Double.NaN;

        @NonNull
        public Builder setMeasurement(double measurement) {
            this.mMeasurement = measurement;
            return this;
        }

        @NonNull
        public Builder setConfidence(int confidence) {
            this.mConfidence = confidence;
            return this;
        }

        @NonNull
        public Builder setRawConfidence(double confidence) {
            if (confidence < 0.0 || confidence > 1.0) {
                throw new IllegalArgumentException("Provided raw confidence value must be in [0.0, 1.0]");
            }
            this.mRawConfidence = confidence;
            return this;
        }

        @NonNull
        public Builder setError(double error) {
            if (error < 0.0) {
                throw new IllegalArgumentException("Provided error must be positive");
            }
            this.mError = error;
            return this;
        }

        @NonNull
        public RangingMeasurement build() {
            return new RangingMeasurement(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Confidence {
    }
}

