/*
 * Decompiled with CFR 0.152.
 */
package android.ranging.wifi.rtt;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_rtt_enabled")
public class RttRangingParams
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<RttRangingParams> CREATOR = new Parcelable.Creator<RttRangingParams>(){

        @Override
        public RttRangingParams createFromParcel(Parcel in) {
            return new RttRangingParams(in);
        }

        public RttRangingParams[] newArray(int size) {
            return new RttRangingParams[size];
        }
    };
    private final String mServiceName;
    private final byte[] mMatchFilter;
    private final int mRangingUpdateRate;
    private final boolean mPeriodicRangingHwFeatureEnabled;

    private RttRangingParams(Parcel in) {
        this.mServiceName = in.readString();
        this.mMatchFilter = in.createByteArray();
        this.mRangingUpdateRate = in.readInt();
        this.mPeriodicRangingHwFeatureEnabled = in.readBoolean();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mServiceName);
        dest.writeByteArray(this.mMatchFilter);
        dest.writeInt(this.mRangingUpdateRate);
        dest.writeBoolean(this.mPeriodicRangingHwFeatureEnabled);
    }

    @NonNull
    public String getServiceName() {
        return this.mServiceName;
    }

    @Nullable
    public byte[] getMatchFilter() {
        return this.mMatchFilter;
    }

    public int getRangingUpdateRate() {
        return this.mRangingUpdateRate;
    }

    public boolean isPeriodicRangingHwFeatureEnabled() {
        return this.mPeriodicRangingHwFeatureEnabled;
    }

    private RttRangingParams(Builder builder) {
        this.mServiceName = builder.mServiceName;
        this.mMatchFilter = builder.mMatchFilter;
        this.mRangingUpdateRate = builder.mRangingUpdateRate;
        this.mPeriodicRangingHwFeatureEnabled = builder.mPeriodicRangingHwFeatureEnabled;
    }

    public String toString() {
        return "RttRangingParams{ mServiceName='" + this.mServiceName + ", mMatchFilter=" + Arrays.toString(this.mMatchFilter) + ", mRangingUpdateRate=" + this.mRangingUpdateRate + ", mPeriodicRangingHwFeatureEnabled=" + this.mPeriodicRangingHwFeatureEnabled + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RttRangingParams)) {
            return false;
        }
        RttRangingParams that = (RttRangingParams)o;
        return this.mRangingUpdateRate == that.mRangingUpdateRate && this.mPeriodicRangingHwFeatureEnabled == that.mPeriodicRangingHwFeatureEnabled && Objects.equals(this.mServiceName, that.mServiceName) && Objects.deepEquals(this.mMatchFilter, that.mMatchFilter);
    }

    public int hashCode() {
        return Objects.hash(this.mServiceName, Arrays.hashCode(this.mMatchFilter), this.mRangingUpdateRate, this.mPeriodicRangingHwFeatureEnabled);
    }

    public static class Builder {
        private String mServiceName = "";
        private byte[] mMatchFilter = null;
        private boolean mPeriodicRangingHwFeatureEnabled = false;
        private int mRangingUpdateRate = 1;

        public Builder(@NonNull String serviceName) {
            Objects.requireNonNull(serviceName);
            this.mServiceName = serviceName;
        }

        @NonNull
        public Builder setMatchFilter(@NonNull byte[] matchFilter) {
            Objects.requireNonNull(matchFilter);
            this.mMatchFilter = (byte[])matchFilter.clone();
            return this;
        }

        @NonNull
        public Builder setRangingUpdateRate(int updateRate) {
            this.mRangingUpdateRate = updateRate;
            return this;
        }

        @NonNull
        public Builder setPeriodicRangingHwFeatureEnabled(boolean periodicRangingHwFeatureEnabled) {
            this.mPeriodicRangingHwFeatureEnabled = periodicRangingHwFeatureEnabled;
            return this;
        }

        @NonNull
        public RttRangingParams build() {
            return new RttRangingParams(this);
        }
    }
}

