/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.safetycenter.SafetyCenterEntry;
import android.text.TextUtils;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetyCenterEntryGroup
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<SafetyCenterEntryGroup> CREATOR = new Parcelable.Creator<SafetyCenterEntryGroup>(){

        @Override
        public SafetyCenterEntryGroup createFromParcel(Parcel in) {
            String id2 = in.readString();
            CharSequence title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            return new Builder(id2, title).setSummary(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in)).setSeverityLevel(in.readInt()).setSeverityUnspecifiedIconType(in.readInt()).setEntries(in.createTypedArrayList(SafetyCenterEntry.CREATOR)).build();
        }

        public SafetyCenterEntryGroup[] newArray(int size) {
            return new SafetyCenterEntryGroup[size];
        }
    };
    @NonNull
    private final String mId;
    @NonNull
    private final CharSequence mTitle;
    @Nullable
    private final CharSequence mSummary;
    private final int mSeverityLevel;
    private final int mSeverityUnspecifiedIconType;
    @NonNull
    private final List<SafetyCenterEntry> mEntries;

    private SafetyCenterEntryGroup(@NonNull String id2, @NonNull CharSequence title, @Nullable CharSequence summary, int severityLevel, int severityUnspecifiedIconType, @NonNull List<SafetyCenterEntry> entries) {
        this.mId = id2;
        this.mTitle = title;
        this.mSummary = summary;
        this.mSeverityLevel = severityLevel;
        this.mSeverityUnspecifiedIconType = severityUnspecifiedIconType;
        this.mEntries = entries;
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @NonNull
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Nullable
    public CharSequence getSummary() {
        return this.mSummary;
    }

    public int getSeverityLevel() {
        return this.mSeverityLevel;
    }

    public int getSeverityUnspecifiedIconType() {
        return this.mSeverityUnspecifiedIconType;
    }

    @NonNull
    public List<SafetyCenterEntry> getEntries() {
        return this.mEntries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetyCenterEntryGroup)) {
            return false;
        }
        SafetyCenterEntryGroup that = (SafetyCenterEntryGroup)o;
        return this.mSeverityLevel == that.mSeverityLevel && this.mSeverityUnspecifiedIconType == that.mSeverityUnspecifiedIconType && Objects.equals(this.mId, that.mId) && TextUtils.equals(this.mTitle, that.mTitle) && TextUtils.equals(this.mSummary, that.mSummary) && Objects.equals(this.mEntries, that.mEntries);
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mTitle, this.mSummary, this.mSeverityLevel, this.mSeverityUnspecifiedIconType, this.mEntries);
    }

    public String toString() {
        return "SafetyCenterEntryGroup{mId=" + this.mId + ", mTitle=" + this.mTitle + ", mSummary=" + this.mSummary + ", mSeverityLevel=" + this.mSeverityLevel + ", mSeverityUnspecifiedIconType=" + this.mSeverityUnspecifiedIconType + ", mEntries=" + this.mEntries + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mId);
        TextUtils.writeToParcel(this.mTitle, dest, flags);
        TextUtils.writeToParcel(this.mSummary, dest, flags);
        dest.writeInt(this.mSeverityLevel);
        dest.writeInt(this.mSeverityUnspecifiedIconType);
        dest.writeTypedList(this.mEntries);
    }

    private static int validateEntrySeverityLevel(int value) {
        switch (value) {
            case 3000: 
            case 3100: 
            case 3200: 
            case 3300: 
            case 3400: {
                return value;
            }
        }
        throw new IllegalArgumentException("Unexpected EntrySeverityLevel for SafetyCenterEntryGroup: " + value);
    }

    private static int validateSeverityUnspecifiedIconType(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: {
                return value;
            }
        }
        throw new IllegalArgumentException("Unexpected SeverityUnspecifiedIconType for SafetyCenterEntryGroup: " + value);
    }

    public static class Builder {
        @NonNull
        private String mId;
        @NonNull
        private CharSequence mTitle;
        @Nullable
        private CharSequence mSummary;
        private int mSeverityLevel = 3000;
        private int mSeverityUnspecifiedIconType = 0;
        @NonNull
        private List<SafetyCenterEntry> mEntries = new ArrayList<SafetyCenterEntry>();

        public Builder(@NonNull String id2, @NonNull CharSequence title) {
            this.mId = Objects.requireNonNull(id2);
            this.mTitle = Objects.requireNonNull(title);
        }

        public Builder(@NonNull SafetyCenterEntryGroup safetyCenterEntryGroup) {
            this.mId = safetyCenterEntryGroup.mId;
            this.mTitle = safetyCenterEntryGroup.mTitle;
            this.mSummary = safetyCenterEntryGroup.mSummary;
            this.mSeverityLevel = safetyCenterEntryGroup.mSeverityLevel;
            this.mSeverityUnspecifiedIconType = safetyCenterEntryGroup.mSeverityUnspecifiedIconType;
            this.mEntries = new ArrayList<SafetyCenterEntry>(safetyCenterEntryGroup.mEntries);
        }

        @NonNull
        public Builder setId(@NonNull String id2) {
            this.mId = Objects.requireNonNull(id2);
            return this;
        }

        @NonNull
        public Builder setTitle(@NonNull CharSequence title) {
            this.mTitle = Objects.requireNonNull(title);
            return this;
        }

        @NonNull
        public Builder setSummary(@Nullable CharSequence summary) {
            this.mSummary = summary;
            return this;
        }

        @NonNull
        public Builder setSeverityLevel(int severityLevel) {
            this.mSeverityLevel = SafetyCenterEntryGroup.validateEntrySeverityLevel(severityLevel);
            return this;
        }

        @NonNull
        public Builder setSeverityUnspecifiedIconType(int severityUnspecifiedIconType) {
            this.mSeverityUnspecifiedIconType = SafetyCenterEntryGroup.validateSeverityUnspecifiedIconType(severityUnspecifiedIconType);
            return this;
        }

        @NonNull
        public Builder setEntries(@NonNull List<SafetyCenterEntry> entries) {
            this.mEntries = Objects.requireNonNull(entries);
            return this;
        }

        @NonNull
        public SafetyCenterEntryGroup build() {
            return new SafetyCenterEntryGroup(this.mId, this.mTitle, this.mSummary, this.mSeverityLevel, this.mSeverityUnspecifiedIconType, Collections.unmodifiableList(new ArrayList<SafetyCenterEntry>(this.mEntries)));
        }
    }
}

