/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.os.Parcel;
import android.os.Parcelable;
import android.permission.jarjar.com.android.internal.util.Preconditions;
import android.permission.jarjar.com.android.modules.utils.build.SdkLevel;
import android.text.TextUtils;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetySourceIssue
implements Parcelable {
    public static final int ISSUE_CATEGORY_DEVICE = 100;
    public static final int ISSUE_CATEGORY_ACCOUNT = 200;
    public static final int ISSUE_CATEGORY_GENERAL = 300;
    @RequiresApi(value=34)
    public static final int ISSUE_CATEGORY_DATA = 400;
    @RequiresApi(value=34)
    public static final int ISSUE_CATEGORY_PASSWORDS = 500;
    @RequiresApi(value=34)
    public static final int ISSUE_CATEGORY_PERSONAL_SAFETY = 600;
    @RequiresApi(value=34)
    public static final int NOTIFICATION_BEHAVIOR_UNSPECIFIED = 0;
    @RequiresApi(value=34)
    public static final int NOTIFICATION_BEHAVIOR_NEVER = 100;
    @RequiresApi(value=34)
    public static final int NOTIFICATION_BEHAVIOR_DELAYED = 200;
    @RequiresApi(value=34)
    public static final int NOTIFICATION_BEHAVIOR_IMMEDIATELY = 300;
    @RequiresApi(value=34)
    public static final int ISSUE_ACTIONABILITY_MANUAL = 0;
    @RequiresApi(value=34)
    public static final int ISSUE_ACTIONABILITY_TIP = 100;
    @RequiresApi(value=34)
    public static final int ISSUE_ACTIONABILITY_AUTOMATIC = 200;
    @NonNull
    public static final Parcelable.Creator<SafetySourceIssue> CREATOR = new Parcelable.Creator<SafetySourceIssue>(){

        @Override
        public SafetySourceIssue createFromParcel(Parcel in) {
            String id2 = in.readString();
            CharSequence title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            CharSequence subtitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            CharSequence summary = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            int severityLevel = in.readInt();
            int issueCategory = in.readInt();
            List actions = Objects.requireNonNull(in.createTypedArrayList(Action.CREATOR));
            PendingIntent onDismissPendingIntent = in.readTypedObject(PendingIntent.CREATOR);
            String issueTypeId = in.readString();
            Builder builder = new Builder(id2, title, summary, severityLevel, issueTypeId).setSubtitle(subtitle).setIssueCategory(issueCategory).setOnDismissPendingIntent(onDismissPendingIntent);
            for (int i = 0; i < actions.size(); ++i) {
                builder.addAction((Action)actions.get(i));
            }
            if (SdkLevel.isAtLeastU()) {
                builder.setCustomNotification(in.readTypedObject(Notification.CREATOR));
                builder.setNotificationBehavior(in.readInt());
                builder.setAttributionTitle(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in));
                builder.setDeduplicationId(in.readString());
                builder.setIssueActionability(in.readInt());
            }
            return builder.build();
        }

        public SafetySourceIssue[] newArray(int size) {
            return new SafetySourceIssue[size];
        }
    };
    @NonNull
    private final String mId;
    @NonNull
    private final CharSequence mTitle;
    @Nullable
    private final CharSequence mSubtitle;
    @NonNull
    private final CharSequence mSummary;
    private final int mSeverityLevel;
    private final List<Action> mActions;
    @Nullable
    private final PendingIntent mOnDismissPendingIntent;
    private final int mIssueCategory;
    @NonNull
    private final String mIssueTypeId;
    @Nullable
    private final Notification mCustomNotification;
    private final int mNotificationBehavior;
    @Nullable
    private final CharSequence mAttributionTitle;
    @Nullable
    private final String mDeduplicationId;
    private final int mIssueActionability;

    private SafetySourceIssue(@NonNull String id2, @NonNull CharSequence title, @Nullable CharSequence subtitle, @NonNull CharSequence summary, int severityLevel, int issueCategory, @NonNull List<Action> actions, @Nullable PendingIntent onDismissPendingIntent, @NonNull String issueTypeId, @Nullable Notification customNotification, int notificationBehavior, @Nullable CharSequence attributionTitle, @Nullable String deduplicationId, int issueActionability) {
        this.mId = id2;
        this.mTitle = title;
        this.mSubtitle = subtitle;
        this.mSummary = summary;
        this.mSeverityLevel = severityLevel;
        this.mIssueCategory = issueCategory;
        this.mActions = actions;
        this.mOnDismissPendingIntent = onDismissPendingIntent;
        this.mIssueTypeId = issueTypeId;
        this.mCustomNotification = customNotification;
        this.mNotificationBehavior = notificationBehavior;
        this.mAttributionTitle = attributionTitle;
        this.mDeduplicationId = deduplicationId;
        this.mIssueActionability = issueActionability;
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @NonNull
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Nullable
    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    @NonNull
    public CharSequence getSummary() {
        return this.mSummary;
    }

    @Nullable
    @RequiresApi(value=34)
    public CharSequence getAttributionTitle() {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
        }
        return this.mAttributionTitle;
    }

    public int getSeverityLevel() {
        return this.mSeverityLevel;
    }

    public int getIssueCategory() {
        return this.mIssueCategory;
    }

    @NonNull
    public List<Action> getActions() {
        return this.mActions;
    }

    @Nullable
    public PendingIntent getOnDismissPendingIntent() {
        return this.mOnDismissPendingIntent;
    }

    @NonNull
    public String getIssueTypeId() {
        return this.mIssueTypeId;
    }

    @Nullable
    @RequiresApi(value=34)
    public Notification getCustomNotification() {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
        }
        return this.mCustomNotification;
    }

    @RequiresApi(value=34)
    public int getNotificationBehavior() {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
        }
        return this.mNotificationBehavior;
    }

    @Nullable
    @RequiresApi(value=34)
    public String getDeduplicationId() {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
        }
        return this.mDeduplicationId;
    }

    @RequiresApi(value=34)
    public int getIssueActionability() {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
        }
        return this.mIssueActionability;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mId);
        TextUtils.writeToParcel(this.mTitle, dest, flags);
        TextUtils.writeToParcel(this.mSubtitle, dest, flags);
        TextUtils.writeToParcel(this.mSummary, dest, flags);
        dest.writeInt(this.mSeverityLevel);
        dest.writeInt(this.mIssueCategory);
        dest.writeTypedList(this.mActions);
        dest.writeTypedObject(this.mOnDismissPendingIntent, flags);
        dest.writeString(this.mIssueTypeId);
        if (SdkLevel.isAtLeastU()) {
            dest.writeTypedObject(this.mCustomNotification, flags);
            dest.writeInt(this.mNotificationBehavior);
            TextUtils.writeToParcel(this.mAttributionTitle, dest, flags);
            dest.writeString(this.mDeduplicationId);
            dest.writeInt(this.mIssueActionability);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetySourceIssue)) {
            return false;
        }
        SafetySourceIssue that = (SafetySourceIssue)o;
        return this.mSeverityLevel == that.mSeverityLevel && TextUtils.equals(this.mId, that.mId) && TextUtils.equals(this.mTitle, that.mTitle) && TextUtils.equals(this.mSubtitle, that.mSubtitle) && TextUtils.equals(this.mSummary, that.mSummary) && this.mIssueCategory == that.mIssueCategory && this.mActions.equals(that.mActions) && Objects.equals(this.mOnDismissPendingIntent, that.mOnDismissPendingIntent) && TextUtils.equals(this.mIssueTypeId, that.mIssueTypeId) && Objects.equals(this.mCustomNotification, that.mCustomNotification) && this.mNotificationBehavior == that.mNotificationBehavior && TextUtils.equals(this.mAttributionTitle, that.mAttributionTitle) && TextUtils.equals(this.mDeduplicationId, that.mDeduplicationId) && this.mIssueActionability == that.mIssueActionability;
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mTitle, this.mSubtitle, this.mSummary, this.mSeverityLevel, this.mIssueCategory, this.mActions, this.mOnDismissPendingIntent, this.mIssueTypeId, this.mCustomNotification, this.mNotificationBehavior, this.mAttributionTitle, this.mDeduplicationId, this.mIssueActionability);
    }

    public String toString() {
        return "SafetySourceIssue{mId=" + this.mId + "mTitle=" + this.mTitle + ", mSubtitle=" + this.mSubtitle + ", mSummary=" + this.mSummary + ", mSeverityLevel=" + this.mSeverityLevel + ", mIssueCategory=" + this.mIssueCategory + ", mActions=" + this.mActions + ", mOnDismissPendingIntent=" + this.mOnDismissPendingIntent + ", mIssueTypeId=" + this.mIssueTypeId + ", mCustomNotification=" + this.mCustomNotification + ", mNotificationBehavior=" + this.mNotificationBehavior + ", mAttributionTitle=" + this.mAttributionTitle + ", mDeduplicationId=" + this.mDeduplicationId + ", mIssueActionability=" + this.mIssueActionability + '}';
    }

    private static int validateSeverityLevel(int value) {
        switch (value) {
            case 200: 
            case 300: 
            case 400: {
                return value;
            }
            case 100: {
                throw new IllegalArgumentException("SeverityLevel for SafetySourceIssue must not be SEVERITY_LEVEL_UNSPECIFIED");
            }
        }
        throw new IllegalArgumentException("Unexpected SeverityLevel for SafetySourceIssue: " + value);
    }

    private static int validateIssueCategory(int value) {
        switch (value) {
            case 100: 
            case 200: 
            case 300: {
                return value;
            }
        }
        if (SdkLevel.isAtLeastU()) {
            switch (value) {
                case 400: 
                case 500: 
                case 600: {
                    return value;
                }
            }
        }
        throw new IllegalArgumentException("Unexpected IssueCategory for SafetySourceIssue: " + value);
    }

    private static int validateNotificationBehavior(int value) {
        switch (value) {
            case 0: 
            case 100: 
            case 200: 
            case 300: {
                return value;
            }
        }
        throw new IllegalArgumentException("Unexpected NotificationBehavior for SafetySourceIssue: " + value);
    }

    private static int validateIssueActionability(int value) {
        switch (value) {
            case 0: 
            case 100: 
            case 200: {
                return value;
            }
        }
        throw new IllegalArgumentException("Unexpected IssueActionability for SafetySourceIssue: " + value);
    }

    @RequiresApi(value=34)
    public static class Notification
    implements Parcelable {
        @NonNull
        public static final Parcelable.Creator<Notification> CREATOR = new Parcelable.Creator<Notification>(){

            @Override
            public Notification createFromParcel(Parcel in) {
                return new Builder(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in), TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in)).addActions(in.createTypedArrayList(Action.CREATOR)).build();
            }

            public Notification[] newArray(int size) {
                return new Notification[size];
            }
        };
        @NonNull
        private final CharSequence mTitle;
        @NonNull
        private final CharSequence mText;
        @NonNull
        private final List<Action> mActions;

        private Notification(@NonNull CharSequence title, @NonNull CharSequence text, @NonNull List<Action> actions) {
            this.mTitle = title;
            this.mText = text;
            this.mActions = actions;
        }

        @NonNull
        public CharSequence getTitle() {
            return this.mTitle;
        }

        @NonNull
        public CharSequence getText() {
            return this.mText;
        }

        @NonNull
        public List<Action> getActions() {
            return this.mActions;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            TextUtils.writeToParcel(this.mTitle, dest, flags);
            TextUtils.writeToParcel(this.mText, dest, flags);
            dest.writeTypedList(this.mActions);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Notification)) {
                return false;
            }
            Notification that = (Notification)o;
            return TextUtils.equals(this.mTitle, that.mTitle) && TextUtils.equals(this.mText, that.mText) && this.mActions.equals(that.mActions);
        }

        public int hashCode() {
            return Objects.hash(this.mTitle, this.mText, this.mActions);
        }

        public String toString() {
            return "Notification{mTitle=" + this.mTitle + ", mText=" + this.mText + ", mActions=" + this.mActions + '}';
        }

        public static class Builder {
            @NonNull
            private final CharSequence mTitle;
            @NonNull
            private final CharSequence mText;
            @NonNull
            private final List<Action> mActions = new ArrayList<Action>();

            public Builder(@NonNull CharSequence title, @NonNull CharSequence text) {
                this.mTitle = Objects.requireNonNull(title);
                this.mText = Objects.requireNonNull(text);
            }

            public Builder(@NonNull Notification notification) {
                Objects.requireNonNull(notification);
                this.mTitle = notification.mTitle;
                this.mText = notification.mText;
                this.mActions.addAll(notification.mActions);
            }

            @NonNull
            public Builder addAction(@NonNull Action action) {
                this.mActions.add(Objects.requireNonNull(action));
                return this;
            }

            @NonNull
            public Builder addActions(@NonNull List<Action> actions) {
                this.mActions.addAll((Collection<Action>)Objects.requireNonNull(actions));
                return this;
            }

            @NonNull
            public Builder clearActions() {
                this.mActions.clear();
                return this;
            }

            @NonNull
            public Notification build() {
                List<Action> actions = Collections.unmodifiableList(new ArrayList<Action>(this.mActions));
                Action.enforceUniqueActionIds(actions, "Custom notification cannot have duplicate action ids");
                Preconditions.checkArgument(actions.size() <= 2, "Custom notification must not contain more than 2 actions");
                return new Notification(this.mTitle, this.mText, actions);
            }
        }
    }

    public static class Builder {
        @NonNull
        private final String mId;
        @NonNull
        private final CharSequence mTitle;
        @NonNull
        private final CharSequence mSummary;
        private final int mSeverityLevel;
        @NonNull
        private final String mIssueTypeId;
        private final List<Action> mActions = new ArrayList<Action>();
        @Nullable
        private CharSequence mSubtitle;
        private int mIssueCategory = 300;
        @Nullable
        private PendingIntent mOnDismissPendingIntent;
        @Nullable
        private CharSequence mAttributionTitle;
        @Nullable
        private String mDeduplicationId;
        @Nullable
        private Notification mCustomNotification = null;
        @SuppressLint(value={"NewApi"})
        private int mNotificationBehavior = 0;
        @SuppressLint(value={"NewApi"})
        private int mIssueActionability = 0;

        public Builder(@NonNull String id2, @NonNull CharSequence title, @NonNull CharSequence summary, int severityLevel, @NonNull String issueTypeId) {
            this.mId = Objects.requireNonNull(id2);
            this.mTitle = Objects.requireNonNull(title);
            this.mSummary = Objects.requireNonNull(summary);
            this.mSeverityLevel = SafetySourceIssue.validateSeverityLevel(severityLevel);
            this.mIssueTypeId = Objects.requireNonNull(issueTypeId);
        }

        @RequiresApi(value=34)
        public Builder(@NonNull SafetySourceIssue safetySourceIssue) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            Objects.requireNonNull(safetySourceIssue);
            this.mId = safetySourceIssue.mId;
            this.mTitle = safetySourceIssue.mTitle;
            this.mSummary = safetySourceIssue.mSummary;
            this.mSeverityLevel = safetySourceIssue.mSeverityLevel;
            this.mIssueTypeId = safetySourceIssue.mIssueTypeId;
            this.mActions.addAll(safetySourceIssue.mActions);
            this.mSubtitle = safetySourceIssue.mSubtitle;
            this.mIssueCategory = safetySourceIssue.mIssueCategory;
            this.mOnDismissPendingIntent = safetySourceIssue.mOnDismissPendingIntent;
            this.mAttributionTitle = safetySourceIssue.mAttributionTitle;
            this.mDeduplicationId = safetySourceIssue.mDeduplicationId;
            this.mCustomNotification = safetySourceIssue.mCustomNotification;
            this.mNotificationBehavior = safetySourceIssue.mNotificationBehavior;
            this.mIssueActionability = safetySourceIssue.mIssueActionability;
        }

        @NonNull
        public Builder setSubtitle(@Nullable CharSequence subtitle) {
            this.mSubtitle = subtitle;
            return this;
        }

        @NonNull
        @RequiresApi(value=34)
        public Builder setAttributionTitle(@Nullable CharSequence attributionTitle) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            this.mAttributionTitle = attributionTitle;
            return this;
        }

        @NonNull
        public Builder setIssueCategory(int issueCategory) {
            this.mIssueCategory = SafetySourceIssue.validateIssueCategory(issueCategory);
            return this;
        }

        @NonNull
        public Builder addAction(@NonNull Action actionData) {
            this.mActions.add(Objects.requireNonNull(actionData));
            return this;
        }

        @NonNull
        public Builder clearActions() {
            this.mActions.clear();
            return this;
        }

        @NonNull
        public Builder setOnDismissPendingIntent(@Nullable PendingIntent onDismissPendingIntent) {
            Preconditions.checkArgument(onDismissPendingIntent == null || !onDismissPendingIntent.isActivity(), "Safety source issue on dismiss pending intent must not start an activity");
            this.mOnDismissPendingIntent = onDismissPendingIntent;
            return this;
        }

        @NonNull
        @RequiresApi(value=34)
        public Builder setCustomNotification(@Nullable Notification customNotification) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            this.mCustomNotification = customNotification;
            return this;
        }

        @NonNull
        @RequiresApi(value=34)
        public Builder setNotificationBehavior(int notificationBehavior) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            this.mNotificationBehavior = SafetySourceIssue.validateNotificationBehavior(notificationBehavior);
            return this;
        }

        @NonNull
        @RequiresApi(value=34)
        public Builder setDeduplicationId(@Nullable String deduplicationId) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            this.mDeduplicationId = deduplicationId;
            return this;
        }

        @NonNull
        @RequiresApi(value=34)
        public Builder setIssueActionability(int issueActionability) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            this.mIssueActionability = SafetySourceIssue.validateIssueActionability(issueActionability);
            return this;
        }

        @NonNull
        public SafetySourceIssue build() {
            List<Action> actions = Collections.unmodifiableList(new ArrayList<Action>(this.mActions));
            Action.enforceUniqueActionIds(actions, "Safety source issue cannot have duplicate action ids");
            if (SdkLevel.isAtLeastU()) {
                Preconditions.checkArgument(this.mIssueActionability != 0 || !actions.isEmpty(), "Actionable safety source issue must contain at least 1 action");
            } else {
                Preconditions.checkArgument(!actions.isEmpty(), "Safety source issue must contain at least 1 action");
            }
            Preconditions.checkArgument(actions.size() <= 2, "Safety source issue must not contain more than 2 actions");
            return new SafetySourceIssue(this.mId, this.mTitle, this.mSubtitle, this.mSummary, this.mSeverityLevel, this.mIssueCategory, actions, this.mOnDismissPendingIntent, this.mIssueTypeId, this.mCustomNotification, this.mNotificationBehavior, this.mAttributionTitle, this.mDeduplicationId, this.mIssueActionability);
        }
    }

    public static class Action
    implements Parcelable {
        @NonNull
        public static final Parcelable.Creator<Action> CREATOR = new Parcelable.Creator<Action>(){

            @Override
            public Action createFromParcel(Parcel in) {
                String id2 = in.readString();
                CharSequence label = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                PendingIntent pendingIntent = in.readTypedObject(PendingIntent.CREATOR);
                Builder builder = new Builder(id2, label, pendingIntent).setWillResolve(in.readBoolean()).setSuccessMessage(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in));
                if (SdkLevel.isAtLeastU()) {
                    ConfirmationDialogDetails confirmationDialogDetails = in.readTypedObject(ConfirmationDialogDetails.CREATOR);
                    builder.setConfirmationDialogDetails(confirmationDialogDetails);
                }
                return builder.build();
            }

            public Action[] newArray(int size) {
                return new Action[size];
            }
        };
        @NonNull
        private final String mId;
        @NonNull
        private final CharSequence mLabel;
        @NonNull
        private final PendingIntent mPendingIntent;
        private final boolean mWillResolve;
        @Nullable
        private final CharSequence mSuccessMessage;
        @Nullable
        private final ConfirmationDialogDetails mConfirmationDialogDetails;

        private static void enforceUniqueActionIds(@NonNull List<Action> actions, @NonNull String message) {
            HashSet<String> actionIds = new HashSet<String>();
            for (int i = 0; i < actions.size(); ++i) {
                Action action = actions.get(i);
                String actionId = action.getId();
                Preconditions.checkArgument(!actionIds.contains(actionId), message);
                actionIds.add(actionId);
            }
        }

        private Action(@NonNull String id2, @NonNull CharSequence label, @NonNull PendingIntent pendingIntent, boolean willResolve, @Nullable CharSequence successMessage, @Nullable ConfirmationDialogDetails confirmationDialogDetails) {
            this.mId = id2;
            this.mLabel = label;
            this.mPendingIntent = pendingIntent;
            this.mWillResolve = willResolve;
            this.mSuccessMessage = successMessage;
            this.mConfirmationDialogDetails = confirmationDialogDetails;
        }

        @NonNull
        public String getId() {
            return this.mId;
        }

        @NonNull
        public CharSequence getLabel() {
            return this.mLabel;
        }

        @NonNull
        public PendingIntent getPendingIntent() {
            return this.mPendingIntent;
        }

        public boolean willResolve() {
            return this.mWillResolve;
        }

        @Nullable
        public CharSequence getSuccessMessage() {
            return this.mSuccessMessage;
        }

        @Nullable
        @RequiresApi(value=34)
        public ConfirmationDialogDetails getConfirmationDialogDetails() {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            return this.mConfirmationDialogDetails;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeString(this.mId);
            TextUtils.writeToParcel(this.mLabel, dest, flags);
            dest.writeTypedObject(this.mPendingIntent, flags);
            dest.writeBoolean(this.mWillResolve);
            TextUtils.writeToParcel(this.mSuccessMessage, dest, flags);
            if (SdkLevel.isAtLeastU()) {
                dest.writeTypedObject(this.mConfirmationDialogDetails, flags);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Action)) {
                return false;
            }
            Action that = (Action)o;
            return this.mId.equals(that.mId) && TextUtils.equals(this.mLabel, that.mLabel) && ((Object)this.mPendingIntent).equals(that.mPendingIntent) && this.mWillResolve == that.mWillResolve && TextUtils.equals(this.mSuccessMessage, that.mSuccessMessage) && Objects.equals(this.mConfirmationDialogDetails, that.mConfirmationDialogDetails);
        }

        public int hashCode() {
            return Objects.hash(this.mId, this.mLabel, this.mPendingIntent, this.mWillResolve, this.mSuccessMessage, this.mConfirmationDialogDetails);
        }

        public String toString() {
            return "Action{mId=" + this.mId + ", mLabel=" + this.mLabel + ", mPendingIntent=" + this.mPendingIntent + ", mWillResolve=" + this.mWillResolve + ", mSuccessMessage=" + this.mSuccessMessage + ", mConfirmationDialogDetails=" + this.mConfirmationDialogDetails + '}';
        }

        @RequiresApi(value=34)
        public static class ConfirmationDialogDetails
        implements Parcelable {
            @NonNull
            public static final Parcelable.Creator<ConfirmationDialogDetails> CREATOR = new Parcelable.Creator<ConfirmationDialogDetails>(){

                @Override
                public ConfirmationDialogDetails createFromParcel(Parcel in) {
                    CharSequence title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                    CharSequence text = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                    CharSequence acceptButtonText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                    CharSequence denyButtonText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                    return new ConfirmationDialogDetails(title, text, acceptButtonText, denyButtonText);
                }

                public ConfirmationDialogDetails[] newArray(int size) {
                    return new ConfirmationDialogDetails[size];
                }
            };
            @NonNull
            private final CharSequence mTitle;
            @NonNull
            private final CharSequence mText;
            @NonNull
            private final CharSequence mAcceptButtonText;
            @NonNull
            private final CharSequence mDenyButtonText;

            public ConfirmationDialogDetails(@NonNull CharSequence title, @NonNull CharSequence text, @NonNull CharSequence acceptButtonText, @NonNull CharSequence denyButtonText) {
                this.mTitle = Objects.requireNonNull(title);
                this.mText = Objects.requireNonNull(text);
                this.mAcceptButtonText = Objects.requireNonNull(acceptButtonText);
                this.mDenyButtonText = Objects.requireNonNull(denyButtonText);
            }

            @NonNull
            public CharSequence getTitle() {
                return this.mTitle;
            }

            @NonNull
            public CharSequence getText() {
                return this.mText;
            }

            @NonNull
            public CharSequence getAcceptButtonText() {
                return this.mAcceptButtonText;
            }

            @NonNull
            public CharSequence getDenyButtonText() {
                return this.mDenyButtonText;
            }

            @Override
            public int describeContents() {
                return 0;
            }

            @Override
            public void writeToParcel(@NonNull Parcel dest, int flags) {
                TextUtils.writeToParcel(this.mTitle, dest, flags);
                TextUtils.writeToParcel(this.mText, dest, flags);
                TextUtils.writeToParcel(this.mAcceptButtonText, dest, flags);
                TextUtils.writeToParcel(this.mDenyButtonText, dest, flags);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof ConfirmationDialogDetails)) {
                    return false;
                }
                ConfirmationDialogDetails that = (ConfirmationDialogDetails)o;
                return TextUtils.equals(this.mTitle, that.mTitle) && TextUtils.equals(this.mText, that.mText) && TextUtils.equals(this.mAcceptButtonText, that.mAcceptButtonText) && TextUtils.equals(this.mDenyButtonText, that.mDenyButtonText);
            }

            public int hashCode() {
                return Objects.hash(this.mTitle, this.mText, this.mAcceptButtonText, this.mDenyButtonText);
            }

            public String toString() {
                return "ConfirmationDialogDetails{mTitle=" + this.mTitle + ", mText=" + this.mText + ", mAcceptButtonText=" + this.mAcceptButtonText + ", mDenyButtonText=" + this.mDenyButtonText + '}';
            }
        }

        public static class Builder {
            @NonNull
            private final String mId;
            @NonNull
            private final CharSequence mLabel;
            @NonNull
            private final PendingIntent mPendingIntent;
            private boolean mWillResolve = false;
            @Nullable
            private CharSequence mSuccessMessage;
            @Nullable
            private ConfirmationDialogDetails mConfirmationDialogDetails;

            public Builder(@NonNull String id2, @NonNull CharSequence label, @NonNull PendingIntent pendingIntent) {
                this.mId = Objects.requireNonNull(id2);
                this.mLabel = Objects.requireNonNull(label);
                this.mPendingIntent = Objects.requireNonNull(pendingIntent);
            }

            @RequiresApi(value=34)
            public Builder(@NonNull Action action) {
                if (!SdkLevel.isAtLeastU()) {
                    throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
                }
                Objects.requireNonNull(action);
                this.mId = action.mId;
                this.mLabel = action.mLabel;
                this.mPendingIntent = action.mPendingIntent;
                this.mWillResolve = action.mWillResolve;
                this.mSuccessMessage = action.mSuccessMessage;
                this.mConfirmationDialogDetails = action.mConfirmationDialogDetails;
            }

            @SuppressLint(value={"MissingGetterMatchingBuilder"})
            @NonNull
            public Builder setWillResolve(boolean willResolve) {
                this.mWillResolve = willResolve;
                return this;
            }

            @NonNull
            public Builder setSuccessMessage(@Nullable CharSequence successMessage) {
                this.mSuccessMessage = successMessage;
                return this;
            }

            @NonNull
            @RequiresApi(value=34)
            public Builder setConfirmationDialogDetails(@Nullable ConfirmationDialogDetails confirmationDialogDetails) {
                if (!SdkLevel.isAtLeastU()) {
                    throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
                }
                this.mConfirmationDialogDetails = confirmationDialogDetails;
                return this;
            }

            @NonNull
            public Action build() {
                if (SdkLevel.isAtLeastU()) {
                    boolean willResolveWithActivity = this.mWillResolve && this.mPendingIntent.isActivity();
                    Preconditions.checkArgument(!willResolveWithActivity, "Launching activity from Action that should resolve the SafetySourceIssue is not allowed. Consider using setting a Confirmation if needed, and either set the willResolve to false or make PendingIntent to start a service/send a broadcast.");
                }
                return new Action(this.mId, this.mLabel, this.mPendingIntent, this.mWillResolve, this.mSuccessMessage, this.mConfirmationDialogDetails);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @TargetApi(value=34)
    public static @interface IssueActionability {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @TargetApi(value=34)
    public static @interface NotificationBehavior {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @TargetApi(value=34)
    public static @interface IssueCategory {
    }
}

