/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.IInstalld;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.security.IFileIntegrityService;
import android.system.ErrnoException;
import com.android.internal.security.VerityUtils;
import java.io.File;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class FileIntegrityManager {
    @NonNull
    private final IFileIntegrityService mService;
    @NonNull
    private final Context mContext;

    public FileIntegrityManager(@NonNull Context context, @NonNull IFileIntegrityService service) {
        this.mContext = context;
        this.mService = service;
    }

    public boolean isApkVeritySupported() {
        return VerityUtils.isFsVeritySupported();
    }

    @SystemApi
    @FlaggedApi(value="android.security.fsverity_api")
    @SuppressLint(value={"StreamFiles"})
    public void setupFsVerity(@NonNull File file) throws IOException {
        IInstalld.IFsveritySetupAuthToken authToken;
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("Expect an absolute path");
        }
        try (ParcelFileDescriptor authFd = ParcelFileDescriptor.open(file, 0x30000000);){
            authToken = this.mService.createAuthToken(authFd);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        try {
            int errno = this.mService.setupFsverity(authToken, file.getPath(), this.mContext.getPackageName());
            if (errno != 0) {
                new ErrnoException("setupFsVerity", errno).rethrowAsIOException();
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="android.security.fsverity_api")
    @SuppressLint(value={"StreamFiles"})
    @Nullable
    public byte[] getFsVerityDigest(@NonNull File file) throws IOException {
        return VerityUtils.getFsverityDigest(file.getPath());
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.INSTALL_PACKAGES", "android.permission.REQUEST_INSTALL_PACKAGES"})
    public boolean isAppSourceCertificateTrusted(@NonNull X509Certificate certificate) throws CertificateEncodingException {
        return false;
    }
}

