/*
 * Decompiled with CFR 0.152.
 */
package android.security.authenticationpolicy;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.os.UserHandle;
import android.proximity.IProximityResultCallback;
import android.security.authenticationpolicy.DisableSecureLockDeviceParams;
import android.security.authenticationpolicy.EnableSecureLockDeviceParams;
import android.security.authenticationpolicy.ISecureLockDeviceStatusListener;

public interface IAuthenticationPolicyService
extends IInterface {
    public static final String DESCRIPTOR = "android.security.authenticationpolicy.IAuthenticationPolicyService";

    @EnforcePermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    public int enableSecureLockDevice(UserHandle var1, EnableSecureLockDeviceParams var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    public int disableSecureLockDevice(UserHandle var1, DisableSecureLockDeviceParams var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    public int isSecureLockDeviceAvailable(UserHandle var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    public boolean isSecureLockDeviceEnabled() throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    public void registerSecureLockDeviceStatusListener(UserHandle var1, ISecureLockDeviceStatusListener var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    public void unregisterSecureLockDeviceStatusListener(ISecureLockDeviceStatusListener var1) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void startWatchRangingForIdentityCheck(long var1, IProximityResultCallback var3) throws RemoteException;

    @EnforcePermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void cancelWatchRangingForRequestId(long var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAuthenticationPolicyService {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_enableSecureLockDevice = 1;
        static final int TRANSACTION_disableSecureLockDevice = 2;
        static final int TRANSACTION_isSecureLockDeviceAvailable = 3;
        static final int TRANSACTION_isSecureLockDeviceEnabled = 4;
        static final int TRANSACTION_registerSecureLockDeviceStatusListener = 5;
        static final int TRANSACTION_unregisterSecureLockDeviceStatusListener = 6;
        static final int TRANSACTION_startWatchRangingForIdentityCheck = 7;
        static final int TRANSACTION_cancelWatchRangingForRequestId = 8;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IAuthenticationPolicyService.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IAuthenticationPolicyService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAuthenticationPolicyService.DESCRIPTOR);
            if (iin != null && iin instanceof IAuthenticationPolicyService) {
                return (IAuthenticationPolicyService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "enableSecureLockDevice";
                }
                case 2: {
                    return "disableSecureLockDevice";
                }
                case 3: {
                    return "isSecureLockDeviceAvailable";
                }
                case 4: {
                    return "isSecureLockDeviceEnabled";
                }
                case 5: {
                    return "registerSecureLockDeviceStatusListener";
                }
                case 6: {
                    return "unregisterSecureLockDeviceStatusListener";
                }
                case 7: {
                    return "startWatchRangingForIdentityCheck";
                }
                case 8: {
                    return "cancelWatchRangingForRequestId";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAuthenticationPolicyService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    EnableSecureLockDeviceParams _arg1 = data.readTypedObject(EnableSecureLockDeviceParams.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.enableSecureLockDevice(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    DisableSecureLockDeviceParams _arg1 = data.readTypedObject(DisableSecureLockDeviceParams.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.disableSecureLockDevice(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 3: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.isSecureLockDeviceAvailable(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 4: {
                    boolean _result = this.isSecureLockDeviceEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    ISecureLockDeviceStatusListener _arg1 = ISecureLockDeviceStatusListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerSecureLockDeviceStatusListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    ISecureLockDeviceStatusListener _arg0 = ISecureLockDeviceStatusListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterSecureLockDeviceStatusListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    long _arg0 = data.readLong();
                    IProximityResultCallback _arg1 = IProximityResultCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startWatchRangingForIdentityCheck(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.cancelWatchRangingForRequestId(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void enableSecureLockDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_SECURE_LOCK_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void disableSecureLockDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_SECURE_LOCK_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isSecureLockDeviceAvailable_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_SECURE_LOCK_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isSecureLockDeviceEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_SECURE_LOCK_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerSecureLockDeviceStatusListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_SECURE_LOCK_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterSecureLockDeviceStatusListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_SECURE_LOCK_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void startWatchRangingForIdentityCheck_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void cancelWatchRangingForRequestId_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.USE_BIOMETRIC_INTERNAL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements IAuthenticationPolicyService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAuthenticationPolicyService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int enableSecureLockDevice(UserHandle user, EnableSecureLockDeviceParams params) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthenticationPolicyService.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int disableSecureLockDevice(UserHandle user, DisableSecureLockDeviceParams params) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthenticationPolicyService.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int isSecureLockDeviceAvailable(UserHandle user) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthenticationPolicyService.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSecureLockDeviceEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthenticationPolicyService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSecureLockDeviceStatusListener(UserHandle user, ISecureLockDeviceStatusListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthenticationPolicyService.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSecureLockDeviceStatusListener(ISecureLockDeviceStatusListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthenticationPolicyService.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWatchRangingForIdentityCheck(long authenticationRequestId, IProximityResultCallback resultCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthenticationPolicyService.DESCRIPTOR);
                    _data.writeLong(authenticationRequestId);
                    _data.writeStrongInterface(resultCallback);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelWatchRangingForRequestId(long authenticationRequestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthenticationPolicyService.DESCRIPTOR);
                    _data.writeLong(authenticationRequestId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAuthenticationPolicyService {
        @Override
        public int enableSecureLockDevice(UserHandle user, EnableSecureLockDeviceParams params) throws RemoteException {
            return 0;
        }

        @Override
        public int disableSecureLockDevice(UserHandle user, DisableSecureLockDeviceParams params) throws RemoteException {
            return 0;
        }

        @Override
        public int isSecureLockDeviceAvailable(UserHandle user) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isSecureLockDeviceEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void registerSecureLockDeviceStatusListener(UserHandle user, ISecureLockDeviceStatusListener listener) throws RemoteException {
        }

        @Override
        public void unregisterSecureLockDeviceStatusListener(ISecureLockDeviceStatusListener listener) throws RemoteException {
        }

        @Override
        public void startWatchRangingForIdentityCheck(long authenticationRequestId, IProximityResultCallback resultCallback) throws RemoteException {
        }

        @Override
        public void cancelWatchRangingForRequestId(long authenticationRequestId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

