/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore2;

import android.annotation.NonNull;
import android.security.KeyStoreSecurityLevel;
import android.security.keystore2.AndroidKeyStorePrivateKey;
import android.security.keystore2.AndroidKeyStorePublicKey;
import android.security.keystore2.AndroidKeyStoreXDHPrivateKey;
import android.system.keystore2.KeyDescriptor;
import android.system.keystore2.KeyMetadata;
import java.math.BigInteger;
import java.security.interfaces.XECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.NamedParameterSpec;
import java.util.Arrays;

public class AndroidKeyStoreXDHPublicKey
extends AndroidKeyStorePublicKey
implements XECPublicKey {
    private static final byte[] X509_PREAMBLE = new byte[]{48, 42, 48, 5, 6, 3, 43, 101, 110, 3, 33, 0};
    private static final byte[] X509_PREAMBLE_WITH_NULL = new byte[]{48, 44, 48, 7, 6, 3, 43, 101, 110, 5, 0, 3, 33, 0};
    private static final int X25519_KEY_SIZE_BYTES = 32;
    private final byte[] mEncodedKey;
    private final int mPreambleLength;

    public AndroidKeyStoreXDHPublicKey(@NonNull KeyDescriptor descriptor, @NonNull KeyMetadata metadata, @NonNull String algorithm, @NonNull KeyStoreSecurityLevel iSecurityLevel, @NonNull byte[] encodedKey) {
        super(descriptor, metadata, encodedKey, algorithm, iSecurityLevel);
        this.mEncodedKey = encodedKey;
        if (this.mEncodedKey == null) {
            throw new IllegalArgumentException("empty encoded key.");
        }
        this.mPreambleLength = AndroidKeyStoreXDHPublicKey.matchesPreamble(X509_PREAMBLE, this.mEncodedKey) | AndroidKeyStoreXDHPublicKey.matchesPreamble(X509_PREAMBLE_WITH_NULL, this.mEncodedKey);
        if (this.mPreambleLength == 0) {
            throw new IllegalArgumentException("Key size is not correct size");
        }
    }

    private static int matchesPreamble(byte[] preamble, byte[] encoded) {
        if (encoded.length != preamble.length + 32) {
            return 0;
        }
        if (Arrays.compare(preamble, 0, preamble.length, encoded, 0, preamble.length) != 0) {
            return 0;
        }
        return preamble.length;
    }

    @Override
    AndroidKeyStorePrivateKey getPrivateKey() {
        return new AndroidKeyStoreXDHPrivateKey(this.getUserKeyDescriptor(), this.getKeyIdDescriptor().nspace, this.getAuthorizations(), "XDH", this.getSecurityLevel());
    }

    @Override
    public BigInteger getU() {
        return new BigInteger(Arrays.copyOfRange(this.mEncodedKey, this.mPreambleLength, this.mEncodedKey.length));
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.mEncodedKey.clone();
    }

    @Override
    public String getAlgorithm() {
        return "XDH";
    }

    @Override
    public String getFormat() {
        return "x.509";
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return NamedParameterSpec.X25519;
    }
}

