/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.security.net.config.ConfigSource;
import android.security.net.config.Domain;
import android.security.net.config.NetworkSecurityConfig;
import android.security.net.config.XmlConfigSource;
import android.util.Pair;
import java.util.Set;

public class ManifestConfigSource
implements ConfigSource {
    private static final boolean DBG = false;
    private static final String LOG_TAG = "NetworkSecurityConfig";
    private final Object mLock = new Object();
    private final Context mContext;
    private final ApplicationInfo mApplicationInfo;
    private ConfigSource mConfigSource;

    public ManifestConfigSource(Context context) {
        this.mContext = context;
        this.mApplicationInfo = new ApplicationInfo(context.getApplicationInfo());
    }

    @Override
    public Set<Pair<Domain, NetworkSecurityConfig>> getPerDomainConfigs() {
        return this.getConfigSource().getPerDomainConfigs();
    }

    @Override
    public NetworkSecurityConfig getDefaultConfig() {
        return this.getConfigSource().getDefaultConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigSource getConfigSource() {
        Object object = this.mLock;
        synchronized (object) {
            ConfigSource source;
            if (this.mConfigSource != null) {
                return this.mConfigSource;
            }
            int configResource = this.mApplicationInfo.networkSecurityConfigRes;
            if (configResource != 0) {
                boolean debugBuild = (this.mApplicationInfo.flags & 2) != 0;
                source = new XmlConfigSource(this.mContext, configResource, this.mApplicationInfo);
            } else {
                boolean usesCleartextTraffic = (this.mApplicationInfo.flags & 0x8000000) != 0 && !this.mApplicationInfo.isInstantApp();
                source = new DefaultConfigSource(usesCleartextTraffic, this.mApplicationInfo);
            }
            this.mConfigSource = source;
            return this.mConfigSource;
        }
    }

    private static class DefaultConfigSource
    implements ConfigSource {
        private final NetworkSecurityConfig mDefaultConfig;

        DefaultConfigSource(boolean usesCleartextTraffic, ApplicationInfo info) {
            this.mDefaultConfig = NetworkSecurityConfig.getDefaultBuilder(info).setCleartextTrafficPermitted(usesCleartextTraffic).build();
        }

        @Override
        public NetworkSecurityConfig getDefaultConfig() {
            return this.mDefaultConfig;
        }

        @Override
        public Set<Pair<Domain, NetworkSecurityConfig>> getPerDomainConfigs() {
            return null;
        }
    }
}

