/*
 * Decompiled with CFR 0.152.
 */
package android.service.chooser;

import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IChooserController
extends IInterface {
    public static final String DESCRIPTOR = "android.service.chooser.IChooserController";

    public void updateIntent(Intent var1) throws RemoteException;

    public void collapse() throws RemoteException;

    public void setTargetsEnabled(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IChooserController {
        static final int TRANSACTION_updateIntent = 1;
        static final int TRANSACTION_collapse = 2;
        static final int TRANSACTION_setTargetsEnabled = 3;

        public Stub() {
            this.attachInterface(this, IChooserController.DESCRIPTOR);
        }

        public static IChooserController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IChooserController.DESCRIPTOR);
            if (iin != null && iin instanceof IChooserController) {
                return (IChooserController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "updateIntent";
                }
                case 2: {
                    return "collapse";
                }
                case 3: {
                    return "setTargetsEnabled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IChooserController.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    Intent _arg0 = data.readTypedObject(Intent.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateIntent(_arg0);
                    break;
                }
                case 2: {
                    this.collapse();
                    break;
                }
                case 3: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setTargetsEnabled(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IChooserController {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IChooserController.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateIntent(Intent intent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IChooserController.DESCRIPTOR);
                    _data.writeTypedObject(intent, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void collapse() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IChooserController.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTargetsEnabled(boolean isEnabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IChooserController.DESCRIPTOR);
                    _data.writeBoolean(isEnabled);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IChooserController {
        @Override
        public void updateIntent(Intent intent) throws RemoteException {
        }

        @Override
        public void collapse() throws RemoteException {
        }

        @Override
        public void setTargetsEnabled(boolean isEnabled) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

