/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

public class RateEstimator {
    private static final double RATE_ALPHA = 0.7;
    private static final double MINIMUM_DT = 5.0E-4;
    private Long mLastEventTime;
    private double mInterarrivalTime = 1000.0;

    public void update(long now) {
        if (this.mLastEventTime != null) {
            this.mInterarrivalTime = this.getInterarrivalEstimate(now);
        }
        this.mLastEventTime = now;
    }

    public float getRate(long now) {
        if (this.mLastEventTime == null) {
            return 0.0f;
        }
        return (float)(1.0 / this.getInterarrivalEstimate(now));
    }

    private double getInterarrivalEstimate(long now) {
        double dt = (double)(now - this.mLastEventTime) / 1000.0;
        dt = Math.max(dt, 5.0E-4);
        return 0.7 * this.mInterarrivalTime + 0.30000000000000004 * dt;
    }
}

