/*
 * Decompiled with CFR 0.152.
 */
package android.service.oemlock;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;

public interface IOemLockService
extends IInterface {
    @EnforcePermission(value="android.permission.MANAGE_CARRIER_OEM_UNLOCK_STATE")
    public String getLockName() throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_CARRIER_OEM_UNLOCK_STATE")
    public void setOemUnlockAllowedByCarrier(boolean var1, byte[] var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_CARRIER_OEM_UNLOCK_STATE")
    public boolean isOemUnlockAllowedByCarrier() throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_USER_OEM_UNLOCK_STATE")
    public void setOemUnlockAllowedByUser(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_USER_OEM_UNLOCK_STATE")
    public boolean isOemUnlockAllowedByUser() throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.READ_OEM_UNLOCK_STATE", "android.permission.OEM_UNLOCK_STATE"})
    public boolean isOemUnlockAllowed() throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.READ_OEM_UNLOCK_STATE", "android.permission.OEM_UNLOCK_STATE"})
    public boolean isDeviceOemUnlocked() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOemLockService {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.service.oemlock.IOemLockService";
        static final int TRANSACTION_getLockName = 1;
        static final int TRANSACTION_setOemUnlockAllowedByCarrier = 2;
        static final int TRANSACTION_isOemUnlockAllowedByCarrier = 3;
        static final int TRANSACTION_setOemUnlockAllowedByUser = 4;
        static final int TRANSACTION_isOemUnlockAllowedByUser = 5;
        static final int TRANSACTION_isOemUnlockAllowed = 6;
        static final String[] PERMISSIONS_isOemUnlockAllowed = new String[]{"android.permission.READ_OEM_UNLOCK_STATE", "android.permission.OEM_UNLOCK_STATE"};
        static final int TRANSACTION_isDeviceOemUnlocked = 7;
        static final String[] PERMISSIONS_isDeviceOemUnlocked = new String[]{"android.permission.READ_OEM_UNLOCK_STATE", "android.permission.OEM_UNLOCK_STATE"};

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IOemLockService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IOemLockService) {
                return (IOemLockService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getLockName";
                }
                case 2: {
                    return "setOemUnlockAllowedByCarrier";
                }
                case 3: {
                    return "isOemUnlockAllowedByCarrier";
                }
                case 4: {
                    return "setOemUnlockAllowedByUser";
                }
                case 5: {
                    return "isOemUnlockAllowedByUser";
                }
                case 6: {
                    return "isOemUnlockAllowed";
                }
                case 7: {
                    return "isDeviceOemUnlocked";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _result = this.getLockName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 2: {
                    boolean _arg0 = data.readBoolean();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.setOemUnlockAllowedByCarrier(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    boolean _result = this.isOemUnlockAllowedByCarrier();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setOemUnlockAllowedByUser(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    boolean _result = this.isOemUnlockAllowedByUser();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    boolean _result = this.isOemUnlockAllowed();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    boolean _result = this.isDeviceOemUnlocked();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void getLockName_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_CARRIER_OEM_UNLOCK_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setOemUnlockAllowedByCarrier_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_CARRIER_OEM_UNLOCK_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isOemUnlockAllowedByCarrier_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_CARRIER_OEM_UNLOCK_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setOemUnlockAllowedByUser_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_USER_OEM_UNLOCK_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isOemUnlockAllowedByUser_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_USER_OEM_UNLOCK_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isOemUnlockAllowed_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_isOemUnlockAllowed, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isDeviceOemUnlocked_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_isDeviceOemUnlocked, Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IOemLockService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getLockName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOemUnlockAllowedByCarrier(boolean allowed, byte[] signature) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(allowed);
                    _data.writeByteArray(signature);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isOemUnlockAllowedByCarrier() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOemUnlockAllowedByUser(boolean allowed) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(allowed);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isOemUnlockAllowedByUser() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isOemUnlockAllowed() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDeviceOemUnlocked() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IOemLockService {
        @Override
        public String getLockName() throws RemoteException {
            return null;
        }

        @Override
        public void setOemUnlockAllowedByCarrier(boolean allowed, byte[] signature) throws RemoteException {
        }

        @Override
        public boolean isOemUnlockAllowedByCarrier() throws RemoteException {
            return false;
        }

        @Override
        public void setOemUnlockAllowedByUser(boolean allowed) throws RemoteException {
        }

        @Override
        public boolean isOemUnlockAllowedByUser() throws RemoteException {
            return false;
        }

        @Override
        public boolean isOemUnlockAllowed() throws RemoteException {
            return false;
        }

        @Override
        public boolean isDeviceOemUnlocked() throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

