/*
 * Decompiled with CFR 0.152.
 */
package android.service.textclassifier;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.service.textclassifier.ITextClassifierCallback;
import android.view.textclassifier.ConversationActions;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationSessionId;
import android.view.textclassifier.TextClassifierEvent;
import android.view.textclassifier.TextLanguage;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;

public interface ITextClassifierService
extends IInterface {
    public void onSuggestSelection(TextClassificationSessionId var1, TextSelection.Request var2, ITextClassifierCallback var3) throws RemoteException;

    public void onClassifyText(TextClassificationSessionId var1, TextClassification.Request var2, ITextClassifierCallback var3) throws RemoteException;

    public void onGenerateLinks(TextClassificationSessionId var1, TextLinks.Request var2, ITextClassifierCallback var3) throws RemoteException;

    public void onSelectionEvent(TextClassificationSessionId var1, SelectionEvent var2) throws RemoteException;

    public void onTextClassifierEvent(TextClassificationSessionId var1, TextClassifierEvent var2) throws RemoteException;

    public void onCreateTextClassificationSession(TextClassificationContext var1, TextClassificationSessionId var2) throws RemoteException;

    public void onDestroyTextClassificationSession(TextClassificationSessionId var1) throws RemoteException;

    public void onDetectLanguage(TextClassificationSessionId var1, TextLanguage.Request var2, ITextClassifierCallback var3) throws RemoteException;

    public void onSuggestConversationActions(TextClassificationSessionId var1, ConversationActions.Request var2, ITextClassifierCallback var3) throws RemoteException;

    public void onConnectedStateChanged(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITextClassifierService {
        public static final String DESCRIPTOR = "android.service.textclassifier.ITextClassifierService";
        static final int TRANSACTION_onSuggestSelection = 1;
        static final int TRANSACTION_onClassifyText = 2;
        static final int TRANSACTION_onGenerateLinks = 3;
        static final int TRANSACTION_onSelectionEvent = 4;
        static final int TRANSACTION_onTextClassifierEvent = 5;
        static final int TRANSACTION_onCreateTextClassificationSession = 6;
        static final int TRANSACTION_onDestroyTextClassificationSession = 7;
        static final int TRANSACTION_onDetectLanguage = 8;
        static final int TRANSACTION_onSuggestConversationActions = 9;
        static final int TRANSACTION_onConnectedStateChanged = 10;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITextClassifierService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITextClassifierService) {
                return (ITextClassifierService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSuggestSelection";
                }
                case 2: {
                    return "onClassifyText";
                }
                case 3: {
                    return "onGenerateLinks";
                }
                case 4: {
                    return "onSelectionEvent";
                }
                case 5: {
                    return "onTextClassifierEvent";
                }
                case 6: {
                    return "onCreateTextClassificationSession";
                }
                case 7: {
                    return "onDestroyTextClassificationSession";
                }
                case 8: {
                    return "onDetectLanguage";
                }
                case 9: {
                    return "onSuggestConversationActions";
                }
                case 10: {
                    return "onConnectedStateChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    TextClassificationSessionId _arg0 = data.readTypedObject(TextClassificationSessionId.CREATOR);
                    TextSelection.Request _arg1 = data.readTypedObject(TextSelection.Request.CREATOR);
                    ITextClassifierCallback _arg2 = ITextClassifierCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onSuggestSelection(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    TextClassificationSessionId _arg0 = data.readTypedObject(TextClassificationSessionId.CREATOR);
                    TextClassification.Request _arg1 = data.readTypedObject(TextClassification.Request.CREATOR);
                    ITextClassifierCallback _arg2 = ITextClassifierCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onClassifyText(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    TextClassificationSessionId _arg0 = data.readTypedObject(TextClassificationSessionId.CREATOR);
                    TextLinks.Request _arg1 = data.readTypedObject(TextLinks.Request.CREATOR);
                    ITextClassifierCallback _arg2 = ITextClassifierCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onGenerateLinks(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    TextClassificationSessionId _arg0 = data.readTypedObject(TextClassificationSessionId.CREATOR);
                    SelectionEvent _arg1 = data.readTypedObject(SelectionEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSelectionEvent(_arg0, _arg1);
                    break;
                }
                case 5: {
                    TextClassificationSessionId _arg0 = data.readTypedObject(TextClassificationSessionId.CREATOR);
                    TextClassifierEvent _arg1 = data.readTypedObject(TextClassifierEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTextClassifierEvent(_arg0, _arg1);
                    break;
                }
                case 6: {
                    TextClassificationContext _arg0 = data.readTypedObject(TextClassificationContext.CREATOR);
                    TextClassificationSessionId _arg1 = data.readTypedObject(TextClassificationSessionId.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCreateTextClassificationSession(_arg0, _arg1);
                    break;
                }
                case 7: {
                    TextClassificationSessionId _arg0 = data.readTypedObject(TextClassificationSessionId.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDestroyTextClassificationSession(_arg0);
                    break;
                }
                case 8: {
                    TextClassificationSessionId _arg0 = data.readTypedObject(TextClassificationSessionId.CREATOR);
                    TextLanguage.Request _arg1 = data.readTypedObject(TextLanguage.Request.CREATOR);
                    ITextClassifierCallback _arg2 = ITextClassifierCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onDetectLanguage(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    TextClassificationSessionId _arg0 = data.readTypedObject(TextClassificationSessionId.CREATOR);
                    ConversationActions.Request _arg1 = data.readTypedObject(ConversationActions.Request.CREATOR);
                    ITextClassifierCallback _arg2 = ITextClassifierCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onSuggestConversationActions(_arg0, _arg1, _arg2);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onConnectedStateChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 9;
        }

        private static class Proxy
        implements ITextClassifierService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuggestSelection(TextClassificationSessionId sessionId, TextSelection.Request request, ITextClassifierCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onClassifyText(TextClassificationSessionId sessionId, TextClassification.Request request, ITextClassifierCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGenerateLinks(TextClassificationSessionId sessionId, TextLinks.Request request, ITextClassifierCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSelectionEvent(TextClassificationSessionId sessionId, SelectionEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeTypedObject(event, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTextClassifierEvent(TextClassificationSessionId sessionId, TextClassifierEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeTypedObject(event, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCreateTextClassificationSession(TextClassificationContext context, TextClassificationSessionId sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(context, 0);
                    _data.writeTypedObject(sessionId, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDestroyTextClassificationSession(TextClassificationSessionId sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDetectLanguage(TextClassificationSessionId sessionId, TextLanguage.Request request, ITextClassifierCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuggestConversationActions(TextClassificationSessionId sessionId, ConversationActions.Request request, ITextClassifierCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectedStateChanged(int connected) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(connected);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITextClassifierService {
        @Override
        public void onSuggestSelection(TextClassificationSessionId sessionId, TextSelection.Request request, ITextClassifierCallback callback) throws RemoteException {
        }

        @Override
        public void onClassifyText(TextClassificationSessionId sessionId, TextClassification.Request request, ITextClassifierCallback callback) throws RemoteException {
        }

        @Override
        public void onGenerateLinks(TextClassificationSessionId sessionId, TextLinks.Request request, ITextClassifierCallback callback) throws RemoteException {
        }

        @Override
        public void onSelectionEvent(TextClassificationSessionId sessionId, SelectionEvent event) throws RemoteException {
        }

        @Override
        public void onTextClassifierEvent(TextClassificationSessionId sessionId, TextClassifierEvent event) throws RemoteException {
        }

        @Override
        public void onCreateTextClassificationSession(TextClassificationContext context, TextClassificationSessionId sessionId) throws RemoteException {
        }

        @Override
        public void onDestroyTextClassificationSession(TextClassificationSessionId sessionId) throws RemoteException {
        }

        @Override
        public void onDetectLanguage(TextClassificationSessionId sessionId, TextLanguage.Request request, ITextClassifierCallback callback) throws RemoteException {
        }

        @Override
        public void onSuggestConversationActions(TextClassificationSessionId sessionId, ConversationActions.Request request, ITextClassifierCallback callback) throws RemoteException {
        }

        @Override
        public void onConnectedStateChanged(int connected) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

