/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class HotwordRejectedResult
implements Parcelable {
    public static final int CONFIDENCE_LEVEL_NONE = 0;
    public static final int CONFIDENCE_LEVEL_LOW = 1;
    public static final int CONFIDENCE_LEVEL_MEDIUM = 2;
    public static final int CONFIDENCE_LEVEL_HIGH = 3;
    @FlaggedApi(value="android.service.voice.flags.allow_hotword_bump_egress")
    public static final int CONFIDENCE_LEVEL_VERY_HIGH = 4;
    private final int mConfidenceLevel;
    @NonNull
    public static final Parcelable.Creator<HotwordRejectedResult> CREATOR = new Parcelable.Creator<HotwordRejectedResult>(){

        public HotwordRejectedResult[] newArray(int size) {
            return new HotwordRejectedResult[size];
        }

        @Override
        public HotwordRejectedResult createFromParcel(@NonNull Parcel in) {
            return new HotwordRejectedResult(in);
        }
    };

    private static int defaultConfidenceLevel() {
        return 0;
    }

    public static String confidenceLevelToString(int value) {
        switch (value) {
            case 0: {
                return "CONFIDENCE_LEVEL_NONE";
            }
            case 1: {
                return "CONFIDENCE_LEVEL_LOW";
            }
            case 2: {
                return "CONFIDENCE_LEVEL_MEDIUM";
            }
            case 3: {
                return "CONFIDENCE_LEVEL_HIGH";
            }
            case 4: {
                return "CONFIDENCE_LEVEL_VERY_HIGH";
            }
        }
        return Integer.toHexString(value);
    }

    HotwordRejectedResult(int confidenceLevel) {
        this.mConfidenceLevel = confidenceLevel;
        AnnotationValidations.validate(HotwordConfidenceLevelValue.class, null, this.mConfidenceLevel);
    }

    public int getConfidenceLevel() {
        return this.mConfidenceLevel;
    }

    public String toString() {
        return "HotwordRejectedResult { confidenceLevel = " + this.mConfidenceLevel + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotwordRejectedResult that = (HotwordRejectedResult)o;
        return this.mConfidenceLevel == that.mConfidenceLevel;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mConfidenceLevel;
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mConfidenceLevel);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    HotwordRejectedResult(@NonNull Parcel in) {
        int confidenceLevel;
        this.mConfidenceLevel = confidenceLevel = in.readInt();
        AnnotationValidations.validate(HotwordConfidenceLevelValue.class, null, this.mConfidenceLevel);
    }

    @Deprecated
    private void __metadata() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface HotwordConfidenceLevelValue {
    }

    public static class Builder {
        private int mConfidenceLevel;
        private long mBuilderFieldsSet = 0L;

        @NonNull
        public Builder setConfidenceLevel(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mConfidenceLevel = value;
            return this;
        }

        @NonNull
        public HotwordRejectedResult build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mConfidenceLevel = HotwordRejectedResult.defaultConfidenceLevel();
            }
            HotwordRejectedResult o = new HotwordRejectedResult(this.mConfidenceLevel);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 2L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConfidenceLevel {
    }
}

