/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.annotation.IntRange;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
@SuppressLint(value={"UnflaggedApi"})
public class VisualQueryAttentionResult
implements Parcelable {
    @SuppressLint(value={"UnflaggedApi"})
    public static final int INTERACTION_INTENTION_AUDIO_VISUAL = 0;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int INTERACTION_INTENTION_VISUAL_ACCESSIBILITY = 1;
    private final int mInteractionIntention;
    private final int mEngagementLevel;
    @SuppressLint(value={"UnflaggedApi"})
    @NonNull
    public static final Parcelable.Creator<VisualQueryAttentionResult> CREATOR = new Parcelable.Creator<VisualQueryAttentionResult>(){

        public VisualQueryAttentionResult[] newArray(int size) {
            return new VisualQueryAttentionResult[size];
        }

        @Override
        public VisualQueryAttentionResult createFromParcel(@NonNull Parcel in) {
            return new VisualQueryAttentionResult(in);
        }
    };

    private static int defaultInteractionIntention() {
        return 0;
    }

    private static int defaultEngagementLevel() {
        return 100;
    }

    public Builder buildUpon() {
        return new Builder().setInteractionIntention(this.mInteractionIntention).setEngagementLevel(this.mEngagementLevel);
    }

    public static String interactionIntentionToString(int value) {
        switch (value) {
            case 0: {
                return "INTERACTION_INTENTION_AUDIO_VISUAL";
            }
            case 1: {
                return "INTERACTION_INTENTION_VISUAL_ACCESSIBILITY";
            }
        }
        return Integer.toHexString(value);
    }

    VisualQueryAttentionResult(int interactionIntention, int engagementLevel) {
        this.mInteractionIntention = interactionIntention;
        if (this.mInteractionIntention != 0 && this.mInteractionIntention != 1) {
            throw new IllegalArgumentException("interactionIntention was " + this.mInteractionIntention + " but must be one of: INTERACTION_INTENTION_AUDIO_VISUAL(" + 0 + "), INTERACTION_INTENTION_VISUAL_ACCESSIBILITY(" + 1 + ")");
        }
        this.mEngagementLevel = engagementLevel;
        AnnotationValidations.validate(IntRange.class, null, this.mEngagementLevel, "from", 1L, "to", 100L);
    }

    @SuppressLint(value={"UnflaggedApi"})
    public int getInteractionIntention() {
        return this.mInteractionIntention;
    }

    @SuppressLint(value={"UnflaggedApi"})
    public int getEngagementLevel() {
        return this.mEngagementLevel;
    }

    public String toString() {
        return "VisualQueryAttentionResult { interactionIntention = " + this.mInteractionIntention + ", engagementLevel = " + this.mEngagementLevel + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VisualQueryAttentionResult that = (VisualQueryAttentionResult)o;
        return this.mInteractionIntention == that.mInteractionIntention && this.mEngagementLevel == that.mEngagementLevel;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mInteractionIntention;
        _hash = 31 * _hash + this.mEngagementLevel;
        return _hash;
    }

    @Override
    @SuppressLint(value={"UnflaggedApi"})
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mInteractionIntention);
        dest.writeInt(this.mEngagementLevel);
    }

    @Override
    @SuppressLint(value={"UnflaggedApi"})
    public int describeContents() {
        return 0;
    }

    VisualQueryAttentionResult(@NonNull Parcel in) {
        int interactionIntention = in.readInt();
        int engagementLevel = in.readInt();
        this.mInteractionIntention = interactionIntention;
        if (this.mInteractionIntention != 0 && this.mInteractionIntention != 1) {
            throw new IllegalArgumentException("interactionIntention was " + this.mInteractionIntention + " but must be one of: INTERACTION_INTENTION_AUDIO_VISUAL(" + 0 + "), INTERACTION_INTENTION_VISUAL_ACCESSIBILITY(" + 1 + ")");
        }
        this.mEngagementLevel = engagementLevel;
        AnnotationValidations.validate(IntRange.class, null, this.mEngagementLevel, "from", 1L, "to", 100L);
    }

    @Deprecated
    private void __metadata() {
    }

    @SuppressLint(value={"UnflaggedApi"})
    public static class Builder {
        private int mInteractionIntention;
        private int mEngagementLevel;
        private long mBuilderFieldsSet = 0L;

        @SuppressLint(value={"UnflaggedApi"})
        public Builder() {
        }

        @SuppressLint(value={"UnflaggedApi"})
        @NonNull
        public Builder setInteractionIntention(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mInteractionIntention = value;
            return this;
        }

        @SuppressLint(value={"UnflaggedApi"})
        @NonNull
        public Builder setEngagementLevel(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mEngagementLevel = value;
            return this;
        }

        @SuppressLint(value={"UnflaggedApi"})
        @NonNull
        public VisualQueryAttentionResult build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mInteractionIntention = VisualQueryAttentionResult.defaultInteractionIntention();
            }
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mEngagementLevel = VisualQueryAttentionResult.defaultEngagementLevel();
            }
            VisualQueryAttentionResult o = new VisualQueryAttentionResult(this.mInteractionIntention, this.mEngagementLevel);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 4L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InteractionIntention {
    }
}

