/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.OutcomeReceiver;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.telecom.CallEndpoint;
import android.telecom.CallException;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.text.TextUtils;
import com.android.internal.telecom.ICallControl;
import java.util.Objects;
import java.util.concurrent.Executor;

@SuppressLint(value={"NotCloseable"})
public class CallControl {
    private static final String TAG = CallControl.class.getSimpleName();
    private final String mCallId;
    private final ICallControl mServerInterface;

    public CallControl(@NonNull String callId, @NonNull ICallControl serverInterface) {
        this.mCallId = callId;
        this.mServerInterface = serverInterface;
    }

    @NonNull
    public ParcelUuid getCallId() {
        return ParcelUuid.fromString(this.mCallId);
    }

    public void setActive(@NonNull Executor executor, @NonNull OutcomeReceiver<Void, CallException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mServerInterface.setActive(this.mCallId, new CallControlResultReceiver("setActive", executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void answer(int videoState, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, CallException> callback) {
        this.validateVideoState(videoState);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mServerInterface.answer(videoState, this.mCallId, new CallControlResultReceiver("answer", executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void setInactive(@NonNull Executor executor, @NonNull OutcomeReceiver<Void, CallException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mServerInterface.setInactive(this.mCallId, new CallControlResultReceiver("setInactive", executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void disconnect(@NonNull DisconnectCause disconnectCause, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, CallException> callback) {
        Objects.requireNonNull(disconnectCause);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        this.validateDisconnectCause(disconnectCause);
        try {
            this.mServerInterface.disconnect(this.mCallId, disconnectCause, new CallControlResultReceiver("disconnect", executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void startCallStreaming(@NonNull Executor executor, @NonNull OutcomeReceiver<Void, CallException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mServerInterface.startCallStreaming(this.mCallId, new CallControlResultReceiver("startCallStreaming", executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void requestCallEndpointChange(@NonNull CallEndpoint callEndpoint, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, CallException> callback) {
        Objects.requireNonNull(callEndpoint);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mServerInterface.requestCallEndpointChange(callEndpoint, new CallControlResultReceiver("requestCallEndpointChange", executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @FlaggedApi(value="com.android.server.telecom.flags.set_mute_state")
    public void requestMuteState(boolean isMuted, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, CallException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mServerInterface.setMuteState(isMuted, new CallControlResultReceiver("requestMuteState", executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @FlaggedApi(value="com.android.server.telecom.flags.transactional_video_state")
    public void requestVideoState(int videoState, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, CallException> callback) {
        this.validateVideoState(videoState);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mServerInterface.requestVideoState(videoState, this.mCallId, new CallControlResultReceiver("requestVideoState", executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void sendEvent(@NonNull String event, @NonNull Bundle extras) {
        Objects.requireNonNull(event);
        Objects.requireNonNull(extras);
        try {
            this.mServerInterface.sendEvent(this.mCallId, event, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    private CallException getTransactionException(Bundle resultData) {
        String message = "unknown error";
        if (resultData != null && resultData.containsKey("TelecomTransactionalExceptionKey")) {
            return resultData.getParcelable("TelecomTransactionalExceptionKey", CallException.class);
        }
        return new CallException(message, 1);
    }

    private void validateDisconnectCause(DisconnectCause disconnectCause) {
        int code = disconnectCause.getCode();
        if (code != 2 && code != 3 && code != 5 && code != 6) {
            throw new IllegalArgumentException(TextUtils.formatSimple("The DisconnectCause code provided, %d , is not a valid Disconnect code. Valid DisconnectCause codes are limited to [DisconnectCause.LOCAL, DisconnectCause.REMOTE, DisconnectCause.MISSED, or DisconnectCause.REJECTED]", disconnectCause.getCode()));
        }
    }

    private void validateVideoState(int videoState) {
        if (videoState != 1 && videoState != 2) {
            throw new IllegalArgumentException(TextUtils.formatSimple("The VideoState argument passed in, %d , is not a valid VideoState. The VideoState choices are limited to CallAttributes.AUDIO_CALL orCallAttributes.VIDEO_CALL", videoState));
        }
    }

    private class CallControlResultReceiver
    extends ResultReceiver {
        private final String mCallingMethod;
        private final Executor mExecutor;
        private final OutcomeReceiver<Void, CallException> mClientCallback;

        CallControlResultReceiver(String method, Executor executor, OutcomeReceiver<Void, CallException> clientCallback) {
            super((Handler)null);
            this.mCallingMethod = method;
            this.mExecutor = executor;
            this.mClientCallback = clientCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onReceiveResult(int resultCode, Bundle resultData) {
            Log.d(TAG, "%s: oRR: resultCode=[%s]", this.mCallingMethod, resultCode);
            super.onReceiveResult(resultCode, resultData);
            long identity = Binder.clearCallingIdentity();
            try {
                if (resultCode == 0) {
                    this.mExecutor.execute(() -> this.mClientCallback.onResult(null));
                } else {
                    this.mExecutor.execute(() -> this.mClientCallback.onError(CallControl.this.getTransactionException(resultData)));
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }
}

