/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.annotation.NonNull;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.net.Uri;
import android.os._Original_Build;
import android.telecom.Logging.EventManager;
import android.telecom.Logging.Session;
import android.telecom.Logging.SessionManager;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.IndentingPrintWriter;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.stream.Collectors;

public class Log {
    private static final long EXTENDED_LOGGING_DURATION_MILLIS = 1800000L;
    private static final int EVENTS_TO_CACHE = 10;
    private static final int EVENTS_TO_CACHE_DEBUG = 20;
    private static final int NUM_DIALABLE_DIGITS_TO_LOG = _Original_Build.IS_USER ? 0 : 2;
    @VisibleForTesting
    public static String TAG = "TelecomFramework";
    public static boolean DEBUG = Log.isLoggable(3);
    public static boolean INFO = Log.isLoggable(4);
    public static boolean VERBOSE = Log.isLoggable(2);
    public static boolean WARN = Log.isLoggable(5);
    public static boolean ERROR = Log.isLoggable(6);
    private static final boolean FORCE_LOGGING = false;
    private static final boolean USER_BUILD = _Original_Build.IS_USER;
    private static final Object sSingletonSync = new Object();
    private static EventManager sEventManager;
    private static volatile SessionManager sSessionManager;
    private static Object sLock;
    private static boolean sIsUserExtendedLoggingEnabled;
    private static boolean sIsUnitTestingEnabled;
    private static long sUserExtendedLoggingStopTime;

    private Log() {
    }

    public static void d(String prefix, String format, Object ... args) {
        if (sIsUserExtendedLoggingEnabled) {
            Log.maybeDisableLogging();
            Slog.i(TAG, Log.buildMessage(prefix, format, args));
        } else if (DEBUG) {
            Slog.d(TAG, Log.buildMessage(prefix, format, args));
        }
    }

    public static void d(Object objectPrefix, String format, Object ... args) {
        if (sIsUserExtendedLoggingEnabled) {
            Log.maybeDisableLogging();
            Slog.i(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        } else if (DEBUG) {
            Slog.d(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static void i(String prefix, String format, Object ... args) {
        if (INFO) {
            Slog.i(TAG, Log.buildMessage(prefix, format, args));
        }
    }

    public static void i(Object objectPrefix, String format, Object ... args) {
        if (INFO) {
            Slog.i(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        }
    }

    public static void v(String prefix, String format, Object ... args) {
        if (sIsUserExtendedLoggingEnabled) {
            Log.maybeDisableLogging();
            Slog.i(TAG, Log.buildMessage(prefix, format, args));
        } else if (VERBOSE) {
            Slog.v(TAG, Log.buildMessage(prefix, format, args));
        }
    }

    public static void v(Object objectPrefix, String format, Object ... args) {
        if (sIsUserExtendedLoggingEnabled) {
            Log.maybeDisableLogging();
            Slog.i(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        } else if (VERBOSE) {
            Slog.v(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static void w(String prefix, String format, Object ... args) {
        if (WARN) {
            Slog.w(TAG, Log.buildMessage(prefix, format, args));
        }
    }

    public static void w(Object objectPrefix, String format, Object ... args) {
        if (WARN) {
            Slog.w(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        }
    }

    public static void e(String prefix, Throwable tr, String format, Object ... args) {
        if (ERROR) {
            Slog.e(TAG, Log.buildMessage(prefix, format, args), tr);
        }
    }

    public static void e(Object objectPrefix, Throwable tr, String format, Object ... args) {
        if (ERROR) {
            Slog.e(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args), tr);
        }
    }

    public static void wtf(String prefix, Throwable tr, String format, Object ... args) {
        Slog.wtf(TAG, Log.buildMessage(prefix, format, args), tr);
    }

    public static void wtf(Object objectPrefix, Throwable tr, String format, Object ... args) {
        Slog.wtf(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args), tr);
    }

    public static void wtf(String prefix, String format, Object ... args) {
        String msg = Log.buildMessage(prefix, format, args);
        Slog.wtf(TAG, msg, new IllegalStateException(msg));
    }

    public static void wtf(Object objectPrefix, String format, Object ... args) {
        String msg = Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args);
        Slog.wtf(TAG, msg, new IllegalStateException(msg));
    }

    public static void setSessionContext(Context context) {
        Log.getSessionManager().setContext(context);
    }

    public static void startSession(String shortMethodName) {
        Log.getSessionManager().startSession(shortMethodName, null);
    }

    public static void startSession(Session.Info info, String shortMethodName) {
        Log.getSessionManager().startSession(info, shortMethodName, null);
    }

    public static void startSession(String shortMethodName, String callerIdentification) {
        Log.getSessionManager().startSession(shortMethodName, callerIdentification);
    }

    public static void startSession(Session.Info info, String shortMethodName, String callerIdentification) {
        Log.getSessionManager().startSession(info, shortMethodName, callerIdentification);
    }

    public static Session createSubsession() {
        return Log.getSessionManager().createSubsession();
    }

    public static Session.Info getExternalSession() {
        return Log.getSessionManager().getExternalSession();
    }

    public static Session.Info getExternalSession(@NonNull String ownerInfo) {
        return Log.getSessionManager().getExternalSession(ownerInfo);
    }

    public static void cancelSubsession(Session subsession) {
        Log.getSessionManager().cancelSubsession(subsession);
    }

    public static void continueSession(Session subsession, String shortMethodName) {
        Log.getSessionManager().continueSession(subsession, shortMethodName);
    }

    public static void endSession() {
        Log.getSessionManager().endSession();
    }

    public static void registerSessionListener(SessionManager.ISessionListener l) {
        Log.getSessionManager().registerSessionListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSessionId() {
        Object object = sSingletonSync;
        synchronized (object) {
            if (sSessionManager != null) {
                return Log.getSessionManager().getSessionId();
            }
            return "";
        }
    }

    public static void addEvent(EventManager.Loggable recordEntry, String event) {
        Log.getEventManager().event(recordEntry, event, null);
    }

    public static void addEvent(EventManager.Loggable recordEntry, String event, Object data) {
        Log.getEventManager().event(recordEntry, event, data);
    }

    public static void addEvent(EventManager.Loggable recordEntry, String event, String format, Object ... args) {
        Log.getEventManager().event(recordEntry, event, format, args);
    }

    public static void registerEventListener(EventManager.EventListener e) {
        Log.getEventManager().registerEventListener(e);
    }

    public static void addRequestResponsePair(EventManager.TimedEventPair p) {
        Log.getEventManager().addRequestResponsePair(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpEvents(IndentingPrintWriter pw) {
        Object object = sSingletonSync;
        synchronized (object) {
            if (sEventManager != null) {
                Log.getEventManager().dumpEvents(pw);
            } else {
                pw.println("No Historical Events Logged.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpEventsTimeline(IndentingPrintWriter pw) {
        Object object = sSingletonSync;
        synchronized (object) {
            if (sEventManager != null) {
                Log.getEventManager().dumpEventsTimeline(pw);
            } else {
                pw.println("No Historical Events Logged.");
            }
        }
    }

    public static void setIsExtendedLoggingEnabled(boolean isExtendedLoggingEnabled) {
        if (sIsUserExtendedLoggingEnabled == isExtendedLoggingEnabled) {
            return;
        }
        if (sEventManager != null) {
            sEventManager.changeEventCacheSize(isExtendedLoggingEnabled ? 20 : 10);
        }
        sUserExtendedLoggingStopTime = (sIsUserExtendedLoggingEnabled = isExtendedLoggingEnabled) ? System_Delegate.currentTimeMillis() + 1800000L : 0L;
    }

    public static void setUnitTestingEnabled(boolean isEnabled) {
        sIsUnitTestingEnabled = isEnabled;
    }

    public static boolean isUnitTestingEnabled() {
        return sIsUnitTestingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EventManager getEventManager() {
        if (sEventManager == null) {
            Object object = sSingletonSync;
            synchronized (object) {
                if (sEventManager == null) {
                    sEventManager = new EventManager(Log::getSessionId);
                    return sEventManager;
                }
            }
        }
        return sEventManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static SessionManager getSessionManager() {
        if (sSessionManager == null) {
            Object object = sSingletonSync;
            synchronized (object) {
                if (sSessionManager == null) {
                    sSessionManager = new SessionManager();
                    return sSessionManager;
                }
            }
        }
        return sSessionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static SessionManager setSessionManager(Context context, Runnable cleanSessionRunnable) {
        if (sSessionManager == null) {
            Object object = sSingletonSync;
            synchronized (object) {
                if (sSessionManager == null) {
                    sSessionManager = new SessionManager(cleanSessionRunnable);
                    sSessionManager.setContext(context);
                    return sSessionManager;
                }
            }
        }
        return sSessionManager;
    }

    public static void setTag(String tag) {
        TAG = tag;
        DEBUG = Log.isLoggable(3);
        INFO = Log.isLoggable(4);
        VERBOSE = Log.isLoggable(2);
        WARN = Log.isLoggable(5);
        ERROR = Log.isLoggable(6);
    }

    public static void setLock(Object lock) {
        if (!_Original_Build.IS_USER) {
            sLock = lock;
        }
    }

    private static void maybeDisableLogging() {
        if (!sIsUserExtendedLoggingEnabled) {
            return;
        }
        if (sUserExtendedLoggingStopTime < System_Delegate.currentTimeMillis()) {
            sUserExtendedLoggingStopTime = 0L;
            sIsUserExtendedLoggingEnabled = false;
        }
    }

    public static boolean isLoggable(int level) {
        return android.util.Log.isLoggable(TAG, level);
    }

    public static String piiHandle(Object pii) {
        if (pii == null || VERBOSE) {
            return String.valueOf(pii);
        }
        StringBuilder sb = new StringBuilder();
        if (pii instanceof Uri) {
            Uri uri = (Uri)pii;
            String scheme = uri.getScheme();
            if (!TextUtils.isEmpty(scheme)) {
                sb.append(scheme).append(":");
            }
            String textToObfuscate = uri.getSchemeSpecificPart();
            if ("tel".equals(scheme)) {
                Log.obfuscatePhoneNumber(sb, textToObfuscate);
            } else if ("sip".equals(scheme)) {
                for (int i = 0; i < textToObfuscate.length(); ++i) {
                    int c = textToObfuscate.charAt(i);
                    if (c != 64 && c != 46) {
                        c = 42;
                    }
                    sb.append((char)c);
                }
            } else {
                sb.append(Log.pii(pii));
            }
        } else if (pii instanceof String) {
            String number = (String)pii;
            Log.obfuscatePhoneNumber(sb, number);
        }
        return sb.toString();
    }

    private static void obfuscatePhoneNumber(StringBuilder sb, String phoneNumber) {
        int numDigitsToObfuscate = Log.getDialableCount(phoneNumber) - NUM_DIALABLE_DIGITS_TO_LOG;
        for (int i = 0; i < phoneNumber.length(); ++i) {
            char c = phoneNumber.charAt(i);
            boolean isDialable = PhoneNumberUtils.isDialable(c);
            if (isDialable) {
                --numDigitsToObfuscate;
            }
            sb.append(isDialable && numDigitsToObfuscate >= 0 ? "*" : Character.valueOf(c));
        }
    }

    private static int getDialableCount(String toCount) {
        int numDialable = 0;
        for (char c : toCount.toCharArray()) {
            if (!PhoneNumberUtils.isDialable(c)) continue;
            ++numDialable;
        }
        return numDialable;
    }

    public static String pii(Object pii) {
        if (pii == null || VERBOSE) {
            return String.valueOf(pii);
        }
        return "***";
    }

    private static String getPrefixFromObject(Object obj) {
        return obj == null ? "<null>" : obj.getClass().getSimpleName();
    }

    private static String buildMessage(String prefix, String format, Object ... args) {
        String msg;
        String sessionName = Log.getSessionId();
        String sessionPostfix = TextUtils.isEmpty(sessionName) ? "" : ": " + sessionName;
        try {
            msg = args == null || args.length == 0 ? format : String.format(Locale.US, format, args);
        }
        catch (IllegalFormatException ife) {
            Log.e(TAG, (Throwable)ife, "Log: IllegalFormatException: formatString='%s' numArgs=%d", format, args.length);
            msg = format + " (An error occurred while formatting the message.)";
        }
        String isLocked = sLock != null ? (Thread.holdsLock(sLock) ? "\ud83d\udd12" : "\u2757") : "";
        return String.format(Locale.US, "%s: %s%s%s", prefix, msg, sessionPostfix, isLocked);
    }

    public static String getPackageAbbreviation(ComponentName componentName) {
        if (componentName == null) {
            return "";
        }
        return Log.getPackageAbbreviation(componentName.getPackageName());
    }

    public static String getPackageAbbreviation(String packageName) {
        if (packageName == null) {
            return "";
        }
        return Arrays.stream(packageName.split("\\.")).map(s -> s.length() == 0 ? "" : s.substring(0, 1)).collect(Collectors.joining(""));
    }

    static {
        sLock = null;
        sIsUserExtendedLoggingEnabled = false;
        sIsUnitTestingEnabled = false;
        sUserExtendedLoggingStopTime = 0L;
    }
}

