/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class CellBroadcastIdRange
implements Parcelable {
    private int mStartId;
    private int mEndId;
    private int mType;
    private boolean mIsEnabled;
    @NonNull
    public static final Parcelable.Creator<CellBroadcastIdRange> CREATOR = new Parcelable.Creator<CellBroadcastIdRange>(){

        @Override
        @NonNull
        public CellBroadcastIdRange createFromParcel(Parcel in) {
            int startId = in.readInt();
            int endId = in.readInt();
            int type = in.readInt();
            boolean isEnabled = in.readBoolean();
            return new CellBroadcastIdRange(startId, endId, type, isEnabled);
        }

        @NonNull
        public CellBroadcastIdRange[] newArray(int size) {
            return new CellBroadcastIdRange[size];
        }
    };

    public CellBroadcastIdRange(int startId, int endId, int type, boolean isEnabled) throws IllegalArgumentException {
        if (startId < 0 || endId < 0 || startId > 65535 || endId > 65535) {
            throw new IllegalArgumentException("invalid id");
        }
        if (endId < startId) {
            throw new IllegalArgumentException("endId must be greater than or equal to startId");
        }
        this.mStartId = startId;
        this.mEndId = endId;
        this.mType = type;
        this.mIsEnabled = isEnabled;
    }

    public int getStartId() {
        return this.mStartId;
    }

    public int getEndId() {
        return this.mEndId;
    }

    public int getType() {
        return this.mType;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mStartId);
        out.writeInt(this.mEndId);
        out.writeInt(this.mType);
        out.writeBoolean(this.mIsEnabled);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.mStartId, this.mEndId, this.mType, this.mIsEnabled);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CellBroadcastIdRange)) {
            return false;
        }
        CellBroadcastIdRange other = (CellBroadcastIdRange)obj;
        return this.mStartId == other.mStartId && this.mEndId == other.mEndId && this.mType == other.mType && this.mIsEnabled == other.mIsEnabled;
    }

    public String toString() {
        return "CellBroadcastIdRange[" + this.mStartId + ", " + this.mEndId + ", " + this.mType + ", " + this.mIsEnabled + "]";
    }
}

