/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.telephony.CellSignalStrength;
import android.telephony.ServiceState;
import com.android.telephony.Rlog;
import java.util.Objects;

public class CellSignalStrengthLte
extends CellSignalStrength
implements Parcelable {
    private static final String LOG_TAG = "CellSignalStrengthLte";
    private static final boolean DBG = false;
    private static final int SIGNAL_STRENGTH_LTE_RSSI_ASU_UNKNOWN = 99;
    private static final int SIGNAL_STRENGTH_LTE_RSSI_VALID_ASU_MAX_VALUE = 31;
    private static final int SIGNAL_STRENGTH_LTE_RSSI_VALID_ASU_MIN_VALUE = 0;
    private static final int MAX_LTE_RSRP = -44;
    private static final int MIN_LTE_RSRP = -140;
    public static final int USE_RSRP = 1;
    public static final int USE_RSRQ = 2;
    public static final int USE_RSSNR = 4;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mSignalStrength;
    private int mRssi;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mRsrp;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mRsrq;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mRssnr;
    private int mCqiTableIndex;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mCqi;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mTimingAdvance;
    private int mLevel;
    private int mParametersUseForLevel;
    private static final int[] sRsrpThresholds = new int[]{-115, -105, -95, -85};
    private static final int[] sRsrqThresholds = new int[]{-19, -17, -14, -12};
    private static final int[] sRssnrThresholds = new int[]{-3, 1, 5, 13};
    private static final int sRsrpBoost = 0;
    private static final CellSignalStrengthLte sInvalid = new CellSignalStrengthLte();
    @NonNull
    public static final Parcelable.Creator<CellSignalStrengthLte> CREATOR = new Parcelable.Creator<CellSignalStrengthLte>(){

        @Override
        public CellSignalStrengthLte createFromParcel(Parcel in) {
            return new CellSignalStrengthLte(in);
        }

        public CellSignalStrengthLte[] newArray(int size) {
            return new CellSignalStrengthLte[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public CellSignalStrengthLte() {
        this.setDefaultValues();
    }

    public CellSignalStrengthLte(int rssi, int rsrp, int rsrq, int rssnr, int cqiTableIndex, int cqi, int timingAdvance) {
        this.mSignalStrength = this.mRssi = CellSignalStrengthLte.inRangeOrUnavailable(rssi, -113, -51);
        this.mRsrp = CellSignalStrengthLte.inRangeOrUnavailable(rsrp, -140, -43);
        this.mRsrq = CellSignalStrengthLte.inRangeOrUnavailable(rsrq, -34, 3);
        this.mRssnr = CellSignalStrengthLte.inRangeOrUnavailable(rssnr, -20, 30);
        this.mCqiTableIndex = CellSignalStrengthLte.inRangeOrUnavailable(cqiTableIndex, 1, 6);
        this.mCqi = CellSignalStrengthLte.inRangeOrUnavailable(cqi, 0, 15);
        this.mTimingAdvance = CellSignalStrengthLte.inRangeOrUnavailable(timingAdvance, 0, 1282);
        this.updateLevel(null, null);
    }

    public CellSignalStrengthLte(int rssi, int rsrp, int rsrq, int rssnr, int cqi, int timingAdvance) {
        this(rssi, rsrp, rsrq, rssnr, Integer.MAX_VALUE, cqi, timingAdvance);
    }

    public CellSignalStrengthLte(CellSignalStrengthLte s) {
        this.copyFrom(s);
    }

    protected void copyFrom(CellSignalStrengthLte s) {
        this.mSignalStrength = s.mSignalStrength;
        this.mRssi = s.mRssi;
        this.mRsrp = s.mRsrp;
        this.mRsrq = s.mRsrq;
        this.mRssnr = s.mRssnr;
        this.mCqiTableIndex = s.mCqiTableIndex;
        this.mCqi = s.mCqi;
        this.mTimingAdvance = s.mTimingAdvance;
        this.mLevel = s.mLevel;
        this.mParametersUseForLevel = s.mParametersUseForLevel;
    }

    @Override
    public CellSignalStrengthLte copy() {
        return new CellSignalStrengthLte(this);
    }

    @Override
    public void setDefaultValues() {
        this.mSignalStrength = Integer.MAX_VALUE;
        this.mRssi = Integer.MAX_VALUE;
        this.mRsrp = Integer.MAX_VALUE;
        this.mRsrq = Integer.MAX_VALUE;
        this.mRssnr = Integer.MAX_VALUE;
        this.mCqiTableIndex = Integer.MAX_VALUE;
        this.mCqi = Integer.MAX_VALUE;
        this.mTimingAdvance = Integer.MAX_VALUE;
        this.mLevel = 0;
        this.mParametersUseForLevel = 1;
    }

    @Override
    public int getLevel() {
        return this.mLevel;
    }

    private boolean isLevelForParameter(int parameterType) {
        return (parameterType & this.mParametersUseForLevel) == parameterType;
    }

    @Override
    public void updateLevel(PersistableBundle cc, ServiceState ss) {
        int level;
        boolean rsrpOnly;
        int[] rssnrThresholds;
        int[] rsrqThresholds;
        int[] rsrpThresholds;
        if (cc == null) {
            this.mParametersUseForLevel = 1;
            rsrpThresholds = sRsrpThresholds;
            rsrqThresholds = sRsrqThresholds;
            rssnrThresholds = sRssnrThresholds;
            rsrpOnly = false;
        } else {
            if (ss != null && ss.isUsingNonTerrestrialNetwork()) {
                this.mParametersUseForLevel = cc.getInt("parameters_used_for_ntn_lte_signal_bar_int");
                rsrpThresholds = cc.getIntArray("ntn_lte_rsrp_thresholds_int_array");
                rsrqThresholds = cc.getIntArray("ntn_lte_rsrq_thresholds_int_array");
                rssnrThresholds = cc.getIntArray("ntn_lte_rssnr_thresholds_int_array");
            } else {
                this.mParametersUseForLevel = cc.getInt("parameters_used_for_lte_signal_bar_int");
                rsrpThresholds = cc.getIntArray("lte_rsrp_thresholds_int_array");
                rsrqThresholds = cc.getIntArray("lte_rsrq_thresholds_int_array");
                rssnrThresholds = cc.getIntArray("lte_rssnr_thresholds_int_array");
            }
            if (rsrpThresholds == null) {
                rsrpThresholds = sRsrpThresholds;
            }
            if (rsrqThresholds == null) {
                rsrqThresholds = sRsrqThresholds;
            }
            if (rssnrThresholds == null) {
                rssnrThresholds = sRssnrThresholds;
            }
            rsrpOnly = cc.getBoolean("use_only_rsrp_for_lte_signal_bar_bool", false);
        }
        int rsrpBoost = 0;
        if (ss != null) {
            rsrpBoost = ss.getArfcnRsrpBoost();
        }
        int rsrp = CellSignalStrengthLte.inRangeOrUnavailable(this.mRsrp + rsrpBoost, -140, -44);
        if (rsrpOnly && (level = this.updateLevelWithMeasure(rsrp, rsrpThresholds)) != Integer.MAX_VALUE) {
            this.mLevel = level;
            return;
        }
        int rsrpLevel = Integer.MAX_VALUE;
        int rsrqLevel = Integer.MAX_VALUE;
        int rssnrLevel = Integer.MAX_VALUE;
        if (this.isLevelForParameter(1)) {
            rsrpLevel = this.updateLevelWithMeasure(rsrp, rsrpThresholds);
        }
        if (this.isLevelForParameter(2)) {
            rsrqLevel = this.updateLevelWithMeasure(this.mRsrq, rsrqThresholds);
        }
        if (this.isLevelForParameter(4)) {
            rssnrLevel = this.updateLevelWithMeasure(this.mRssnr, rssnrThresholds);
        }
        this.mLevel = Math.min(Math.min(rsrpLevel, rsrqLevel), rssnrLevel);
        if (this.mLevel == Integer.MAX_VALUE) {
            int rssiLevel = this.mRssi > -51 ? 0 : (this.mRssi >= -89 ? 4 : (this.mRssi >= -97 ? 3 : (this.mRssi >= -103 ? 2 : (this.mRssi >= -113 ? 1 : 0))));
            this.mLevel = rssiLevel;
        }
    }

    private int updateLevelWithMeasure(int measure, int[] thresholds) {
        int level = measure == Integer.MAX_VALUE ? Integer.MAX_VALUE : (measure >= thresholds[3] ? 4 : (measure >= thresholds[2] ? 3 : (measure >= thresholds[1] ? 2 : (measure >= thresholds[0] ? 1 : 0))));
        return level;
    }

    public int getRsrq() {
        return this.mRsrq;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public int getRssnr() {
        return this.mRssnr;
    }

    public int getRsrp() {
        return this.mRsrp;
    }

    public int getCqiTableIndex() {
        return this.mCqiTableIndex;
    }

    public int getCqi() {
        return this.mCqi;
    }

    @Override
    public int getDbm() {
        return this.mRsrp;
    }

    @Override
    public int getAsuLevel() {
        int lteAsuLevel = 99;
        int lteDbm = this.mRsrp;
        lteAsuLevel = lteDbm == Integer.MAX_VALUE ? 99 : (lteDbm <= -140 ? 0 : (lteDbm >= -43 ? 97 : lteDbm + 140));
        return lteAsuLevel;
    }

    public int getTimingAdvance() {
        return this.mTimingAdvance;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mRssi, this.mRsrp, this.mRsrq, this.mRssnr, this.mCqiTableIndex, this.mCqi, this.mTimingAdvance, this.mLevel);
    }

    @Override
    public boolean isValid() {
        return !this.equals(sInvalid);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CellSignalStrengthLte)) {
            return false;
        }
        CellSignalStrengthLte s = (CellSignalStrengthLte)o;
        return this.mRssi == s.mRssi && this.mRsrp == s.mRsrp && this.mRsrq == s.mRsrq && this.mRssnr == s.mRssnr && this.mCqiTableIndex == s.mCqiTableIndex && this.mCqi == s.mCqi && this.mTimingAdvance == s.mTimingAdvance && this.mLevel == s.mLevel;
    }

    public String toString() {
        return "CellSignalStrengthLte: rssi=" + this.mRssi + " rsrp=" + this.mRsrp + " rsrq=" + this.mRsrq + " rssnr=" + this.mRssnr + " cqiTableIndex=" + this.mCqiTableIndex + " cqi=" + this.mCqi + " ta=" + this.mTimingAdvance + " level=" + this.mLevel + " parametersUseForLevel=" + this.mParametersUseForLevel;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mRsrp);
        dest.writeInt(this.mRsrq);
        dest.writeInt(this.mRssnr);
        dest.writeInt(this.mCqiTableIndex);
        dest.writeInt(this.mCqi);
        dest.writeInt(this.mTimingAdvance);
        dest.writeInt(this.mLevel);
    }

    private CellSignalStrengthLte(Parcel in) {
        this.mSignalStrength = this.mRssi = in.readInt();
        this.mRsrp = in.readInt();
        this.mRsrq = in.readInt();
        this.mRssnr = in.readInt();
        this.mCqiTableIndex = in.readInt();
        this.mCqi = in.readInt();
        this.mTimingAdvance = in.readInt();
        this.mLevel = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static void log(String s) {
        Rlog.w(LOG_TAG, s);
    }

    public static int convertRssnrUnitFromTenDbToDB(int rssnr) {
        return (int)Math.floor((float)rssnr / 10.0f);
    }

    public static int convertRssiAsuToDBm(int rssiAsu) {
        if (rssiAsu == 99 || rssiAsu == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (rssiAsu < 0 || rssiAsu > 31) {
            Rlog.e(LOG_TAG, "convertRssiAsuToDBm: invalid RSSI in ASU=" + rssiAsu);
            return Integer.MAX_VALUE;
        }
        return -113 + 2 * rssiAsu;
    }
}

