/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.DataThrottlingRequest;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class ThermalMitigationRequest
implements Parcelable {
    @SystemApi
    public static final int THERMAL_MITIGATION_ACTION_DATA_THROTTLING = 0;
    @SystemApi
    public static final int THERMAL_MITIGATION_ACTION_VOICE_ONLY = 1;
    @SystemApi
    public static final int THERMAL_MITIGATION_ACTION_RADIO_OFF = 2;
    private int mThermalMitigationAction;
    private DataThrottlingRequest mDataThrottlingRequest;
    @NonNull
    public static final Parcelable.Creator<ThermalMitigationRequest> CREATOR = new Parcelable.Creator<ThermalMitigationRequest>(){

        @Override
        public ThermalMitigationRequest createFromParcel(Parcel in) {
            return new ThermalMitigationRequest(in);
        }

        public ThermalMitigationRequest[] newArray(int size) {
            return new ThermalMitigationRequest[size];
        }
    };

    private ThermalMitigationRequest(int thermalMitigationAction, @Nullable DataThrottlingRequest dataThrottlingRequest) {
        this.mThermalMitigationAction = thermalMitigationAction;
        this.mDataThrottlingRequest = dataThrottlingRequest;
    }

    private ThermalMitigationRequest(Parcel in) {
        this.mThermalMitigationAction = in.readInt();
        this.mDataThrottlingRequest = in.readParcelable(DataThrottlingRequest.class.getClassLoader(), DataThrottlingRequest.class);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mThermalMitigationAction);
        dest.writeParcelable(this.mDataThrottlingRequest, 0);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "[ThermalMitigationRequest , thermalMitigationAction=" + this.mThermalMitigationAction + ", dataThrottlingRequest=" + this.mDataThrottlingRequest + "]";
    }

    public int getThermalMitigationAction() {
        return this.mThermalMitigationAction;
    }

    @Nullable
    public DataThrottlingRequest getDataThrottlingRequest() {
        return this.mDataThrottlingRequest;
    }

    @SystemApi
    public static class Builder {
        private int mThermalMitigationAction = -1;
        private DataThrottlingRequest mDataThrottlingRequest;

        @NonNull
        public Builder setThermalMitigationAction(int thermalMitigationAction) {
            this.mThermalMitigationAction = thermalMitigationAction;
            return this;
        }

        @NonNull
        public Builder setDataThrottlingRequest(@NonNull DataThrottlingRequest dataThrottlingRequest) {
            this.mDataThrottlingRequest = dataThrottlingRequest;
            return this;
        }

        @NonNull
        public ThermalMitigationRequest build() {
            if (this.mThermalMitigationAction < 0) {
                throw new IllegalArgumentException("thermalMitigationAction was  not set");
            }
            if (this.mThermalMitigationAction == 0) {
                if (this.mDataThrottlingRequest == null) {
                    throw new IllegalArgumentException("dataThrottlingRequest  cannot be null for THERMAL_MITIGATION_ACTION_DATA_THROTTLING");
                }
            } else if (this.mDataThrottlingRequest != null) {
                throw new IllegalArgumentException("dataThrottlingRequest must be null for THERMAL_MITIGATION_ACTION_VOICE_ONLY and THERMAL_MITIGATION_ACTION_RADIO_OFF");
            }
            return new ThermalMitigationRequest(this.mThermalMitigationAction, this.mDataThrottlingRequest);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ThermalMitigationAction {
    }
}

