/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.ims.RegistrationManager;
import android.telephony.ims.SipDetails;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class ImsRegistrationAttributes
implements Parcelable {
    public static final int ATTR_EPDG_OVER_CELL_INTERNET = 1;
    @FlaggedApi(value="com.android.internal.telephony.flags.emergency_registration_state")
    public static final int ATTR_REGISTRATION_TYPE_EMERGENCY = 2;
    @FlaggedApi(value="com.android.internal.telephony.flags.emergency_registration_state")
    public static final int ATTR_VIRTUAL_FOR_ANONYMOUS_EMERGENCY_CALL = 4;
    private final int mRegistrationTech;
    private final int mTransportType;
    private final int mImsAttributeFlags;
    private final ArrayList<String> mFeatureTags;
    @Nullable
    private final SipDetails mSipDetails;
    @NonNull
    public static final Parcelable.Creator<ImsRegistrationAttributes> CREATOR = new Parcelable.Creator<ImsRegistrationAttributes>(){

        @Override
        public ImsRegistrationAttributes createFromParcel(Parcel source) {
            return new ImsRegistrationAttributes(source);
        }

        public ImsRegistrationAttributes[] newArray(int size) {
            return new ImsRegistrationAttributes[size];
        }
    };

    public ImsRegistrationAttributes(int registrationTech, int transportType, int imsAttributeFlags, @Nullable Set<String> featureTags) {
        this.mRegistrationTech = registrationTech;
        this.mTransportType = transportType;
        this.mImsAttributeFlags = imsAttributeFlags;
        this.mFeatureTags = new ArrayList<String>(featureTags);
        this.mSipDetails = null;
    }

    public ImsRegistrationAttributes(int registrationTech, int transportType, int imsAttributeFlags, @Nullable Set<String> featureTags, @Nullable SipDetails details) {
        this.mRegistrationTech = registrationTech;
        this.mTransportType = transportType;
        this.mImsAttributeFlags = imsAttributeFlags;
        this.mFeatureTags = new ArrayList<String>(featureTags);
        this.mSipDetails = details;
    }

    public ImsRegistrationAttributes(Parcel source) {
        this.mRegistrationTech = source.readInt();
        this.mTransportType = source.readInt();
        this.mImsAttributeFlags = source.readInt();
        this.mFeatureTags = new ArrayList();
        source.readList(this.mFeatureTags, null, String.class);
        this.mSipDetails = source.readParcelable(null, SipDetails.class);
    }

    @SystemApi
    public int getRegistrationTechnology() {
        return this.mRegistrationTech;
    }

    public int getTransportType() {
        return this.mTransportType;
    }

    public int getAttributeFlags() {
        return this.mImsAttributeFlags;
    }

    @FlaggedApi(value="com.android.internal.telephony.flags.emergency_registration_state")
    public boolean getFlagRegistrationTypeEmergency() {
        return (this.mImsAttributeFlags & 2) != 0;
    }

    @FlaggedApi(value="com.android.internal.telephony.flags.emergency_registration_state")
    public boolean getFlagVirtualRegistrationForEmergencyCall() {
        return (this.mImsAttributeFlags & 4) != 0;
    }

    @NonNull
    public Set<String> getFeatureTags() {
        if (this.mFeatureTags == null) {
            return Collections.emptySet();
        }
        return new ArraySet<String>(this.mFeatureTags);
    }

    @Nullable
    public SipDetails getSipDetails() {
        return this.mSipDetails;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mRegistrationTech);
        dest.writeInt(this.mTransportType);
        dest.writeInt(this.mImsAttributeFlags);
        dest.writeList(this.mFeatureTags);
        dest.writeParcelable(this.mSipDetails, flags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImsRegistrationAttributes that = (ImsRegistrationAttributes)o;
        return this.mRegistrationTech == that.mRegistrationTech && this.mTransportType == that.mTransportType && this.mImsAttributeFlags == that.mImsAttributeFlags && Objects.equals(this.mFeatureTags, that.mFeatureTags) && Objects.equals(this.mSipDetails, that.mSipDetails);
    }

    public int hashCode() {
        return Objects.hash(this.mRegistrationTech, this.mTransportType, this.mImsAttributeFlags, this.mFeatureTags, this.mSipDetails);
    }

    public String toString() {
        return "ImsRegistrationAttributes { transportType= " + this.mTransportType + ", attributeFlags=" + this.mImsAttributeFlags + ", featureTags=[" + this.mFeatureTags + "],SipDetails=" + this.mSipDetails + "}";
    }

    @SystemApi
    public static class Builder {
        private final int mRegistrationTech;
        private Set<String> mFeatureTags = Collections.emptySet();
        @Nullable
        private SipDetails mSipDetails;
        private int mAttributeFlags;

        public Builder(int registrationTech) {
            this.mRegistrationTech = registrationTech;
            if (registrationTech == 2) {
                this.mAttributeFlags |= 1;
            }
        }

        @NonNull
        public Builder setFeatureTags(@NonNull Set<String> tags) {
            if (tags == null) {
                throw new IllegalArgumentException("feature tag set must not be null");
            }
            this.mFeatureTags = new ArraySet<String>(tags);
            return this;
        }

        @NonNull
        public Builder setSipDetails(@NonNull SipDetails details) {
            this.mSipDetails = details;
            return this;
        }

        @FlaggedApi(value="com.android.internal.telephony.flags.emergency_registration_state")
        @NonNull
        public Builder setFlagRegistrationTypeEmergency() {
            this.mAttributeFlags |= 2;
            return this;
        }

        @FlaggedApi(value="com.android.internal.telephony.flags.emergency_registration_state")
        @NonNull
        public Builder setFlagVirtualRegistrationForEmergencyCall() {
            this.mAttributeFlags |= 4;
            return this;
        }

        @NonNull
        public ImsRegistrationAttributes build() {
            return new ImsRegistrationAttributes(this.mRegistrationTech, RegistrationManager.getAccessType(this.mRegistrationTech), this.mAttributeFlags, this.mFeatureTags, this.mSipDetails);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsAttributeFlag {
    }
}

