/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.telephony.ims.ImsException;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.ImsRegistrationAttributes;
import android.telephony.ims.SipDetails;
import android.telephony.ims.aidl.IImsRegistrationCallback;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public interface RegistrationManager {
    public static final int REGISTRATION_STATE_NOT_REGISTERED = 0;
    public static final int REGISTRATION_STATE_REGISTERING = 1;
    public static final int REGISTRATION_STATE_REGISTERED = 2;
    @SystemApi
    public static final int SUGGESTED_ACTION_NONE = 0;
    @SystemApi
    public static final int SUGGESTED_ACTION_TRIGGER_PLMN_BLOCK = 1;
    @SystemApi
    public static final int SUGGESTED_ACTION_TRIGGER_PLMN_BLOCK_WITH_TIMEOUT = 2;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.add_rat_related_suggested_action_to_ims_registration")
    public static final int SUGGESTED_ACTION_TRIGGER_RAT_BLOCK = 3;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.add_rat_related_suggested_action_to_ims_registration")
    public static final int SUGGESTED_ACTION_TRIGGER_CLEAR_RAT_BLOCKS = 4;
    public static final Map<Integer, Integer> IMS_REG_TO_ACCESS_TYPE_MAP = Map.of(-1, -1, 0, 1, 3, 1, 1, 2, 2, 2);

    @NonNull
    public static String registrationStateToString(int value) {
        switch (value) {
            case 0: {
                return "REGISTRATION_STATE_NOT_REGISTERED";
            }
            case 1: {
                return "REGISTRATION_STATE_REGISTERING";
            }
            case 2: {
                return "REGISTRATION_STATE_REGISTERED";
            }
        }
        return Integer.toString(value);
    }

    public static int getAccessType(int regtech) {
        if (!IMS_REG_TO_ACCESS_TYPE_MAP.containsKey(regtech)) {
            Log.w("RegistrationManager", "getAccessType - invalid regType returned: " + regtech);
            return -1;
        }
        return IMS_REG_TO_ACCESS_TYPE_MAP.get(regtech);
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void registerImsRegistrationCallback(@NonNull Executor var1, @NonNull RegistrationCallback var2) throws ImsException;

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void unregisterImsRegistrationCallback(@NonNull RegistrationCallback var1);

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void getRegistrationState(@NonNull Executor var1, @NonNull Consumer<Integer> var2);

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void getRegistrationTransportType(@NonNull Executor var1, @NonNull Consumer<Integer> var2);

    public static class RegistrationCallback {
        private final RegistrationBinder mBinder = new RegistrationBinder(this);

        @Deprecated
        public void onRegistered(int imsTransportType) {
        }

        public void onRegistered(@NonNull ImsRegistrationAttributes attributes) {
            this.onRegistered(attributes.getTransportType());
        }

        public void onRegistering(int imsTransportType) {
        }

        public void onRegistering(@NonNull ImsRegistrationAttributes attributes) {
            this.onRegistering(attributes.getTransportType());
        }

        public void onUnregistered(@NonNull ImsReasonInfo info) {
        }

        public void onUnregistered(@NonNull ImsReasonInfo info, int suggestedAction, int imsRadioTech) {
            this.onUnregistered(info);
        }

        @SystemApi
        public void onUnregistered(@NonNull ImsReasonInfo info, @NonNull SipDetails details) {
        }

        public void onTechnologyChangeFailed(int imsTransportType, @NonNull ImsReasonInfo info) {
        }

        public void onSubscriberAssociatedUriChanged(@Nullable Uri[] uris) {
        }

        public IImsRegistrationCallback getBinder() {
            return this.mBinder;
        }

        public void setExecutor(Executor executor) {
            this.mBinder.setExecutor(executor);
        }

        private static class RegistrationBinder
        extends IImsRegistrationCallback.Stub {
            private final RegistrationCallback mLocalCallback;
            private Executor mExecutor;
            private Bundle mBundle = new Bundle();

            RegistrationBinder(RegistrationCallback localCallback) {
                this.mLocalCallback = localCallback;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRegistered(ImsRegistrationAttributes attr2) {
                if (this.mLocalCallback == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onRegistered(attr2));
                }
                finally {
                    RegistrationBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRegistering(ImsRegistrationAttributes attr2) {
                if (this.mLocalCallback == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onRegistering(attr2));
                }
                finally {
                    RegistrationBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDeregistered(ImsReasonInfo info, int suggestedAction, int imsRadioTech) {
                if (this.mLocalCallback == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onUnregistered(info, suggestedAction, imsRadioTech));
                }
                finally {
                    RegistrationBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDeregisteredWithDetails(ImsReasonInfo info, int suggestedAction, int imsRadioTech, @NonNull SipDetails details) {
                if (this.mLocalCallback == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onUnregistered(info, suggestedAction, imsRadioTech));
                    this.mExecutor.execute(() -> this.mLocalCallback.onUnregistered(info, details));
                }
                finally {
                    RegistrationBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTechnologyChangeFailed(int imsRadioTech, ImsReasonInfo info) {
                if (this.mLocalCallback == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onTechnologyChangeFailed(RegistrationManager.getAccessType(imsRadioTech), info));
                }
                finally {
                    RegistrationBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSubscriberAssociatedUriChanged(Uri[] uris) {
                if (this.mLocalCallback == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onSubscriberAssociatedUriChanged(uris));
                }
                finally {
                    RegistrationBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            private void setExecutor(Executor executor) {
                this.mExecutor = executor;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SuggestedAction {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsRegistrationState {
    }
}

